/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.plugins.ide.eclipse.internal.EclipseProjectMetadata;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;

public class ProjectDependencyBuilder {
    private final IdeArtifactRegistry ideArtifactRegistry;

    public ProjectDependencyBuilder(IdeArtifactRegistry ideArtifactRegistry) {
        this.ideArtifactRegistry = ideArtifactRegistry;
    }

    public ProjectDependency build(ProjectComponentIdentifier componentIdentifier, FileReference publication, TaskDependency buildDependencies, boolean asJavaModule) {
        ProjectDependency dependency = this.buildProjectDependency(this.determineTargetProjectPath(componentIdentifier));
        dependency.setPublication(publication);
        if (buildDependencies != null) {
            dependency.buildDependencies(buildDependencies);
        }
        if (asJavaModule) {
            dependency.getEntryAttributes().put("module", "true");
        }
        dependency.getEntryAttributes().put("without_test_code", "true");
        return dependency;
    }

    private String determineTargetProjectPath(ProjectComponentIdentifier id) {
        return "/" + this.determineTargetProjectName(id);
    }

    public String determineTargetProjectName(ProjectComponentIdentifier id) {
        EclipseProjectMetadata eclipseProject = this.ideArtifactRegistry.getIdeProject(EclipseProjectMetadata.class, id);
        return eclipseProject == null ? id.getProjectName() : eclipseProject.getName();
    }

    private ProjectDependency buildProjectDependency(String path) {
        ProjectDependency out = new ProjectDependency(path);
        out.setExported(false);
        return out;
    }
}

