/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkInstall;
import org.gradle.util.VersionNumber;

public class LegacyWindowsSdkInstall
implements WindowsSdkInstall {
    private static final String[] BINPATHS_X86 = new String[]{"bin/x86", "Bin"};
    private static final String[] BINPATHS_AMD64 = new String[]{"bin/x64"};
    private static final String[] BINPATHS_IA64 = new String[]{"bin/IA64"};
    private static final String[] BINPATHS_ARM = new String[]{"bin/arm"};
    private static final String LIBPATH_SDK8 = "Lib/win8/um/";
    private static final String LIBPATH_SDK81 = "Lib/winv6.3/um/";
    private static final String[] LIBPATHS_X86 = new String[]{"Lib/winv6.3/um/x86", "Lib/win8/um/x86", "lib"};
    private static final String[] LIBPATHS_AMD64 = new String[]{"Lib/winv6.3/um/x64", "Lib/win8/um/x64", "lib/x64"};
    private static final String[] LIBPATHS_IA64 = new String[]{"lib/IA64"};
    private static final String[] LIBPATHS_ARM = new String[]{"Lib/winv6.3/um/arm", "Lib/win8/um/arm"};
    private final File baseDir;
    private final VersionNumber version;
    private final String name;

    public LegacyWindowsSdkInstall(File baseDir, VersionNumber version, String name) {
        this.baseDir = baseDir;
        this.version = version;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public VersionNumber getVersion() {
        return this.version;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public WindowsSdk forPlatform(NativePlatformInternal platform) {
        if (platform.getArchitecture().isAmd64()) {
            return new LegacyPlatformWindowsSdk(BINPATHS_AMD64, LIBPATHS_AMD64);
        }
        if (platform.getArchitecture().isIa64()) {
            return new LegacyPlatformWindowsSdk(BINPATHS_IA64, LIBPATHS_IA64);
        }
        if (platform.getArchitecture().isArm()) {
            return new LegacyPlatformWindowsSdk(BINPATHS_ARM, LIBPATHS_ARM);
        }
        if (platform.getArchitecture().isI386()) {
            return new LegacyPlatformWindowsSdk(BINPATHS_X86, LIBPATHS_X86);
        }
        throw new UnsupportedOperationException(String.format("Unsupported %s for %s.", platform.getArchitecture().getDisplayName(), this.toString()));
    }

    private class LegacyPlatformWindowsSdk
    implements WindowsSdk {
        private final String[] binPaths;
        private final String[] libPaths;

        LegacyPlatformWindowsSdk(String[] binPaths, String[] libPaths) {
            this.binPaths = binPaths;
            this.libPaths = libPaths;
        }

        @Override
        public VersionNumber getImplementationVersion() {
            return LegacyWindowsSdkInstall.this.version;
        }

        @Override
        public VersionNumber getSdkVersion() {
            return LegacyWindowsSdkInstall.this.version;
        }

        @Override
        public List<File> getIncludeDirs() {
            List<File> includesSdk8 = Arrays.asList(new File(LegacyWindowsSdkInstall.this.baseDir, "Include/shared"), new File(LegacyWindowsSdkInstall.this.baseDir, "Include/um"));
            for (File file : includesSdk8) {
                if (file.isDirectory()) continue;
                return Collections.singletonList(new File(LegacyWindowsSdkInstall.this.baseDir, "Include"));
            }
            return includesSdk8;
        }

        @Override
        public List<File> getLibDirs() {
            return Collections.singletonList(this.getAvailableFile(this.libPaths));
        }

        @Override
        public Map<String, String> getPreprocessorMacros() {
            return Collections.emptyMap();
        }

        @Override
        public File getResourceCompiler() {
            return new File(this.getBinDir(), "rc.exe");
        }

        @Override
        public List<File> getPath() {
            return Collections.singletonList(this.getBinDir());
        }

        private File getBinDir() {
            return this.getAvailableFile(this.binPaths);
        }

        private File getAvailableFile(String ... candidates) {
            for (String candidate : candidates) {
                File file = new File(LegacyWindowsSdkInstall.this.baseDir, candidate);
                if (!file.isDirectory()) continue;
                return file;
            }
            return new File(LegacyWindowsSdkInstall.this.baseDir, candidates[0]);
        }
    }
}

