/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.plugins;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.nativeplatform.internal.NativeLanguageTransform;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.language.rc.internal.DefaultWindowsResourceSet;
import org.gradle.language.rc.plugins.internal.WindowsResourcesCompileTaskConfig;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.internal.DefaultPreprocessingTool;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;

@Incubating
public class WindowsResourceScriptPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    private static class WindowsResources
    extends NativeLanguageTransform<WindowsResourceSet> {
        private WindowsResources() {
        }

        public Class<WindowsResourceSet> getSourceSetType() {
            return WindowsResourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            LinkedHashMap tools = Maps.newLinkedHashMap();
            tools.put("rcCompiler", DefaultPreprocessingTool.class);
            return tools;
        }

        public String getLanguageName() {
            return "rc";
        }

        @Override
        public ToolType getToolType() {
            return ToolType.WINDOW_RESOURCES_COMPILER;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new WindowsResourcesCompileTaskConfig();
        }

        @Override
        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof NativeBinarySpec && this.shouldProcessResources((NativeBinarySpec)binary);
        }

        private boolean shouldProcessResources(NativeBinarySpec binary) {
            return binary.getTargetPlatform().getOperatingSystem().isWindows();
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerLanguage(TypeBuilder<WindowsResourceSet> builder) {
            builder.defaultImplementation(DefaultWindowsResourceSet.class);
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry) {
            languages.add((Object)new WindowsResources());
        }
    }
}

