/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.SessionLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.SessionScopeBuildActionExecutor;

public class SessionScopeLifecycleBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final ServiceRegistry globalServices;
    private final GradleUserHomeScopeServiceRegistry userHomeServiceRegistry;

    public SessionScopeLifecycleBuildActionExecuter(GradleUserHomeScopeServiceRegistry userHomeServiceRegistry, ServiceRegistry globalServices) {
        this.userHomeServiceRegistry = userHomeServiceRegistry;
        this.globalServices = globalServices;
    }

    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        StartParameterInternal startParameter = action.getStartParameter();
        try (CrossBuildSessionState crossBuildSessionState = new CrossBuildSessionState(this.globalServices, (StartParameter)startParameter);){
            BuildActionResult buildActionResult;
            try (BuildSessionState buildSessionState = new BuildSessionState(this.userHomeServiceRegistry, crossBuildSessionState, (StartParameter)startParameter, (BuildRequestMetaData)requestContext, actionParameters.getInjectedPluginClasspath(), requestContext.getCancellationToken(), requestContext.getClient(), requestContext.getEventConsumer());){
                buildActionResult = (BuildActionResult)buildSessionState.run(context -> {
                    SessionLifecycleListener sessionLifecycleListener = (SessionLifecycleListener)context.getServices().get(ListenerManager.class).getBroadcaster(SessionLifecycleListener.class);
                    try {
                        sessionLifecycleListener.afterStart();
                        BuildActionResult buildActionResult = context.getServices().get(SessionScopeBuildActionExecutor.class).execute(action, actionParameters, context);
                        return buildActionResult;
                    }
                    finally {
                        sessionLifecycleListener.beforeComplete();
                    }
                });
            }
            return buildActionResult;
        }
    }
}

