/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycleMapping
implements LifecycleMapping {
    private List<Lifecycle> lifecycles;
    private Map<String, Lifecycle> lifecycleMap;
    private Map<String, String> phases;

    private void initLifecycleMap() {
        block4: {
            if (this.lifecycleMap != null) break block4;
            this.lifecycleMap = new HashMap<String, Lifecycle>();
            if (this.lifecycles != null) {
                for (Lifecycle lifecycle : this.lifecycles) {
                    this.lifecycleMap.put(lifecycle.getId(), lifecycle);
                }
            } else {
                String[] lifecycleIds;
                for (String lifecycleId : lifecycleIds = new String[]{"default", "clean", "site"}) {
                    Map<String, String> phases = this.getPhases(lifecycleId);
                    if (phases == null) continue;
                    Lifecycle lifecycle = new Lifecycle();
                    lifecycle.setId(lifecycleId);
                    lifecycle.setPhases(phases);
                    this.lifecycleMap.put(lifecycleId, lifecycle);
                }
            }
        }
    }

    @Override
    public Map<String, Lifecycle> getLifecycles() {
        this.initLifecycleMap();
        return this.lifecycleMap;
    }

    @Override
    public List<String> getOptionalMojos(String lifecycle) {
        return null;
    }

    @Override
    public Map<String, String> getPhases(String lifecycle) {
        this.initLifecycleMap();
        Lifecycle lifecycleMapping = this.lifecycleMap.get(lifecycle);
        if (lifecycleMapping != null) {
            return lifecycleMapping.getPhases();
        }
        if ("default".equals(lifecycle)) {
            return this.phases;
        }
        return null;
    }
}

