/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.DefaultJvmLanguageCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.tasks.compile.CompileOptions;

public class DefaultJavaCompileSpec
extends DefaultJvmLanguageCompileSpec
implements JavaCompileSpec {
    private MinimalJavaCompileOptions compileOptions;
    private List<File> annotationProcessorPath;
    private Set<AnnotationProcessorDeclaration> effectiveAnnotationProcessors;
    private Set<String> classes;
    private List<File> modulePath;
    private List<File> sourceRoots;

    @Override
    public MinimalJavaCompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    public void setCompileOptions(CompileOptions compileOptions) {
        this.compileOptions = new MinimalJavaCompileOptions(compileOptions);
    }

    @Override
    public List<File> getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    @Override
    public void setAnnotationProcessorPath(List<File> annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Override
    public Set<AnnotationProcessorDeclaration> getEffectiveAnnotationProcessors() {
        return this.effectiveAnnotationProcessors;
    }

    @Override
    public void setEffectiveAnnotationProcessors(Set<AnnotationProcessorDeclaration> annotationProcessors) {
        this.effectiveAnnotationProcessors = annotationProcessors;
    }

    @Override
    public Set<String> getClasses() {
        return this.classes;
    }

    @Override
    public void setClasses(Set<String> classes) {
        this.classes = classes;
    }

    @Override
    public List<File> getModulePath() {
        if (this.modulePath == null || this.modulePath.isEmpty()) {
            int i = this.compileOptions.getCompilerArgs().indexOf("--module-path");
            if (i >= 0) {
                String[] modules = this.compileOptions.getCompilerArgs().get(i + 1).split(File.pathSeparator);
                this.modulePath = Lists.newArrayListWithCapacity((int)modules.length);
                for (String module : modules) {
                    this.modulePath.add(new File(module));
                }
            } else if (this.modulePath == null) {
                this.modulePath = ImmutableList.of();
            }
        }
        return this.modulePath;
    }

    @Override
    public void setModulePath(List<File> modulePath) {
        this.modulePath = modulePath;
    }

    public List<File> getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourcesRoots(List<File> sourcesRoots) {
        this.sourceRoots = sourcesRoots;
    }
}

