/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.DisplayName;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;

public class TextResourceScriptSource
implements ScriptSource {
    private final TextResource resource;
    private String className;

    public TextResourceScriptSource(TextResource resource) {
        this.resource = resource;
    }

    @Override
    public TextResource getResource() {
        return this.resource;
    }

    @Override
    public String getFileName() {
        ResourceLocation location = this.resource.getLocation();
        if (location.getFile() != null) {
            return location.getFile().getPath();
        }
        if (location.getURI() != null) {
            return location.getURI().toString();
        }
        return this.getClassName();
    }

    @Override
    public String getDisplayName() {
        return this.getLongDisplayName().getDisplayName();
    }

    @Override
    public DisplayName getLongDisplayName() {
        return this.resource.getLongDisplayName();
    }

    @Override
    public DisplayName getShortDisplayName() {
        return this.resource.getShortDisplayName();
    }

    @Override
    public String getClassName() {
        if (this.className == null) {
            this.className = this.initClassName();
        }
        return this.className;
    }

    private String initClassName() {
        URI sourceUri = this.getResource().getLocation().getURI();
        if (sourceUri != null) {
            String path = sourceUri.toString();
            return this.classNameFromPath(path);
        }
        return "script_" + HashUtil.createCompactMD5((String)this.resource.getText());
    }

    private String classNameFromPath(String path) {
        String name = StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)path, (String)"/"), (String)".");
        StringBuilder className = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            className.append(Character.isJavaIdentifierPart(ch) ? ch : (char)'_');
        }
        if (!Character.isJavaIdentifierStart(className.charAt(0))) {
            className.insert(0, '_');
        }
        className.setLength(Math.min(className.length(), 30));
        className.append('_');
        className.append(HashUtil.createCompactMD5((String)path));
        return className.toString();
    }
}

