/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.Cast;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.util.CollectionUtils;

class WatchServicePoller {
    private static final int POLL_TIMEOUT_SECONDS = 5;
    private final WatchService watchService;

    WatchServicePoller(WatchService watchService) throws IOException {
        this.watchService = watchService;
    }

    @Nullable
    public List<FileWatcherEvent> takeEvents() throws InterruptedException {
        WatchKey watchKey = this.watchService.poll(5L, TimeUnit.SECONDS);
        if (watchKey != null) {
            return this.handleWatchKey(watchKey);
        }
        return null;
    }

    private List<FileWatcherEvent> handleWatchKey(WatchKey watchKey) {
        final Path watchedPath = (Path)watchKey.watchable();
        Transformer watchEventTransformer = new Transformer<FileWatcherEvent, WatchEvent<?>>(){

            public FileWatcherEvent transform(WatchEvent<?> event) {
                WatchEvent.Kind<?> kind = event.kind();
                File file = null;
                if (kind.type() == Path.class) {
                    WatchEvent ev = (WatchEvent)Cast.uncheckedCast(event);
                    file = watchedPath.resolve((Path)ev.context()).toFile();
                }
                return WatchServicePoller.this.toEvent(kind, file);
            }
        };
        List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
        watchKey.reset();
        if (watchEvents.isEmpty()) {
            return Collections.singletonList(FileWatcherEvent.delete(watchedPath.toFile()));
        }
        return CollectionUtils.collect(watchEvents, (Transformer)watchEventTransformer);
    }

    private FileWatcherEvent toEvent(WatchEvent.Kind kind, File file) {
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            return FileWatcherEvent.create(file);
        }
        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            return FileWatcherEvent.delete(file);
        }
        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            return FileWatcherEvent.modify(file);
        }
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            return FileWatcherEvent.undefined();
        }
        throw new IllegalStateException("Unknown watch kind " + kind);
    }
}

