/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import java.io.File;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.file.Deleter;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.play.internal.spec.PlayCompileSpec;

public class CleaningPlayToolCompiler<T extends PlayCompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private TaskOutputsInternal taskOutputs;
    private final Deleter deleter;

    public CleaningPlayToolCompiler(Compiler<T> delegate, TaskOutputsInternal taskOutputs, Deleter deleter) {
        this.delegate = delegate;
        this.taskOutputs = taskOutputs;
        this.deleter = deleter;
    }

    public WorkResult execute(T spec) {
        boolean cleanedOutputs = StaleOutputCleaner.cleanOutputs((Deleter)this.deleter, (Iterable)this.taskOutputs.getPreviousOutputFiles(), (File)spec.getDestinationDir());
        return this.delegate.execute(spec).or(WorkResults.didWork((boolean)cleanedOutputs));
    }
}

