/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.plugin.testng;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import java.lang.reflect.Method;
import org.apache.groovy.plugin.GroovyRunner;
import org.codehaus.groovy.runtime.InvokerHelper;

public class TestNgRunner
implements GroovyRunner {
    private static final String OUTPUT_DIRECTORY = TestNgRunner.getTestOutputDirectory();

    private static String getTestOutputDirectory() {
        try {
            return System.getProperty("groovy.plugin.testng.output");
        }
        catch (SecurityException ignore) {
            return null;
        }
    }

    @Override
    public boolean canRun(Class<?> scriptClass, GroovyClassLoader loader) {
        try {
            Method[] methods;
            Class<?> testAnnotationClass = loader.loadClass("org.testng.annotations.Test");
            if (scriptClass.isAnnotationPresent(testAnnotationClass)) {
                return true;
            }
            for (Method method : methods = scriptClass.getMethods()) {
                if (!method.isAnnotationPresent(testAnnotationClass)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object run(Class<?> scriptClass, GroovyClassLoader loader) {
        try {
            Class<?> testNGClass = loader.loadClass("org.testng.TestNG");
            Object testng = InvokerHelper.invokeConstructorOf(testNGClass, (Object)new Object[0]);
            InvokerHelper.invokeMethod(testng, "setTestClasses", new Object[]{scriptClass});
            Class<?> listenerClass = loader.loadClass("org.testng.TestListenerAdapter");
            Object listener = InvokerHelper.invokeConstructorOf(listenerClass, (Object)new Object[0]);
            InvokerHelper.invokeMethod(testng, "addListener", new Object[]{listener});
            if (OUTPUT_DIRECTORY != null) {
                InvokerHelper.invokeMethod(testng, "setOutputDirectory", new Object[]{OUTPUT_DIRECTORY});
            }
            return InvokerHelper.invokeMethod(testng, "run", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Error running TestNG test.", e);
        }
    }
}

