/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jansi;

import org.gradle.internal.nativeintegration.jansi.JansiOperatingSystemSupport;
import org.gradle.internal.nativeintegration.jansi.JansiRuntimeResolver;

public class DefaultJansiRuntimeResolver
implements JansiRuntimeResolver {
    @Override
    public String getOperatingSystem() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        if (name.startsWith("linux")) {
            return JansiOperatingSystemSupport.LINUX.getIdentifier();
        }
        if (name.startsWith("mac os x")) {
            return JansiOperatingSystemSupport.MAC_OS_X.getIdentifier();
        }
        if (name.startsWith("win")) {
            return JansiOperatingSystemSupport.WINDOWS.getIdentifier();
        }
        return name.replaceAll("\\W+", "_");
    }

    @Override
    public String getPlatform() {
        return this.getOperatingSystem() + this.getBitModel();
    }

    private int getBitModel() {
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }
}

