/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import javax.annotation.Nullable;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;

public abstract class MessageFormattingTypeValidationContext
implements TypeValidationContext {
    private final Class<?> rootType;

    public MessageFormattingTypeValidationContext(@Nullable Class<?> rootType) {
        this.rootType = rootType;
    }

    @Override
    public void visitTypeProblem(TypeValidationContext.Severity severity, Class<?> type, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Type '");
        builder.append(ModelType.of(type).getDisplayName());
        builder.append("': ");
        builder.append(message);
        builder.append('.');
        this.recordProblem(severity, builder.toString());
    }

    @Override
    public void visitPropertyProblem(TypeValidationContext.Severity severity, @Nullable String parentProperty, @Nullable String property, String message) {
        StringBuilder builder = new StringBuilder();
        if (this.rootType != null) {
            builder.append("Type '");
            builder.append(ModelType.of(this.rootType).getDisplayName());
            builder.append("': ");
        }
        if (property != null) {
            if (this.rootType == null) {
                builder.append("Property '");
            } else {
                builder.append("property '");
            }
            if (parentProperty != null) {
                builder.append(parentProperty);
                builder.append('.');
            }
            builder.append(property);
            builder.append("' ");
        }
        builder.append(message);
        builder.append('.');
        this.recordProblem(severity, builder.toString());
    }

    protected abstract void recordProblem(TypeValidationContext.Severity var1, String var2);
}

