/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Optional;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.AbstractFileSystemNode;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.ReadOnlyFileSystemNode;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractCompleteFileSystemLocationSnapshot
implements CompleteFileSystemLocationSnapshot {
    private final String absolutePath;
    private final String name;
    private final FileMetadata.AccessType accessType;

    public AbstractCompleteFileSystemLocationSnapshot(String absolutePath, String name, FileMetadata.AccessType accessType) {
        this.absolutePath = absolutePath;
        this.name = name;
        this.accessType = accessType;
    }

    protected static MissingFileSnapshot missingSnapshotForAbsolutePath(String filePath) {
        return new MissingFileSnapshot(filePath, FileMetadata.AccessType.DIRECT);
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileMetadata.AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public String getPathToParent() {
        return this.getName();
    }

    @Override
    public CompleteFileSystemLocationSnapshot store(VfsRelativePath relativePath, CaseSensitivity caseSensitivity, MetadataSnapshot snapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
        return this;
    }

    @Override
    public void accept(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        snapshotVisitor.visitSnapshotRoot(this);
    }

    @Override
    public boolean hasDescendants() {
        return true;
    }

    @Override
    public FileSystemNode asFileSystemNode(String pathToParent) {
        return this.getPathToParent().equals(pathToParent) ? this : new PathCompressingSnapshotWrapper(pathToParent, this);
    }

    @Override
    public FileSystemNode withPathToParent(String newPathToParent) {
        return this.getPathToParent().equals(newPathToParent) ? this : new PathCompressingSnapshotWrapper(newPathToParent, this);
    }

    @Override
    public Optional<MetadataSnapshot> getSnapshot() {
        return Optional.of(this);
    }

    @Override
    public Optional<MetadataSnapshot> getSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return this.getChildSnapshot(relativePath, caseSensitivity);
    }

    protected Optional<MetadataSnapshot> getChildSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return Optional.of(AbstractCompleteFileSystemLocationSnapshot.missingSnapshotForAbsolutePath(relativePath.getAbsolutePath()));
    }

    @Override
    public ReadOnlyFileSystemNode getNode(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return this.getChildNode(relativePath, caseSensitivity);
    }

    protected ReadOnlyFileSystemNode getChildNode(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return AbstractCompleteFileSystemLocationSnapshot.missingSnapshotForAbsolutePath(relativePath.getAbsolutePath());
    }

    private static class PathCompressingSnapshotWrapper
    extends AbstractFileSystemNode {
        private final AbstractCompleteFileSystemLocationSnapshot delegate;

        public PathCompressingSnapshotWrapper(String pathToParent, AbstractCompleteFileSystemLocationSnapshot delegate) {
            super(pathToParent);
            this.delegate = delegate;
        }

        @Override
        public Optional<FileSystemNode> invalidate(VfsRelativePath relativePath, CaseSensitivity caseSensitivity, SnapshotHierarchy.NodeDiffListener diffListener) {
            return this.delegate.invalidate(relativePath, caseSensitivity, diffListener).map(splitSnapshot -> splitSnapshot.withPathToParent(this.getPathToParent()));
        }

        @Override
        public FileSystemNode store(VfsRelativePath relativePath, CaseSensitivity caseSensitivity, MetadataSnapshot newSnapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
            return this;
        }

        @Override
        public Optional<MetadataSnapshot> getSnapshot() {
            return this.delegate.getSnapshot();
        }

        @Override
        public Optional<MetadataSnapshot> getSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
            return this.delegate.getSnapshot(relativePath, caseSensitivity);
        }

        @Override
        public boolean hasDescendants() {
            return this.delegate.hasDescendants();
        }

        @Override
        public ReadOnlyFileSystemNode getNode(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
            return this.delegate.getNode(relativePath, caseSensitivity);
        }

        @Override
        public FileSystemNode withPathToParent(String newPathToParent) {
            return this.getPathToParent().equals(newPathToParent) ? this : this.delegate.asFileSystemNode(newPathToParent);
        }

        @Override
        public void accept(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
            this.delegate.accept(snapshotVisitor);
        }
    }
}

