/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLContextCallbackI;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.opencl.CLNativeKernelI;
import org.lwjgl.opencl.CLProgramCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CL10 {
    public static final int CL_SUCCESS = 0;
    public static final int CL_DEVICE_NOT_FOUND = -1;
    public static final int CL_DEVICE_NOT_AVAILABLE = -2;
    public static final int CL_COMPILER_NOT_AVAILABLE = -3;
    public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE = -4;
    public static final int CL_OUT_OF_RESOURCES = -5;
    public static final int CL_OUT_OF_HOST_MEMORY = -6;
    public static final int CL_PROFILING_INFO_NOT_AVAILABLE = -7;
    public static final int CL_MEM_COPY_OVERLAP = -8;
    public static final int CL_IMAGE_FORMAT_MISMATCH = -9;
    public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED = -10;
    public static final int CL_BUILD_PROGRAM_FAILURE = -11;
    public static final int CL_MAP_FAILURE = -12;
    public static final int CL_INVALID_VALUE = -30;
    public static final int CL_INVALID_DEVICE_TYPE = -31;
    public static final int CL_INVALID_PLATFORM = -32;
    public static final int CL_INVALID_DEVICE = -33;
    public static final int CL_INVALID_CONTEXT = -34;
    public static final int CL_INVALID_QUEUE_PROPERTIES = -35;
    public static final int CL_INVALID_COMMAND_QUEUE = -36;
    public static final int CL_INVALID_HOST_PTR = -37;
    public static final int CL_INVALID_MEM_OBJECT = -38;
    public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR = -39;
    public static final int CL_INVALID_IMAGE_SIZE = -40;
    public static final int CL_INVALID_SAMPLER = -41;
    public static final int CL_INVALID_BINARY = -42;
    public static final int CL_INVALID_BUILD_OPTIONS = -43;
    public static final int CL_INVALID_PROGRAM = -44;
    public static final int CL_INVALID_PROGRAM_EXECUTABLE = -45;
    public static final int CL_INVALID_KERNEL_NAME = -46;
    public static final int CL_INVALID_KERNEL_DEFINITION = -47;
    public static final int CL_INVALID_KERNEL = -48;
    public static final int CL_INVALID_ARG_INDEX = -49;
    public static final int CL_INVALID_ARG_VALUE = -50;
    public static final int CL_INVALID_ARG_SIZE = -51;
    public static final int CL_INVALID_KERNEL_ARGS = -52;
    public static final int CL_INVALID_WORK_DIMENSION = -53;
    public static final int CL_INVALID_WORK_GROUP_SIZE = -54;
    public static final int CL_INVALID_WORK_ITEM_SIZE = -55;
    public static final int CL_INVALID_GLOBAL_OFFSET = -56;
    public static final int CL_INVALID_EVENT_WAIT_LIST = -57;
    public static final int CL_INVALID_EVENT = -58;
    public static final int CL_INVALID_OPERATION = -59;
    public static final int CL_INVALID_BUFFER_SIZE = -61;
    public static final int CL_INVALID_GLOBAL_WORK_SIZE = -63;
    public static final int CL_VERSION_1_0 = 1;
    public static final int CL_FALSE = 0;
    public static final int CL_TRUE = 1;
    public static final int CL_PLATFORM_PROFILE = 2304;
    public static final int CL_PLATFORM_VERSION = 2305;
    public static final int CL_PLATFORM_NAME = 2306;
    public static final int CL_PLATFORM_VENDOR = 2307;
    public static final int CL_PLATFORM_EXTENSIONS = 2308;
    public static final int CL_DEVICE_TYPE_DEFAULT = 1;
    public static final int CL_DEVICE_TYPE_CPU = 2;
    public static final int CL_DEVICE_TYPE_GPU = 4;
    public static final int CL_DEVICE_TYPE_ACCELERATOR = 8;
    public static final int CL_DEVICE_TYPE_ALL = -1;
    public static final int CL_DEVICE_TYPE = 4096;
    public static final int CL_DEVICE_VENDOR_ID = 4097;
    public static final int CL_DEVICE_MAX_COMPUTE_UNITS = 4098;
    public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = 4099;
    public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE = 4100;
    public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES = 4101;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR = 4102;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT = 4103;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT = 4104;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG = 4105;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT = 4106;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE = 4107;
    public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY = 4108;
    public static final int CL_DEVICE_ADDRESS_BITS = 4109;
    public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS = 4110;
    public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS = 4111;
    public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE = 4112;
    public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH = 4113;
    public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT = 4114;
    public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH = 4115;
    public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT = 4116;
    public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH = 4117;
    public static final int CL_DEVICE_IMAGE_SUPPORT = 4118;
    public static final int CL_DEVICE_MAX_PARAMETER_SIZE = 4119;
    public static final int CL_DEVICE_MAX_SAMPLERS = 4120;
    public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN = 4121;
    public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE = 4122;
    public static final int CL_DEVICE_SINGLE_FP_CONFIG = 4123;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE = 4124;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE = 4125;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE = 4126;
    public static final int CL_DEVICE_GLOBAL_MEM_SIZE = 4127;
    public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE = 4128;
    public static final int CL_DEVICE_MAX_CONSTANT_ARGS = 4129;
    public static final int CL_DEVICE_LOCAL_MEM_TYPE = 4130;
    public static final int CL_DEVICE_LOCAL_MEM_SIZE = 4131;
    public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT = 4132;
    public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION = 4133;
    public static final int CL_DEVICE_ENDIAN_LITTLE = 4134;
    public static final int CL_DEVICE_AVAILABLE = 4135;
    public static final int CL_DEVICE_COMPILER_AVAILABLE = 4136;
    public static final int CL_DEVICE_EXECUTION_CAPABILITIES = 4137;
    public static final int CL_DEVICE_QUEUE_PROPERTIES = 4138;
    public static final int CL_DEVICE_NAME = 4139;
    public static final int CL_DEVICE_VENDOR = 4140;
    public static final int CL_DRIVER_VERSION = 4141;
    public static final int CL_DEVICE_PROFILE = 4142;
    public static final int CL_DEVICE_VERSION = 4143;
    public static final int CL_DEVICE_EXTENSIONS = 4144;
    public static final int CL_DEVICE_PLATFORM = 4145;
    public static final int CL_FP_DENORM = 1;
    public static final int CL_FP_INF_NAN = 2;
    public static final int CL_FP_ROUND_TO_NEAREST = 4;
    public static final int CL_FP_ROUND_TO_ZERO = 8;
    public static final int CL_FP_ROUND_TO_INF = 16;
    public static final int CL_FP_FMA = 32;
    public static final int CL_NONE = 0;
    public static final int CL_READ_ONLY_CACHE = 1;
    public static final int CL_READ_WRITE_CACHE = 2;
    public static final int CL_LOCAL = 1;
    public static final int CL_GLOBAL = 2;
    public static final int CL_EXEC_KERNEL = 1;
    public static final int CL_EXEC_NATIVE_KERNEL = 2;
    public static final int CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE = 1;
    public static final int CL_QUEUE_PROFILING_ENABLE = 2;
    public static final int CL_CONTEXT_REFERENCE_COUNT = 4224;
    public static final int CL_CONTEXT_DEVICES = 4225;
    public static final int CL_CONTEXT_PROPERTIES = 4226;
    public static final int CL_CONTEXT_PLATFORM = 4228;
    public static final int CL_QUEUE_CONTEXT = 4240;
    public static final int CL_QUEUE_DEVICE = 4241;
    public static final int CL_QUEUE_REFERENCE_COUNT = 4242;
    public static final int CL_QUEUE_PROPERTIES = 4243;
    public static final int CL_MEM_READ_WRITE = 1;
    public static final int CL_MEM_WRITE_ONLY = 2;
    public static final int CL_MEM_READ_ONLY = 4;
    public static final int CL_MEM_USE_HOST_PTR = 8;
    public static final int CL_MEM_ALLOC_HOST_PTR = 16;
    public static final int CL_MEM_COPY_HOST_PTR = 32;
    public static final int CL_R = 4272;
    public static final int CL_A = 4273;
    public static final int CL_RG = 4274;
    public static final int CL_RA = 4275;
    public static final int CL_RGB = 4276;
    public static final int CL_RGBA = 4277;
    public static final int CL_BGRA = 4278;
    public static final int CL_ARGB = 4279;
    public static final int CL_INTENSITY = 4280;
    public static final int CL_LUMINANCE = 4281;
    public static final int CL_SNORM_INT8 = 4304;
    public static final int CL_SNORM_INT16 = 4305;
    public static final int CL_UNORM_INT8 = 4306;
    public static final int CL_UNORM_INT16 = 4307;
    public static final int CL_UNORM_SHORT_565 = 4308;
    public static final int CL_UNORM_SHORT_555 = 4309;
    public static final int CL_UNORM_INT_101010 = 4310;
    public static final int CL_SIGNED_INT8 = 4311;
    public static final int CL_SIGNED_INT16 = 4312;
    public static final int CL_SIGNED_INT32 = 4313;
    public static final int CL_UNSIGNED_INT8 = 4314;
    public static final int CL_UNSIGNED_INT16 = 4315;
    public static final int CL_UNSIGNED_INT32 = 4316;
    public static final int CL_HALF_FLOAT = 4317;
    public static final int CL_FLOAT = 4318;
    public static final int CL_MEM_OBJECT_BUFFER = 4336;
    public static final int CL_MEM_OBJECT_IMAGE2D = 4337;
    public static final int CL_MEM_OBJECT_IMAGE3D = 4338;
    public static final int CL_MEM_TYPE = 4352;
    public static final int CL_MEM_FLAGS = 4353;
    public static final int CL_MEM_SIZE = 4354;
    public static final int CL_MEM_HOST_PTR = 4355;
    public static final int CL_MEM_MAP_COUNT = 4356;
    public static final int CL_MEM_REFERENCE_COUNT = 4357;
    public static final int CL_MEM_CONTEXT = 4358;
    public static final int CL_IMAGE_FORMAT = 4368;
    public static final int CL_IMAGE_ELEMENT_SIZE = 4369;
    public static final int CL_IMAGE_ROW_PITCH = 4370;
    public static final int CL_IMAGE_SLICE_PITCH = 4371;
    public static final int CL_IMAGE_WIDTH = 4372;
    public static final int CL_IMAGE_HEIGHT = 4373;
    public static final int CL_IMAGE_DEPTH = 4374;
    public static final int CL_ADDRESS_NONE = 4400;
    public static final int CL_ADDRESS_CLAMP_TO_EDGE = 4401;
    public static final int CL_ADDRESS_CLAMP = 4402;
    public static final int CL_ADDRESS_REPEAT = 4403;
    public static final int CL_FILTER_NEAREST = 4416;
    public static final int CL_FILTER_LINEAR = 4417;
    public static final int CL_SAMPLER_REFERENCE_COUNT = 4432;
    public static final int CL_SAMPLER_CONTEXT = 4433;
    public static final int CL_SAMPLER_NORMALIZED_COORDS = 4434;
    public static final int CL_SAMPLER_ADDRESSING_MODE = 4435;
    public static final int CL_SAMPLER_FILTER_MODE = 4436;
    public static final int CL_MAP_READ = 1;
    public static final int CL_MAP_WRITE = 2;
    public static final int CL_PROGRAM_REFERENCE_COUNT = 4448;
    public static final int CL_PROGRAM_CONTEXT = 4449;
    public static final int CL_PROGRAM_NUM_DEVICES = 4450;
    public static final int CL_PROGRAM_DEVICES = 4451;
    public static final int CL_PROGRAM_SOURCE = 4452;
    public static final int CL_PROGRAM_BINARY_SIZES = 4453;
    public static final int CL_PROGRAM_BINARIES = 4454;
    public static final int CL_PROGRAM_BUILD_STATUS = 4481;
    public static final int CL_PROGRAM_BUILD_OPTIONS = 4482;
    public static final int CL_PROGRAM_BUILD_LOG = 4483;
    public static final int CL_BUILD_SUCCESS = 0;
    public static final int CL_BUILD_NONE = -1;
    public static final int CL_BUILD_ERROR = -2;
    public static final int CL_BUILD_IN_PROGRESS = -3;
    public static final int CL_KERNEL_FUNCTION_NAME = 4496;
    public static final int CL_KERNEL_NUM_ARGS = 4497;
    public static final int CL_KERNEL_REFERENCE_COUNT = 4498;
    public static final int CL_KERNEL_CONTEXT = 4499;
    public static final int CL_KERNEL_PROGRAM = 4500;
    public static final int CL_KERNEL_WORK_GROUP_SIZE = 4528;
    public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE = 4529;
    public static final int CL_KERNEL_LOCAL_MEM_SIZE = 4530;
    public static final int CL_EVENT_COMMAND_QUEUE = 4560;
    public static final int CL_EVENT_COMMAND_TYPE = 4561;
    public static final int CL_EVENT_REFERENCE_COUNT = 4562;
    public static final int CL_EVENT_COMMAND_EXECUTION_STATUS = 4563;
    public static final int CL_COMMAND_NDRANGE_KERNEL = 4592;
    public static final int CL_COMMAND_TASK = 4593;
    public static final int CL_COMMAND_NATIVE_KERNEL = 4594;
    public static final int CL_COMMAND_READ_BUFFER = 4595;
    public static final int CL_COMMAND_WRITE_BUFFER = 4596;
    public static final int CL_COMMAND_COPY_BUFFER = 4597;
    public static final int CL_COMMAND_READ_IMAGE = 4598;
    public static final int CL_COMMAND_WRITE_IMAGE = 4599;
    public static final int CL_COMMAND_COPY_IMAGE = 4600;
    public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER = 4601;
    public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE = 4602;
    public static final int CL_COMMAND_MAP_BUFFER = 4603;
    public static final int CL_COMMAND_MAP_IMAGE = 4604;
    public static final int CL_COMMAND_UNMAP_MEM_OBJECT = 4605;
    public static final int CL_COMMAND_MARKER = 4606;
    public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS = 4607;
    public static final int CL_COMMAND_RELEASE_GL_OBJECTS = 4608;
    public static final int CL_COMPLETE = 0;
    public static final int CL_RUNNING = 1;
    public static final int CL_SUBMITTED = 2;
    public static final int CL_QUEUED = 3;
    public static final int CL_PROFILING_COMMAND_QUEUED = 4736;
    public static final int CL_PROFILING_COMMAND_SUBMIT = 4737;
    public static final int CL_PROFILING_COMMAND_START = 4738;
    public static final int CL_PROFILING_COMMAND_END = 4739;

    protected CL10() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.clGetPlatformIDs, caps.clGetPlatformInfo, caps.clGetDeviceIDs, caps.clGetDeviceInfo, caps.clCreateContext, caps.clCreateContextFromType, caps.clRetainContext, caps.clReleaseContext, caps.clGetContextInfo, caps.clCreateCommandQueue, caps.clRetainCommandQueue, caps.clReleaseCommandQueue, caps.clGetCommandQueueInfo, caps.clCreateBuffer, caps.clEnqueueReadBuffer, caps.clEnqueueWriteBuffer, caps.clEnqueueCopyBuffer, caps.clEnqueueMapBuffer, caps.clCreateImage2D, caps.clCreateImage3D, caps.clGetSupportedImageFormats, caps.clEnqueueReadImage, caps.clEnqueueWriteImage, caps.clEnqueueCopyImage, caps.clEnqueueCopyImageToBuffer, caps.clEnqueueCopyBufferToImage, caps.clEnqueueMapImage, caps.clGetImageInfo, caps.clRetainMemObject, caps.clReleaseMemObject, caps.clEnqueueUnmapMemObject, caps.clGetMemObjectInfo, caps.clCreateSampler, caps.clRetainSampler, caps.clReleaseSampler, caps.clGetSamplerInfo, caps.clCreateProgramWithSource, caps.clCreateProgramWithBinary, caps.clRetainProgram, caps.clReleaseProgram, caps.clBuildProgram, caps.clUnloadCompiler, caps.clGetProgramInfo, caps.clGetProgramBuildInfo, caps.clCreateKernel, caps.clCreateKernelsInProgram, caps.clRetainKernel, caps.clReleaseKernel, caps.clSetKernelArg, caps.clGetKernelInfo, caps.clGetKernelWorkGroupInfo, caps.clEnqueueNDRangeKernel, caps.clEnqueueTask, caps.clEnqueueNativeKernel, caps.clWaitForEvents, caps.clGetEventInfo, caps.clRetainEvent, caps.clReleaseEvent, caps.clEnqueueMarker, caps.clEnqueueBarrier, caps.clEnqueueWaitForEvents, caps.clGetEventProfilingInfo, caps.clFlush, caps.clFinish, caps.clGetExtensionFunctionAddress});
    }

    public static int nclGetPlatformIDs(int num_entries, long platforms, long num_platforms) {
        long __functionAddress = CL.getICD().clGetPlatformIDs;
        return JNI.callPPI((int)num_entries, (long)platforms, (long)num_platforms, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformIDs(@Nullable @NativeType(value="cl_platform_id *") PointerBuffer platforms, @Nullable @NativeType(value="cl_uint *") IntBuffer num_platforms) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_platforms, (int)1);
        }
        return CL10.nclGetPlatformIDs(Checks.remainingSafe((CustomBuffer)platforms), MemoryUtil.memAddressSafe((Pointer)platforms), MemoryUtil.memAddressSafe((IntBuffer)num_platforms));
    }

    public static int nclGetPlatformInfo(long platform, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPlatformInfo;
        if (Checks.CHECKS) {
            Checks.check((long)platform);
        }
        return JNI.callPPPPI((long)platform, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformInfo(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_platform_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetPlatformInfo(platform, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformInfo(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_platform_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetPlatformInfo(platform, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 3, MemoryUtil.memAddressSafe((LongBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int nclGetDeviceIDs(long platform, long device_type, int num_entries, long devices, long num_devices) {
        long __functionAddress = CL.getICD().clGetDeviceIDs;
        return JNI.callPJPPI((long)platform, (long)device_type, (int)num_entries, (long)devices, (long)num_devices, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceIDs(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="cl_device_id *") PointerBuffer devices, @Nullable @NativeType(value="cl_uint *") IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_devices, (int)1);
        }
        return CL10.nclGetDeviceIDs(platform, device_type, Checks.remainingSafe((CustomBuffer)devices), MemoryUtil.memAddressSafe((Pointer)devices), MemoryUtil.memAddressSafe((IntBuffer)num_devices));
    }

    public static int nclGetDeviceInfo(long device, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check((long)device);
        }
        return JNI.callPPPPI((long)device, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 3, MemoryUtil.memAddressSafe((LongBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclCreateContext(long properties, int num_devices, long devices, long pfn_notify, long user_data, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContext;
        return JNI.callPPPPPP((long)properties, (int)num_devices, (long)devices, (long)pfn_notify, (long)user_data, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContext(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties, @NativeType(value="cl_device_id const *") PointerBuffer devices, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateContext(MemoryUtil.memAddressSafe((Pointer)properties), devices.remaining(), MemoryUtil.memAddress((CustomBuffer)devices), MemoryUtil.memAddressSafe((Pointer)pfn_notify), user_data, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_context")
    public static long clCreateContext(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties, @NativeType(value="cl_device_id const *") long device, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer devices = stack.pointers(device);
            long l = CL10.nclCreateContext(MemoryUtil.memAddressSafe((Pointer)properties), 1, MemoryUtil.memAddress((CustomBuffer)devices), MemoryUtil.memAddressSafe((Pointer)pfn_notify), user_data, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclCreateContextFromType(long properties, long device_type, long pfn_notify, long user_data, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContextFromType;
        return JNI.callPJPPPP((long)properties, (long)device_type, (long)pfn_notify, (long)user_data, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContextFromType(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateContextFromType(MemoryUtil.memAddressSafe((Pointer)properties), device_type, MemoryUtil.memAddressSafe((Pointer)pfn_notify), user_data, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainContext(@NativeType(value="cl_context") long context) {
        long __functionAddress = CL.getICD().clRetainContext;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPI((long)context, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseContext(@NativeType(value="cl_context") long context) {
        long __functionAddress = CL.getICD().clReleaseContext;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPI((long)context, (long)__functionAddress);
    }

    public static int nclGetContextInfo(long context, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetContextInfo;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPPPPI((long)context, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetContextInfo(context, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetContextInfo(context, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetContextInfo(context, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclCreateCommandQueue(long context, long device, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueue;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)device);
        }
        return JNI.callPPJPP((long)context, (long)device, (long)properties, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_command_queue")
    public static long clCreateCommandQueue(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_command_queue_properties") long properties, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateCommandQueue(context, device, properties, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainCommandQueue(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clRetainCommandQueue;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPI((long)command_queue, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseCommandQueue(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clReleaseCommandQueue;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPI((long)command_queue, (long)__functionAddress);
    }

    public static int nclGetCommandQueueInfo(long command_queue, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandQueueInfo;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPI((long)command_queue, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 3, MemoryUtil.memAddressSafe((LongBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclCreateBuffer(long context, long flags, long size, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPJPPPP((long)context, (long)flags, (long)size, (long)host_ptr, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateBuffer(context, flags, size, 0L, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateBuffer(context, flags, host_ptr.remaining(), MemoryUtil.memAddress((ByteBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateBuffer(context, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateBuffer(context, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateBuffer(context, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") DoubleBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateBuffer(context, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 3, MemoryUtil.memAddress((DoubleBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static int nclEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, long size, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)blocking_read, (long)offset, (long)size, (long)ptr, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset, ptr.remaining(), MemoryUtil.memAddress((ByteBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 3, MemoryUtil.memAddress((DoubleBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, long size, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)blocking_write, (long)offset, (long)size, (long)ptr, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset, ptr.remaining(), MemoryUtil.memAddress((ByteBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset, Integer.toUnsignedLong(ptr.remaining()) << 3, MemoryUtil.memAddress((DoubleBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueCopyBuffer(long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_buffer);
        }
        return JNI.callPPPPPPPPI((long)command_queue, (long)src_buffer, (long)dst_buffer, (long)src_offset, (long)dst_offset, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t") long dst_offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static long nclEnqueueMapBuffer(long command_queue, long buffer, int blocking_map, long map_flags, long offset, long size, int num_events_in_wait_list, long event_wait_list, long event, long errcode_ret) {
        long __functionAddress = CL.getICD().clEnqueueMapBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
        }
        return JNI.callPPJPPPPPP((long)command_queue, (long)buffer, (int)blocking_map, (long)map_flags, (long)offset, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)errcode_ret, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        long __result = CL10.nclEnqueueMapBuffer(command_queue, buffer, blocking_map ? 1 : 0, map_flags, offset, size, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)size));
    }

    public static long nclCreateImage2D(long context, long flags, long image_format, long image_width, long image_height, long image_row_pitch, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPJPPPPPPP((long)context, (long)flags, (long)image_format, (long)image_width, (long)image_height, (long)image_row_pitch, (long)host_ptr, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage2D(context, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe((ByteBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage2D(context, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe((ShortBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage2D(context, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe((IntBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage2D(context, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe((FloatBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static long nclCreateImage3D(long context, long flags, long image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPJPPPPPPPPP((long)context, (long)flags, (long)image_format, (long)image_width, (long)image_height, (long)image_depth, (long)image_row_pitch, (long)image_slice_pitch, (long)host_ptr, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage3D(context, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe((ByteBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage3D(context, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe((ShortBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage3D(context, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe((IntBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateImage3D(context, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe((FloatBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static int nclGetSupportedImageFormats(long context, long flags, int image_type, int num_entries, long image_formats, long num_image_formats) {
        long __functionAddress = CL.getICD().clGetSupportedImageFormats;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPJPPI((long)context, (long)flags, (int)image_type, (int)num_entries, (long)image_formats, (long)num_image_formats, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSupportedImageFormats(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_mem_object_type") int image_type, @Nullable @NativeType(value="cl_image_format *") CLImageFormat.Buffer image_formats, @Nullable @NativeType(value="cl_uint *") IntBuffer num_image_formats) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_image_formats, (int)1);
        }
        return CL10.nclGetSupportedImageFormats(context, flags, image_type, Checks.remainingSafe((CustomBuffer)image_formats), MemoryUtil.memAddressSafe((Pointer)image_formats), MemoryUtil.memAddressSafe((IntBuffer)num_image_formats));
    }

    public static int nclEnqueueReadImage(long command_queue, long image, int blocking_read, long origin, long region, long row_pitch, long slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)blocking_read, (long)origin, (long)region, (long)row_pitch, (long)slice_pitch, (long)ptr, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), row_pitch, slice_pitch, MemoryUtil.memAddress((ByteBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), row_pitch, slice_pitch, MemoryUtil.memAddress((ShortBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), row_pitch, slice_pitch, MemoryUtil.memAddress((IntBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), row_pitch, slice_pitch, MemoryUtil.memAddress((FloatBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), row_pitch, slice_pitch, MemoryUtil.memAddress((DoubleBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueWriteImage(long command_queue, long image, int blocking_write, long origin, long region, long input_row_pitch, long input_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)blocking_write, (long)origin, (long)region, (long)input_row_pitch, (long)input_slice_pitch, (long)ptr, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress((ByteBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress((ShortBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress((IntBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress((FloatBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress((DoubleBuffer)ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueCopyImage(long command_queue, long src_image, long dst_image, long src_origin, long dst_origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)src_image);
            Checks.check((long)dst_image);
        }
        return JNI.callPPPPPPPPI((long)command_queue, (long)src_image, (long)dst_image, (long)src_origin, (long)dst_origin, (long)region, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueCopyImage(command_queue, src_image, dst_image, MemoryUtil.memAddress((CustomBuffer)src_origin), MemoryUtil.memAddress((CustomBuffer)dst_origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueCopyImageToBuffer(long command_queue, long src_image, long dst_buffer, long src_origin, long region, long dst_offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyImageToBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)src_image);
            Checks.check((long)dst_buffer);
        }
        return JNI.callPPPPPPPPI((long)command_queue, (long)src_image, (long)dst_buffer, (long)src_origin, (long)region, (long)dst_offset, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyImageToBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long dst_offset, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, MemoryUtil.memAddress((CustomBuffer)src_origin), MemoryUtil.memAddress((CustomBuffer)region), dst_offset, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueCopyBufferToImage(long command_queue, long src_buffer, long dst_image, long src_offset, long dst_origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyBufferToImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_image);
        }
        return JNI.callPPPPPPPPI((long)command_queue, (long)src_buffer, (long)dst_image, (long)src_offset, (long)dst_origin, (long)region, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyBufferToImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress((CustomBuffer)dst_origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static long nclEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, long origin, long region, long image_row_pitch, long image_slice_pitch, int num_events_in_wait_list, long event_wait_list, long event, long errcode_ret) {
        long __functionAddress = CL.getICD().clEnqueueMapImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
        }
        return JNI.callPPJPPPPPPPP((long)command_queue, (long)image, (int)blocking_map, (long)map_flags, (long)origin, (long)region, (long)image_row_pitch, (long)image_slice_pitch, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)errcode_ret, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.check((CustomBuffer)image_row_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)image_slice_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)event, (int)1);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), MemoryUtil.memAddress((CustomBuffer)image_row_pitch), MemoryUtil.memAddressSafe((Pointer)image_slice_pitch), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
        int length = (int)CL10.getMemObjectInfoPointer(image, 4354);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret, long length, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.check((CustomBuffer)image_row_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)image_slice_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)event, (int)1);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), MemoryUtil.memAddress((CustomBuffer)image_row_pitch), MemoryUtil.memAddressSafe((Pointer)image_slice_pitch), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static int nclGetImageInfo(long image, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetImageInfo;
        if (Checks.CHECKS) {
            Checks.check((long)image);
        }
        return JNI.callPPPPI((long)image, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetImageInfo(image, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetImageInfo(image, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetImageInfo(image, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainMemObject(@NativeType(value="cl_mem") long memobj) {
        long __functionAddress = CL.getICD().clRetainMemObject;
        if (Checks.CHECKS) {
            Checks.check((long)memobj);
        }
        return JNI.callPI((long)memobj, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseMemObject(@NativeType(value="cl_mem") long memobj) {
        long __functionAddress = CL.getICD().clReleaseMemObject;
        if (Checks.CHECKS) {
            Checks.check((long)memobj);
        }
        return JNI.callPI((long)memobj, (long)__functionAddress);
    }

    public static int nclEnqueueUnmapMemObject(long command_queue, long memobj, long mapped_ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueUnmapMemObject;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)memobj);
        }
        return JNI.callPPPPPI((long)command_queue, (long)memobj, (long)mapped_ptr, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueUnmapMemObject(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long memobj, @NativeType(value="void *") ByteBuffer mapped_ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueUnmapMemObject(command_queue, memobj, MemoryUtil.memAddress((ByteBuffer)mapped_ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclGetMemObjectInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemObjectInfo;
        if (Checks.CHECKS) {
            Checks.check((long)memobj);
        }
        return JNI.callPPPPI((long)memobj, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 3, MemoryUtil.memAddressSafe((LongBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclCreateSampler(long context, int normalized_coords, int addressing_mode, int filter_mode, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSampler;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPPP((long)context, (int)normalized_coords, (int)addressing_mode, (int)filter_mode, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_sampler")
    public static long clCreateSampler(@NativeType(value="cl_context") long context, @NativeType(value="cl_bool") boolean normalized_coords, @NativeType(value="cl_addressing_mode") int addressing_mode, @NativeType(value="cl_filter_mode") int filter_mode, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateSampler(context, normalized_coords ? 1 : 0, addressing_mode, filter_mode, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainSampler(@NativeType(value="cl_sampler") long sampler) {
        long __functionAddress = CL.getICD().clRetainSampler;
        if (Checks.CHECKS) {
            Checks.check((long)sampler);
        }
        return JNI.callPI((long)sampler, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseSampler(@NativeType(value="cl_sampler") long sampler) {
        long __functionAddress = CL.getICD().clReleaseSampler;
        if (Checks.CHECKS) {
            Checks.check((long)sampler);
        }
        return JNI.callPI((long)sampler, (long)__functionAddress);
    }

    public static int nclGetSamplerInfo(long sampler, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSamplerInfo;
        if (Checks.CHECKS) {
            Checks.check((long)sampler);
        }
        return JNI.callPPPPI((long)sampler, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclCreateProgramWithSource(long context, int count, long strings, long lengths, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithSource;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPPPPP((long)context, (int)count, (long)strings, (long)lengths, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context, @NativeType(value="cl_char const **") PointerBuffer strings, @Nullable @NativeType(value="size_t const *") PointerBuffer lengths, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)lengths, (int)strings.remaining());
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateProgramWithSource(context, strings.remaining(), MemoryUtil.memAddress((CustomBuffer)strings), MemoryUtil.memAddressSafe((Pointer)lengths), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context, @NativeType(value="cl_char const **") CharSequence[] strings, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArrayp((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])strings);
            long __result = CL10.nclCreateProgramWithSource(context, strings.length, stringsAddress, stringsAddress - (long)(strings.length << Pointer.POINTER_SHIFT), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
            APIUtil.apiArrayFree((long)stringsAddress, (int)strings.length);
            long l = __result;
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context, @NativeType(value="cl_char const **") CharSequence string, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArrayp((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])new CharSequence[]{string});
            long __result = CL10.nclCreateProgramWithSource(context, 1, stringsAddress, stringsAddress - (long)Pointer.POINTER_SIZE, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
            APIUtil.apiArrayFree((long)stringsAddress, (int)1);
            long l = __result;
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclCreateProgramWithBinary(long context, int num_devices, long device_list, long lengths, long binaries, long binary_status, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBinary;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.callPPPPPPP((long)context, (int)num_devices, (long)device_list, (long)lengths, (long)binaries, (long)binary_status, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="size_t const *") PointerBuffer lengths, @NativeType(value="cl_uchar const **") PointerBuffer binaries, @Nullable @NativeType(value="cl_int *") IntBuffer binary_status, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)device_list, (int)binaries.remaining());
            Checks.check((CustomBuffer)lengths, (int)binaries.remaining());
            Checks.checkSafe((Buffer)binary_status, (int)binaries.remaining());
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateProgramWithBinary(context, binaries.remaining(), MemoryUtil.memAddress((CustomBuffer)device_list), MemoryUtil.memAddress((CustomBuffer)lengths), MemoryUtil.memAddress((CustomBuffer)binaries), MemoryUtil.memAddressSafe((IntBuffer)binary_status), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_uchar const **") ByteBuffer[] binaries, @Nullable @NativeType(value="cl_int *") IntBuffer binary_status, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)device_list, (int)binaries.length);
            Checks.checkSafe((Buffer)binary_status, (int)binaries.length);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long binariesAddress = APIUtil.apiArrayp((MemoryStack)stack, (ByteBuffer[])binaries);
            long l = CL10.nclCreateProgramWithBinary(context, binaries.length, MemoryUtil.memAddress((CustomBuffer)device_list), binariesAddress - (long)(binaries.length << Pointer.POINTER_SHIFT), binariesAddress, MemoryUtil.memAddressSafe((IntBuffer)binary_status), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_uchar const **") ByteBuffer binary, @Nullable @NativeType(value="cl_int *") IntBuffer binary_status, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)device_list, (int)1);
            Checks.checkSafe((Buffer)binary_status, (int)1);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long binariesAddress = APIUtil.apiArrayp((MemoryStack)stack, (ByteBuffer[])new ByteBuffer[]{binary});
            long l = CL10.nclCreateProgramWithBinary(context, 1, MemoryUtil.memAddress((CustomBuffer)device_list), binariesAddress - (long)Pointer.POINTER_SIZE, binariesAddress, MemoryUtil.memAddressSafe((IntBuffer)binary_status), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clRetainProgram(@NativeType(value="cl_program") long program) {
        long __functionAddress = CL.getICD().clRetainProgram;
        if (Checks.CHECKS) {
            Checks.check((long)program);
        }
        return JNI.callPI((long)program, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseProgram(@NativeType(value="cl_program") long program) {
        long __functionAddress = CL.getICD().clReleaseProgram;
        if (Checks.CHECKS) {
            Checks.check((long)program);
        }
        return JNI.callPI((long)program, (long)__functionAddress);
    }

    public static int nclBuildProgram(long program, int num_devices, long device_list, long options, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clBuildProgram;
        if (Checks.CHECKS) {
            Checks.check((long)program);
        }
        return JNI.callPPPPPI((long)program, (int)num_devices, (long)device_list, (long)options, (long)pfn_notify, (long)user_data, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clBuildProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") ByteBuffer options, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)options);
        }
        return CL10.nclBuildProgram(program, Checks.remainingSafe((CustomBuffer)device_list), MemoryUtil.memAddressSafe((Pointer)device_list), MemoryUtil.memAddress((ByteBuffer)options), MemoryUtil.memAddressSafe((Pointer)pfn_notify), user_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clBuildProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(options, true);
            long optionsEncoded = stack.getPointerAddress();
            int n = CL10.nclBuildProgram(program, Checks.remainingSafe((CustomBuffer)device_list), MemoryUtil.memAddressSafe((Pointer)device_list), optionsEncoded, MemoryUtil.memAddressSafe((Pointer)pfn_notify), user_data);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clBuildProgram(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id const *") long device, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(options, true);
            long optionsEncoded = stack.getPointerAddress();
            PointerBuffer device_list = stack.pointers(device);
            int n = CL10.nclBuildProgram(program, 1, MemoryUtil.memAddress((CustomBuffer)device_list), optionsEncoded, MemoryUtil.memAddressSafe((Pointer)pfn_notify), user_data);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clUnloadCompiler() {
        long __functionAddress = CL.getICD().clUnloadCompiler;
        return JNI.callI((long)__functionAddress);
    }

    public static int nclGetProgramInfo(long program, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramInfo;
        if (Checks.CHECKS) {
            Checks.check((long)program);
        }
        return JNI.callPPPPI((long)program, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetProgramInfo(program, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetProgramInfo(program, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetProgramInfo(program, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int nclGetProgramBuildInfo(long program, long device, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramBuildInfo;
        if (Checks.CHECKS) {
            Checks.check((long)program);
            Checks.check((long)device);
        }
        return JNI.callPPPPPI((long)program, (long)device, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclCreateKernel(long program, long kernel_name, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateKernel;
        if (Checks.CHECKS) {
            Checks.check((long)program);
        }
        return JNI.callPPPP((long)program, (long)kernel_name, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") ByteBuffer kernel_name, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)kernel_name);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL10.nclCreateKernel(program, MemoryUtil.memAddress((ByteBuffer)kernel_name), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") CharSequence kernel_name, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(kernel_name, true);
            long kernel_nameEncoded = stack.getPointerAddress();
            long l = CL10.nclCreateKernel(program, kernel_nameEncoded, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclCreateKernelsInProgram(long program, int num_kernels, long kernels, long num_kernels_ret) {
        long __functionAddress = CL.getICD().clCreateKernelsInProgram;
        if (Checks.CHECKS) {
            Checks.check((long)program);
        }
        return JNI.callPPPI((long)program, (int)num_kernels, (long)kernels, (long)num_kernels_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCreateKernelsInProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_kernel *") PointerBuffer kernels, @Nullable @NativeType(value="cl_uint *") IntBuffer num_kernels_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_kernels_ret, (int)1);
        }
        return CL10.nclCreateKernelsInProgram(program, Checks.remainingSafe((CustomBuffer)kernels), MemoryUtil.memAddressSafe((Pointer)kernels), MemoryUtil.memAddressSafe((IntBuffer)num_kernels_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainKernel(@NativeType(value="cl_kernel") long kernel) {
        long __functionAddress = CL.getICD().clRetainKernel;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPI((long)kernel, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseKernel(@NativeType(value="cl_kernel") long kernel) {
        long __functionAddress = CL.getICD().clReleaseKernel;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPI((long)kernel, (long)__functionAddress);
    }

    public static int nclSetKernelArg(long kernel, int arg_index, long arg_size, long arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)kernel, (int)arg_index, (long)arg_size, (long)arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="size_t") long arg_size) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_size, 0L);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ByteBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining(), MemoryUtil.memAddress((ByteBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ShortBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") IntBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") LongBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 3, MemoryUtil.memAddress((LongBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") FloatBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") DoubleBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 3, MemoryUtil.memAddress((DoubleBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") PointerBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddress((CustomBuffer)arg_value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1b(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") byte arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer arg_value = stack.bytes(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 1L, MemoryUtil.memAddress((ByteBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2b(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") byte arg0, byte arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer arg_value = stack.bytes(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 2L, MemoryUtil.memAddress((ByteBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4b(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") byte arg0, byte arg1, byte arg2, byte arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer arg_value = stack.bytes(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress((ByteBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1s(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ShortBuffer arg_value = stack.shorts(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 2L, MemoryUtil.memAddress((ShortBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2s(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short arg0, short arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ShortBuffer arg_value = stack.shorts(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress((ShortBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4s(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short arg0, short arg1, short arg2, short arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ShortBuffer arg_value = stack.shorts(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress((ShortBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1i(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arg_value = stack.ints(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress((IntBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2i(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int arg0, int arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arg_value = stack.ints(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress((IntBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4i(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int arg0, int arg1, int arg2, int arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arg_value = stack.ints(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress((IntBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1l(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer arg_value = stack.longs(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress((LongBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2l(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer arg_value = stack.longs(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress((LongBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4l(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1, long arg2, long arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer arg_value = stack.longs(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 32L, MemoryUtil.memAddress((LongBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1f(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer arg_value = stack.floats(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress((FloatBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2f(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float arg0, float arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer arg_value = stack.floats(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress((FloatBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4f(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float arg0, float arg1, float arg2, float arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer arg_value = stack.floats(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress((FloatBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1d(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer arg_value = stack.doubles(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress((DoubleBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2d(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double arg0, double arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer arg_value = stack.doubles(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress((DoubleBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4d(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double arg0, double arg1, double arg2, double arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer arg_value = stack.doubles(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 32L, MemoryUtil.memAddress((DoubleBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1p(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer arg_value = stack.pointers(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 1, MemoryUtil.memAddress((CustomBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2p(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer arg_value = stack.pointers(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 2, MemoryUtil.memAddress((CustomBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4p(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1, long arg2, long arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer arg_value = stack.pointers(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 4, MemoryUtil.memAddress((CustomBuffer)arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclGetKernelInfo(long kernel, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelInfo;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPPI((long)kernel, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int nclGetKernelWorkGroupInfo(long kernel, long device, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelWorkGroupInfo;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
            Checks.check((long)device);
        }
        return JNI.callPPPPPI((long)kernel, (long)device, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 3, MemoryUtil.memAddressSafe((LongBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int nclEnqueueNDRangeKernel(long command_queue, long kernel, int work_dim, long global_work_offset, long global_work_size, long local_work_size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueNDRangeKernel;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)kernel);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)kernel, (int)work_dim, (long)global_work_offset, (long)global_work_size, (long)local_work_size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueNDRangeKernel(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int work_dim, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_offset, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_size, @Nullable @NativeType(value="size_t const *") PointerBuffer local_work_size, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)global_work_offset, (int)work_dim);
            Checks.checkSafe((CustomBuffer)global_work_size, (int)work_dim);
            Checks.checkSafe((CustomBuffer)local_work_size, (int)work_dim);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueNDRangeKernel(command_queue, kernel, work_dim, MemoryUtil.memAddressSafe((Pointer)global_work_offset), MemoryUtil.memAddressSafe((Pointer)global_work_size), MemoryUtil.memAddressSafe((Pointer)local_work_size), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueTask(long command_queue, long kernel, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueTask;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)kernel);
        }
        return JNI.callPPPPI((long)command_queue, (long)kernel, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueTask(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_kernel") long kernel, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueTask(command_queue, kernel, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueNativeKernel(long command_queue, long user_func, long args, long cb_args, int num_mem_objects, long mem_list, long args_mem_loc, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueNativeKernel;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPPPPI((long)command_queue, (long)user_func, (long)args, (long)cb_args, (int)num_mem_objects, (long)mem_list, (long)args_mem_loc, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueNativeKernel(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void (*) (void *)") CLNativeKernelI user_func, @Nullable @NativeType(value="void *") ByteBuffer args, @Nullable @NativeType(value="cl_mem const *") PointerBuffer mem_list, @Nullable @NativeType(value="void const **") PointerBuffer args_mem_loc, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)args_mem_loc, (int)Checks.remainingSafe((CustomBuffer)mem_list));
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueNativeKernel(command_queue, user_func.address(), MemoryUtil.memAddressSafe((ByteBuffer)args), Checks.remainingSafe((Buffer)args), Checks.remainingSafe((CustomBuffer)mem_list), MemoryUtil.memAddressSafe((Pointer)mem_list), MemoryUtil.memAddressSafe((Pointer)args_mem_loc), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueNativeKernel(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void (*) (void *)") CLNativeKernelI user_func, @Nullable @NativeType(value="void *") ByteBuffer args, @NativeType(value="cl_mem const *") long memobj, @NativeType(value="void const **") long memobj_loc, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_list = stack.pointers(memobj);
            PointerBuffer args_mem_loc = stack.pointers(memobj_loc);
            int n = CL10.nclEnqueueNativeKernel(command_queue, user_func.address(), MemoryUtil.memAddressSafe((ByteBuffer)args), Checks.remainingSafe((Buffer)args), 1, MemoryUtil.memAddress((CustomBuffer)mem_list), MemoryUtil.memAddress((CustomBuffer)args_mem_loc), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclWaitForEvents(int num_events, long event_list) {
        long __functionAddress = CL.getICD().clWaitForEvents;
        return JNI.callPI((int)num_events, (long)event_list, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clWaitForEvents(@NativeType(value="cl_event const *") PointerBuffer event_list) {
        return CL10.nclWaitForEvents(event_list.remaining(), MemoryUtil.memAddress((CustomBuffer)event_list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clWaitForEvents(@NativeType(value="cl_event const *") long event) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer event_list = stack.pointers(event);
            int n = CL10.nclWaitForEvents(1, MemoryUtil.memAddress((CustomBuffer)event_list));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclGetEventInfo(long event, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventInfo;
        if (Checks.CHECKS) {
            Checks.check((long)event);
        }
        return JNI.callPPPPI((long)event, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetEventInfo(event, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetEventInfo(event, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetEventInfo(event, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainEvent(@NativeType(value="cl_event") long event) {
        long __functionAddress = CL.getICD().clRetainEvent;
        if (Checks.CHECKS) {
            Checks.check((long)event);
        }
        return JNI.callPI((long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseEvent(@NativeType(value="cl_event") long event) {
        long __functionAddress = CL.getICD().clReleaseEvent;
        if (Checks.CHECKS) {
            Checks.check((long)event);
        }
        return JNI.callPI((long)event, (long)__functionAddress);
    }

    public static int nclEnqueueMarker(long command_queue, long event) {
        long __functionAddress = CL.getICD().clEnqueueMarker;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPPI((long)command_queue, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMarker(@NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL10.nclEnqueueMarker(command_queue, MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueBarrier(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clEnqueueBarrier;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPI((long)command_queue, (long)__functionAddress);
    }

    public static int nclEnqueueWaitForEvents(long command_queue, int num_events, long event_list) {
        long __functionAddress = CL.getICD().clEnqueueWaitForEvents;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPPI((long)command_queue, (int)num_events, (long)event_list, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitForEvents(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_event const *") PointerBuffer event_list) {
        return CL10.nclEnqueueWaitForEvents(command_queue, event_list.remaining(), MemoryUtil.memAddress((CustomBuffer)event_list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueWaitForEvents(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_event const *") long event) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer event_list = stack.pointers(event);
            int n = CL10.nclEnqueueWaitForEvents(command_queue, 1, MemoryUtil.memAddress((CustomBuffer)event_list));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclGetEventProfilingInfo(long event, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventProfilingInfo;
        if (Checks.CHECKS) {
            Checks.check((long)event);
        }
        return JNI.callPPPPI((long)event, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventProfilingInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_profiling_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetEventProfilingInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_profiling_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 3, MemoryUtil.memAddressSafe((LongBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clFlush(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clFlush;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPI((long)command_queue, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clFinish(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clFinish;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
        }
        return JNI.callPI((long)command_queue, (long)__functionAddress);
    }

    public static long nclGetExtensionFunctionAddress(long funcname) {
        long __functionAddress = CL.getICD().clGetExtensionFunctionAddress;
        return JNI.callPP((long)funcname, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long clGetExtensionFunctionAddress(@NativeType(value="cl_char const *") ByteBuffer funcname) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)funcname);
        }
        return CL10.nclGetExtensionFunctionAddress(MemoryUtil.memAddress((ByteBuffer)funcname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long clGetExtensionFunctionAddress(@NativeType(value="cl_char const *") CharSequence funcname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(funcname, true);
            long funcnameEncoded = stack.getPointerAddress();
            long l = CL10.nclGetExtensionFunctionAddress(funcnameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformIDs(@Nullable @NativeType(value="cl_platform_id *") PointerBuffer platforms, @Nullable @NativeType(value="cl_uint *") int[] num_platforms) {
        long __functionAddress = CL.getICD().clGetPlatformIDs;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])num_platforms, (int)1);
        }
        return JNI.callPPI((int)Checks.remainingSafe((CustomBuffer)platforms), (long)MemoryUtil.memAddressSafe((Pointer)platforms), (int[])num_platforms, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformInfo(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_platform_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPlatformInfo;
        if (Checks.CHECKS) {
            Checks.check((long)platform);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)platform, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((long[])param_value)) << 3), (long[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceIDs(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="cl_device_id *") PointerBuffer devices, @Nullable @NativeType(value="cl_uint *") int[] num_devices) {
        long __functionAddress = CL.getICD().clGetDeviceIDs;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])num_devices, (int)1);
        }
        return JNI.callPJPPI((long)platform, (long)device_type, (int)Checks.remainingSafe((CustomBuffer)devices), (long)MemoryUtil.memAddressSafe((Pointer)devices), (int[])num_devices, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check((long)device);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)device, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check((long)device);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)device, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((long[])param_value)) << 3), (long[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContext(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties, @NativeType(value="cl_device_id const *") PointerBuffer devices, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContext;
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPPPP((long)MemoryUtil.memAddressSafe((Pointer)properties), (int)devices.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)devices), (long)MemoryUtil.memAddressSafe((Pointer)pfn_notify), (long)user_data, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContextFromType(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContextFromType;
        if (Checks.CHECKS) {
            Checks.checkNTSafe((PointerBuffer)properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPP((long)MemoryUtil.memAddressSafe((Pointer)properties), (long)device_type, (long)MemoryUtil.memAddressSafe((Pointer)pfn_notify), (long)user_data, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetContextInfo;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)context, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_command_queue")
    public static long clCreateCommandQueue(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_command_queue_properties") long properties, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueue;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)device);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPP((long)context, (long)device, (long)properties, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandQueueInfo;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)command_queue, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandQueueInfo;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)command_queue, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((long[])param_value)) << 3), (long[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPP((long)context, (long)flags, (long)host_ptr.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)host_ptr), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPP((long)context, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 1), (short[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPP((long)context, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 2), (int[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPP((long)context, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 2), (float[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") double[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPP((long)context, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 3), (double[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_read ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 1), (short[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_read ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 2), (int[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_read ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 2), (float[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset, @NativeType(value="void *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_read ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 3), (double[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_write ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 1), (short[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_write ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 2), (int[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_write ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 2), (float[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset, @NativeType(value="void const *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)buffer, (int)(blocking_write ? 1 : 0), (long)offset, (long)(Integer.toUnsignedLong(ptr.length) << 3), (double[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") int[] errcode_ret, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = CL.getICD().clEnqueueMapBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)buffer);
            Checks.checkSafe((CustomBuffer)event, (int)1);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        long __result = JNI.callPPJPPPPPP((long)command_queue, (long)buffer, (int)(blocking_map ? 1 : 0), (long)map_flags, (long)offset, (long)size, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (int[])errcode_ret, (long)__functionAddress);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)size));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_row_pitch, (long)MemoryUtil.memAddressSafe((ByteBuffer)host_ptr), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_row_pitch, (short[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_row_pitch, (int[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_row_pitch, (float[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_depth, (long)image_row_pitch, (long)image_slice_pitch, (long)MemoryUtil.memAddressSafe((ByteBuffer)host_ptr), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_depth, (long)image_row_pitch, (long)image_slice_pitch, (short[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_depth, (long)image_row_pitch, (long)image_slice_pitch, (int[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPPPPPPPP((long)context, (long)flags, (long)image_format.address(), (long)image_width, (long)image_height, (long)image_depth, (long)image_row_pitch, (long)image_slice_pitch, (float[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSupportedImageFormats(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_mem_object_type") int image_type, @Nullable @NativeType(value="cl_image_format *") CLImageFormat.Buffer image_formats, @Nullable @NativeType(value="cl_uint *") int[] num_image_formats) {
        long __functionAddress = CL.getICD().clGetSupportedImageFormats;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])num_image_formats, (int)1);
        }
        return JNI.callPJPPI((long)context, (long)flags, (int)image_type, (int)Checks.remainingSafe((CustomBuffer)image_formats), (long)MemoryUtil.memAddressSafe((Pointer)image_formats), (int[])num_image_formats, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_read ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)row_pitch, (long)slice_pitch, (short[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_read ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)row_pitch, (long)slice_pitch, (int[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_read ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)row_pitch, (long)slice_pitch, (float[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_read ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)row_pitch, (long)slice_pitch, (double[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_write ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)input_row_pitch, (long)input_slice_pitch, (short[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_write ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)input_row_pitch, (long)input_slice_pitch, (int[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_write ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)input_row_pitch, (long)input_slice_pitch, (float[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_queue, (long)image, (int)(blocking_write ? 1 : 0), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)input_row_pitch, (long)input_slice_pitch, (double[])ptr, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") int[] errcode_ret, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = CL.getICD().clEnqueueMapImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.check((CustomBuffer)image_row_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)image_slice_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)event, (int)1);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        long __result = JNI.callPPJPPPPPPPP((long)command_queue, (long)image, (int)(blocking_map ? 1 : 0), (long)map_flags, (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)MemoryUtil.memAddress((CustomBuffer)image_row_pitch), (long)MemoryUtil.memAddressSafe((Pointer)image_slice_pitch), (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (int[])errcode_ret, (long)__functionAddress);
        int length = (int)CL10.getMemObjectInfoPointer(image, 4354);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") int[] errcode_ret, long length, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = CL.getICD().clEnqueueMapImage;
        if (Checks.CHECKS) {
            Checks.check((long)command_queue);
            Checks.check((long)image);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.check((CustomBuffer)image_row_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)image_slice_pitch, (int)1);
            Checks.checkSafe((CustomBuffer)event, (int)1);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        long __result = JNI.callPPJPPPPPPPP((long)command_queue, (long)image, (int)(blocking_map ? 1 : 0), (long)map_flags, (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)MemoryUtil.memAddress((CustomBuffer)image_row_pitch), (long)MemoryUtil.memAddressSafe((Pointer)image_slice_pitch), (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (int[])errcode_ret, (long)__functionAddress);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetImageInfo;
        if (Checks.CHECKS) {
            Checks.check((long)image);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)image, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemObjectInfo;
        if (Checks.CHECKS) {
            Checks.check((long)memobj);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)memobj, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemObjectInfo;
        if (Checks.CHECKS) {
            Checks.check((long)memobj);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)memobj, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((long[])param_value)) << 3), (long[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_sampler")
    public static long clCreateSampler(@NativeType(value="cl_context") long context, @NativeType(value="cl_bool") boolean normalized_coords, @NativeType(value="cl_addressing_mode") int addressing_mode, @NativeType(value="cl_filter_mode") int filter_mode, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSampler;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPP((long)context, (int)(normalized_coords ? 1 : 0), (int)addressing_mode, (int)filter_mode, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSamplerInfo;
        if (Checks.CHECKS) {
            Checks.check((long)sampler);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)sampler, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context, @NativeType(value="cl_char const **") PointerBuffer strings, @Nullable @NativeType(value="size_t const *") PointerBuffer lengths, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithSource;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.checkSafe((CustomBuffer)lengths, (int)strings.remaining());
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPPP((long)context, (int)strings.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)strings), (long)MemoryUtil.memAddressSafe((Pointer)lengths), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="size_t const *") PointerBuffer lengths, @NativeType(value="cl_uchar const **") PointerBuffer binaries, @Nullable @NativeType(value="cl_int *") int[] binary_status, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBinary;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((CustomBuffer)device_list, (int)binaries.remaining());
            Checks.check((CustomBuffer)lengths, (int)binaries.remaining());
            Checks.checkSafe((int[])binary_status, (int)binaries.remaining());
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPPPPP((long)context, (int)binaries.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)device_list), (long)MemoryUtil.memAddress((CustomBuffer)lengths), (long)MemoryUtil.memAddress((CustomBuffer)binaries), (int[])binary_status, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramInfo;
        if (Checks.CHECKS) {
            Checks.check((long)program);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)program, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramBuildInfo;
        if (Checks.CHECKS) {
            Checks.check((long)program);
            Checks.check((long)device);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPPI((long)program, (long)device, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") ByteBuffer kernel_name, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateKernel;
        if (Checks.CHECKS) {
            Checks.check((long)program);
            Checks.checkNT1((ByteBuffer)kernel_name);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPP((long)program, (long)MemoryUtil.memAddress((ByteBuffer)kernel_name), (int[])errcode_ret, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") CharSequence kernel_name, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateKernel;
        if (Checks.CHECKS) {
            Checks.check((long)program);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(kernel_name, true);
            long kernel_nameEncoded = stack.getPointerAddress();
            long l = JNI.callPPPP((long)program, (long)kernel_nameEncoded, (int[])errcode_ret, (long)__functionAddress);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clCreateKernelsInProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_kernel *") PointerBuffer kernels, @Nullable @NativeType(value="cl_uint *") int[] num_kernels_ret) {
        long __functionAddress = CL.getICD().clCreateKernelsInProgram;
        if (Checks.CHECKS) {
            Checks.check((long)program);
            Checks.checkSafe((int[])num_kernels_ret, (int)1);
        }
        return JNI.callPPPI((long)program, (int)Checks.remainingSafe((CustomBuffer)kernels), (long)MemoryUtil.memAddressSafe((Pointer)kernels), (int[])num_kernels_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)kernel, (int)arg_index, (long)(Integer.toUnsignedLong(arg_value.length) << 1), (short[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)kernel, (int)arg_index, (long)(Integer.toUnsignedLong(arg_value.length) << 2), (int[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)kernel, (int)arg_index, (long)(Integer.toUnsignedLong(arg_value.length) << 3), (long[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)kernel, (int)arg_index, (long)(Integer.toUnsignedLong(arg_value.length) << 2), (float[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)kernel, (int)arg_index, (long)(Integer.toUnsignedLong(arg_value.length) << 3), (double[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelInfo;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)kernel, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelWorkGroupInfo;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
            Checks.check((long)device);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPPI((long)kernel, (long)device, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelWorkGroupInfo;
        if (Checks.CHECKS) {
            Checks.check((long)kernel);
            Checks.check((long)device);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPPI((long)kernel, (long)device, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((long[])param_value)) << 3), (long[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventInfo;
        if (Checks.CHECKS) {
            Checks.check((long)event);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)event, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventProfilingInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_profiling_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventProfilingInfo;
        if (Checks.CHECKS) {
            Checks.check((long)event);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)event, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((long[])param_value)) << 3), (long[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    private static long getMemObjectInfoPointer(long cl_mem, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.pointers(0L);
            long l = CL10.clGetMemObjectInfo(cl_mem, param_name, pp, null) == 0 ? pp.get(0) : 0L;
            return l;
        }
    }
}

