/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentReference
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENT;
    public static final int LAYOUT;

    public VkAttachmentReference(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAttachmentReference.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int attachment() {
        return VkAttachmentReference.nattachment(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int layout() {
        return VkAttachmentReference.nlayout(this.address());
    }

    public VkAttachmentReference attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference set(int attachment, int layout) {
        this.attachment(attachment);
        this.layout(layout);
        return this;
    }

    public VkAttachmentReference set(VkAttachmentReference src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAttachmentReference malloc() {
        return (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAttachmentReference calloc() {
        return (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAttachmentReference create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAttachmentReference create(long address) {
        return (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)address);
    }

    @Nullable
    public static VkAttachmentReference createSafe(long address) {
        return address == 0L ? null : (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAttachmentReference.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentReference.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAttachmentReference mallocStack() {
        return VkAttachmentReference.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference callocStack() {
        return VkAttachmentReference.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference mallocStack(MemoryStack stack) {
        return (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentReference callocStack(MemoryStack stack) {
        return (VkAttachmentReference)VkAttachmentReference.wrap(VkAttachmentReference.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAttachmentReference.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nattachment(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENT);
    }

    public static int nlayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYOUT);
    }

    public static void nattachment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENT, value);
    }

    public static void nlayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYOUT, value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference.__struct((Struct.Member[])new Struct.Member[]{VkAttachmentReference.__member((int)4), VkAttachmentReference.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENT = layout.offsetof(0);
        LAYOUT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentReference, Buffer>
    implements NativeResource {
        private static final VkAttachmentReference ELEMENT_FACTORY = VkAttachmentReference.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAttachmentReference getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int attachment() {
            return VkAttachmentReference.nattachment(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int layout() {
            return VkAttachmentReference.nlayout(this.address());
        }

        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference.nlayout(this.address(), value);
            return this;
        }
    }
}

