/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryWin32HandleInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int HANDLE;

    public VkImportMemoryWin32HandleInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImportMemoryWin32HandleInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int handleType() {
        return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
    }

    @NativeType(value="HANDLE")
    public long handle() {
        return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
    }

    public VkImportMemoryWin32HandleInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
        VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handle(@NativeType(value="HANDLE") long value) {
        VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(int sType, long pNext, int handleType, long handle) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.handle(handle);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(VkImportMemoryWin32HandleInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImportMemoryWin32HandleInfoNV malloc() {
        return (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV calloc() {
        return (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImportMemoryWin32HandleInfoNV create(long address) {
        return (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)address);
    }

    @Nullable
    public static VkImportMemoryWin32HandleInfoNV createSafe(long address) {
        return address == 0L ? null : (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImportMemoryWin32HandleInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMemoryWin32HandleInfoNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImportMemoryWin32HandleInfoNV mallocStack() {
        return VkImportMemoryWin32HandleInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryWin32HandleInfoNV callocStack() {
        return VkImportMemoryWin32HandleInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryWin32HandleInfoNV mallocStack(MemoryStack stack) {
        return (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV callocStack(MemoryStack stack) {
        return (VkImportMemoryWin32HandleInfoNV)VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkImportMemoryWin32HandleInfoNV.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkImportMemoryWin32HandleInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkImportMemoryWin32HandleInfoNV.__member((int)4), VkImportMemoryWin32HandleInfoNV.__member((int)POINTER_SIZE), VkImportMemoryWin32HandleInfoNV.__member((int)4), VkImportMemoryWin32HandleInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryWin32HandleInfoNV, Buffer>
    implements NativeResource {
        private static final VkImportMemoryWin32HandleInfoNV ELEMENT_FACTORY = VkImportMemoryWin32HandleInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImportMemoryWin32HandleInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int handleType() {
            return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
        }

        @NativeType(value="HANDLE")
        public long handle() {
            return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
            VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="HANDLE") long value) {
            VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
            return this;
        }
    }
}

