/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkApplicationInfo;

public class VkInstanceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PAPPLICATIONINFO;
    public static final int ENABLEDLAYERCOUNT;
    public static final int PPENABLEDLAYERNAMES;
    public static final int ENABLEDEXTENSIONCOUNT;
    public static final int PPENABLEDEXTENSIONNAMES;

    public VkInstanceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkInstanceCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkInstanceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkInstanceCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkInstanceCreateFlags")
    public int flags() {
        return VkInstanceCreateInfo.nflags(this.address());
    }

    @Nullable
    @NativeType(value="VkApplicationInfo const *")
    public VkApplicationInfo pApplicationInfo() {
        return VkInstanceCreateInfo.npApplicationInfo(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledLayerCount() {
        return VkInstanceCreateInfo.nenabledLayerCount(this.address());
    }

    @Nullable
    @NativeType(value="char const * const *")
    public PointerBuffer ppEnabledLayerNames() {
        return VkInstanceCreateInfo.nppEnabledLayerNames(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledExtensionCount() {
        return VkInstanceCreateInfo.nenabledExtensionCount(this.address());
    }

    @Nullable
    @NativeType(value="char const * const *")
    public PointerBuffer ppEnabledExtensionNames() {
        return VkInstanceCreateInfo.nppEnabledExtensionNames(this.address());
    }

    public VkInstanceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkInstanceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkInstanceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo flags(@NativeType(value="VkInstanceCreateFlags") int value) {
        VkInstanceCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo pApplicationInfo(@Nullable @NativeType(value="VkApplicationInfo const *") VkApplicationInfo value) {
        VkInstanceCreateInfo.npApplicationInfo(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo ppEnabledLayerNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
        VkInstanceCreateInfo.nppEnabledLayerNames(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo ppEnabledExtensionNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
        VkInstanceCreateInfo.nppEnabledExtensionNames(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo set(int sType, long pNext, int flags, @Nullable VkApplicationInfo pApplicationInfo, @Nullable PointerBuffer ppEnabledLayerNames, @Nullable PointerBuffer ppEnabledExtensionNames) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pApplicationInfo(pApplicationInfo);
        this.ppEnabledLayerNames(ppEnabledLayerNames);
        this.ppEnabledExtensionNames(ppEnabledExtensionNames);
        return this;
    }

    public VkInstanceCreateInfo set(VkInstanceCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkInstanceCreateInfo malloc() {
        return (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkInstanceCreateInfo calloc() {
        return (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkInstanceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkInstanceCreateInfo create(long address) {
        return (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkInstanceCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkInstanceCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkInstanceCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkInstanceCreateInfo mallocStack() {
        return VkInstanceCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkInstanceCreateInfo callocStack() {
        return VkInstanceCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkInstanceCreateInfo mallocStack(MemoryStack stack) {
        return (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkInstanceCreateInfo callocStack(MemoryStack stack) {
        return (VkInstanceCreateInfo)VkInstanceCreateInfo.wrap(VkInstanceCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkInstanceCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkInstanceCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkInstanceCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static VkApplicationInfo npApplicationInfo(long struct) {
        return VkApplicationInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PAPPLICATIONINFO)));
    }

    public static int nenabledLayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEDLAYERCOUNT);
    }

    @Nullable
    public static PointerBuffer nppEnabledLayerNames(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPENABLEDLAYERNAMES)), (int)VkInstanceCreateInfo.nenabledLayerCount(struct));
    }

    public static int nenabledExtensionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEDEXTENSIONCOUNT);
    }

    @Nullable
    public static PointerBuffer nppEnabledExtensionNames(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPENABLEDEXTENSIONNAMES)), (int)VkInstanceCreateInfo.nenabledExtensionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npApplicationInfo(long struct, @Nullable VkApplicationInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PAPPLICATIONINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nenabledLayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEDLAYERCOUNT, value);
    }

    public static void nppEnabledLayerNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPENABLEDLAYERNAMES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkInstanceCreateInfo.nenabledLayerCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nenabledExtensionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEDEXTENSIONCOUNT, value);
    }

    public static void nppEnabledExtensionNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPENABLEDEXTENSIONNAMES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkInstanceCreateInfo.nenabledExtensionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkInstanceCreateInfo.nenabledLayerCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPENABLEDLAYERNAMES)));
        }
        if (VkInstanceCreateInfo.nenabledExtensionCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPENABLEDEXTENSIONNAMES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkInstanceCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkInstanceCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkInstanceCreateInfo.__member((int)4), VkInstanceCreateInfo.__member((int)POINTER_SIZE), VkInstanceCreateInfo.__member((int)4), VkInstanceCreateInfo.__member((int)POINTER_SIZE), VkInstanceCreateInfo.__member((int)4), VkInstanceCreateInfo.__member((int)POINTER_SIZE), VkInstanceCreateInfo.__member((int)4), VkInstanceCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PAPPLICATIONINFO = layout.offsetof(3);
        ENABLEDLAYERCOUNT = layout.offsetof(4);
        PPENABLEDLAYERNAMES = layout.offsetof(5);
        ENABLEDEXTENSIONCOUNT = layout.offsetof(6);
        PPENABLEDEXTENSIONNAMES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkInstanceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkInstanceCreateInfo ELEMENT_FACTORY = VkInstanceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkInstanceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkInstanceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkInstanceCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkInstanceCreateFlags")
        public int flags() {
            return VkInstanceCreateInfo.nflags(this.address());
        }

        @Nullable
        @NativeType(value="VkApplicationInfo const *")
        public VkApplicationInfo pApplicationInfo() {
            return VkInstanceCreateInfo.npApplicationInfo(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledLayerCount() {
            return VkInstanceCreateInfo.nenabledLayerCount(this.address());
        }

        @Nullable
        @NativeType(value="char const * const *")
        public PointerBuffer ppEnabledLayerNames() {
            return VkInstanceCreateInfo.nppEnabledLayerNames(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledExtensionCount() {
            return VkInstanceCreateInfo.nenabledExtensionCount(this.address());
        }

        @Nullable
        @NativeType(value="char const * const *")
        public PointerBuffer ppEnabledExtensionNames() {
            return VkInstanceCreateInfo.nppEnabledExtensionNames(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkInstanceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkInstanceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkInstanceCreateFlags") int value) {
            VkInstanceCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pApplicationInfo(@Nullable @NativeType(value="VkApplicationInfo const *") VkApplicationInfo value) {
            VkInstanceCreateInfo.npApplicationInfo(this.address(), value);
            return this;
        }

        public Buffer ppEnabledLayerNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
            VkInstanceCreateInfo.nppEnabledLayerNames(this.address(), value);
            return this;
        }

        public Buffer ppEnabledExtensionNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
            VkInstanceCreateInfo.nppEnabledExtensionNames(this.address(), value);
            return this;
        }
    }
}

