/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINE;

    public VkPipelineInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkPipeline")
    public long pipeline() {
        return VkPipelineInfoKHR.npipeline(this.address());
    }

    public VkPipelineInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR pipeline(@NativeType(value="VkPipeline") long value) {
        VkPipelineInfoKHR.npipeline(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR set(int sType, long pNext, long pipeline) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipeline(pipeline);
        return this;
    }

    public VkPipelineInfoKHR set(VkPipelineInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineInfoKHR malloc() {
        return (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPipelineInfoKHR calloc() {
        return (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPipelineInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPipelineInfoKHR create(long address) {
        return (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkPipelineInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPipelineInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPipelineInfoKHR mallocStack() {
        return VkPipelineInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineInfoKHR callocStack() {
        return VkPipelineInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineInfoKHR mallocStack(MemoryStack stack) {
        return (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineInfoKHR callocStack(MemoryStack stack) {
        return (VkPipelineInfoKHR)VkPipelineInfoKHR.wrap(VkPipelineInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long npipeline(long struct) {
        return UNSAFE.getLong(null, struct + (long)PIPELINE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npipeline(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PIPELINE, value);
    }

    static {
        Struct.Layout layout = VkPipelineInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkPipelineInfoKHR.__member((int)4), VkPipelineInfoKHR.__member((int)POINTER_SIZE), VkPipelineInfoKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineInfoKHR ELEMENT_FACTORY = VkPipelineInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPipelineInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkPipeline")
        public long pipeline() {
            return VkPipelineInfoKHR.npipeline(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkPipelineInfoKHR.npipeline(this.address(), value);
            return this;
        }
    }
}

