/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.LibMeow;

@NativeType(value="struct meow_hash_state")
public class MeowHashState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    public MeowHashState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeowHashState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static MeowHashState malloc() {
        return (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MeowHashState calloc() {
        return (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MeowHashState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MeowHashState create(long address) {
        return (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)address);
    }

    @Nullable
    public static MeowHashState createSafe(long address) {
        return address == 0L ? null : (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MeowHashState.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MeowHashState.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MeowHashState.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeowHashState.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MeowHashState.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MeowHashState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MeowHashState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MeowHashState mallocStack() {
        return MeowHashState.mallocStack(MemoryStack.stackGet());
    }

    public static MeowHashState callocStack() {
        return MeowHashState.callocStack(MemoryStack.stackGet());
    }

    public static MeowHashState mallocStack(MemoryStack stack) {
        return (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeowHashState callocStack(MemoryStack stack) {
        return (MeowHashState)MeowHashState.wrap(MeowHashState.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MeowHashState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MeowHashState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeowHashState.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeowHashState.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    static {
        LibMeow.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = MeowHashState.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<MeowHashState, Buffer>
    implements NativeResource {
        private static final MeowHashState ELEMENT_FACTORY = MeowHashState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeowHashState getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

