/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUDA_ARRAY3D_DESCRIPTOR;
import org.lwjgl.cuda.CUDA_ARRAY_DESCRIPTOR;
import org.lwjgl.cuda.CUDA_MEMCPY2D;
import org.lwjgl.cuda.CUDA_MEMCPY3D;
import org.lwjgl.cuda.CUdevprop;
import org.lwjgl.cuda.CUstreamCallbackI;
import org.lwjgl.cuda.CUuuid;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class CU {
    public static final int CU_MEMHOSTALLOC_PORTABLE = 1;
    public static final int CU_MEMHOSTALLOC_DEVICEMAP = 2;
    public static final int CU_MEMHOSTALLOC_WRITECOMBINED = 4;
    public static final int CU_MEMHOSTREGISTER_PORTABLE = 1;
    public static final int CU_MEMHOSTREGISTER_DEVICEMAP = 2;
    public static final int CU_MEMHOSTREGISTER_IOMEMORY = 4;
    public static final int CUDA_ARRAY3D_LAYERED = 1;
    public static final int CUDA_ARRAY3D_2DARRAY = 1;
    public static final int CUDA_ARRAY3D_SURFACE_LDST = 2;
    public static final int CUDA_ARRAY3D_CUBEMAP = 4;
    public static final int CUDA_ARRAY3D_TEXTURE_GATHER = 8;
    public static final int CUDA_ARRAY3D_DEPTH_TEXTURE = 16;
    public static final int CUDA_ARRAY3D_COLOR_ATTACHMENT = 32;
    public static final int CU_TRSA_OVERRIDE_FORMAT = 1;
    public static final int CU_TRSF_READ_AS_INTEGER = 1;
    public static final int CU_TRSF_NORMALIZED_COORDINATES = 2;
    public static final int CU_TRSF_SRGB = 16;
    public static final int CU_PARAM_TR_DEFAULT = -1;
    public static final int CU_CTX_SCHED_AUTO = 0;
    public static final int CU_CTX_SCHED_SPIN = 1;
    public static final int CU_CTX_SCHED_YIELD = 2;
    public static final int CU_CTX_SCHED_BLOCKING_SYNC = 4;
    public static final int CU_CTX_BLOCKING_SYNC = 4;
    public static final int CU_CTX_SCHED_MASK = 7;
    public static final int CU_CTX_MAP_HOST = 8;
    public static final int CU_CTX_LMEM_RESIZE_TO_MAX = 16;
    public static final int CU_CTX_FLAGS_MASK = 31;
    public static final int CU_STREAM_DEFAULT = 0;
    public static final int CU_STREAM_NON_BLOCKING = 1;
    public static final int CU_EVENT_DEFAULT = 0;
    public static final int CU_EVENT_BLOCKING_SYNC = 1;
    public static final int CU_EVENT_DISABLE_TIMING = 2;
    public static final int CU_EVENT_INTERPROCESS = 4;
    public static final int CU_AD_FORMAT_UNSIGNED_INT8 = 1;
    public static final int CU_AD_FORMAT_UNSIGNED_INT16 = 2;
    public static final int CU_AD_FORMAT_UNSIGNED_INT32 = 3;
    public static final int CU_AD_FORMAT_SIGNED_INT8 = 8;
    public static final int CU_AD_FORMAT_SIGNED_INT16 = 9;
    public static final int CU_AD_FORMAT_SIGNED_INT32 = 10;
    public static final int CU_AD_FORMAT_HALF = 16;
    public static final int CU_AD_FORMAT_FLOAT = 32;
    public static final int CU_TR_ADDRESS_MODE_WRAP = 0;
    public static final int CU_TR_ADDRESS_MODE_CLAMP = 1;
    public static final int CU_TR_ADDRESS_MODE_MIRROR = 2;
    public static final int CU_TR_ADDRESS_MODE_BORDER = 3;
    public static final int CU_TR_FILTER_MODE_POINT = 0;
    public static final int CU_TR_FILTER_MODE_LINEAR = 1;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK = 1;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X = 2;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y = 3;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z = 4;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X = 5;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y = 6;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z = 7;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK = 8;
    public static final int CU_DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK = 8;
    public static final int CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY = 9;
    public static final int CU_DEVICE_ATTRIBUTE_WARP_SIZE = 10;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_PITCH = 11;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK = 12;
    public static final int CU_DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK = 12;
    public static final int CU_DEVICE_ATTRIBUTE_CLOCK_RATE = 13;
    public static final int CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT = 14;
    public static final int CU_DEVICE_ATTRIBUTE_GPU_OVERLAP = 15;
    public static final int CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT = 16;
    public static final int CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT = 17;
    public static final int CU_DEVICE_ATTRIBUTE_INTEGRATED = 18;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY = 19;
    public static final int CU_DEVICE_ATTRIBUTE_COMPUTE_MODE = 20;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH = 21;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH = 22;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT = 23;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH = 24;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT = 25;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH = 26;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH = 27;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT = 28;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS = 29;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_WIDTH = 27;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_HEIGHT = 28;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_NUMSLICES = 29;
    public static final int CU_DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT = 30;
    public static final int CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS = 31;
    public static final int CU_DEVICE_ATTRIBUTE_ECC_ENABLED = 32;
    public static final int CU_DEVICE_ATTRIBUTE_PCI_BUS_ID = 33;
    public static final int CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID = 34;
    public static final int CU_DEVICE_ATTRIBUTE_TCC_DRIVER = 35;
    public static final int CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE = 36;
    public static final int CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH = 37;
    public static final int CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE = 38;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR = 39;
    public static final int CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT = 40;
    public static final int CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING = 41;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH = 42;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS = 43;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_TEX2D_GATHER = 44;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH = 45;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT = 46;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE = 47;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE = 48;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE = 49;
    public static final int CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID = 50;
    public static final int CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT = 51;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH = 52;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH = 53;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS = 54;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH = 55;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH = 56;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT = 57;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH = 58;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT = 59;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH = 60;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH = 61;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS = 62;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH = 63;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT = 64;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS = 65;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH = 66;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH = 67;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS = 68;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH = 69;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH = 70;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT = 71;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH = 72;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH = 73;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT = 74;
    public static final int CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR = 75;
    public static final int CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR = 76;
    public static final int CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH = 77;
    public static final int CU_DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED = 78;
    public static final int CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED = 79;
    public static final int CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED = 80;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR = 81;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR = 82;
    public static final int CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY = 83;
    public static final int CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD = 84;
    public static final int CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID = 85;
    public static final int CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED = 86;
    public static final int CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO = 87;
    public static final int CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS = 88;
    public static final int CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS = 89;
    public static final int CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED = 90;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM = 91;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS = 92;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS = 93;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = 94;
    public static final int CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH = 95;
    public static final int CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH = 96;
    public static final int CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN = 97;
    public static final int CU_DEVICE_ATTRIBUTE_CAN_FLUSH_REMOTE_WRITES = 98;
    public static final int CU_DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED = 99;
    public static final int CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES = 100;
    public static final int CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST = 101;
    public static final int CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK = 0;
    public static final int CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES = 1;
    public static final int CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES = 2;
    public static final int CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES = 3;
    public static final int CU_FUNC_ATTRIBUTE_NUM_REGS = 4;
    public static final int CU_FUNC_ATTRIBUTE_PTX_VERSION = 5;
    public static final int CU_FUNC_ATTRIBUTE_BINARY_VERSION = 6;
    public static final int CU_FUNC_ATTRIBUTE_CACHE_MODE_CA = 7;
    public static final int CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES = 8;
    public static final int CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = 9;
    public static final int CU_FUNC_CACHE_PREFER_NONE = 0;
    public static final int CU_FUNC_CACHE_PREFER_SHARED = 1;
    public static final int CU_FUNC_CACHE_PREFER_L1 = 2;
    public static final int CU_FUNC_CACHE_PREFER_EQUAL = 3;
    public static final int CU_MEMORYTYPE_HOST = 1;
    public static final int CU_MEMORYTYPE_DEVICE = 2;
    public static final int CU_MEMORYTYPE_ARRAY = 3;
    public static final int CU_MEMORYTYPE_UNIFIED = 4;
    public static final int CU_COMPUTEMODE_DEFAULT = 0;
    public static final int CU_COMPUTEMODE_PROHIBITED = 2;
    public static final int CU_COMPUTEMODE_EXCLUSIVE_PROCESS = 3;
    public static final int CU_JIT_MAX_REGISTERS = 0;
    public static final int CU_JIT_THREADS_PER_BLOCK = 1;
    public static final int CU_JIT_WALL_TIME = 2;
    public static final int CU_JIT_INFO_LOG_BUFFER = 3;
    public static final int CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES = 4;
    public static final int CU_JIT_ERROR_LOG_BUFFER = 5;
    public static final int CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES = 6;
    public static final int CU_JIT_OPTIMIZATION_LEVEL = 7;
    public static final int CU_JIT_TARGET_FROM_CUCONTEXT = 8;
    public static final int CU_JIT_TARGET = 9;
    public static final int CU_JIT_FALLBACK_STRATEGY = 10;
    public static final int CU_JIT_GENERATE_DEBUG_INFO = 11;
    public static final int CU_JIT_LOG_VERBOSE = 12;
    public static final int CU_JIT_GENERATE_LINE_INFO = 13;
    public static final int CU_JIT_CACHE_MODE = 14;
    public static final int CU_JIT_NEW_SM3X_OPT = 15;
    public static final int CU_JIT_FAST_COMPILE = 16;
    public static final int CU_JIT_GLOBAL_SYMBOL_NAMES = 17;
    public static final int CU_JIT_GLOBAL_SYMBOL_ADDRESSES = 18;
    public static final int CU_JIT_GLOBAL_SYMBOL_COUNT = 19;
    public static final int CU_TARGET_COMPUTE_20 = 20;
    public static final int CU_TARGET_COMPUTE_21 = 21;
    public static final int CU_TARGET_COMPUTE_30 = 30;
    public static final int CU_TARGET_COMPUTE_32 = 32;
    public static final int CU_TARGET_COMPUTE_35 = 35;
    public static final int CU_TARGET_COMPUTE_37 = 37;
    public static final int CU_TARGET_COMPUTE_50 = 50;
    public static final int CU_TARGET_COMPUTE_52 = 52;
    public static final int CU_TARGET_COMPUTE_53 = 53;
    public static final int CU_TARGET_COMPUTE_60 = 60;
    public static final int CU_TARGET_COMPUTE_61 = 61;
    public static final int CU_TARGET_COMPUTE_62 = 62;
    public static final int CU_TARGET_COMPUTE_70 = 70;
    public static final int CU_TARGET_COMPUTE_72 = 72;
    public static final int CU_TARGET_COMPUTE_75 = 75;
    public static final int CU_PREFER_PTX = 0;
    public static final int CU_PREFER_BINARY = 1;
    public static final int CU_JIT_CACHE_OPTION_NONE = 0;
    public static final int CU_JIT_CACHE_OPTION_CG = 1;
    public static final int CU_JIT_CACHE_OPTION_CA = 2;
    public static final int CU_GRAPHICS_REGISTER_FLAGS_NONE = 0;
    public static final int CU_GRAPHICS_REGISTER_FLAGS_READ_ONLY = 1;
    public static final int CU_GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD = 2;
    public static final int CU_GRAPHICS_REGISTER_FLAGS_SURFACE_LDST = 4;
    public static final int CU_GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER = 8;
    public static final int CU_GRAPHICS_MAP_RESOURCE_FLAGS_NONE = 0;
    public static final int CU_GRAPHICS_MAP_RESOURCE_FLAGS_READ_ONLY = 1;
    public static final int CU_GRAPHICS_MAP_RESOURCE_FLAGS_WRITE_DISCARD = 2;
    public static final int CU_CUBEMAP_FACE_POSITIVE_X = 0;
    public static final int CU_CUBEMAP_FACE_NEGATIVE_X = 1;
    public static final int CU_CUBEMAP_FACE_POSITIVE_Y = 2;
    public static final int CU_CUBEMAP_FACE_NEGATIVE_Y = 3;
    public static final int CU_CUBEMAP_FACE_POSITIVE_Z = 4;
    public static final int CU_CUBEMAP_FACE_NEGATIVE_Z = 5;
    public static final int CU_LIMIT_STACK_SIZE = 0;
    public static final int CU_LIMIT_PRINTF_FIFO_SIZE = 1;
    public static final int CU_LIMIT_MALLOC_HEAP_SIZE = 2;
    public static final int CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH = 3;
    public static final int CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT = 4;
    public static final int CU_LIMIT_MAX_L2_FETCH_GRANULARITY = 5;
    public static final int CUDA_SUCCESS = 0;
    public static final int CUDA_ERROR_INVALID_VALUE = 1;
    public static final int CUDA_ERROR_OUT_OF_MEMORY = 2;
    public static final int CUDA_ERROR_NOT_INITIALIZED = 3;
    public static final int CUDA_ERROR_DEINITIALIZED = 4;
    public static final int CUDA_ERROR_PROFILER_DISABLED = 5;
    public static final int CUDA_ERROR_PROFILER_NOT_INITIALIZED = 6;
    public static final int CUDA_ERROR_PROFILER_ALREADY_STARTED = 7;
    public static final int CUDA_ERROR_PROFILER_ALREADY_STOPPED = 8;
    public static final int CUDA_ERROR_NO_DEVICE = 100;
    public static final int CUDA_ERROR_INVALID_DEVICE = 101;
    public static final int CUDA_ERROR_INVALID_IMAGE = 200;
    public static final int CUDA_ERROR_INVALID_CONTEXT = 201;
    public static final int CUDA_ERROR_CONTEXT_ALREADY_CURRENT = 202;
    public static final int CUDA_ERROR_MAP_FAILED = 205;
    public static final int CUDA_ERROR_UNMAP_FAILED = 206;
    public static final int CUDA_ERROR_ARRAY_IS_MAPPED = 207;
    public static final int CUDA_ERROR_ALREADY_MAPPED = 208;
    public static final int CUDA_ERROR_NO_BINARY_FOR_GPU = 209;
    public static final int CUDA_ERROR_ALREADY_ACQUIRED = 210;
    public static final int CUDA_ERROR_NOT_MAPPED = 211;
    public static final int CUDA_ERROR_NOT_MAPPED_AS_ARRAY = 212;
    public static final int CUDA_ERROR_NOT_MAPPED_AS_POINTER = 213;
    public static final int CUDA_ERROR_ECC_UNCORRECTABLE = 214;
    public static final int CUDA_ERROR_UNSUPPORTED_LIMIT = 215;
    public static final int CUDA_ERROR_CONTEXT_ALREADY_IN_USE = 216;
    public static final int CUDA_ERROR_PEER_ACCESS_UNSUPPORTED = 217;
    public static final int CUDA_ERROR_INVALID_PTX = 218;
    public static final int CUDA_ERROR_INVALID_GRAPHICS_CONTEXT = 219;
    public static final int CUDA_ERROR_NVLINK_UNCORRECTABLE = 220;
    public static final int CUDA_ERROR_JIT_COMPILER_NOT_FOUND = 221;
    public static final int CUDA_ERROR_INVALID_SOURCE = 300;
    public static final int CUDA_ERROR_FILE_NOT_FOUND = 301;
    public static final int CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND = 302;
    public static final int CUDA_ERROR_SHARED_OBJECT_INIT_FAILED = 303;
    public static final int CUDA_ERROR_OPERATING_SYSTEM = 304;
    public static final int CUDA_ERROR_INVALID_HANDLE = 400;
    public static final int CUDA_ERROR_ILLEGAL_STATE = 401;
    public static final int CUDA_ERROR_NOT_FOUND = 500;
    public static final int CUDA_ERROR_NOT_READY = 600;
    public static final int CUDA_ERROR_ILLEGAL_ADDRESS = 700;
    public static final int CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES = 701;
    public static final int CUDA_ERROR_LAUNCH_TIMEOUT = 702;
    public static final int CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING = 703;
    public static final int CUDA_ERROR_PEER_ACCESS_ALREADY_ENABLED = 704;
    public static final int CUDA_ERROR_PEER_ACCESS_NOT_ENABLED = 705;
    public static final int CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE = 708;
    public static final int CUDA_ERROR_CONTEXT_IS_DESTROYED = 709;
    public static final int CUDA_ERROR_ASSERT = 710;
    public static final int CUDA_ERROR_TOO_MANY_PEERS = 711;
    public static final int CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED = 712;
    public static final int CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED = 713;
    public static final int CUDA_ERROR_HARDWARE_STACK_ERROR = 714;
    public static final int CUDA_ERROR_ILLEGAL_INSTRUCTION = 715;
    public static final int CUDA_ERROR_MISALIGNED_ADDRESS = 716;
    public static final int CUDA_ERROR_INVALID_ADDRESS_SPACE = 717;
    public static final int CUDA_ERROR_INVALID_PC = 718;
    public static final int CUDA_ERROR_LAUNCH_FAILED = 719;
    public static final int CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE = 720;
    public static final int CUDA_ERROR_NOT_PERMITTED = 800;
    public static final int CUDA_ERROR_NOT_SUPPORTED = 801;
    public static final int CUDA_ERROR_SYSTEM_NOT_READY = 802;
    public static final int CUDA_ERROR_SYSTEM_DRIVER_MISMATCH = 803;
    public static final int CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE = 804;
    public static final int CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED = 900;
    public static final int CUDA_ERROR_STREAM_CAPTURE_INVALIDATED = 901;
    public static final int CUDA_ERROR_STREAM_CAPTURE_MERGE = 902;
    public static final int CUDA_ERROR_STREAM_CAPTURE_UNMATCHED = 903;
    public static final int CUDA_ERROR_STREAM_CAPTURE_UNJOINED = 904;
    public static final int CUDA_ERROR_STREAM_CAPTURE_ISOLATION = 905;
    public static final int CUDA_ERROR_STREAM_CAPTURE_IMPLICIT = 906;
    public static final int CUDA_ERROR_CAPTURED_EVENT = 907;
    public static final int CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD = 908;
    public static final int CUDA_ERROR_UNKNOWN = 999;
    private static final SharedLibrary NVCUDA = Library.loadNative(CU.class, (String)"org.lwjgl.cuda", (Configuration)Configuration.CUDA_LIBRARY_NAME, (String[])new String[]{"nvcuda"});

    protected CU() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return NVCUDA;
    }

    public static int ncuGetErrorString(int error, long pStr) {
        long __functionAddress = Functions.GetErrorString;
        return JNI.callPI((int)error, (long)pStr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGetErrorString(@NativeType(value="CUresult") int error, @NativeType(value="char const **") PointerBuffer pStr) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pStr, (int)1);
        }
        return CU.ncuGetErrorString(error, MemoryUtil.memAddress((CustomBuffer)pStr));
    }

    public static int ncuGetErrorName(int error, long pStr) {
        long __functionAddress = Functions.GetErrorName;
        return JNI.callPI((int)error, (long)pStr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGetErrorName(@NativeType(value="CUresult") int error, @NativeType(value="char const **") PointerBuffer pStr) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pStr, (int)1);
        }
        return CU.ncuGetErrorName(error, MemoryUtil.memAddress((CustomBuffer)pStr));
    }

    @NativeType(value="CUresult")
    public static int cuInit(@NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.Init;
        return JNI.callI((int)Flags, (long)__functionAddress);
    }

    public static int ncuDriverGetVersion(long driverVersion) {
        long __functionAddress = Functions.DriverGetVersion;
        return JNI.callPI((long)driverVersion, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDriverGetVersion(@NativeType(value="int *") IntBuffer driverVersion) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)driverVersion, (int)1);
        }
        return CU.ncuDriverGetVersion(MemoryUtil.memAddress((IntBuffer)driverVersion));
    }

    public static int ncuDeviceGet(long device, int ordinal) {
        long __functionAddress = Functions.DeviceGet;
        return JNI.callPI((long)device, (int)ordinal, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGet(@NativeType(value="CUdevice *") IntBuffer device, int ordinal) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)device, (int)1);
        }
        return CU.ncuDeviceGet(MemoryUtil.memAddress((IntBuffer)device), ordinal);
    }

    public static int ncuDeviceGetCount(long count) {
        long __functionAddress = Functions.DeviceGetCount;
        return JNI.callPI((long)count, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetCount(@NativeType(value="int *") IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)count, (int)1);
        }
        return CU.ncuDeviceGetCount(MemoryUtil.memAddress((IntBuffer)count));
    }

    public static int ncuDeviceGetName(long name, int len, int dev) {
        long __functionAddress = Functions.DeviceGetName;
        return JNI.callPI((long)name, (int)len, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetName(@NativeType(value="char *") ByteBuffer name, @NativeType(value="CUdevice") int dev) {
        return CU.ncuDeviceGetName(MemoryUtil.memAddress((ByteBuffer)name), name.remaining(), dev);
    }

    public static int ncuDeviceTotalMem(long bytes, int dev) {
        long __functionAddress = Functions.DeviceTotalMem;
        return JNI.callPI((long)bytes, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceTotalMem(@NativeType(value="size_t *") PointerBuffer bytes, @NativeType(value="CUdevice") int dev) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)bytes, (int)1);
        }
        return CU.ncuDeviceTotalMem(MemoryUtil.memAddress((CustomBuffer)bytes), dev);
    }

    public static int ncuDeviceGetAttribute(long pi, int attrib, int dev) {
        long __functionAddress = Functions.DeviceGetAttribute;
        return JNI.callPI((long)pi, (int)attrib, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetAttribute(@NativeType(value="int *") IntBuffer pi, @NativeType(value="CUdevice_attribute") int attrib, @NativeType(value="CUdevice") int dev) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pi, (int)1);
        }
        return CU.ncuDeviceGetAttribute(MemoryUtil.memAddress((IntBuffer)pi), attrib, dev);
    }

    public static int ncuDeviceGetProperties(long prop, int dev) {
        long __functionAddress = Functions.DeviceGetProperties;
        return JNI.callPI((long)prop, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetProperties(@NativeType(value="CUdevprop *") CUdevprop prop, @NativeType(value="CUdevice") int dev) {
        return CU.ncuDeviceGetProperties(prop.address(), dev);
    }

    public static int ncuDeviceComputeCapability(long major, long minor, int dev) {
        long __functionAddress = Functions.DeviceComputeCapability;
        return JNI.callPPI((long)major, (long)minor, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceComputeCapability(@NativeType(value="int *") IntBuffer major, @NativeType(value="int *") IntBuffer minor, @NativeType(value="CUdevice") int dev) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)major, (int)1);
            Checks.check((Buffer)minor, (int)1);
        }
        return CU.ncuDeviceComputeCapability(MemoryUtil.memAddress((IntBuffer)major), MemoryUtil.memAddress((IntBuffer)minor), dev);
    }

    public static int ncuCtxCreate(long pctx, int flags, int dev) {
        long __functionAddress = Functions.CtxCreate;
        return JNI.callPI((long)pctx, (int)flags, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxCreate(@NativeType(value="CUcontext *") PointerBuffer pctx, @NativeType(value="unsigned int") int flags, @NativeType(value="CUdevice") int dev) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pctx, (int)1);
        }
        return CU.ncuCtxCreate(MemoryUtil.memAddress((CustomBuffer)pctx), flags, dev);
    }

    public static int ncuCtxGetDevice(long device) {
        long __functionAddress = Functions.CtxGetDevice;
        return JNI.callPI((long)device, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetDevice(@NativeType(value="CUdevice *") IntBuffer device) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)device, (int)1);
        }
        return CU.ncuCtxGetDevice(MemoryUtil.memAddress((IntBuffer)device));
    }

    @NativeType(value="CUresult")
    public static int cuCtxSynchronize() {
        long __functionAddress = Functions.CtxSynchronize;
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxSetLimit(@NativeType(value="CUlimit") int limit, @NativeType(value="size_t") long value) {
        long __functionAddress = Functions.CtxSetLimit;
        return JNI.callPI((int)limit, (long)value, (long)__functionAddress);
    }

    public static int ncuCtxGetLimit(long pvalue, int limit) {
        long __functionAddress = Functions.CtxGetLimit;
        return JNI.callPI((long)pvalue, (int)limit, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetLimit(@NativeType(value="size_t *") PointerBuffer pvalue, @NativeType(value="CUlimit") int limit) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pvalue, (int)1);
        }
        return CU.ncuCtxGetLimit(MemoryUtil.memAddress((CustomBuffer)pvalue), limit);
    }

    public static int ncuCtxGetCacheConfig(long pconfig) {
        long __functionAddress = Functions.CtxGetCacheConfig;
        return JNI.callPI((long)pconfig, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetCacheConfig(@NativeType(value="CUfunc_cache *") IntBuffer pconfig) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pconfig, (int)1);
        }
        return CU.ncuCtxGetCacheConfig(MemoryUtil.memAddress((IntBuffer)pconfig));
    }

    @NativeType(value="CUresult")
    public static int cuCtxSetCacheConfig(@NativeType(value="CUfunc_cache") int config) {
        long __functionAddress = Functions.CtxSetCacheConfig;
        return JNI.callI((int)config, (long)__functionAddress);
    }

    public static int ncuCtxGetApiVersion(long ctx, long version) {
        long __functionAddress = Functions.CtxGetApiVersion;
        return JNI.callPPI((long)ctx, (long)version, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetApiVersion(@NativeType(value="CUcontext") long ctx, @NativeType(value="unsigned int *") IntBuffer version) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)version, (int)1);
        }
        return CU.ncuCtxGetApiVersion(ctx, MemoryUtil.memAddress((IntBuffer)version));
    }

    public static int ncuCtxGetStreamPriorityRange(long leastPriority, long greatestPriority) {
        long __functionAddress = Functions.CtxGetStreamPriorityRange;
        return JNI.callPPI((long)leastPriority, (long)greatestPriority, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetStreamPriorityRange(@Nullable @NativeType(value="int *") IntBuffer leastPriority, @Nullable @NativeType(value="int *") IntBuffer greatestPriority) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)leastPriority, (int)1);
            Checks.checkSafe((Buffer)greatestPriority, (int)1);
        }
        return CU.ncuCtxGetStreamPriorityRange(MemoryUtil.memAddressSafe((IntBuffer)leastPriority), MemoryUtil.memAddressSafe((IntBuffer)greatestPriority));
    }

    public static int ncuCtxAttach(long pctx, int flags) {
        long __functionAddress = Functions.CtxAttach;
        return JNI.callPI((long)pctx, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxAttach(@NativeType(value="CUcontext *") PointerBuffer pctx, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pctx, (int)1);
        }
        return CU.ncuCtxAttach(MemoryUtil.memAddress((CustomBuffer)pctx), flags);
    }

    @NativeType(value="CUresult")
    public static int cuCtxDetach(@NativeType(value="CUcontext") long ctx) {
        long __functionAddress = Functions.CtxDetach;
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return JNI.callPI((long)ctx, (long)__functionAddress);
    }

    public static int ncuModuleLoad(long module, long fname) {
        long __functionAddress = Functions.ModuleLoad;
        return JNI.callPPI((long)module, (long)fname, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleLoad(@NativeType(value="CUmodule *") PointerBuffer module, @NativeType(value="char const *") ByteBuffer fname) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)module, (int)1);
            Checks.checkNT1((ByteBuffer)fname);
        }
        return CU.ncuModuleLoad(MemoryUtil.memAddress((CustomBuffer)module), MemoryUtil.memAddress((ByteBuffer)fname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuModuleLoad(@NativeType(value="CUmodule *") PointerBuffer module, @NativeType(value="char const *") CharSequence fname) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)module, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(fname, true);
            long fnameEncoded = stack.getPointerAddress();
            int n = CU.ncuModuleLoad(MemoryUtil.memAddress((CustomBuffer)module), fnameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuModuleLoadData(long module, long image) {
        long __functionAddress = Functions.ModuleLoadData;
        return JNI.callPPI((long)module, (long)image, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleLoadData(@NativeType(value="CUmodule *") PointerBuffer module, @NativeType(value="void const *") ByteBuffer image) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)module, (int)1);
        }
        return CU.ncuModuleLoadData(MemoryUtil.memAddress((CustomBuffer)module), MemoryUtil.memAddress((ByteBuffer)image));
    }

    public static int ncuModuleLoadDataEx(long module, long image, int numOptions, long options, long optionValues) {
        long __functionAddress = Functions.ModuleLoadDataEx;
        return JNI.callPPPPI((long)module, (long)image, (int)numOptions, (long)options, (long)optionValues, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleLoadDataEx(@NativeType(value="CUmodule *") PointerBuffer module, @NativeType(value="void const *") ByteBuffer image, @Nullable @NativeType(value="CUjit_option *") IntBuffer options, @Nullable @NativeType(value="void **") PointerBuffer optionValues) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)module, (int)1);
            Checks.checkSafe((CustomBuffer)optionValues, (int)Checks.remainingSafe((Buffer)options));
        }
        return CU.ncuModuleLoadDataEx(MemoryUtil.memAddress((CustomBuffer)module), MemoryUtil.memAddress((ByteBuffer)image), Checks.remainingSafe((Buffer)options), MemoryUtil.memAddressSafe((IntBuffer)options), MemoryUtil.memAddressSafe((Pointer)optionValues));
    }

    public static int ncuModuleLoadFatBinary(long module, long fatCubin) {
        long __functionAddress = Functions.ModuleLoadFatBinary;
        return JNI.callPPI((long)module, (long)fatCubin, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleLoadFatBinary(@NativeType(value="CUmodule *") PointerBuffer module, @NativeType(value="void const *") ByteBuffer fatCubin) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)module, (int)1);
        }
        return CU.ncuModuleLoadFatBinary(MemoryUtil.memAddress((CustomBuffer)module), MemoryUtil.memAddress((ByteBuffer)fatCubin));
    }

    @NativeType(value="CUresult")
    public static int cuModuleUnload(@NativeType(value="CUmodule") long hmod) {
        long __functionAddress = Functions.ModuleUnload;
        if (Checks.CHECKS) {
            Checks.check((long)hmod);
        }
        return JNI.callPI((long)hmod, (long)__functionAddress);
    }

    public static int ncuModuleGetFunction(long hfunc, long hmod, long name) {
        long __functionAddress = Functions.ModuleGetFunction;
        if (Checks.CHECKS) {
            Checks.check((long)hmod);
        }
        return JNI.callPPPI((long)hfunc, (long)hmod, (long)name, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleGetFunction(@NativeType(value="CUfunction *") PointerBuffer hfunc, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)hfunc, (int)1);
            Checks.checkNT1((ByteBuffer)name);
        }
        return CU.ncuModuleGetFunction(MemoryUtil.memAddress((CustomBuffer)hfunc), hmod, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuModuleGetFunction(@NativeType(value="CUfunction *") PointerBuffer hfunc, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") CharSequence name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)hfunc, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = CU.ncuModuleGetFunction(MemoryUtil.memAddress((CustomBuffer)hfunc), hmod, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuModuleGetGlobal(long dptr, long bytes, long hmod, long name) {
        long __functionAddress = Functions.ModuleGetGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)hmod);
        }
        return JNI.callPPPPI((long)dptr, (long)bytes, (long)hmod, (long)name, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleGetGlobal(@Nullable @NativeType(value="CUdeviceptr *") PointerBuffer dptr, @Nullable @NativeType(value="size_t *") PointerBuffer bytes, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)dptr, (int)1);
            Checks.checkSafe((CustomBuffer)bytes, (int)1);
            Checks.checkNT1((ByteBuffer)name);
        }
        return CU.ncuModuleGetGlobal(MemoryUtil.memAddressSafe((Pointer)dptr), MemoryUtil.memAddressSafe((Pointer)bytes), hmod, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuModuleGetGlobal(@Nullable @NativeType(value="CUdeviceptr *") PointerBuffer dptr, @Nullable @NativeType(value="size_t *") PointerBuffer bytes, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") CharSequence name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)dptr, (int)1);
            Checks.checkSafe((CustomBuffer)bytes, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = CU.ncuModuleGetGlobal(MemoryUtil.memAddressSafe((Pointer)dptr), MemoryUtil.memAddressSafe((Pointer)bytes), hmod, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuModuleGetTexRef(long pTexRef, long hmod, long name) {
        long __functionAddress = Functions.ModuleGetTexRef;
        if (Checks.CHECKS) {
            Checks.check((long)hmod);
        }
        return JNI.callPPPI((long)pTexRef, (long)hmod, (long)name, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleGetTexRef(@NativeType(value="CUtexref *") PointerBuffer pTexRef, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pTexRef, (int)1);
            Checks.checkNT1((ByteBuffer)name);
        }
        return CU.ncuModuleGetTexRef(MemoryUtil.memAddress((CustomBuffer)pTexRef), hmod, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuModuleGetTexRef(@NativeType(value="CUtexref *") PointerBuffer pTexRef, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") CharSequence name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pTexRef, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = CU.ncuModuleGetTexRef(MemoryUtil.memAddress((CustomBuffer)pTexRef), hmod, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuModuleGetSurfRef(long pSurfRef, long hmod, long name) {
        long __functionAddress = Functions.ModuleGetSurfRef;
        if (Checks.CHECKS) {
            Checks.check((long)hmod);
        }
        return JNI.callPPPI((long)pSurfRef, (long)hmod, (long)name, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuModuleGetSurfRef(@NativeType(value="CUsurfref *") PointerBuffer pSurfRef, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pSurfRef, (int)1);
            Checks.checkNT1((ByteBuffer)name);
        }
        return CU.ncuModuleGetSurfRef(MemoryUtil.memAddress((CustomBuffer)pSurfRef), hmod, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuModuleGetSurfRef(@NativeType(value="CUsurfref *") PointerBuffer pSurfRef, @NativeType(value="CUmodule") long hmod, @NativeType(value="char const *") CharSequence name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pSurfRef, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = CU.ncuModuleGetSurfRef(MemoryUtil.memAddress((CustomBuffer)pSurfRef), hmod, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuMemGetInfo(long free, long total) {
        long __functionAddress = Functions.MemGetInfo;
        return JNI.callPPI((long)free, (long)total, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemGetInfo(@NativeType(value="size_t *") PointerBuffer free, @NativeType(value="size_t *") PointerBuffer total) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)free, (int)1);
            Checks.check((CustomBuffer)total, (int)1);
        }
        return CU.ncuMemGetInfo(MemoryUtil.memAddress((CustomBuffer)free), MemoryUtil.memAddress((CustomBuffer)total));
    }

    public static int ncuMemAlloc(long dptr, long bytesize) {
        long __functionAddress = Functions.MemAlloc;
        return JNI.callPPI((long)dptr, (long)bytesize, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemAlloc(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t") long bytesize) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dptr, (int)1);
        }
        return CU.ncuMemAlloc(MemoryUtil.memAddress((CustomBuffer)dptr), bytesize);
    }

    public static int ncuMemAllocPitch(long dptr, long pPitch, long WidthInBytes, long Height, int ElementSizeBytes) {
        long __functionAddress = Functions.MemAllocPitch;
        return JNI.callPPPPI((long)dptr, (long)pPitch, (long)WidthInBytes, (long)Height, (int)ElementSizeBytes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemAllocPitch(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t *") PointerBuffer pPitch, @NativeType(value="size_t") long WidthInBytes, @NativeType(value="size_t") long Height, @NativeType(value="unsigned int") int ElementSizeBytes) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dptr, (int)1);
            Checks.check((CustomBuffer)pPitch, (int)1);
        }
        return CU.ncuMemAllocPitch(MemoryUtil.memAddress((CustomBuffer)dptr), MemoryUtil.memAddress((CustomBuffer)pPitch), WidthInBytes, Height, ElementSizeBytes);
    }

    @NativeType(value="CUresult")
    public static int cuMemFree(@NativeType(value="CUdeviceptr") long dptr) {
        long __functionAddress = Functions.MemFree;
        if (Checks.CHECKS) {
            Checks.check((long)dptr);
        }
        return JNI.callPI((long)dptr, (long)__functionAddress);
    }

    public static int ncuMemGetAddressRange(long pbase, long psize, long dptr) {
        long __functionAddress = Functions.MemGetAddressRange;
        if (Checks.CHECKS) {
            Checks.check((long)dptr);
        }
        return JNI.callPPPI((long)pbase, (long)psize, (long)dptr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemGetAddressRange(@Nullable @NativeType(value="CUdeviceptr *") PointerBuffer pbase, @Nullable @NativeType(value="size_t *") PointerBuffer psize, @NativeType(value="CUdeviceptr") long dptr) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)pbase, (int)1);
            Checks.checkSafe((CustomBuffer)psize, (int)1);
        }
        return CU.ncuMemGetAddressRange(MemoryUtil.memAddressSafe((Pointer)pbase), MemoryUtil.memAddressSafe((Pointer)psize), dptr);
    }

    public static int ncuMemAllocHost(long pp, long bytesize) {
        long __functionAddress = Functions.MemAllocHost;
        return JNI.callPPI((long)pp, (long)bytesize, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemAllocHost(@NativeType(value="void **") PointerBuffer pp, @NativeType(value="size_t") long bytesize) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pp, (int)1);
        }
        return CU.ncuMemAllocHost(MemoryUtil.memAddress((CustomBuffer)pp), bytesize);
    }

    public static int ncuMemFreeHost(long p) {
        long __functionAddress = Functions.MemFreeHost;
        return JNI.callPI((long)p, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemFreeHost(@NativeType(value="void *") ByteBuffer p) {
        return CU.ncuMemFreeHost(MemoryUtil.memAddress((ByteBuffer)p));
    }

    public static int ncuMemHostAlloc(long pp, long bytesize, int Flags) {
        long __functionAddress = Functions.MemHostAlloc;
        return JNI.callPPI((long)pp, (long)bytesize, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemHostAlloc(@NativeType(value="void **") PointerBuffer pp, @NativeType(value="size_t") long bytesize, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pp, (int)1);
        }
        return CU.ncuMemHostAlloc(MemoryUtil.memAddress((CustomBuffer)pp), bytesize, Flags);
    }

    public static int ncuMemHostGetDevicePointer(long pdptr, long p, int Flags) {
        long __functionAddress = Functions.MemHostGetDevicePointer;
        return JNI.callPPI((long)pdptr, (long)p, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemHostGetDevicePointer(@NativeType(value="CUdeviceptr *") PointerBuffer pdptr, @NativeType(value="void *") ByteBuffer p, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pdptr, (int)1);
        }
        return CU.ncuMemHostGetDevicePointer(MemoryUtil.memAddress((CustomBuffer)pdptr), MemoryUtil.memAddress((ByteBuffer)p), Flags);
    }

    public static int ncuMemHostGetFlags(long pFlags, long p) {
        long __functionAddress = Functions.MemHostGetFlags;
        return JNI.callPPI((long)pFlags, (long)p, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemHostGetFlags(@NativeType(value="unsigned int *") IntBuffer pFlags, @NativeType(value="void *") ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFlags, (int)1);
        }
        return CU.ncuMemHostGetFlags(MemoryUtil.memAddress((IntBuffer)pFlags), MemoryUtil.memAddress((ByteBuffer)p));
    }

    public static int ncuMemcpyHtoD(long dstDevice, long srcHost, long ByteCount) {
        long __functionAddress = Functions.MemcpyHtoD;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPI((long)dstDevice, (long)srcHost, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") ByteBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((ByteBuffer)srcHost), srcHost.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") ShortBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((ShortBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 1);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") IntBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((IntBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") LongBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((LongBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") FloatBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((FloatBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") DoubleBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((DoubleBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") PointerBuffer srcHost) {
        return CU.ncuMemcpyHtoD(dstDevice, MemoryUtil.memAddress((CustomBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << Pointer.POINTER_SHIFT);
    }

    public static int ncuMemcpyDtoH(long dstHost, long srcDevice, long ByteCount) {
        long __functionAddress = Functions.MemcpyDtoH;
        if (Checks.CHECKS) {
            Checks.check((long)srcDevice);
        }
        return JNI.callPPPI((long)dstHost, (long)srcDevice, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") ByteBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((ByteBuffer)dstHost), srcDevice, dstHost.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") ShortBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((ShortBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 1);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") IntBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((IntBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") LongBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((LongBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") FloatBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((FloatBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") DoubleBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((DoubleBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoH(@NativeType(value="void *") PointerBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice) {
        return CU.ncuMemcpyDtoH(MemoryUtil.memAddress((CustomBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << Pointer.POINTER_SHIFT);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="size_t") long ByteCount) {
        long __functionAddress = Functions.MemcpyDtoD;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
            Checks.check((long)srcDevice);
        }
        return JNI.callPPPI((long)dstDevice, (long)srcDevice, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="size_t") long ByteCount) {
        long __functionAddress = Functions.MemcpyDtoA;
        if (Checks.CHECKS) {
            Checks.check((long)dstArray);
            Checks.check((long)srcDevice);
        }
        return JNI.callPPPPI((long)dstArray, (long)dstOffset, (long)srcDevice, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoD(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="size_t") long ByteCount) {
        long __functionAddress = Functions.MemcpyAtoD;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
            Checks.check((long)srcArray);
        }
        return JNI.callPPPPI((long)dstDevice, (long)srcArray, (long)srcOffset, (long)ByteCount, (long)__functionAddress);
    }

    public static int ncuMemcpyHtoA(long dstArray, long dstOffset, long srcHost, long ByteCount) {
        long __functionAddress = Functions.MemcpyHtoA;
        if (Checks.CHECKS) {
            Checks.check((long)dstArray);
        }
        return JNI.callPPPPI((long)dstArray, (long)dstOffset, (long)srcHost, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") ByteBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((ByteBuffer)srcHost), srcHost.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") ShortBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((ShortBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 1);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") IntBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((IntBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") LongBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((LongBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") FloatBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((FloatBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") DoubleBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((DoubleBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") PointerBuffer srcHost) {
        return CU.ncuMemcpyHtoA(dstArray, dstOffset, MemoryUtil.memAddress((CustomBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << Pointer.POINTER_SHIFT);
    }

    public static int ncuMemcpyAtoH(long dstHost, long srcArray, long srcOffset, long ByteCount) {
        long __functionAddress = Functions.MemcpyAtoH;
        if (Checks.CHECKS) {
            Checks.check((long)srcArray);
        }
        return JNI.callPPPPI((long)dstHost, (long)srcArray, (long)srcOffset, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") ByteBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((ByteBuffer)dstHost), srcArray, srcOffset, dstHost.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") ShortBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((ShortBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 1);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") IntBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((IntBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") LongBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((LongBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") FloatBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((FloatBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 2);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") DoubleBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((DoubleBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 3);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoH(@NativeType(value="void *") PointerBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset) {
        return CU.ncuMemcpyAtoH(MemoryUtil.memAddress((CustomBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << Pointer.POINTER_SHIFT);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoA(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="size_t") long ByteCount) {
        long __functionAddress = Functions.MemcpyAtoA;
        if (Checks.CHECKS) {
            Checks.check((long)dstArray);
            Checks.check((long)srcArray);
        }
        return JNI.callPPPPPI((long)dstArray, (long)dstOffset, (long)srcArray, (long)srcOffset, (long)ByteCount, (long)__functionAddress);
    }

    public static int ncuMemcpy2D(long pCopy) {
        long __functionAddress = Functions.Memcpy2D;
        if (Checks.CHECKS) {
            CUDA_MEMCPY2D.validate(pCopy);
        }
        return JNI.callPI((long)pCopy, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy2D(@NativeType(value="CUDA_MEMCPY2D const *") CUDA_MEMCPY2D pCopy) {
        return CU.ncuMemcpy2D(pCopy.address());
    }

    public static int ncuMemcpy2DUnaligned(long pCopy) {
        long __functionAddress = Functions.Memcpy2DUnaligned;
        if (Checks.CHECKS) {
            CUDA_MEMCPY2D.validate(pCopy);
        }
        return JNI.callPI((long)pCopy, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy2DUnaligned(@NativeType(value="CUDA_MEMCPY2D const *") CUDA_MEMCPY2D pCopy) {
        return CU.ncuMemcpy2DUnaligned(pCopy.address());
    }

    public static int ncuMemcpy3D(long pCopy) {
        long __functionAddress = Functions.Memcpy3D;
        if (Checks.CHECKS) {
            CUDA_MEMCPY3D.validate(pCopy);
        }
        return JNI.callPI((long)pCopy, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy3D(@NativeType(value="CUDA_MEMCPY3D const *") CUDA_MEMCPY3D pCopy) {
        return CU.ncuMemcpy3D(pCopy.address());
    }

    public static int ncuMemcpyHtoDAsync(long dstDevice, long srcHost, long ByteCount, long hStream) {
        long __functionAddress = Functions.MemcpyHtoDAsync;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPI((long)dstDevice, (long)srcHost, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") ByteBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((ByteBuffer)srcHost), srcHost.remaining(), hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") ShortBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((ShortBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 1, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") IntBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((IntBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") LongBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((LongBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") FloatBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((FloatBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") DoubleBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((DoubleBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="void const *") PointerBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoDAsync(dstDevice, MemoryUtil.memAddress((CustomBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << Pointer.POINTER_SHIFT, hStream);
    }

    public static int ncuMemcpyDtoHAsync(long dstHost, long srcDevice, long ByteCount, long hStream) {
        long __functionAddress = Functions.MemcpyDtoHAsync;
        if (Checks.CHECKS) {
            Checks.check((long)srcDevice);
        }
        return JNI.callPPPPI((long)dstHost, (long)srcDevice, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") ByteBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((ByteBuffer)dstHost), srcDevice, dstHost.remaining(), hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") ShortBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((ShortBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 1, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") IntBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((IntBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") LongBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((LongBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") FloatBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((FloatBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") DoubleBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((DoubleBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoHAsync(@NativeType(value="void *") PointerBuffer dstHost, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyDtoHAsync(MemoryUtil.memAddress((CustomBuffer)dstHost), srcDevice, Integer.toUnsignedLong(dstHost.remaining()) << Pointer.POINTER_SHIFT, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyDtoDAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="size_t") long ByteCount, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemcpyDtoDAsync;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
            Checks.check((long)srcDevice);
        }
        return JNI.callPPPPI((long)dstDevice, (long)srcDevice, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    public static int ncuMemcpyHtoAAsync(long dstArray, long dstOffset, long srcHost, long ByteCount, long hStream) {
        long __functionAddress = Functions.MemcpyHtoAAsync;
        if (Checks.CHECKS) {
            Checks.check((long)dstArray);
        }
        return JNI.callPPPPPI((long)dstArray, (long)dstOffset, (long)srcHost, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") ByteBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((ByteBuffer)srcHost), srcHost.remaining(), hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") ShortBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((ShortBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 1, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") IntBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((IntBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") LongBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((LongBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") FloatBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((FloatBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") DoubleBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((DoubleBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyHtoAAsync(@NativeType(value="CUarray") long dstArray, @NativeType(value="size_t") long dstOffset, @NativeType(value="void const *") PointerBuffer srcHost, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyHtoAAsync(dstArray, dstOffset, MemoryUtil.memAddress((CustomBuffer)srcHost), Integer.toUnsignedLong(srcHost.remaining()) << Pointer.POINTER_SHIFT, hStream);
    }

    public static int ncuMemcpyAtoHAsync(long dstHost, long srcArray, long srcOffset, long ByteCount, long hStream) {
        long __functionAddress = Functions.MemcpyAtoHAsync;
        if (Checks.CHECKS) {
            Checks.check((long)srcArray);
        }
        return JNI.callPPPPPI((long)dstHost, (long)srcArray, (long)srcOffset, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") ByteBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((ByteBuffer)dstHost), srcArray, srcOffset, dstHost.remaining(), hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") ShortBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((ShortBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 1, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") IntBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((IntBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") LongBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((LongBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") FloatBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((FloatBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 2, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") DoubleBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((DoubleBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << 3, hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAtoHAsync(@NativeType(value="void *") PointerBuffer dstHost, @NativeType(value="CUarray") long srcArray, @NativeType(value="size_t") long srcOffset, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpyAtoHAsync(MemoryUtil.memAddress((CustomBuffer)dstHost), srcArray, srcOffset, Integer.toUnsignedLong(dstHost.remaining()) << Pointer.POINTER_SHIFT, hStream);
    }

    public static int ncuMemcpy2DAsync(long pCopy, long hStream) {
        long __functionAddress = Functions.Memcpy2DAsync;
        if (Checks.CHECKS) {
            CUDA_MEMCPY2D.validate(pCopy);
        }
        return JNI.callPPI((long)pCopy, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy2DAsync(@NativeType(value="CUDA_MEMCPY2D const *") CUDA_MEMCPY2D pCopy, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpy2DAsync(pCopy.address(), hStream);
    }

    public static int ncuMemcpy3DAsync(long pCopy, long hStream) {
        long __functionAddress = Functions.Memcpy3DAsync;
        if (Checks.CHECKS) {
            CUDA_MEMCPY3D.validate(pCopy);
        }
        return JNI.callPPI((long)pCopy, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy3DAsync(@NativeType(value="CUDA_MEMCPY3D const *") CUDA_MEMCPY3D pCopy, @NativeType(value="CUstream") long hStream) {
        return CU.ncuMemcpy3DAsync(pCopy.address(), hStream);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD8(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="unsigned char") byte uc, @NativeType(value="size_t") long N) {
        long __functionAddress = Functions.MemsetD8;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPI((long)dstDevice, (byte)uc, (long)N, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD16(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="unsigned short") short us, @NativeType(value="size_t") long N) {
        long __functionAddress = Functions.MemsetD16;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPI((long)dstDevice, (short)us, (long)N, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD32(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="unsigned int") int ui, @NativeType(value="size_t") long N) {
        long __functionAddress = Functions.MemsetD32;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPI((long)dstDevice, (int)ui, (long)N, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD2D8(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="size_t") long dstPitch, @NativeType(value="unsigned char") byte uc, @NativeType(value="size_t") long Width, @NativeType(value="size_t") long Height) {
        long __functionAddress = Functions.MemsetD2D8;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPI((long)dstDevice, (long)dstPitch, (byte)uc, (long)Width, (long)Height, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD2D16(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="size_t") long dstPitch, @NativeType(value="unsigned short") short us, @NativeType(value="size_t") long Width, @NativeType(value="size_t") long Height) {
        long __functionAddress = Functions.MemsetD2D16;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPI((long)dstDevice, (long)dstPitch, (short)us, (long)Width, (long)Height, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD2D32(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="size_t") long dstPitch, @NativeType(value="unsigned int") int ui, @NativeType(value="size_t") long Width, @NativeType(value="size_t") long Height) {
        long __functionAddress = Functions.MemsetD2D32;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPI((long)dstDevice, (long)dstPitch, (int)ui, (long)Width, (long)Height, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD8Async(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="unsigned char") byte uc, @NativeType(value="size_t") long N, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemsetD8Async;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPI((long)dstDevice, (byte)uc, (long)N, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD16Async(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="unsigned short") short us, @NativeType(value="size_t") long N, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemsetD16Async;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPI((long)dstDevice, (short)us, (long)N, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD32Async(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="unsigned int") int ui, @NativeType(value="size_t") long N, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemsetD32Async;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPI((long)dstDevice, (int)ui, (long)N, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD2D8Async(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="size_t") long dstPitch, @NativeType(value="unsigned char") byte uc, @NativeType(value="size_t") long Width, @NativeType(value="size_t") long Height, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemsetD2D8Async;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPPI((long)dstDevice, (long)dstPitch, (byte)uc, (long)Width, (long)Height, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD2D16Async(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="size_t") long dstPitch, @NativeType(value="unsigned short") short us, @NativeType(value="size_t") long Width, @NativeType(value="size_t") long Height, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemsetD2D16Async;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPPI((long)dstDevice, (long)dstPitch, (short)us, (long)Width, (long)Height, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemsetD2D32Async(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="size_t") long dstPitch, @NativeType(value="unsigned int") int ui, @NativeType(value="size_t") long Width, @NativeType(value="size_t") long Height, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemsetD2D32Async;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
        }
        return JNI.callPPPPPI((long)dstDevice, (long)dstPitch, (int)ui, (long)Width, (long)Height, (long)hStream, (long)__functionAddress);
    }

    public static int ncuArrayCreate(long pHandle, long pAllocateArray) {
        long __functionAddress = Functions.ArrayCreate;
        return JNI.callPPI((long)pHandle, (long)pAllocateArray, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuArrayCreate(@NativeType(value="CUarray *") PointerBuffer pHandle, @NativeType(value="CUDA_ARRAY_DESCRIPTOR const *") CUDA_ARRAY_DESCRIPTOR pAllocateArray) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pHandle, (int)1);
        }
        return CU.ncuArrayCreate(MemoryUtil.memAddress((CustomBuffer)pHandle), pAllocateArray.address());
    }

    public static int ncuArrayGetDescriptor(long pArrayDescriptor, long hArray) {
        long __functionAddress = Functions.ArrayGetDescriptor;
        if (Checks.CHECKS) {
            Checks.check((long)hArray);
        }
        return JNI.callPPI((long)pArrayDescriptor, (long)hArray, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuArrayGetDescriptor(@NativeType(value="CUDA_ARRAY_DESCRIPTOR *") CUDA_ARRAY_DESCRIPTOR pArrayDescriptor, @NativeType(value="CUarray") long hArray) {
        return CU.ncuArrayGetDescriptor(pArrayDescriptor.address(), hArray);
    }

    @NativeType(value="CUresult")
    public static int cuArrayDestroy(@NativeType(value="CUarray") long hArray) {
        long __functionAddress = Functions.ArrayDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hArray);
        }
        return JNI.callPI((long)hArray, (long)__functionAddress);
    }

    public static int ncuArray3DCreate(long pHandle, long pAllocateArray) {
        long __functionAddress = Functions.Array3DCreate;
        return JNI.callPPI((long)pHandle, (long)pAllocateArray, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuArray3DCreate(@NativeType(value="CUarray *") PointerBuffer pHandle, @NativeType(value="CUDA_ARRAY3D_DESCRIPTOR const *") CUDA_ARRAY3D_DESCRIPTOR pAllocateArray) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pHandle, (int)1);
        }
        return CU.ncuArray3DCreate(MemoryUtil.memAddress((CustomBuffer)pHandle), pAllocateArray.address());
    }

    public static int ncuArray3DGetDescriptor(long pArrayDescriptor, long hArray) {
        long __functionAddress = Functions.Array3DGetDescriptor;
        if (Checks.CHECKS) {
            Checks.check((long)hArray);
        }
        return JNI.callPPI((long)pArrayDescriptor, (long)hArray, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuArray3DGetDescriptor(@NativeType(value="CUDA_ARRAY3D_DESCRIPTOR *") CUDA_ARRAY3D_DESCRIPTOR pArrayDescriptor, @NativeType(value="CUarray") long hArray) {
        return CU.ncuArray3DGetDescriptor(pArrayDescriptor.address(), hArray);
    }

    public static int ncuStreamCreate(long phStream, int Flags) {
        long __functionAddress = Functions.StreamCreate;
        return JNI.callPI((long)phStream, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamCreate(@NativeType(value="CUstream *") PointerBuffer phStream, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phStream, (int)1);
        }
        return CU.ncuStreamCreate(MemoryUtil.memAddress((CustomBuffer)phStream), Flags);
    }

    public static int ncuStreamCreateWithPriority(long phStream, int flags, int priority) {
        long __functionAddress = Functions.StreamCreateWithPriority;
        return JNI.callPI((long)phStream, (int)flags, (int)priority, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamCreateWithPriority(@NativeType(value="CUstream *") PointerBuffer phStream, @NativeType(value="unsigned int") int flags, int priority) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phStream, (int)1);
        }
        return CU.ncuStreamCreateWithPriority(MemoryUtil.memAddress((CustomBuffer)phStream), flags, priority);
    }

    public static int ncuStreamGetPriority(long hStream, long priority) {
        long __functionAddress = Functions.StreamGetPriority;
        if (Checks.CHECKS) {
            Checks.check((long)hStream);
        }
        return JNI.callPPI((long)hStream, (long)priority, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamGetPriority(@NativeType(value="CUstream") long hStream, @NativeType(value="int *") IntBuffer priority) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)priority, (int)1);
        }
        return CU.ncuStreamGetPriority(hStream, MemoryUtil.memAddress((IntBuffer)priority));
    }

    public static int ncuStreamGetFlags(long hStream, long flags) {
        long __functionAddress = Functions.StreamGetFlags;
        if (Checks.CHECKS) {
            Checks.check((long)hStream);
        }
        return JNI.callPPI((long)hStream, (long)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamGetFlags(@NativeType(value="CUstream") long hStream, @NativeType(value="unsigned int *") IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)flags, (int)1);
        }
        return CU.ncuStreamGetFlags(hStream, MemoryUtil.memAddress((IntBuffer)flags));
    }

    @NativeType(value="CUresult")
    public static int cuStreamWaitEvent(@NativeType(value="CUstream") long hStream, @NativeType(value="CUevent") long hEvent, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.StreamWaitEvent;
        if (Checks.CHECKS) {
            Checks.check((long)hEvent);
        }
        return JNI.callPPI((long)hStream, (long)hEvent, (int)Flags, (long)__functionAddress);
    }

    public static int ncuStreamAddCallback(long hStream, long callback, long userData, int flags) {
        long __functionAddress = Functions.StreamAddCallback;
        if (Checks.CHECKS) {
            Checks.check((long)userData);
        }
        return JNI.callPPPI((long)hStream, (long)callback, (long)userData, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamAddCallback(@NativeType(value="CUstream") long hStream, @NativeType(value="void (*) (CUstream, CUresult, void *)") CUstreamCallbackI callback, @NativeType(value="void *") long userData, @NativeType(value="unsigned int") int flags) {
        return CU.ncuStreamAddCallback(hStream, callback.address(), userData, flags);
    }

    @NativeType(value="CUresult")
    public static int cuStreamQuery(@NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.StreamQuery;
        return JNI.callPI((long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamSynchronize(@NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.StreamSynchronize;
        return JNI.callPI((long)hStream, (long)__functionAddress);
    }

    public static int ncuEventCreate(long phEvent, int Flags) {
        long __functionAddress = Functions.EventCreate;
        return JNI.callPI((long)phEvent, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuEventCreate(@NativeType(value="CUevent *") PointerBuffer phEvent, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phEvent, (int)1);
        }
        return CU.ncuEventCreate(MemoryUtil.memAddress((CustomBuffer)phEvent), Flags);
    }

    @NativeType(value="CUresult")
    public static int cuEventRecord(@NativeType(value="CUevent") long hEvent, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.EventRecord;
        if (Checks.CHECKS) {
            Checks.check((long)hEvent);
        }
        return JNI.callPPI((long)hEvent, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuEventQuery(@NativeType(value="CUevent") long hEvent) {
        long __functionAddress = Functions.EventQuery;
        if (Checks.CHECKS) {
            Checks.check((long)hEvent);
        }
        return JNI.callPI((long)hEvent, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuEventSynchronize(@NativeType(value="CUevent") long hEvent) {
        long __functionAddress = Functions.EventSynchronize;
        if (Checks.CHECKS) {
            Checks.check((long)hEvent);
        }
        return JNI.callPI((long)hEvent, (long)__functionAddress);
    }

    public static int ncuEventElapsedTime(long pMilliseconds, long hStart, long hEnd) {
        long __functionAddress = Functions.EventElapsedTime;
        if (Checks.CHECKS) {
            Checks.check((long)hStart);
            Checks.check((long)hEnd);
        }
        return JNI.callPPPI((long)pMilliseconds, (long)hStart, (long)hEnd, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuEventElapsedTime(@NativeType(value="float *") FloatBuffer pMilliseconds, @NativeType(value="CUevent") long hStart, @NativeType(value="CUevent") long hEnd) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pMilliseconds, (int)1);
        }
        return CU.ncuEventElapsedTime(MemoryUtil.memAddress((FloatBuffer)pMilliseconds), hStart, hEnd);
    }

    public static int ncuFuncGetAttribute(long pi, int attrib, long hfunc) {
        long __functionAddress = Functions.FuncGetAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPPI((long)pi, (int)attrib, (long)hfunc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuFuncGetAttribute(@NativeType(value="int *") IntBuffer pi, @NativeType(value="CUfunction_attribute") int attrib, @NativeType(value="CUfunction") long hfunc) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pi, (int)1);
        }
        return CU.ncuFuncGetAttribute(MemoryUtil.memAddress((IntBuffer)pi), attrib, hfunc);
    }

    @NativeType(value="CUresult")
    public static int cuFuncSetCacheConfig(@NativeType(value="CUfunction") long hfunc, @NativeType(value="CUfunc_cache") int config) {
        long __functionAddress = Functions.FuncSetCacheConfig;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)config, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuFuncSetBlockShape(@NativeType(value="CUfunction") long hfunc, int x, int y, int z) {
        long __functionAddress = Functions.FuncSetBlockShape;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)x, (int)y, (int)z, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuFuncSetSharedSize(@NativeType(value="CUfunction") long hfunc, @NativeType(value="unsigned int") int bytes) {
        long __functionAddress = Functions.FuncSetSharedSize;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)bytes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuParamSetSize(@NativeType(value="CUfunction") long hfunc, @NativeType(value="unsigned int") int numbytes) {
        long __functionAddress = Functions.ParamSetSize;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)numbytes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuParamSeti(@NativeType(value="CUfunction") long hfunc, int offset, @NativeType(value="unsigned int") int value) {
        long __functionAddress = Functions.ParamSeti;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)offset, (int)value, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuParamSetf(@NativeType(value="CUfunction") long hfunc, int offset, float value) {
        long __functionAddress = Functions.ParamSetf;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)offset, (float)value, (long)__functionAddress);
    }

    public static int ncuParamSetv(long hfunc, int offset, long ptr, int numbytes) {
        long __functionAddress = Functions.ParamSetv;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPPI((long)hfunc, (int)offset, (long)ptr, (int)numbytes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuParamSetv(@NativeType(value="CUfunction") long hfunc, int offset, @NativeType(value="void *") ByteBuffer ptr) {
        return CU.ncuParamSetv(hfunc, offset, MemoryUtil.memAddress((ByteBuffer)ptr), ptr.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuLaunch(@NativeType(value="CUfunction") long f) {
        long __functionAddress = Functions.Launch;
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return JNI.callPI((long)f, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLaunchGrid(@NativeType(value="CUfunction") long f, int grid_width, int grid_height) {
        long __functionAddress = Functions.LaunchGrid;
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return JNI.callPI((long)f, (int)grid_width, (int)grid_height, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLaunchGridAsync(@NativeType(value="CUfunction") long f, int grid_width, int grid_height, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.LaunchGridAsync;
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return JNI.callPPI((long)f, (int)grid_width, (int)grid_height, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuParamSetTexRef(@NativeType(value="CUfunction") long hfunc, int texunit, @NativeType(value="CUtexref") long hTexRef) {
        long __functionAddress = Functions.ParamSetTexRef;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)hfunc, (int)texunit, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetArray(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUarray") long hArray, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.TexRefSetArray;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
            Checks.check((long)hArray);
        }
        return JNI.callPPI((long)hTexRef, (long)hArray, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetMipmappedArray(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUmipmappedArray") long hMipmappedArray, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.TexRefSetMipmappedArray;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
            Checks.check((long)hMipmappedArray);
        }
        return JNI.callPPI((long)hTexRef, (long)hMipmappedArray, (int)Flags, (long)__functionAddress);
    }

    public static int ncuTexRefSetAddress(long ByteOffset, long hTexRef, long dptr, long bytes) {
        long __functionAddress = Functions.TexRefSetAddress;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
            Checks.check((long)dptr);
        }
        return JNI.callPPPPI((long)ByteOffset, (long)hTexRef, (long)dptr, (long)bytes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetAddress(@Nullable @NativeType(value="size_t *") PointerBuffer ByteOffset, @NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUdeviceptr") long dptr, @NativeType(value="size_t") long bytes) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)ByteOffset, (int)1);
        }
        return CU.ncuTexRefSetAddress(MemoryUtil.memAddressSafe((Pointer)ByteOffset), hTexRef, dptr, bytes);
    }

    public static int ncuTexRefSetAddress2D(long hTexRef, long desc, long dptr, long Pitch) {
        long __functionAddress = Functions.TexRefSetAddress2D;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
            Checks.check((long)dptr);
        }
        return JNI.callPPPPI((long)hTexRef, (long)desc, (long)dptr, (long)Pitch, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetAddress2D(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUDA_ARRAY_DESCRIPTOR const *") CUDA_ARRAY_DESCRIPTOR desc, @NativeType(value="CUdeviceptr") long dptr, @NativeType(value="size_t") long Pitch) {
        return CU.ncuTexRefSetAddress2D(hTexRef, desc.address(), dptr, Pitch);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetFormat(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUarray_format") int fmt, int NumPackedComponents) {
        long __functionAddress = Functions.TexRefSetFormat;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (int)fmt, (int)NumPackedComponents, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetAddressMode(@NativeType(value="CUtexref") long hTexRef, int dim, @NativeType(value="CUaddress_mode") int am) {
        long __functionAddress = Functions.TexRefSetAddressMode;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (int)dim, (int)am, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetFilterMode(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUfilter_mode") int fm) {
        long __functionAddress = Functions.TexRefSetFilterMode;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (int)fm, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetMipmapFilterMode(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="CUfilter_mode") int fm) {
        long __functionAddress = Functions.TexRefSetMipmapFilterMode;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (int)fm, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetMipmapLevelBias(@NativeType(value="CUtexref") long hTexRef, float bias) {
        long __functionAddress = Functions.TexRefSetMipmapLevelBias;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (float)bias, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetMipmapLevelClamp(@NativeType(value="CUtexref") long hTexRef, float minMipmapLevelClamp, float maxMipmapLevelClamp) {
        long __functionAddress = Functions.TexRefSetMipmapLevelClamp;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (float)minMipmapLevelClamp, (float)maxMipmapLevelClamp, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetMaxAnisotropy(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="unsigned int") int maxAniso) {
        long __functionAddress = Functions.TexRefSetMaxAnisotropy;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (int)maxAniso, (long)__functionAddress);
    }

    public static int ncuTexRefSetBorderColor(long hTexRef, long pBorderColor) {
        long __functionAddress = Functions.TexRefSetBorderColor;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)hTexRef, (long)pBorderColor, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetBorderColor(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="float *") FloatBuffer pBorderColor) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pBorderColor, (int)4);
        }
        return CU.ncuTexRefSetBorderColor(hTexRef, MemoryUtil.memAddress((FloatBuffer)pBorderColor));
    }

    @NativeType(value="CUresult")
    public static int cuTexRefSetFlags(@NativeType(value="CUtexref") long hTexRef, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.TexRefSetFlags;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (int)Flags, (long)__functionAddress);
    }

    public static int ncuTexRefGetAddress(long pdptr, long hTexRef) {
        long __functionAddress = Functions.TexRefGetAddress;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pdptr, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetAddress(@NativeType(value="CUdeviceptr *") PointerBuffer pdptr, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pdptr, (int)1);
        }
        return CU.ncuTexRefGetAddress(MemoryUtil.memAddress((CustomBuffer)pdptr), hTexRef);
    }

    public static int ncuTexRefGetArray(long phArray, long hTexRef) {
        long __functionAddress = Functions.TexRefGetArray;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)phArray, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetArray(@NativeType(value="CUarray *") PointerBuffer phArray, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phArray, (int)1);
        }
        return CU.ncuTexRefGetArray(MemoryUtil.memAddress((CustomBuffer)phArray), hTexRef);
    }

    public static int ncuTexRefGetMipmappedArray(long phMipmappedArray, long hTexRef) {
        long __functionAddress = Functions.TexRefGetMipmappedArray;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)phMipmappedArray, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetMipmappedArray(@NativeType(value="CUmipmappedArray *") PointerBuffer phMipmappedArray, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phMipmappedArray, (int)1);
        }
        return CU.ncuTexRefGetMipmappedArray(MemoryUtil.memAddress((CustomBuffer)phMipmappedArray), hTexRef);
    }

    public static int ncuTexRefGetAddressMode(long pam, long hTexRef, int dim) {
        long __functionAddress = Functions.TexRefGetAddressMode;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pam, (long)hTexRef, (int)dim, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetAddressMode(@NativeType(value="CUaddress_mode *") IntBuffer pam, @NativeType(value="CUtexref") long hTexRef, int dim) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pam, (int)1);
        }
        return CU.ncuTexRefGetAddressMode(MemoryUtil.memAddress((IntBuffer)pam), hTexRef, dim);
    }

    public static int ncuTexRefGetFilterMode(long pfm, long hTexRef) {
        long __functionAddress = Functions.TexRefGetFilterMode;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pfm, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetFilterMode(@NativeType(value="CUfilter_mode *") IntBuffer pfm, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfm, (int)1);
        }
        return CU.ncuTexRefGetFilterMode(MemoryUtil.memAddress((IntBuffer)pfm), hTexRef);
    }

    public static int ncuTexRefGetFormat(long pFormat, long pNumChannels, long hTexRef) {
        long __functionAddress = Functions.TexRefGetFormat;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPPI((long)pFormat, (long)pNumChannels, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetFormat(@Nullable @NativeType(value="CUarray_format *") IntBuffer pFormat, @Nullable @NativeType(value="int *") IntBuffer pNumChannels, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)pFormat, (int)1);
            Checks.checkSafe((Buffer)pNumChannels, (int)1);
        }
        return CU.ncuTexRefGetFormat(MemoryUtil.memAddressSafe((IntBuffer)pFormat), MemoryUtil.memAddressSafe((IntBuffer)pNumChannels), hTexRef);
    }

    public static int ncuTexRefGetMipmapFilterMode(long pfm, long hTexRef) {
        long __functionAddress = Functions.TexRefGetMipmapFilterMode;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pfm, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetMipmapFilterMode(@NativeType(value="CUfilter_mode *") IntBuffer pfm, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfm, (int)1);
        }
        return CU.ncuTexRefGetMipmapFilterMode(MemoryUtil.memAddress((IntBuffer)pfm), hTexRef);
    }

    public static int ncuTexRefGetMipmapLevelBias(long pbias, long hTexRef) {
        long __functionAddress = Functions.TexRefGetMipmapLevelBias;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pbias, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetMipmapLevelBias(@NativeType(value="float *") FloatBuffer pbias, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pbias, (int)1);
        }
        return CU.ncuTexRefGetMipmapLevelBias(MemoryUtil.memAddress((FloatBuffer)pbias), hTexRef);
    }

    public static int ncuTexRefGetMipmapLevelClamp(long pminMipmapLevelClamp, long pmaxMipmapLevelClamp, long hTexRef) {
        long __functionAddress = Functions.TexRefGetMipmapLevelClamp;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPPI((long)pminMipmapLevelClamp, (long)pmaxMipmapLevelClamp, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetMipmapLevelClamp(@NativeType(value="float *") FloatBuffer pminMipmapLevelClamp, @NativeType(value="float *") FloatBuffer pmaxMipmapLevelClamp, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pminMipmapLevelClamp, (int)1);
            Checks.check((Buffer)pmaxMipmapLevelClamp, (int)1);
        }
        return CU.ncuTexRefGetMipmapLevelClamp(MemoryUtil.memAddress((FloatBuffer)pminMipmapLevelClamp), MemoryUtil.memAddress((FloatBuffer)pmaxMipmapLevelClamp), hTexRef);
    }

    public static int ncuTexRefGetMaxAnisotropy(long pmaxAniso, long hTexRef) {
        long __functionAddress = Functions.TexRefGetMaxAnisotropy;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pmaxAniso, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetMaxAnisotropy(@NativeType(value="int *") IntBuffer pmaxAniso, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pmaxAniso, (int)1);
        }
        return CU.ncuTexRefGetMaxAnisotropy(MemoryUtil.memAddress((IntBuffer)pmaxAniso), hTexRef);
    }

    public static int ncuTexRefGetBorderColor(long pBorderColor, long hTexRef) {
        long __functionAddress = Functions.TexRefGetBorderColor;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pBorderColor, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetBorderColor(@NativeType(value="float *") FloatBuffer pBorderColor, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pBorderColor, (int)4);
        }
        return CU.ncuTexRefGetBorderColor(MemoryUtil.memAddress((FloatBuffer)pBorderColor), hTexRef);
    }

    public static int ncuTexRefGetFlags(long pFlags, long hTexRef) {
        long __functionAddress = Functions.TexRefGetFlags;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPPI((long)pFlags, (long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefGetFlags(@NativeType(value="unsigned int *") IntBuffer pFlags, @NativeType(value="CUtexref") long hTexRef) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFlags, (int)1);
        }
        return CU.ncuTexRefGetFlags(MemoryUtil.memAddress((IntBuffer)pFlags), hTexRef);
    }

    public static int ncuTexRefCreate(long pTexRef) {
        long __functionAddress = Functions.TexRefCreate;
        return JNI.callPI((long)pTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexRefCreate(@NativeType(value="CUtexref *") PointerBuffer pTexRef) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pTexRef, (int)1);
        }
        return CU.ncuTexRefCreate(MemoryUtil.memAddress((CustomBuffer)pTexRef));
    }

    @NativeType(value="CUresult")
    public static int cuTexRefDestroy(@NativeType(value="CUtexref") long hTexRef) {
        long __functionAddress = Functions.TexRefDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hTexRef);
        }
        return JNI.callPI((long)hTexRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuSurfRefSetArray(@NativeType(value="CUsurfref") long hSurfRef, @NativeType(value="CUarray") long hArray, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.SurfRefSetArray;
        if (Checks.CHECKS) {
            Checks.check((long)hSurfRef);
            Checks.check((long)hArray);
        }
        return JNI.callPPI((long)hSurfRef, (long)hArray, (int)Flags, (long)__functionAddress);
    }

    public static int ncuSurfRefGetArray(long phArray, long hSurfRef) {
        long __functionAddress = Functions.SurfRefGetArray;
        if (Checks.CHECKS) {
            Checks.check((long)hSurfRef);
        }
        return JNI.callPPI((long)phArray, (long)hSurfRef, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuSurfRefGetArray(@NativeType(value="CUarray *") PointerBuffer phArray, @NativeType(value="CUsurfref") long hSurfRef) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phArray, (int)1);
        }
        return CU.ncuSurfRefGetArray(MemoryUtil.memAddress((CustomBuffer)phArray), hSurfRef);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsUnregisterResource(@NativeType(value="CUgraphicsResource") long resource) {
        long __functionAddress = Functions.GraphicsUnregisterResource;
        if (Checks.CHECKS) {
            Checks.check((long)resource);
        }
        return JNI.callPI((long)resource, (long)__functionAddress);
    }

    public static int ncuGraphicsSubResourceGetMappedArray(long pArray, long resource, int arrayIndex, int mipLevel) {
        long __functionAddress = Functions.GraphicsSubResourceGetMappedArray;
        if (Checks.CHECKS) {
            Checks.check((long)resource);
        }
        return JNI.callPPI((long)pArray, (long)resource, (int)arrayIndex, (int)mipLevel, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsSubResourceGetMappedArray(@NativeType(value="CUarray *") PointerBuffer pArray, @NativeType(value="CUgraphicsResource") long resource, @NativeType(value="unsigned int") int arrayIndex, @NativeType(value="unsigned int") int mipLevel) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pArray, (int)1);
        }
        return CU.ncuGraphicsSubResourceGetMappedArray(MemoryUtil.memAddress((CustomBuffer)pArray), resource, arrayIndex, mipLevel);
    }

    public static int ncuGraphicsResourceGetMappedPointer(long pDevPtr, long pSize, long resource) {
        long __functionAddress = Functions.GraphicsResourceGetMappedPointer;
        if (Checks.CHECKS) {
            Checks.check((long)resource);
        }
        return JNI.callPPPI((long)pDevPtr, (long)pSize, (long)resource, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsResourceGetMappedPointer(@NativeType(value="CUdeviceptr *") PointerBuffer pDevPtr, @NativeType(value="size_t *") PointerBuffer pSize, @NativeType(value="CUgraphicsResource") long resource) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pDevPtr, (int)1);
            Checks.check((CustomBuffer)pSize, (int)1);
        }
        return CU.ncuGraphicsResourceGetMappedPointer(MemoryUtil.memAddress((CustomBuffer)pDevPtr), MemoryUtil.memAddress((CustomBuffer)pSize), resource);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsResourceSetMapFlags(@NativeType(value="CUgraphicsResource") long resource, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.GraphicsResourceSetMapFlags;
        if (Checks.CHECKS) {
            Checks.check((long)resource);
        }
        return JNI.callPI((long)resource, (int)flags, (long)__functionAddress);
    }

    public static int ncuGraphicsMapResources(int count, long resources, long hStream) {
        long __functionAddress = Functions.GraphicsMapResources;
        return JNI.callPPI((int)count, (long)resources, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsMapResources(@NativeType(value="CUgraphicsResource *") PointerBuffer resources, @NativeType(value="CUstream") long hStream) {
        return CU.ncuGraphicsMapResources(resources.remaining(), MemoryUtil.memAddress((CustomBuffer)resources), hStream);
    }

    public static int ncuGraphicsUnmapResources(int count, long resources, long hStream) {
        long __functionAddress = Functions.GraphicsUnmapResources;
        return JNI.callPPI((int)count, (long)resources, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsUnmapResources(@NativeType(value="CUgraphicsResource *") PointerBuffer resources, @NativeType(value="CUstream") long hStream) {
        return CU.ncuGraphicsUnmapResources(resources.remaining(), MemoryUtil.memAddress((CustomBuffer)resources), hStream);
    }

    public static int ncuGetExportTable(long ppExportTable, long pExportTableId) {
        long __functionAddress = Functions.GetExportTable;
        return JNI.callPPI((long)ppExportTable, (long)pExportTableId, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGetExportTable(@NativeType(value="void const **") PointerBuffer ppExportTable, @NativeType(value="CUuuid const *") CUuuid pExportTableId) {
        return CU.ncuGetExportTable(MemoryUtil.memAddress((CustomBuffer)ppExportTable), pExportTableId.address());
    }

    static /* synthetic */ SharedLibrary access$000() {
        return NVCUDA;
    }

    public static final class Functions {
        public static final long GetErrorString = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuGetErrorString");
        public static final long GetErrorName = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuGetErrorName");
        public static final long Init = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuInit");
        public static final long DriverGetVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDriverGetVersion");
        public static final long DeviceGet = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDeviceGet");
        public static final long DeviceGetCount = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDeviceGetCount");
        public static final long DeviceGetName = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDeviceGetName");
        public static final long DeviceTotalMem = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuDeviceTotalMem", 2));
        public static final long DeviceGetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDeviceGetAttribute");
        public static final long DeviceGetProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDeviceGetProperties");
        public static final long DeviceComputeCapability = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuDeviceComputeCapability");
        public static final long CtxCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuCtxCreate", 2));
        public static final long CtxGetDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxGetDevice");
        public static final long CtxSynchronize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxSynchronize");
        public static final long CtxSetLimit = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxSetLimit");
        public static final long CtxGetLimit = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxGetLimit");
        public static final long CtxGetCacheConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxGetCacheConfig");
        public static final long CtxSetCacheConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxSetCacheConfig");
        public static final long CtxGetApiVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxGetApiVersion");
        public static final long CtxGetStreamPriorityRange = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxGetStreamPriorityRange");
        public static final long CtxAttach = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxAttach");
        public static final long CtxDetach = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuCtxDetach");
        public static final long ModuleLoad = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleLoad");
        public static final long ModuleLoadData = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleLoadData");
        public static final long ModuleLoadDataEx = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleLoadDataEx");
        public static final long ModuleLoadFatBinary = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleLoadFatBinary");
        public static final long ModuleUnload = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleUnload");
        public static final long ModuleGetFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleGetFunction");
        public static final long ModuleGetGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuModuleGetGlobal", 2));
        public static final long ModuleGetTexRef = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleGetTexRef");
        public static final long ModuleGetSurfRef = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuModuleGetSurfRef");
        public static final long MemGetInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemGetInfo", 2));
        public static final long MemAlloc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemAlloc", 2));
        public static final long MemAllocPitch = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemAllocPitch", 2));
        public static final long MemFree = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemFree", 2));
        public static final long MemGetAddressRange = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemGetAddressRange", 2));
        public static final long MemAllocHost = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemAllocHost", 2));
        public static final long MemFreeHost = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuMemFreeHost");
        public static final long MemHostAlloc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuMemHostAlloc");
        public static final long MemHostGetDevicePointer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuMemHostGetDevicePointer", 2));
        public static final long MemHostGetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuMemHostGetFlags");
        public static final long MemcpyHtoD = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyHtoD", 2)));
        public static final long MemcpyDtoH = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyDtoH", 2)));
        public static final long MemcpyDtoD = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyDtoD", 2)));
        public static final long MemcpyDtoA = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyDtoA", 2)));
        public static final long MemcpyAtoD = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyAtoD", 2)));
        public static final long MemcpyHtoA = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyHtoA", 2)));
        public static final long MemcpyAtoH = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyAtoH", 2)));
        public static final long MemcpyAtoA = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpyAtoA", 2)));
        public static final long Memcpy2D = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpy2D", 2)));
        public static final long Memcpy2DUnaligned = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpy2DUnaligned", 2)));
        public static final long Memcpy3D = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemcpy3D", 2)));
        public static final long MemcpyHtoDAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpyHtoDAsync", 2)));
        public static final long MemcpyDtoHAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpyDtoHAsync", 2)));
        public static final long MemcpyDtoDAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpyDtoDAsync", 2)));
        public static final long MemcpyHtoAAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpyHtoAAsync", 2)));
        public static final long MemcpyAtoHAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpyAtoHAsync", 2)));
        public static final long Memcpy2DAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpy2DAsync", 2)));
        public static final long Memcpy3DAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ(CUDA.__CUDA_API_VERSION("cuMemcpy3DAsync", 2)));
        public static final long MemsetD8 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemsetD8", 2)));
        public static final long MemsetD16 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemsetD16", 2)));
        public static final long MemsetD32 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemsetD32", 2)));
        public static final long MemsetD2D8 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemsetD2D8", 2)));
        public static final long MemsetD2D16 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemsetD2D16", 2)));
        public static final long MemsetD2D32 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTDS(CUDA.__CUDA_API_VERSION("cuMemsetD2D32", 2)));
        public static final long MemsetD8Async = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuMemsetD8Async"));
        public static final long MemsetD16Async = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuMemsetD16Async"));
        public static final long MemsetD32Async = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuMemsetD32Async"));
        public static final long MemsetD2D8Async = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuMemsetD2D8Async"));
        public static final long MemsetD2D16Async = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuMemsetD2D16Async"));
        public static final long MemsetD2D32Async = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuMemsetD2D32Async"));
        public static final long ArrayCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuArrayCreate", 2));
        public static final long ArrayGetDescriptor = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuArrayGetDescriptor", 2));
        public static final long ArrayDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuArrayDestroy");
        public static final long Array3DCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuArray3DCreate", 2));
        public static final long Array3DGetDescriptor = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuArray3DGetDescriptor", 2));
        public static final long StreamCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuStreamCreate");
        public static final long StreamCreateWithPriority = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuStreamCreateWithPriority");
        public static final long StreamGetPriority = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuStreamGetPriority"));
        public static final long StreamGetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuStreamGetFlags"));
        public static final long StreamWaitEvent = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuStreamWaitEvent"));
        public static final long StreamAddCallback = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuStreamAddCallback"));
        public static final long StreamQuery = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuStreamQuery"));
        public static final long StreamSynchronize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuStreamSynchronize"));
        public static final long EventCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuEventCreate");
        public static final long EventRecord = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuEventRecord"));
        public static final long EventQuery = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuEventQuery");
        public static final long EventSynchronize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuEventSynchronize");
        public static final long EventElapsedTime = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuEventElapsedTime");
        public static final long FuncGetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuFuncGetAttribute");
        public static final long FuncSetCacheConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuFuncSetCacheConfig");
        public static final long FuncSetBlockShape = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuFuncSetBlockShape");
        public static final long FuncSetSharedSize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuFuncSetSharedSize");
        public static final long ParamSetSize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuParamSetSize");
        public static final long ParamSeti = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuParamSeti");
        public static final long ParamSetf = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuParamSetf");
        public static final long ParamSetv = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuParamSetv");
        public static final long Launch = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuLaunch");
        public static final long LaunchGrid = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuLaunchGrid");
        public static final long LaunchGridAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuLaunchGridAsync");
        public static final long ParamSetTexRef = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuParamSetTexRef");
        public static final long TexRefSetArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetArray");
        public static final long TexRefSetMipmappedArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetMipmappedArray");
        public static final long TexRefSetAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuTexRefSetAddress", 2));
        public static final long TexRefSetAddress2D = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuTexRefSetAddress2D", 3));
        public static final long TexRefSetFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetFormat");
        public static final long TexRefSetAddressMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetAddressMode");
        public static final long TexRefSetFilterMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetFilterMode");
        public static final long TexRefSetMipmapFilterMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetMipmapFilterMode");
        public static final long TexRefSetMipmapLevelBias = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetMipmapLevelBias");
        public static final long TexRefSetMipmapLevelClamp = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetMipmapLevelClamp");
        public static final long TexRefSetMaxAnisotropy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetMaxAnisotropy");
        public static final long TexRefSetBorderColor = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetBorderColor");
        public static final long TexRefSetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefSetFlags");
        public static final long TexRefGetAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuTexRefGetAddress", 2));
        public static final long TexRefGetArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetArray");
        public static final long TexRefGetMipmappedArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetMipmappedArray");
        public static final long TexRefGetAddressMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetAddressMode");
        public static final long TexRefGetFilterMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetFilterMode");
        public static final long TexRefGetFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetFormat");
        public static final long TexRefGetMipmapFilterMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetMipmapFilterMode");
        public static final long TexRefGetMipmapLevelBias = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetMipmapLevelBias");
        public static final long TexRefGetMipmapLevelClamp = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetMipmapLevelClamp");
        public static final long TexRefGetMaxAnisotropy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetMaxAnisotropy");
        public static final long TexRefGetBorderColor = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetBorderColor");
        public static final long TexRefGetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefGetFlags");
        public static final long TexRefCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefCreate");
        public static final long TexRefDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuTexRefDestroy");
        public static final long SurfRefSetArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuSurfRefSetArray");
        public static final long SurfRefGetArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuSurfRefGetArray");
        public static final long GraphicsUnregisterResource = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuGraphicsUnregisterResource");
        public static final long GraphicsSubResourceGetMappedArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuGraphicsSubResourceGetMappedArray");
        public static final long GraphicsResourceGetMappedPointer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuGraphicsResourceGetMappedPointer", 2));
        public static final long GraphicsResourceSetMapFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_VERSION("cuGraphicsResourceSetMapFlags", 2));
        public static final long GraphicsMapResources = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuGraphicsMapResources"));
        public static final long GraphicsUnmapResources = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)CUDA.__CUDA_API_PTSZ("cuGraphicsUnmapResources"));
        public static final long GetExportTable = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.access$000(), (String)"cuGetExportTable");

        private Functions() {
        }
    }
}

