/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractConnector;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;

public class ChopRectangleConnector
extends AbstractConnector {
    public ChopRectangleConnector() {
    }

    public ChopRectangleConnector(Figure figure) {
        super(figure);
    }

    @Override
    public Point2D.Double findStart(ConnectionFigure connectionFigure) {
        Point2D.Double double_;
        Figure figure = connectionFigure.getStartConnector().getOwner();
        if (connectionFigure.getNodeCount() <= 2 || connectionFigure.getLiner() != null) {
            if (connectionFigure.getEndConnector() == null) {
                double_ = connectionFigure.getEndPoint();
            } else {
                Rectangle2D.Double double_2 = this.getConnectorTarget(connectionFigure.getEndConnector().getOwner()).getBounds();
                double_ = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y + double_2.height / 2.0);
            }
        } else {
            double_ = connectionFigure.getPoint(1);
        }
        return this.chop(figure, double_);
    }

    @Override
    public Point2D.Double findEnd(ConnectionFigure connectionFigure) {
        Point2D.Double double_;
        Figure figure = connectionFigure.getEndConnector().getOwner();
        if (connectionFigure.getNodeCount() <= 3 && connectionFigure.getStartFigure() == connectionFigure.getEndFigure() || connectionFigure.getNodeCount() <= 2 || connectionFigure.getLiner() != null) {
            if (connectionFigure.getStartConnector() == null) {
                double_ = connectionFigure.getStartPoint();
            } else if (connectionFigure.getStartFigure() == connectionFigure.getEndFigure()) {
                Rectangle2D.Double double_2 = this.getConnectorTarget(connectionFigure.getStartConnector().getOwner()).getBounds();
                double_ = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y);
            } else {
                Rectangle2D.Double double_3 = this.getConnectorTarget(connectionFigure.getStartConnector().getOwner()).getBounds();
                double_ = new Point2D.Double(double_3.x + double_3.width / 2.0, double_3.y + double_3.height / 2.0);
            }
        } else {
            double_ = connectionFigure.getPoint(connectionFigure.getNodeCount() - 2);
        }
        return this.chop(figure, double_);
    }

    protected Point2D.Double chop(Figure figure, Point2D.Double double_) {
        figure = this.getConnectorTarget(figure);
        Rectangle2D.Double double_2 = figure.getBounds();
        if (figure.get(AttributeKeys.STROKE_COLOR) != null) {
            double d;
            switch (figure.get(AttributeKeys.STROKE_PLACEMENT)) {
                default: {
                    d = AttributeKeys.getStrokeTotalWidth(figure) / 2.0;
                    break;
                }
                case OUTSIDE: {
                    d = AttributeKeys.getStrokeTotalWidth(figure);
                    break;
                }
                case INSIDE: {
                    d = 0.0;
                }
            }
            Geom.grow(double_2, d, d);
        }
        return Geom.angleToPoint(double_2, Geom.pointToAngle(double_2, double_));
    }
}

