/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BoundedRangeInputStream
extends FilterInputStream
implements BoundedRangeModel {
    private int nread_ = 0;
    private int size_ = 0;
    private boolean valueIsAdjusting_;
    protected transient ChangeEvent changeEvent_ = null;
    protected EventListenerList listenerList_ = new EventListenerList();

    public BoundedRangeInputStream(InputStream inputStream) {
        super(inputStream);
        try {
            this.size_ = inputStream.available();
        }
        catch (IOException iOException) {
            this.size_ = 0;
        }
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            this.incrementValue(1);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        this.incrementValue(n);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.incrementValue(n3);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.incrementValue((int)l2);
        return l2;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread_ = this.size_ - this.in.available();
        this.fireStateChanged();
    }

    private void incrementValue(int n) {
        if (n > 0) {
            this.nread_ += n;
            if (this.nread_ > this.size_) {
                this.size_ = this.nread_;
            }
            this.fireStateChanged();
        }
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public int getMaximum() {
        return this.size_;
    }

    @Override
    public void setMaximum(int n) {
        this.size_ = n;
        this.fireStateChanged();
    }

    @Override
    public int getValue() {
        return this.nread_;
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.valueIsAdjusting_ = bl;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting_;
    }

    @Override
    public int getExtent() {
        return 0;
    }

    @Override
    public void setExtent(int n) {
    }

    @Override
    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList_.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList_.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList_.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent_ == null) {
                this.changeEvent_ = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent_);
        }
    }
}

