/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import org.jfree.layouting.input.style.StyleSheet;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StyleSheetReadHandler
extends StringReadHandler {
    private StyleSheet styleSheet;

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        String string = attributes.getValue(this.getUri(), "href");
        if (string != null) {
            ResourceKey resourceKey = this.getRootHandler().getSource();
            ResourceManager resourceManager = this.getRootHandler().getResourceManager();
            try {
                ResourceKey resourceKey2 = resourceManager.deriveKey(resourceKey, string);
                Resource resource = resourceManager.create(resourceKey2, null, StyleSheet.class);
                this.getRootHandler().getDependencyCollector().add(resource);
                this.styleSheet = (StyleSheet)resource.getResource();
            }
            catch (ResourceKeyCreationException resourceKeyCreationException) {
                throw new ParseException("Unable to derive key for " + resourceKey + " and " + string, this.getLocator());
            }
            catch (ResourceCreationException resourceCreationException) {
                DebugLog.log((Object)("Unable to parse resource for " + resourceKey + " and " + string));
            }
            catch (ResourceLoadingException resourceLoadingException) {
                DebugLog.log((Object)("Unable to load resource data for " + resourceKey + " and " + string));
            }
            catch (ResourceException resourceException) {
                DebugLog.log((Object)("Unable to load resource for " + resourceKey + " and " + string));
            }
        }
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        if (this.styleSheet != null) {
            return;
        }
        String string = this.getResult();
        if (string.trim().length() == 0) {
            return;
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ResourceKey resourceKey = this.getRootHandler().getSource();
            ResourceManager resourceManager = this.getRootHandler().getResourceManager();
            ResourceKey resourceKey2 = resourceManager.createKey((Object)byArray);
            Resource resource = resourceManager.create(resourceKey2, resourceKey, StyleSheet.class);
            this.styleSheet = (StyleSheet)resource.getResource();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object getObject() {
        return this.styleSheet;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }
}

