/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import jakarta.servlet.SessionCookieConfig;
import org.apache.catalina.Context;

public class SessionConfig {
    private static final String DEFAULT_SESSION_COOKIE_NAME = "JSESSIONID";
    private static final String DEFAULT_SESSION_PARAMETER_NAME = "jsessionid";

    public static String getSessionCookieName(Context context) {
        String result = SessionConfig.getConfiguredSessionCookieName(context);
        if (result == null) {
            result = DEFAULT_SESSION_COOKIE_NAME;
        }
        return result;
    }

    public static String getSessionUriParamName(Context context) {
        String result = SessionConfig.getConfiguredSessionCookieName(context);
        if (result == null) {
            result = DEFAULT_SESSION_PARAMETER_NAME;
        }
        return result;
    }

    private static String getConfiguredSessionCookieName(Context context) {
        if (context != null) {
            String cookieName = context.getSessionCookieName();
            if (cookieName != null && cookieName.length() > 0) {
                return cookieName;
            }
            SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
            cookieName = scc.getName();
            if (cookieName != null && cookieName.length() > 0) {
                return cookieName;
            }
        }
        return null;
    }

    public static String getSessionCookiePath(Context context) {
        SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
        Object contextPath = context.getSessionCookiePath();
        if (contextPath == null || ((String)contextPath).length() == 0) {
            contextPath = scc.getPath();
        }
        if (contextPath == null || ((String)contextPath).length() == 0) {
            contextPath = context.getEncodedPath();
        }
        if (context.getSessionCookiePathUsesTrailingSlash()) {
            if (!((String)contextPath).endsWith("/")) {
                contextPath = (String)contextPath + "/";
            }
        } else if (((String)contextPath).length() == 0) {
            contextPath = "/";
        }
        return contextPath;
    }

    private SessionConfig() {
    }
}

