/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import java.sql.ResultSet;
import java.sql.SQLException;

public class GenericTypeDescriptor {
    protected String name;
    protected int dataType;
    protected long precision;
    protected String literalPrefix;
    protected String literalSuffix;
    protected int nullable;
    protected boolean hasPrecision;
    protected boolean hasScale;

    public GenericTypeDescriptor(ResultSet rs) throws SQLException {
        this.name = rs.getString(1);
        this.dataType = rs.getInt(2);
        this.precision = rs.getLong(3);
        this.literalPrefix = rs.getString(4);
        this.literalSuffix = rs.getString(5);
        this.nullable = rs.getInt(7);
        this.determineScaleAndPrecision();
    }

    public GenericTypeDescriptor(String name, int dataType, long precision, String literalPrefix, String literalSuffix, int nullable, boolean hasPrecision, boolean hasScale) {
        this.name = name;
        this.dataType = dataType;
        this.precision = precision;
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        this.nullable = nullable;
        this.hasPrecision = hasPrecision;
        this.hasScale = hasScale;
    }

    public void determineScaleAndPrecision() {
        switch (this.dataType) {
            default: {
                this.hasScale = false;
                this.hasPrecision = false;
                break;
            }
            case -15: 
            case -9: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 2004: 
            case 2005: {
                this.hasPrecision = true;
                this.hasScale = false;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.hasPrecision = true;
                this.hasScale = true;
            }
        }
    }

    public String toString() {
        return this.getName() + " (type=" + this.getDataType() + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int argDataType) {
        this.dataType = argDataType;
    }

    public long getPrecision() {
        return this.precision;
    }

    public void setPrecision(long argPrecision) {
        this.precision = argPrecision;
    }

    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    public void setLiteralPrefix(String argLiteralPrefix) {
        this.literalPrefix = argLiteralPrefix;
    }

    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    public void setLiteralSuffix(String argLiteralSuffix) {
        this.literalSuffix = argLiteralSuffix;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setNullable(int argNullable) {
        this.nullable = argNullable;
    }

    public boolean isNullable() {
        return this.nullable == 1;
    }

    public boolean getHasScale() {
        return this.hasScale;
    }

    public void setHasScale(boolean argHasScale) {
        this.hasScale = argHasScale;
    }

    public boolean getHasPrecision() {
        return this.hasPrecision;
    }

    public void setHasPrecision(boolean argHasPrecision) {
        this.hasPrecision = argHasPrecision;
    }
}

