/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl.kettle;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.DepthFirstSearch;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.etl.kettle.KettleRepositoryDirectoryChooser;
import ca.sqlpower.architect.etl.kettle.KettleSettings;
import ca.sqlpower.architect.etl.kettle.KettleUtils;
import ca.sqlpower.architect.etl.kettle.RootRepositoryDirectoryChooser;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.util.MonitorableImpl;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

public class KettleJob
implements Monitorable {
    private static final Logger logger = Logger.getLogger(KettleJob.class);
    private static int spacing = 150;
    private List<String> tasksToDo;
    private MonitorableImpl monitor;
    private KettleRepositoryDirectoryChooser dirChooser;
    private final ArchitectSession session;
    private final KettleSettings settings;

    public KettleJob(ArchitectSession session, KettleRepositoryDirectoryChooser chooser) {
        this(session);
        this.dirChooser = chooser;
    }

    public KettleJob(ArchitectSession session) {
        this.session = session;
        if (session.getWorkspace() != null && session.getWorkspace().allowsChildType(KettleSettings.class) && !session.getWorkspace().getChildren(KettleSettings.class).isEmpty()) {
            KettleSettings newSettings = (KettleSettings)((Object)session.getWorkspace().getChildren(KettleSettings.class).get(0));
            if (newSettings == null) {
                throw new IllegalStateException("The workspace should not have null settings if it reports to have them.");
            }
            this.settings = newSettings;
        } else {
            this.settings = new KettleSettings();
        }
        this.tasksToDo = new ArrayList<String>();
        this.monitor = new MonitorableImpl();
        this.dirChooser = new RootRepositoryDirectoryChooser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport(List<SQLTable> tableList, SQLDatabase targetDB) throws SQLObjectException, RuntimeException, IOException, KettleException, SQLException {
        this.monitor = new MonitorableImpl();
        this.monitor.setMessage("");
        this.monitor.setJobSize(new Integer(tableList.size() + 1));
        this.monitor.setStarted(true);
        try {
            EnvUtil.environmentInit();
            LogWriter lw = LogWriter.getInstance();
            JobMeta jm = new JobMeta(lw);
            ArrayList<TransMeta> transformations = new ArrayList<TransMeta>();
            ArrayList<String> noTransTables = new ArrayList<String>();
            this.tasksToDo = new ArrayList<String>();
            tableList = new DepthFirstSearch(tableList).getFinishOrder();
            LinkedHashMap<String, DatabaseMeta> databaseNames = new LinkedHashMap<String, DatabaseMeta>();
            for (SQLTable table : tableList) {
                TransMeta transMeta = new TransMeta();
                transMeta.setName(table.getName());
                LinkedHashMap<SQLTable, StringBuffer> tableMapping = new LinkedHashMap<SQLTable, StringBuffer>();
                JDBCDataSource target = targetDB.getDataSource();
                DatabaseMeta targetDatabaseMeta = this.addDatabaseConnection(databaseNames, target);
                transMeta.addDatabase(targetDatabaseMeta);
                List columnList = table.getColumns();
                ArrayList<String> noMappingForColumn = new ArrayList<String>();
                ArrayList<StepMeta> inputSteps = new ArrayList<StepMeta>();
                for (SQLColumn column : columnList) {
                    String sourceColumn;
                    SQLTable sourceTable;
                    if (column.getSourceColumn() == null) {
                        sourceTable = table;
                        sourceColumn = "null";
                        noMappingForColumn.add(column.getName());
                    } else {
                        sourceTable = column.getSourceColumn().getParent();
                        sourceColumn = column.getSourceColumn().getName();
                    }
                    if (!tableMapping.containsKey(sourceTable)) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT ");
                        buffer.append(sourceColumn);
                        buffer.append(" AS ").append(column.getName());
                        tableMapping.put(sourceTable, buffer);
                        continue;
                    }
                    ((StringBuffer)tableMapping.get(sourceTable)).append(", ").append(sourceColumn).append(" AS ").append(column.getName());
                }
                if (tableMapping.containsKey(table)) {
                    if (tableMapping.size() == 1) {
                        noTransTables.add(table.getName());
                        this.tasksToDo.add("Update table " + table.getName() + " as no source data was found");
                        continue;
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("There is no source for the column(s): ");
                    for (String noMapForCol : noMappingForColumn) {
                        buffer.append(noMapForCol).append(" ");
                    }
                    this.tasksToDo.add(buffer.toString() + " for the table " + table.getName());
                    transMeta.addNote(new NotePadMeta(buffer.toString(), 0, 150, 125, 125));
                }
                for (SQLTable sourceTable : tableMapping.keySet()) {
                    StringBuffer buffer = (StringBuffer)tableMapping.get(sourceTable);
                    buffer.append(" FROM " + DDLUtils.toQualifiedName(sourceTable));
                }
                for (SQLTable sourceTable : tableMapping.keySet()) {
                    JDBCDataSource source = sourceTable.getParentDatabase().getDataSource();
                    DatabaseMeta databaseMeta = this.addDatabaseConnection(databaseNames, source);
                    transMeta.addDatabase(databaseMeta);
                    TableInputMeta tableInputMeta = new TableInputMeta();
                    String stepName = databaseMeta.getName() + ":" + DDLUtils.toQualifiedName(sourceTable);
                    StepMeta stepMeta = new StepMeta("TableInput", stepName, (StepMetaInterface)tableInputMeta);
                    stepMeta.setDraw(true);
                    stepMeta.setLocation(inputSteps.size() == 0 ? spacing : inputSteps.size() * spacing, (inputSteps.size() + 1) * spacing);
                    tableInputMeta.setDatabaseMeta(databaseMeta);
                    tableInputMeta.setSQL(((StringBuffer)tableMapping.get(sourceTable)).toString());
                    transMeta.addStep(stepMeta);
                    inputSteps.add(stepMeta);
                }
                List<StepMeta> mergeSteps = this.createMergeJoins(this.settings.getJoinType(), transMeta, inputSteps);
                TableOutputMeta tableOutputMeta = new TableOutputMeta();
                tableOutputMeta.setDatabaseMeta(targetDatabaseMeta);
                tableOutputMeta.setTablename(table.getName());
                tableOutputMeta.setSchemaName(this.settings.getSchemaName());
                StepMeta stepMeta = new StepMeta("TableOutput", "Output to " + table.getName(), (StepMetaInterface)tableOutputMeta);
                stepMeta.setDraw(true);
                stepMeta.setLocation((inputSteps.size() + 1) * spacing, inputSteps.size() * spacing);
                transMeta.addStep(stepMeta);
                TransHopMeta transHopMeta = new TransHopMeta(mergeSteps.isEmpty() ? (StepMeta)inputSteps.get(0) : mergeSteps.get(mergeSteps.size() - 1), stepMeta);
                if (!mergeSteps.isEmpty()) {
                    transMeta.addNote(new NotePadMeta("The final hop is disabled because the join types may need to be updated.", 0, 0, 125, 125));
                    this.tasksToDo.add("Enable the final hop in " + transMeta.getName() + " after correcting the merge joins.");
                    transHopMeta.setEnabled(false);
                }
                transMeta.addTransHop(transHopMeta);
                transformations.add(transMeta);
                if (!this.monitor.isCancelled()) continue;
                this.cancel();
                return;
            }
            if (!noTransTables.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Transformations were not created for ");
                for (String tableName : noTransTables) {
                    buffer.append(tableName).append(" ");
                }
                buffer.append(" as the tables had no source information.");
                jm.addNote(new NotePadMeta(buffer.toString(), 0, 0, 125, 125));
            }
            JobEntryCopy startEntry = new JobEntryCopy();
            JobEntrySpecial start = new JobEntrySpecial("Start", true, false);
            startEntry.setEntry((JobEntryInterface)start);
            startEntry.setLocation(10, spacing);
            startEntry.setDrawn();
            jm.addJobEntry(startEntry);
            JobEntryCopy oldJobEntry = null;
            int i = 1;
            for (TransMeta transformation : transformations) {
                JobHopMeta hop;
                JobEntryCopy entry = new JobEntryCopy();
                JobEntryTrans trans = new JobEntryTrans(transformation.getName());
                trans.setTransname(transformation.getName());
                entry.setEntry((JobEntryInterface)trans);
                entry.setLocation(i * spacing, spacing);
                entry.setDrawn();
                jm.addJobEntry(entry);
                if (oldJobEntry != null) {
                    hop = new JobHopMeta(oldJobEntry, entry);
                    jm.addJobHop(hop);
                } else {
                    hop = new JobHopMeta(startEntry, entry);
                    jm.addJobHop(hop);
                }
                oldJobEntry = entry;
                ++i;
            }
            if (this.monitor.isCancelled()) {
                this.cancel();
                return;
            }
            jm.setName(this.settings.getJobName());
            if (this.settings.isSavingToFile()) {
                this.outputToXML(transformations, jm);
            } else {
                jm.setDirectory(new RepositoryDirectory());
                this.outputToRepository(jm, transformations, this.createRepository());
            }
        }
        finally {
            this.monitor.setFinished(true);
        }
    }

    private void cancel() {
        this.tasksToDo.clear();
        this.tasksToDo.add("The Kettle job was cancelled so some files may be missing.");
    }

    DatabaseMeta addDatabaseConnection(Map<String, DatabaseMeta> databaseNames, JDBCDataSource dataSource) throws RuntimeException {
        DatabaseMeta databaseMeta;
        if (!databaseNames.containsKey(dataSource.getName())) {
            try {
                databaseMeta = KettleUtils.createDatabaseMeta(dataSource);
                try {
                    Connection conn = dataSource.createConnection();
                    conn.close();
                }
                catch (SQLException e) {
                    logger.info((Object)("Could not connect to the database " + dataSource.getName() + "."));
                    this.tasksToDo.add("Check that the database " + dataSource.getName() + " can be connected to.");
                }
            }
            catch (RuntimeException re) {
                String databaseName = dataSource.getName();
                logger.error((Object)("Could not create the database connection for " + databaseName + "."));
                re.printStackTrace();
                this.tasksToDo.clear();
                this.tasksToDo.add("The Kettle job was not created as the database connection for " + databaseName + " could not be created.");
                throw re;
            }
            databaseNames.put(dataSource.getName(), databaseMeta);
        } else {
            databaseMeta = databaseNames.get(dataSource.getName());
        }
        return databaseMeta;
    }

    void outputToXML(List<TransMeta> transformations, JobMeta job) throws IOException {
        LinkedHashMap<File, String> outputs = new LinkedHashMap<File, String>();
        for (TransMeta transMeta : transformations) {
            File file = new File(this.getTransFilePath(transMeta.getName()));
            transMeta.setFilename(file.getName());
            try {
                outputs.put(file, transMeta.getXML());
            }
            catch (KettleException e) {
                throw new RuntimeException(e);
            }
            if (!this.monitor.isCancelled()) continue;
            this.cancel();
            return;
        }
        for (int i = 1; i < job.nrJobEntries(); ++i) {
            JobEntryTrans trans = (JobEntryTrans)job.getJobEntry(i).getEntry();
            trans.setFileName(this.getTransFilePath(trans.getName()));
        }
        String fileName = this.settings.getFilePath();
        if (!fileName.toUpperCase().endsWith(".KJB")) {
            fileName = fileName + ".kjb";
        }
        job.setFilename(fileName);
        outputs.put(new File(fileName), job.getXML());
        UserPrompter up = this.session.createUserPrompter("The file {0} already exists. Overwrite?", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL, UserPrompter.UserPromptResponse.NOT_OK, false, new String[]{"Overwrite", "Don't Overwrite", "Cancel"});
        for (File f : outputs.keySet()) {
            try {
                logger.debug((Object)("The file to output is " + f.getPath()));
                if (f.exists()) {
                    UserPrompter.UserPromptResponse overwriteOption = up.promptUser(new Object[]{f.getAbsolutePath()});
                    if (overwriteOption == UserPrompter.UserPromptResponse.OK) {
                        f.delete();
                    } else {
                        if (overwriteOption == UserPrompter.UserPromptResponse.NOT_OK) continue;
                        if (overwriteOption == UserPrompter.UserPromptResponse.CANCEL) {
                            this.cancel();
                            return;
                        }
                        throw new IllegalStateException("Unknown response value from user prompt: " + overwriteOption);
                    }
                }
                f.createNewFile();
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8"));
                out.write((String)outputs.get(f));
                out.flush();
                out.close();
                this.monitor.setProgress(this.monitor.getProgress() + 1);
                if (!this.monitor.isCancelled()) continue;
                this.cancel();
                return;
            }
            catch (IOException er) {
                this.tasksToDo.clear();
                this.tasksToDo.add("File " + f.getName() + " was not created");
                throw er;
            }
        }
    }

    String getTransFilePath(String transName) {
        String parentPath = new File(this.settings.getFilePath()).getParentFile().getPath();
        logger.debug((Object)("Parent file path is " + parentPath));
        return new File(parentPath, "transformation_for_table_" + transName + ".ktr").getPath();
    }

    public void createStraightConnection(Repository repo) throws KettleException, SQLException {
        repo.getDatabase().setConnection(this.settings.getRepository().createConnection());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void outputToRepository(JobMeta jm, List<TransMeta> transformations, Repository repo) throws KettleException, SQLException {
        try {
            block21: {
                block22: {
                    block23: {
                        block20: {
                            this.createStraightConnection(repo);
                            try {
                                repo.refreshRepositoryDirectoryTree();
                                directory = this.dirChooser.selectDirectory(repo);
                                if (directory == null) {
                                    throw new KettleException("The directory of the repository was not available.");
                                }
                            }
                            catch (KettleException e) {
                                this.tasksToDo.clear();
                                this.tasksToDo.add("The directory of the repository was not available.");
                                throw e;
                            }
                            try {
                                up = this.session.createUserPrompter("{0} {1} already exists in the repository. Replace?", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL, UserPrompter.UserPromptResponse.NOT_OK, false, new String[]{"Replace", "Don't Replace", "Cancel"});
lbl16:
                                // 3 sources

                                for (TransMeta tm : transformations) {
                                    if (this.monitor.isCancelled()) {
                                        this.cancel();
                                        return;
                                    }
                                    break block20;
                                }
                                break block21;
                            }
                            catch (KettleException e) {
                                this.tasksToDo.clear();
                                this.tasksToDo.add("Kettle job " + jm.getName() + " failed to save to respitory due to a Kettle error.");
                                throw e;
                            }
                        }
                        tm.setDirectory(directory);
                        id = repo.getTransformationID(tm.getName(), directory.getID());
                        if (id < 0L) break block22;
                        KettleJob.logger.debug((Object)("We found a transformation with the same name, the id is " + id));
                        overwriteOption = up.promptUser(new Object[]{"Transformation", tm.getName()});
                        if (overwriteOption == UserPrompter.UserPromptResponse.OK) break block22;
                        if (overwriteOption != UserPrompter.UserPromptResponse.NOT_OK) break block23;
                        this.monitor.setProgress(this.monitor.getProgress() + 1);
                        ** GOTO lbl16
                    }
                    if (overwriteOption != UserPrompter.UserPromptResponse.CANCEL) throw new IllegalStateException("Unknown user prompt response: " + overwriteOption);
                    this.cancel();
                    break block21;
                }
                tm.saveRep(repo);
                this.monitor.setProgress(this.monitor.getProgress() + 1);
                KettleJob.logger.debug((Object)("Progress is " + this.monitor.getProgress() + " out of " + this.monitor.getJobSize()));
                ** GOTO lbl16
            }
            if (this.monitor.isCancelled()) {
                this.cancel();
                return;
            }
            for (i = 1; i < jm.nrJobEntries(); ++i) {
                trans = (JobEntryTrans)jm.getJobEntry(i).getEntry();
                trans.setDirectory(directory.getDirectoryName());
                trans.setDirectoryPath(directory.getPath());
            }
            jm.setDirectory(directory);
            if (repo.getTransformationID(jm.getName(), directory.getID()) < 0L || (overwriteOption = up.promptUser(new Object[]{"Job", jm.getName()})) == UserPrompter.UserPromptResponse.OK) ** GOTO lbl63
            if (overwriteOption == UserPrompter.UserPromptResponse.NOT_OK) {
                return;
            }
            if (overwriteOption != UserPrompter.UserPromptResponse.CANCEL) ** GOTO lbl-1000
            this.cancel();
            return;
lbl-1000:
            // 1 sources

            {
                throw new IllegalStateException("Unknown user prompt response: " + overwriteOption);
lbl63:
                // 1 sources

                jm.saveRep(repo);
                this.monitor.setProgress(this.monitor.getProgress() + 1);
                KettleJob.logger.debug((Object)("Progress is " + this.monitor.getProgress() + " out of " + this.monitor.getJobSize()));
                return;
            }
        }
        catch (SQLException e) {
            this.tasksToDo.clear();
            this.tasksToDo.add("Kettle job " + jm.getName() + " failed to save to respitory due to a SQL error.");
            throw e;
        }
        finally {
            repo.disconnect();
        }
    }

    Repository createRepository() {
        DatabaseMeta kettleDBMeta = KettleUtils.createDatabaseMeta(this.settings.getRepository());
        RepositoryMeta repoMeta = new RepositoryMeta("", "", kettleDBMeta);
        UserInfo userInfo = new UserInfo(this.settings.getRepository().get("ca.sqlpower.architect.etl.kettle.repos.login"), this.settings.getRepository().get("ca.sqlpower.architect.etl.kettle.repos.password"), this.settings.getJobName(), "", true, null);
        LogWriter lw = LogWriter.getInstance();
        Repository repo = new Repository(lw, repoMeta, userInfo);
        return repo;
    }

    public Object[] createTestRepository() {
        DatabaseMeta kettleDBMeta = KettleUtils.createDatabaseMeta(this.settings.getRepository());
        RepositoryMeta repoMeta = new RepositoryMeta("", "", kettleDBMeta);
        UserInfo userInfo = new UserInfo(this.settings.getRepository().get("ca.sqlpower.architect.etl.kettle.repos.login"), this.settings.getRepository().get("ca.sqlpower.architect.etl.kettle.repos.password"), this.settings.getJobName(), "", true, null);
        LogWriter lw = LogWriter.getInstance();
        Object[] ret = new Object[]{lw, repoMeta, userInfo};
        return ret;
    }

    List<StepMeta> createMergeJoins(int defaultJoinType, TransMeta transMeta, List<StepMeta> inputSteps) {
        ArrayList<StepMeta> mergeSteps = new ArrayList<StepMeta>();
        if (inputSteps.size() > 1) {
            MergeJoinMeta mergeJoinMeta = new MergeJoinMeta();
            mergeJoinMeta.setJoinType(MergeJoinMeta.join_types[defaultJoinType]);
            mergeJoinMeta.setStepName1(inputSteps.get(0).getName());
            mergeJoinMeta.setStepMeta1(inputSteps.get(0));
            mergeJoinMeta.setStepName2(inputSteps.get(1).getName());
            mergeJoinMeta.setStepMeta2(inputSteps.get(1));
            mergeJoinMeta.setKeyFields1(new String[0]);
            mergeJoinMeta.setKeyFields2(new String[0]);
            StepMeta stepMeta = new StepMeta("MergeJoin", "Join tables " + inputSteps.get(0).getName() + " and " + inputSteps.get(1).getName(), (StepMetaInterface)mergeJoinMeta);
            stepMeta.setDraw(true);
            stepMeta.setLocation(2 * spacing, new Double(1.5 * (double)spacing).intValue());
            transMeta.addStep(stepMeta);
            mergeSteps.add(stepMeta);
            TransHopMeta transHopMeta = new TransHopMeta(inputSteps.get(0), stepMeta);
            transMeta.addTransHop(transHopMeta);
            transHopMeta = new TransHopMeta(inputSteps.get(1), stepMeta);
            transMeta.addTransHop(transHopMeta);
            this.tasksToDo.add("Verify the merge join " + stepMeta.getName() + " does the correct merge.");
        }
        for (int i = 0; i < inputSteps.size() - 2; ++i) {
            MergeJoinMeta mergeJoinMeta = new MergeJoinMeta();
            mergeJoinMeta.setJoinType(MergeJoinMeta.join_types[defaultJoinType]);
            mergeJoinMeta.setStepName1(((StepMeta)mergeSteps.get(i)).getName());
            mergeJoinMeta.setStepMeta1((StepMeta)mergeSteps.get(i));
            mergeJoinMeta.setStepName2(inputSteps.get(i + 2).getName());
            mergeJoinMeta.setStepMeta2(inputSteps.get(i + 2));
            mergeJoinMeta.setKeyFields1(new String[0]);
            mergeJoinMeta.setKeyFields2(new String[0]);
            StepMeta stepMeta = new StepMeta("MergeJoin", "Join table " + inputSteps.get(i + 2).getName(), (StepMetaInterface)mergeJoinMeta);
            stepMeta.setDraw(true);
            stepMeta.setLocation((i + 3) * spacing, new Double(((double)i + 2.25) * (double)spacing).intValue());
            transMeta.addStep(stepMeta);
            mergeSteps.add(stepMeta);
            TransHopMeta transHopMeta = new TransHopMeta((StepMeta)mergeSteps.get(i), stepMeta);
            transMeta.addTransHop(transHopMeta);
            transHopMeta = new TransHopMeta(inputSteps.get(i + 2), stepMeta);
            transMeta.addTransHop(transHopMeta);
            this.tasksToDo.add("Verify the merge join " + stepMeta.getName() + " does the correct merge.");
        }
        return mergeSteps;
    }

    public String getFilePath() {
        return this.settings.getFilePath();
    }

    public void setFilePath(String filePath) {
        this.settings.setFilePath(filePath);
    }

    public String getJobName() {
        return this.settings.getJobName();
    }

    public void setJobName(String jobName) {
        this.settings.setJobName(jobName);
    }

    public int getKettleJoinType() {
        return this.settings.getJoinType();
    }

    public void setKettleJoinType(int kettleJoinType) {
        this.settings.setJoinType(kettleJoinType);
    }

    public String getSchemaName() {
        return this.settings.getSchemaName();
    }

    public void setSchemaName(String schemaName) {
        this.settings.setSchemaName(schemaName);
    }

    public List<String> getTasksToDo() {
        return this.tasksToDo;
    }

    public Integer getJobSize() {
        return this.monitor.getJobSize();
    }

    public String getMessage() {
        return this.monitor.getMessage();
    }

    public int getProgress() {
        return this.monitor.getProgress();
    }

    public boolean hasStarted() {
        return this.monitor.hasStarted();
    }

    public boolean isFinished() {
        return this.monitor.isFinished();
    }

    public void setCancelled(boolean cancelled) {
        this.monitor.setCancelled(cancelled);
    }

    public boolean isCancelled() {
        return this.monitor.isCancelled();
    }

    public boolean isSavingToFile() {
        return this.settings.isSavingToFile();
    }

    public void setSavingToFile(boolean savingToFile) {
        this.settings.setSavingToFile(savingToFile);
    }

    public void setRepository(JDBCDataSource source) {
        this.settings.setRepository(source);
    }

    public void setRepositoryDirectoryChooser(KettleRepositoryDirectoryChooser chooser) {
        this.dirChooser = chooser;
    }

    public SPDataSource getRepository() {
        return this.settings.getRepository();
    }
}

