/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.SQLTypeTreeCellRenderer;
import ca.sqlpower.architect.swingui.SQLTypeTreeModel;
import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelChangeUtil;
import ca.sqlpower.swingui.PopupJTreeAction;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ColumnEditPanel
extends ChangeListeningDataEntryPanel
implements ActionListener,
SPListener {
    private static final Logger logger = Logger.getLogger(ColumnEditPanel.class);
    private static final Font TITLE_FONT = UIManager.getFont("Label.font").deriveFont(1, 10.0f);
    private final List<SQLColumn> columns;
    private final JPanel panel;
    private final Map<JComponent, JCheckBox> componentEnabledMap = new HashMap<JComponent, JCheckBox>();
    private final Map<JComponent, JCheckBox> typeOverrideMap = new HashMap<JComponent, JCheckBox>();
    private final JButton colSourceButton;
    private final JTree colSourceTree;
    private final TreeNode sourceNotSpecifiedTreeNode = new DefaultMutableTreeNode(Messages.getString("ColumnEditPanel.noneSpecified"), false);
    private final JTextField colLogicalName;
    private final JTextField colPhysicalName;
    private final JButton typeChooserButton;
    private final JTree colType;
    private final JSpinner colScale;
    private final JSpinner colPrec;
    private final JComboBox colNullable;
    private final JTextArea colRemarks;
    private final JTextField colDefaultValue;
    private final JCheckBox colInPK;
    private final JComboBox colAutoInc;
    private final JCheckBox colPrecCB;
    private final JCheckBox colScaleCB;
    private final JTextField colAutoIncSequenceName;
    private String seqNamePrefix;
    private String seqNameSuffix;
    private final ArchitectSwingSession session;
    private final CheckboxEnabler checkboxEnabler = new CheckboxEnabler();
    private final SPListener obsolesenceListener = new AbstractPoolingSPListener(){

        public void childAddedImpl(SPChildEvent e) {
            logger.debug((Object)("SQLObject children got inserted: " + e));
        }

        public void childRemovedImpl(SPChildEvent e) {
            logger.debug((Object)("SQLObject children got removed: " + e));
            for (SQLColumn column : ColumnEditPanel.this.columns) {
                Window parentWindow;
                if (!e.getChild().equals(column) && !e.getChild().equals(column.getParent()) || (parentWindow = SwingUtilities.getWindowAncestor(ColumnEditPanel.this.panel)) == null) continue;
                parentWindow.dispose();
            }
        }
    };
    private final AncestorListener cleanupListener = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            SQLPowerUtils.unlistenToHierarchy((SPObject)ColumnEditPanel.this.session.getRootObject(), (SPListener)ColumnEditPanel.this.obsolesenceListener);
        }
    };

    public ColumnEditPanel(SQLColumn col, ArchitectSwingSession session) throws SQLObjectException {
        this(Collections.singleton(col), session);
    }

    public ColumnEditPanel(Collection<SQLColumn> cols, ArchitectSwingSession session) throws SQLObjectException {
        logger.debug((Object)"ColumnEditPanel called");
        if (session == null) {
            throw new NullPointerException("Null session is not allowed");
        }
        this.session = session;
        if (cols == null || cols.isEmpty()) {
            throw new NullPointerException("Null or empty collection of columns is not allowed");
        }
        this.columns = new ArrayList<SQLColumn>(cols);
        FormLayout layout = new FormLayout("pref, pref, pref:grow, 4dlu, pref, pref:grow", "");
        layout.setColumnGroups((int[][])new int[][]{{3, 6}});
        this.panel = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        int width = 5;
        layout.appendRow(RowSpec.decode((String)"p"));
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.source")), cc.xyw(2, row++, width));
        layout.appendRow(RowSpec.decode((String)"p"));
        JCheckBox cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row));
        }
        this.colSourceTree = new JTree();
        DBTreeModel sourceTreeModel = new DBTreeModel(session.getRootObject(), this.colSourceTree, false, true, false, false, false){

            @Override
            public Object getChild(Object parent, int index) {
                if (parent == ColumnEditPanel.this.sourceNotSpecifiedTreeNode) {
                    return null;
                }
                if (parent == this.getRoot()) {
                    if (index == 0) {
                        return ColumnEditPanel.this.sourceNotSpecifiedTreeNode;
                    }
                    return super.getChild(parent, index - 1);
                }
                return super.getChild(parent, index);
            }

            @Override
            public int getChildCount(Object parent) {
                if (parent == ColumnEditPanel.this.sourceNotSpecifiedTreeNode) {
                    return 0;
                }
                if (parent == this.getRoot()) {
                    return super.getChildCount(parent) + 1;
                }
                return super.getChildCount(parent);
            }

            @Override
            public int getIndexOfChild(Object parent, Object child) {
                if (parent == ColumnEditPanel.this.sourceNotSpecifiedTreeNode) {
                    return -1;
                }
                if (child == ColumnEditPanel.this.sourceNotSpecifiedTreeNode) {
                    return 0;
                }
                if (parent == this.getRoot()) {
                    int index = super.getIndexOfChild(parent, child);
                    if (index != -1) {
                        return index + 1;
                    }
                    return -1;
                }
                return super.getIndexOfChild(parent, child);
            }

            @Override
            public boolean isLeaf(Object parent) {
                if (parent == ColumnEditPanel.this.sourceNotSpecifiedTreeNode) {
                    return true;
                }
                return super.isLeaf(parent);
            }
        };
        this.colSourceTree.setModel(sourceTreeModel);
        this.colSourceTree.setRootVisible(false);
        this.colSourceTree.setShowsRootHandles(true);
        this.colSourceTree.setCellRenderer(new DBTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!sel && value == ColumnEditPanel.this.sourceNotSpecifiedTreeNode) {
                    this.setForeground(this.getTextNonSelectionColor());
                }
                return this;
            }
        });
        this.colSourceTree.getSelectionModel().setSelectionMode(1);
        this.colSourceButton = new JButton();
        this.colSourceButton.setAction((Action)new PopupJTreeAction(this.panel, this.colSourceTree, this.colSourceButton, SQLColumn.class));
        this.panel.add((Component)this.colSourceButton, cc.xyw(2, row++, 2));
        this.componentEnabledMap.put(this.colSourceTree, cb);
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n = ++row;
        ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.logicalName")), cc.xyw(2, n, width));
        layout.appendRow(RowSpec.decode((String)"p"));
        cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row));
        }
        this.colLogicalName = new JTextField();
        this.panel.add((Component)this.colLogicalName, cc.xyw(2, row++, width));
        this.componentEnabledMap.put(this.colLogicalName, cb);
        this.colLogicalName.getDocument().addDocumentListener(new DocumentCheckboxEnabler(cb));
        this.colLogicalName.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ColumnEditPanel.this.colLogicalName.requestFocusInWindow();
            }
        });
        this.colLogicalName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("focus Gained : " + e));
                }
                ColumnEditPanel.this.colLogicalName.selectAll();
            }
        });
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n2 = ++row;
        ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.physicalName")), cc.xyw(2, n2, width));
        layout.appendRow(RowSpec.decode((String)"p"));
        cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row));
        }
        this.colPhysicalName = new JTextField();
        this.panel.add((Component)this.colPhysicalName, cc.xyw(2, row++, width));
        this.componentEnabledMap.put(this.colPhysicalName, cb);
        this.colPhysicalName.getDocument().addDocumentListener(new DocumentCheckboxEnabler(cb));
        this.colPhysicalName.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ColumnEditPanel.this.colPhysicalName.requestFocusInWindow();
            }
        });
        this.colPhysicalName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("focus Gained : " + e));
                }
                ColumnEditPanel.this.colPhysicalName.selectAll();
            }
        });
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        ++row;
        layout.appendRow(RowSpec.decode((String)"p"));
        cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row));
        }
        this.colInPK = new JCheckBox(Messages.getString("ColumnEditPanel.inPrimaryKey"));
        this.panel.add((Component)this.colInPK, cc.xyw(2, row++, width));
        this.componentEnabledMap.put(this.colInPK, cb);
        this.colInPK.addActionListener(this);
        this.colInPK.addActionListener(this.checkboxEnabler);
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n3 = ++row;
        ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.type")), cc.xyw(2, n3, width));
        layout.appendRow(RowSpec.decode((String)"p"));
        cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row));
        }
        this.typeChooserButton = new JButton(Messages.getString("ColumnEditPanel.chooseType"));
        this.colType = session.isEnterpriseSession() ? new JTree(new SQLTypeTreeModel(session.getEnterpriseSession())) : new JTree(new SQLTypeTreeModel(session));
        this.colType.setCellRenderer(new SQLTypeTreeCellRenderer());
        for (int i = 0; i < this.colType.getRowCount(); ++i) {
            this.colType.expandRow(i);
        }
        this.colType.setRootVisible(true);
        this.colType.setShowsRootHandles(true);
        this.colType.getSelectionModel().setSelectionMode(1);
        this.typeChooserButton.setAction((Action)new PopupJTreeAction(this.panel, this.colType, this.typeChooserButton, UserDefinedSQLType.class));
        this.componentEnabledMap.put(this.colType, cb);
        this.panel.add((Component)this.typeChooserButton, cc.xyw(2, row++, 2));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.precision")), cc.xy(3, ++row));
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.scale")), cc.xy(6, row++));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colPrec = this.createPrecisionEditor();
        this.panel.add((Component)this.colPrec, cc.xy(3, row));
        this.colPrec.addChangeListener(this.checkboxEnabler);
        SPSUtils.makeJSpinnerSelectAllTextOnFocus((JSpinner)this.colPrec);
        this.colPrecCB = new JCheckBox();
        this.panel.add((Component)this.colPrecCB, cc.xy(2, row));
        this.typeOverrideMap.put(this.colPrec, this.colPrecCB);
        this.colPrecCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ColumnEditPanel.this.colPrecCB.isSelected()) {
                    ColumnEditPanel.this.colPrec.setEnabled(true);
                } else {
                    ColumnEditPanel.this.colPrec.setEnabled(false);
                    if (ColumnEditPanel.this.colType.getLastSelectedPathComponent() instanceof UserDefinedSQLType) {
                        ColumnEditPanel.this.colPrec.setValue(((UserDefinedSQLType)ColumnEditPanel.this.colType.getLastSelectedPathComponent()).getPrecision("GENERIC"));
                    }
                }
            }
        });
        this.colPrec.setEnabled(false);
        this.colScaleCB = new JCheckBox();
        this.panel.add((Component)this.colScaleCB, cc.xy(5, row));
        this.colScale = this.createScaleEditor();
        this.panel.add((Component)this.colScale, cc.xy(6, row++));
        this.typeOverrideMap.put(this.colScale, this.colScaleCB);
        this.colScale.addChangeListener(this.checkboxEnabler);
        SPSUtils.makeJSpinnerSelectAllTextOnFocus((JSpinner)this.colScale);
        this.colScaleCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ColumnEditPanel.this.colScaleCB.isSelected()) {
                    ColumnEditPanel.this.colScale.setEnabled(true);
                } else {
                    ColumnEditPanel.this.colScale.setEnabled(false);
                    if (ColumnEditPanel.this.colType.getLastSelectedPathComponent() instanceof UserDefinedSQLType) {
                        ColumnEditPanel.this.colScale.setValue(((UserDefinedSQLType)ColumnEditPanel.this.colType.getLastSelectedPathComponent()).getScale("GENERIC"));
                    }
                }
            }
        });
        this.colScale.setEnabled(false);
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n4 = ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.allowsNulls")), cc.xyw(3, n4, width - 1));
        layout.appendRow(RowSpec.decode((String)"p"));
        final JCheckBox colNullCB = new JCheckBox();
        this.panel.add((Component)colNullCB, cc.xy(2, ++row));
        this.colNullable = new JComboBox<YesNoEnum>(YesNoEnum.values());
        this.panel.add(this.colNullable, cc.xy(3, row++));
        this.typeOverrideMap.put(this.colNullable, colNullCB);
        this.colNullable.addActionListener(this);
        this.colNullable.addActionListener(this.checkboxEnabler);
        colNullCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (colNullCB.isSelected()) {
                    ColumnEditPanel.this.colNullable.setEnabled(true);
                } else {
                    ColumnEditPanel.this.colNullable.setEnabled(false);
                    if (ColumnEditPanel.this.colType.getLastSelectedPathComponent() instanceof UserDefinedSQLType) {
                        ColumnEditPanel.this.colNullable.setSelectedItem((Object)YesNoEnum.valueOf(((UserDefinedSQLType)ColumnEditPanel.this.colType.getLastSelectedPathComponent()).getNullability() == 1));
                    }
                }
                ColumnEditPanel.this.updateComponents();
            }
        });
        this.colNullable.setEnabled(false);
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n5 = ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.autoIncrement")), cc.xyw(3, n5, width - 1));
        layout.appendRow(RowSpec.decode((String)"p"));
        final JCheckBox colAutoIncCB = new JCheckBox();
        this.panel.add((Component)colAutoIncCB, cc.xy(2, ++row));
        this.colAutoInc = new JComboBox<YesNoEnum>(YesNoEnum.values());
        this.panel.add(this.colAutoInc, cc.xy(3, row++));
        this.typeOverrideMap.put(this.colAutoInc, colAutoIncCB);
        this.colAutoInc.addActionListener(this);
        this.colAutoInc.addActionListener(this.checkboxEnabler);
        colAutoIncCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (colAutoIncCB.isSelected()) {
                    ColumnEditPanel.this.colAutoInc.setEnabled(true);
                } else {
                    ColumnEditPanel.this.colAutoInc.setEnabled(false);
                    if (ColumnEditPanel.this.colType.getLastSelectedPathComponent() instanceof UserDefinedSQLType) {
                        ColumnEditPanel.this.colAutoInc.setSelectedItem((Object)YesNoEnum.valueOf(((UserDefinedSQLType)ColumnEditPanel.this.colType.getLastSelectedPathComponent()).getAutoIncrement()));
                    }
                }
            }
        });
        this.colAutoInc.setEnabled(false);
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n6 = ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.defaultValue")), cc.xyw(3, n6, width - 1));
        layout.appendRow(RowSpec.decode((String)"p"));
        final JCheckBox colDefaultCB = new JCheckBox();
        this.panel.add((Component)colDefaultCB, cc.xy(2, ++row));
        this.colDefaultValue = new JTextField();
        this.panel.add((Component)this.colDefaultValue, cc.xyw(3, row++, width - 1));
        this.colDefaultValue.setEnabled(false);
        this.typeOverrideMap.put(this.colDefaultValue, colDefaultCB);
        this.colDefaultValue.addActionListener(this);
        colDefaultCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (colDefaultCB.isSelected()) {
                    ColumnEditPanel.this.colDefaultValue.setEnabled(true);
                } else {
                    ColumnEditPanel.this.colDefaultValue.setEnabled(false);
                    if (ColumnEditPanel.this.colType.getLastSelectedPathComponent() instanceof UserDefinedSQLType) {
                        ColumnEditPanel.this.colDefaultValue.setText(((UserDefinedSQLType)ColumnEditPanel.this.colType.getLastSelectedPathComponent()).getDefaultValue("GENERIC"));
                    }
                }
                ColumnEditPanel.this.updateComponents();
            }
        });
        layout.appendRow(RowSpec.decode((String)"6dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n7 = ++row;
        ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.sequenceName")), cc.xyw(2, n7, width));
        layout.appendRow(RowSpec.decode((String)"p"));
        cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row));
        }
        this.colAutoIncSequenceName = new JTextField();
        this.panel.add((Component)this.colAutoIncSequenceName, cc.xyw(2, row++, width));
        this.componentEnabledMap.put(this.colAutoIncSequenceName, cb);
        this.colAutoIncSequenceName.getDocument().addDocumentListener(new DocumentCheckboxEnabler(cb));
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ColumnEditPanel.this.syncSequenceName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ColumnEditPanel.this.syncSequenceName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ColumnEditPanel.this.syncSequenceName();
            }
        };
        this.colPhysicalName.getDocument().addDocumentListener(listener);
        this.colLogicalName.getDocument().addDocumentListener(listener);
        this.colAutoIncSequenceName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (ColumnEditPanel.this.columns.size() == 1 && ColumnEditPanel.this.colAutoIncSequenceName.getText().trim().equals("")) {
                    SQLColumn column = (SQLColumn)ColumnEditPanel.this.columns.iterator().next();
                    if (column.getPhysicalName() != null && !column.getPhysicalName().trim().equals("")) {
                        ColumnEditPanel.this.discoverSequenceNamePattern(column.getPhysicalName());
                    } else {
                        ColumnEditPanel.this.discoverSequenceNamePattern(column.getName());
                    }
                    ColumnEditPanel.this.syncSequenceName();
                } else if (ColumnEditPanel.this.colPhysicalName.getText() != null && !ColumnEditPanel.this.colPhysicalName.getText().trim().equals("")) {
                    ColumnEditPanel.this.discoverSequenceNamePattern(ColumnEditPanel.this.colPhysicalName.getText());
                } else {
                    ColumnEditPanel.this.discoverSequenceNamePattern(ColumnEditPanel.this.colLogicalName.getText());
                }
            }
        });
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n8 = ++row;
        ++row;
        this.panel.add(this.makeTitle(Messages.getString("ColumnEditPanel.remarks")), cc.xyw(2, n8, width));
        layout.appendRow(RowSpec.decode((String)"pref:grow"));
        cb = new JCheckBox();
        if (cols.size() > 1) {
            this.panel.add((Component)cb, cc.xy(1, row, "center, top"));
        }
        this.colRemarks = new JTextArea();
        this.panel.add((Component)new JScrollPane(this.colRemarks), cc.xyw(2, row++, width, "fill, fill"));
        this.componentEnabledMap.put(this.colRemarks, cb);
        this.colRemarks.getDocument().addDocumentListener(new DocumentCheckboxEnabler(cb));
        this.colRemarks.setRows(5);
        this.colRemarks.setLineWrap(true);
        this.colRemarks.setWrapStyleWord(true);
        for (JCheckBox checkbox : this.componentEnabledMap.values()) {
            checkbox.setSelected(true);
        }
        if (cols.size() > 1) {
            Iterator<SQLColumn> colIterator = cols.iterator();
            SQLColumn firstCol = colIterator.next();
            while (colIterator.hasNext()) {
                SQLColumn nextCol = colIterator.next();
                if (firstCol.getTypeName().equals(nextCol.getTypeName()) && firstCol.getPrecision() == nextCol.getPrecision() && firstCol.getScale() == nextCol.getScale() && firstCol.getNullable() == nextCol.getNullable() && firstCol.isAutoIncrement() == nextCol.isAutoIncrement() && firstCol.getDefaultValue().equals(nextCol.getDefaultValue())) continue;
                this.componentEnabledMap.get(this.colType).setSelected(false);
                break;
            }
        }
        for (SQLColumn col : cols) {
            logger.debug((Object)("Updating component state for column " + col));
            this.updateComponents(col);
        }
        this.colPhysicalName.requestFocus();
        this.colPhysicalName.selectAll();
        SQLPowerUtils.listenToHierarchy((SPObject)session.getRootObject(), (SPListener)this.obsolesenceListener);
        SQLPowerUtils.listenToHierarchy((SPObject)session.getRootObject(), (SPListener)this);
        this.panel.addAncestorListener(this.cleanupListener);
        this.colSourceTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    Object selection = path.getLastPathComponent();
                    if (selection instanceof SQLColumn) {
                        SQLColumn sourceColumn = (SQLColumn)selection;
                        ColumnEditPanel.this.colSourceButton.setText(DDLUtils.toQualifiedName(sourceColumn.getParent()) + "." + sourceColumn.getName());
                    } else {
                        ColumnEditPanel.this.colSourceButton.setText(Messages.getString("ColumnEditPanel.noneSpecified"));
                    }
                } else {
                    ColumnEditPanel.this.colSourceButton.setText(Messages.getString("ColumnEditPanel.noneSpecified"));
                }
            }
        });
        this.colType.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    Object selection = path.getLastPathComponent();
                    if (selection instanceof UserDefinedSQLType) {
                        ColumnEditPanel.this.typeChooserButton.setText(((UserDefinedSQLType)selection).getName());
                        ColumnEditPanel.this.updateSQLTypeComponents((UserDefinedSQLType)selection, false);
                    } else {
                        ColumnEditPanel.this.typeChooserButton.setText(Messages.getString("ColumnEditPanel.chooseType"));
                    }
                } else {
                    ColumnEditPanel.this.typeChooserButton.setText(Messages.getString("ColumnEditPanel.chooseType"));
                }
            }
        });
    }

    private Component makeTitle(String string) {
        JLabel label = new JLabel(string);
        label.setFont(TITLE_FONT);
        return label;
    }

    private JSpinner createScaleEditor() {
        return new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    }

    private JSpinner createPrecisionEditor() {
        return this.createScaleEditor();
    }

    private void updateComponents(SQLColumn col) throws SQLObjectException {
        boolean inPk;
        SQLColumn sourceColumn = col.getSourceColumn();
        if (sourceColumn == null) {
            Object[] treePath = new Object[]{this.session.getRootObject(), this.sourceNotSpecifiedTreeNode};
            this.colSourceTree.setSelectionPath(new TreePath(treePath));
            this.colSourceButton.setText(Messages.getString("ColumnEditPanel.noneSpecified"));
        } else {
            this.updateComponent(this.colSourceTree, sourceColumn);
            DBTreeModel model = (DBTreeModel)this.colSourceTree.getModel();
            this.colSourceTree.setSelectionPath(new TreePath(model.getPathToNode((SPObject)sourceColumn)));
            this.colSourceButton.setText(DDLUtils.toQualifiedName(sourceColumn.getParent()) + "." + sourceColumn.getName());
        }
        this.updateComponent(this.colLogicalName, col.getName());
        this.updateComponent(this.colPhysicalName, col.getPhysicalName());
        this.updateComponent(this.colType, col.getUserDefinedSQLType().getUpstreamType());
        if (!this.colType.isSelectionEmpty()) {
            this.typeChooserButton.setText(col.getUserDefinedSQLType().getUpstreamType().getName());
        } else {
            this.colSourceButton.setText(Messages.getString("ColumnEditPanel.noneSpecified"));
        }
        this.updateSQLTypeComponents(col.getUserDefinedSQLType(), true);
        this.updateComponent(this.colRemarks, col.getRemarks());
        if (col.getParent() == null) {
            inPk = SQLColumn.isDefaultInPK();
            logger.debug((Object)"new constructed column");
        } else {
            inPk = col.isPrimaryKey();
            logger.debug((Object)"existing column");
        }
        this.updateComponent(this.colInPK, inPk);
        logger.debug((Object)("Selected" + this.colInPK.isSelected()));
        this.updateComponent(this.colAutoIncSequenceName, col.getAutoIncrementSequenceName());
        this.updateComponents();
        if (col.getPhysicalName() != null && !col.getPhysicalName().trim().equals("")) {
            this.discoverSequenceNamePattern(col.getPhysicalName());
        } else {
            this.discoverSequenceNamePattern(col.getName());
        }
    }

    private void updateComponent(JTree comp, Object expectedValue) {
        if (this.componentEnabledMap.get(comp).isSelected() && (comp.isSelectionEmpty() || comp.getLastSelectedPathComponent() == expectedValue)) {
            for (int i = 0; i < comp.getRowCount(); ++i) {
                Object lastPathComponent = comp.getPathForRow(i).getLastPathComponent();
                if (lastPathComponent != expectedValue) continue;
                comp.setSelectionRow(i);
            }
        } else {
            comp.clearSelection();
            this.componentEnabledMap.get(comp).setSelected(false);
        }
    }

    private void updateComponent(JTextComponent comp, String expectedValue) {
        boolean unvisited = comp.getText().equals("");
        if (this.componentEnabledMap.get(comp).isSelected() && (unvisited || comp.getText().equals(expectedValue))) {
            comp.setText(expectedValue);
        } else {
            comp.setText("");
            this.componentEnabledMap.get(comp).setSelected(false);
        }
    }

    private void updateComponent(JCheckBox comp, boolean expectedValue) {
        boolean unvisited;
        String multiEditVisitedProperty = "ColumnEditPanel.multiEditVisited";
        boolean bl = unvisited = comp.getClientProperty("ColumnEditPanel.multiEditVisited") == null;
        if (this.componentEnabledMap.get(comp).isSelected() && (unvisited || comp.isSelected() == expectedValue)) {
            comp.setSelected(expectedValue);
        } else {
            comp.setSelected(false);
            this.componentEnabledMap.get(comp).setSelected(false);
        }
        comp.putClientProperty("ColumnEditPanel.multiEditVisited", Boolean.TRUE);
    }

    private void discoverSequenceNamePattern(String colName) {
        String seqName = this.colAutoIncSequenceName.getText();
        int prefixEnd = seqName.indexOf(colName);
        String tableName = null;
        if (this.columns.get(0).getParent() != null) {
            tableName = this.columns.get(0).getParent().getPhysicalName();
        }
        if (prefixEnd != -1 && seqName.substring(prefixEnd + colName.length()).indexOf(colName) == -1) {
            this.seqNamePrefix = seqName.substring(0, prefixEnd);
            this.seqNameSuffix = seqName.substring(prefixEnd + colName.length());
        } else if (seqName.equals(tableName + "_" + colName + "_seq")) {
            this.seqNamePrefix = tableName + "_";
            this.seqNameSuffix = "_seq";
        } else {
            this.seqNamePrefix = null;
            this.seqNameSuffix = null;
        }
    }

    private void syncSequenceName() {
        if (this.seqNamePrefix != null && this.seqNameSuffix != null) {
            String newName = this.seqNamePrefix;
            newName = newName + (this.colPhysicalName.getText() == null || this.colPhysicalName.getText().trim().equals("") ? this.colLogicalName.getText() : this.colPhysicalName.getText());
            newName = newName + this.seqNameSuffix;
            this.colAutoIncSequenceName.setText(newName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("action event " + e));
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.colInPK.isSelected() || !this.typeOverrideMap.get(this.colNullable).isSelected()) {
            this.colNullable.setEnabled(false);
        } else {
            this.colNullable.setEnabled(true);
        }
        if (((YesNoEnum)((Object)this.colNullable.getSelectedItem())).getValue()) {
            this.colInPK.setEnabled(false);
        } else {
            this.colInPK.setEnabled(true);
        }
        if (this.colInPK.isSelected() && ((YesNoEnum)((Object)this.colNullable.getSelectedItem())).getValue()) {
            this.colNullable.setSelectedItem(false);
            this.colNullable.setEnabled(false);
        }
        if (this.colAutoInc.getSelectedIndex() == -1 || ((YesNoEnum)((Object)this.colAutoInc.getSelectedItem())).getValue() || !this.typeOverrideMap.get(this.colDefaultValue).isSelected()) {
            this.colDefaultValue.setText("");
            this.colDefaultValue.setEnabled(false);
        } else {
            this.colDefaultValue.setEnabled(true);
        }
        if (this.colAutoInc.getSelectedIndex() != -1) {
            this.colAutoIncSequenceName.setEnabled(((YesNoEnum)((Object)this.colAutoInc.getSelectedItem())).getValue());
        } else {
            this.colAutoIncSequenceName.setEnabled(false);
        }
    }

    private List<String> updateModel() {
        logger.debug((Object)"Updating model");
        ArrayList<String> errors = new ArrayList<String>();
        if (this.componentEnabledMap.get(this.colType).isSelected() && !(this.colType.getLastSelectedPathComponent() instanceof UserDefinedSQLType)) {
            errors.add(Messages.getString("ColumnEditPanel.missingType"));
            return errors;
        }
        SQLObject compoundEditRoot = SQLObjectUtils.findCommonAncestor(this.columns);
        logger.debug((Object)("Compound edit root is " + compoundEditRoot));
        try {
            compoundEditRoot.begin(Messages.getString("ColumnEditPanel.compoundEditName"));
            for (SQLColumn column : this.columns) {
                if (this.componentEnabledMap.get(this.colSourceTree).isSelected()) {
                    Object selection = this.colSourceTree.getLastSelectedPathComponent();
                    if (selection instanceof SQLColumn) {
                        column.setSourceColumn((SQLColumn)selection);
                    } else {
                        column.setSourceColumn(null);
                    }
                }
                if (this.componentEnabledMap.get(this.colPhysicalName).isSelected()) {
                    column.setPhysicalName(this.colPhysicalName.getText());
                }
                if (this.componentEnabledMap.get(this.colLogicalName).isSelected()) {
                    if (this.colLogicalName.getText().trim().length() == 0) {
                        errors.add(Messages.getString("ColumnEditPanel.columnNameRequired"));
                    } else {
                        column.setName(this.colLogicalName.getText());
                    }
                }
                if (this.componentEnabledMap.get(this.colType).isSelected()) {
                    UserDefinedSQLType upstreamType = (UserDefinedSQLType)this.colType.getLastSelectedPathComponent();
                    column.getUserDefinedSQLType().setUpstreamType(upstreamType);
                    if (this.typeOverrideMap.get(this.colScale).isSelected()) {
                        column.setScale(((Integer)this.colScale.getValue()).intValue());
                    } else {
                        column.getUserDefinedSQLType().setScale("GENERIC", null);
                    }
                    if (this.typeOverrideMap.get(this.colPrec).isSelected()) {
                        column.setPrecision(((Integer)this.colPrec.getValue()).intValue());
                    } else {
                        column.getUserDefinedSQLType().setPrecision("GENERIC", null);
                    }
                    if (this.typeOverrideMap.get(this.colNullable).isSelected()) {
                        column.setNullable(((YesNoEnum)((Object)this.colNullable.getSelectedItem())).getValue() ? 1 : 0);
                    } else {
                        column.getUserDefinedSQLType().setMyNullability(null);
                    }
                    if (this.typeOverrideMap.get(this.colDefaultValue).isSelected()) {
                        if (column.getDefaultValue() != null || !this.colDefaultValue.getText().equals("")) {
                            column.setDefaultValue(this.colDefaultValue.getText());
                        }
                    } else {
                        column.getUserDefinedSQLType().setDefaultValue("GENERIC", null);
                    }
                    if (this.typeOverrideMap.get(this.colAutoInc).isSelected()) {
                        column.setAutoIncrement(((YesNoEnum)((Object)this.colAutoInc.getSelectedItem())).getValue());
                    } else {
                        column.getUserDefinedSQLType().setMyAutoIncrement(null);
                    }
                }
                if (this.componentEnabledMap.get(this.colRemarks).isSelected()) {
                    column.setRemarks(this.colRemarks.getText());
                }
                if (this.componentEnabledMap.get(this.colInPK).isSelected()) {
                    if (this.colInPK.isSelected() && !column.isPrimaryKey()) {
                        column.getParent().addToPK(column);
                    } else if (!this.colInPK.isSelected() && column.isPrimaryKey()) {
                        column.getParent().moveAfterPK(column);
                    }
                }
                if (!this.componentEnabledMap.get(this.colAutoIncSequenceName).isSelected()) continue;
                column.setAutoIncrementSequenceName(this.colAutoIncSequenceName.getText());
                if (!this.colAutoIncSequenceName.getText().equals("")) continue;
                column.setAutoIncrementSequenceName(column.makeAutoIncrementSequenceName());
            }
        }
        catch (SQLObjectException e) {
            throw new RuntimeException(e);
        }
        finally {
            compoundEditRoot.commit();
        }
        return errors;
    }

    public boolean applyChanges() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)this.session.getRootObject(), (SPListener)this);
        List<String> errors = this.updateModel();
        if (!errors.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            for (String error : errors) {
                buffer.append(error);
                buffer.append("<br>");
            }
            buffer.append("</html>");
            JOptionPane.showMessageDialog(this.panel, buffer.toString(), Messages.getString("ColumnEditPanel.errorTitle"), 2);
            return false;
        }
        return true;
    }

    public void discardChanges() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)this.session.getRootObject(), (SPListener)this);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JComboBox getColAutoInc() {
        return this.colAutoInc;
    }

    public JTextField getColDefaultValue() {
        return this.colDefaultValue;
    }

    public JCheckBox getColInPK() {
        return this.colInPK;
    }

    public JTextField getColLogicalName() {
        return this.colLogicalName;
    }

    public JTextField getColPhysicalName() {
        return this.colPhysicalName;
    }

    public JComboBox getColNullable() {
        return this.colNullable;
    }

    public JSpinner getColPrec() {
        return this.colPrec;
    }

    public JTextArea getColRemarks() {
        return this.colRemarks;
    }

    public JSpinner getColScale() {
        return this.colScale;
    }

    public JTree getColType() {
        return this.colType;
    }

    public JButton getSourceColumnButton() {
        return this.colSourceButton;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public void childAdded(SPChildEvent e) {
    }

    public void childRemoved(SPChildEvent e) {
    }

    public void propertyChanged(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (this.columns.contains(e.getSource())) {
            if (property.equals("name")) {
                DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.colLogicalName, (PropertyChangeEvent)e);
            } else if (property.equals("physicalName")) {
                DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.colPhysicalName, (PropertyChangeEvent)e);
            } else if (property.equals("type")) {
                DataEntryPanelChangeUtil.incomingChange((JTree)this.colType, (PropertyChangeEvent)e);
            } else if (property.equals("precision")) {
                DataEntryPanelChangeUtil.incomingChange((JSpinner)this.colPrec, (PropertyChangeEvent)e);
            } else if (property.equals("scale")) {
                DataEntryPanelChangeUtil.incomingChange((JSpinner)this.colScale, (PropertyChangeEvent)e);
            } else if (property.equals("inPK")) {
                DataEntryPanelChangeUtil.incomingChange((JCheckBox)this.colInPK, (PropertyChangeEvent)e);
            } else if (property.equals("isNullable")) {
                DataEntryPanelChangeUtil.incomingChange((JComboBox)this.colNullable, (PropertyChangeEvent)e);
            } else if (property.equals("autoIncrement")) {
                DataEntryPanelChangeUtil.incomingChange((JComboBox)this.colAutoInc, (PropertyChangeEvent)e);
            } else if (property.equals("autoIncrementSequenceName")) {
                DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.colAutoIncSequenceName, (PropertyChangeEvent)e);
            } else if (property.equals("remarks")) {
                DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.colRemarks, (PropertyChangeEvent)e);
            } else if (property.equals("defaultValue")) {
                DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.colDefaultValue, (PropertyChangeEvent)e);
            } else {
                return;
            }
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        } else if (e.getSource() instanceof UserDefinedSQLType && this.columns.contains(((UserDefinedSQLType)e.getSource()).getParent())) {
            if (!property.equals("type")) {
                return;
            }
            DataEntryPanelChangeUtil.incomingChange((JTree)this.colType, (PropertyChangeEvent)e);
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        }
    }

    public void transactionEnded(TransactionEvent e) {
    }

    public void transactionRollback(TransactionEvent e) {
    }

    public void transactionStarted(TransactionEvent e) {
    }

    private void updateSQLTypeComponents(UserDefinedSQLType sqlType, boolean overrideIfNotNull) {
        if (!this.componentEnabledMap.get(this.colType).isSelected()) {
            this.colScale.setValue(0);
            this.colPrec.setValue(0);
            this.colNullable.setSelectedItem((Object)YesNoEnum.NO);
            this.colAutoInc.setSelectedItem((Object)YesNoEnum.NO);
            this.colDefaultValue.setText("");
            return;
        }
        if (sqlType.getScaleType("GENERIC") != SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE) {
            this.typeOverrideMap.get(this.colScale).setSelected(false);
            this.typeOverrideMap.get(this.colScale).setEnabled(false);
        } else if (sqlType.getDefaultPhysicalProperties().getScale() == null || !overrideIfNotNull) {
            this.typeOverrideMap.get(this.colScale).setSelected(false);
            this.typeOverrideMap.get(this.colScale).setEnabled(true);
        } else {
            this.typeOverrideMap.get(this.colScale).setSelected(true);
            this.typeOverrideMap.get(this.colScale).setEnabled(true);
        }
        this.colScale.setValue(sqlType.getScale("GENERIC"));
        if (sqlType.getPrecisionType("GENERIC") != SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE) {
            this.typeOverrideMap.get(this.colPrec).setSelected(false);
            this.typeOverrideMap.get(this.colPrec).setEnabled(false);
        } else if (sqlType.getDefaultPhysicalProperties().getPrecision() == null || !overrideIfNotNull) {
            this.typeOverrideMap.get(this.colPrec).setSelected(false);
            this.typeOverrideMap.get(this.colPrec).setEnabled(true);
        } else {
            this.typeOverrideMap.get(this.colPrec).setSelected(true);
            this.typeOverrideMap.get(this.colPrec).setEnabled(true);
        }
        this.colPrec.setValue(sqlType.getPrecision("GENERIC"));
        if (sqlType.getMyNullability() == null || !overrideIfNotNull) {
            this.typeOverrideMap.get(this.colNullable).setSelected(false);
        } else {
            this.typeOverrideMap.get(this.colNullable).setSelected(true);
        }
        this.colNullable.setSelectedItem((Object)YesNoEnum.valueOf(sqlType.getNullability() == 1));
        if (sqlType.getDefaultPhysicalProperties().getDefaultValue() == null || !overrideIfNotNull) {
            this.typeOverrideMap.get(this.colDefaultValue).setSelected(false);
        } else {
            this.typeOverrideMap.get(this.colDefaultValue).setSelected(true);
        }
        this.colDefaultValue.setText(sqlType.getDefaultValue("GENERIC"));
        if (sqlType.getMyAutoIncrement() == null || !overrideIfNotNull) {
            this.typeOverrideMap.get(this.colAutoInc).setSelected(false);
        } else {
            this.typeOverrideMap.get(this.colAutoInc).setSelected(true);
        }
        this.colAutoInc.setSelectedItem((Object)YesNoEnum.valueOf(sqlType.getAutoIncrement()));
    }

    Map<JComponent, JCheckBox> getTypeOverrideMap() {
        return this.typeOverrideMap;
    }

    private class DocumentCheckboxEnabler
    implements DocumentListener {
        private final JCheckBox checkBox;

        public DocumentCheckboxEnabler(JCheckBox checkBox) {
            this.checkBox = checkBox;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkBox.setSelected(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkBox.setSelected(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkBox.setSelected(true);
        }
    }

    private class CheckboxEnabler
    implements ActionListener,
    ChangeListener {
        private CheckboxEnabler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.enable((JComponent)e.getSource());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.enable((JComponent)e.getSource());
        }

        private void enable(JComponent c) {
            JCheckBox checkBox = (JCheckBox)ColumnEditPanel.this.componentEnabledMap.get(c);
            if (checkBox != null) {
                checkBox.setSelected(true);
            }
        }
    }

    static enum YesNoEnum {
        YES("Yes", true),
        NO("No", false);

        private final String displayName;
        private final boolean value;

        private YesNoEnum(String displayName, boolean value) {
            this.displayName = displayName;
            this.value = value;
        }

        public String toString() {
            return this.displayName;
        }

        public boolean getValue() {
            return this.value;
        }

        public static YesNoEnum valueOf(Boolean bool) {
            if (bool == null) {
                return null;
            }
            if (bool.booleanValue()) {
                return YES;
            }
            return NO;
        }
    }
}

