/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.DraggablePlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.event.ItemSelectionEvent;
import ca.sqlpower.architect.swingui.event.ItemSelectionListener;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class ContainerPane<T, C>
extends DraggablePlayPenComponent
implements DragSourceListener,
LayoutNode {
    public static final int ITEM_INDEX_TITLE = -1;
    public static final int ITEM_INDEX_NONE = -2;
    private static final Logger logger = Logger.getLogger(ContainerPane.class);
    private C previousSelectedItem;
    private boolean rounded;
    private boolean dashed;
    protected T model;
    protected Insets margin = new Insets(1, 1, 1, 1);
    protected final Set<C> selectedItems = new HashSet<C>();
    private final List<ItemSelectionListener<T, C>> itemSelectionListeners = new ArrayList<ItemSelectionListener<T, C>>();

    protected ContainerPane(ContainerPane<T, C> copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
        this.dashed = copyMe.dashed;
        if (copyMe.margin != null) {
            this.margin = new Insets(copyMe.margin.top, copyMe.margin.left, copyMe.margin.bottom, copyMe.margin.right);
        }
        this.model = copyMe.model;
        this.rounded = copyMe.rounded;
    }

    protected ContainerPane(String name) {
        super(name);
        this.backgroundColor = new Color(240, 240, 240);
        this.foregroundColor = Color.BLACK;
        this.setOpaque(true);
    }

    protected ContainerPane(String name, PlayPenContentPane parent) {
        this(name);
        this.setParent((SPObject)parent);
    }

    public T getModel() {
        return this.model;
    }

    @Override
    public void handleMouseEvent(MouseEvent evt) {
        PlayPen pp = this.getPlayPen();
        Point p = evt.getPoint();
        pp.unzoomPoint(p);
        p.translate(-this.getX(), -this.getY());
        if (evt.getID() == 500) {
            if (evt.getClickCount() == 1 && evt.getButton() == 1) {
                int selectedItemIndex = this.pointToItemIndex(p);
                if (selectedItemIndex >= 0 && selectedItemIndex < this.getItems().size()) {
                    this.previousSelectedItem = this.getItems().get(selectedItemIndex);
                }
                if (selectedItemIndex > -1 && this.componentPreviouslySelected) {
                    if (evt.isControlDown()) {
                        this.deselectItem(selectedItemIndex);
                        this.fireSelectionEvent(new SelectionEvent(this, 2, 4));
                    } else {
                        this.selectNone();
                        this.selectItem(selectedItemIndex);
                        this.fireSelectionEvent(new SelectionEvent(this, 1, 4));
                    }
                } else if (this.isSelected() && this.componentPreviouslySelected) {
                    this.setSelected(false, 4);
                }
            }
        } else if (evt.getID() == 501) {
            this.componentPreviouslySelected = false;
            int clickItem = this.pointToItemIndex(p);
            if (pp.getMouseMode() != PlayPen.MouseModeType.CREATING_TABLE) {
                if ((evt.getModifiersEx() & (0x40 | SPSUtils.MULTISELECT_MASK)) == 0) {
                    if (!this.isSelected() || pp.getMouseMode() == PlayPen.MouseModeType.IDLE) {
                        pp.setMouseMode(PlayPen.MouseModeType.SELECT_TABLE);
                        pp.selectNone();
                    }
                } else {
                    pp.setMouseMode(PlayPen.MouseModeType.MULTI_SELECT);
                }
                if ((evt.getModifiersEx() & 0x200) != 0) {
                    clickItem = -1;
                }
                if (clickItem > -1 && clickItem < this.getItems().size()) {
                    int previousSelectedIndex = this.isItemSelected(this.previousSelectedItem) ? this.getItems().indexOf(this.previousSelectedItem) : this.getSelectedItemIndex();
                    if ((evt.getModifiersEx() & (0x40 | SPSUtils.MULTISELECT_MASK)) == 0) {
                        if (!this.isItemSelected(clickItem)) {
                            this.selectNone();
                        }
                        pp.setMouseMode(PlayPen.MouseModeType.SELECT_ITEM);
                    } else if ((evt.getModifiersEx() & 0x40) != 0 && this.getSelectedItems().size() > 0 && previousSelectedIndex > -1) {
                        int start = Math.min(previousSelectedIndex, clickItem);
                        int end = Math.max(previousSelectedIndex, clickItem);
                        logger.debug((Object)("Start: " + start + " , End: " + end + " , Total size: " + this.getItems().size()));
                        for (int i = 0; i < this.getItems().size(); ++i) {
                            if (i <= start || i >= end) continue;
                            this.selectItem(i);
                            this.fireSelectionEvent(new SelectionEvent(this, 1, 4));
                        }
                    }
                    if (this.isItemSelected(clickItem)) {
                        this.componentPreviouslySelected = true;
                    } else {
                        this.selectItem(clickItem);
                        this.fireSelectionEvent(new SelectionEvent(this, 1, 4));
                        this.repaint();
                        this.previousSelectedItem = this.getItems().get(clickItem);
                    }
                }
                if (this.isSelected() && clickItem == -1) {
                    this.componentPreviouslySelected = true;
                } else {
                    this.setSelected(true, 4);
                }
            }
            if (clickItem == -1 && !pp.getSession().getArchitectFrame().createRelationshipIsActive() && evt.getButton() == 1) {
                this.setupDrag(p);
            }
        } else if (evt.getID() == 503 || evt.getID() == 506) {
            this.setSelected(pp.rubberBand.intersects(this.getBounds(new Rectangle())), 4);
        }
    }

    protected void deSelectEverythingElse(MouseEvent evt) {
        for (ContainerPane<?, ?> cp : this.getPlayPen().getSelectedContainers()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("(" + this.getModel() + ") zoomed selected containerPane's located point: " + this.getLocationOnScreen()));
                logger.debug((Object)("(" + cp.getModel() + ") zoomed iterating containerPane's point: " + cp.getLocationOnScreen()));
            }
            if (this.getLocationOnScreen().equals(cp.getLocationOnScreen())) continue;
            logger.debug((Object)"found matching containerPane!");
            cp.setSelected(false, 4);
            cp.selectNone();
        }
        for (Relationship r : this.getPlayPen().getSelectedRelationShips()) {
            r.setSelected(false, 4);
        }
    }

    @Transient
    @Mutator
    public void setMargin(Insets argMargin) {
        Insets old = this.margin;
        this.margin = (Insets)argMargin.clone();
        this.firePropertyChange("margin", old, this.margin);
    }

    @Transient
    @Accessor
    public Insets getMargin() {
        return this.margin;
    }

    @Transient
    @Accessor
    protected abstract List<C> getItems();

    @Accessor
    public boolean isRounded() {
        return this.rounded;
    }

    @Mutator
    public void setRounded(boolean isRounded) {
        boolean oldValue = this.rounded;
        this.rounded = isRounded;
        this.firePropertyChange("rounded", oldValue, isRounded);
    }

    @Accessor
    public boolean isDashed() {
        return this.dashed;
    }

    @Mutator
    public void setDashed(boolean isDashed) {
        boolean oldValue = this.dashed;
        this.dashed = isDashed;
        this.firePropertyChange("dashed", oldValue, isDashed);
    }

    @Override
    @Transient
    @Mutator
    public void setSelected(boolean isSelected, int multiSelectType) {
        if (!isSelected) {
            this.selectNone();
        }
        super.setSelected(isSelected, multiSelectType);
    }

    @Deprecated
    public abstract int pointToItemIndex(Point var1);

    public void selectNone() {
        HashSet<C> previouslySelectedItems = new HashSet<C>(this.selectedItems);
        this.selectedItems.clear();
        this.fireItemsDeselected(previouslySelectedItems);
        this.repaint();
    }

    public void deselectItem(int i) {
        if (i < 0) {
            this.selectNone();
        } else {
            C item = this.getItems().get(i);
            this.deselectItem(item);
        }
    }

    public void deselectItem(C item) {
        this.selectedItems.remove(item);
        this.fireItemsDeselected(Collections.singleton(item));
        this.repaint();
    }

    public void selectItem(int i) {
        if (i < 0) {
            this.selectNone();
        } else {
            C item = this.getItems().get(i);
            this.selectItem(item);
        }
    }

    public void selectItem(C item) {
        this.selectedItems.add(item);
        this.fireItemsSelected(Collections.singleton(item));
        this.repaint();
    }

    @NonBound
    public boolean isItemSelected(int i) {
        return this.selectedItems.contains(this.getItems().get(i));
    }

    @NonBound
    public boolean isItemSelected(C item) {
        return this.selectedItems.contains(item);
    }

    @Transient
    @Accessor
    public List<C> getSelectedItems() {
        ArrayList<C> selectedItems = new ArrayList<C>();
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!this.isItemSelected(i)) continue;
            selectedItems.add(this.getItems().get(i));
        }
        return selectedItems;
    }

    @Transient
    @Accessor
    public int getSelectedItemIndex() {
        if (this.selectedItems.size() > 0) {
            return this.getItems().indexOf(this.selectedItems.toArray()[0]);
        }
        return -2;
    }

    protected void fireItemsSelected(Set<C> items) {
        ItemSelectionEvent e = new ItemSelectionEvent(this, items);
        for (int i = this.itemSelectionListeners.size() - 1; i >= 0; --i) {
            this.itemSelectionListeners.get(i).itemsSelected(e);
        }
    }

    protected void fireItemsDeselected(Set<C> items) {
        ItemSelectionEvent e = new ItemSelectionEvent(this, items);
        for (int i = this.itemSelectionListeners.size() - 1; i >= 0; --i) {
            this.itemSelectionListeners.get(i).itemsDeselected(e);
        }
    }

    public void addItemSelectionListener(ItemSelectionListener<T, C> listener) {
        this.itemSelectionListeners.add(listener);
    }

    public void removeItemSelectionListener(ItemSelectionListener<T, C> listener) {
        this.itemSelectionListeners.remove(listener);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragEnter event on " + this.getName()));
        }
    }

    public void dragExit(DropTargetEvent dte) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragExit event on " + this.getName()));
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragOver event on " + this.getName() + ": " + dtde));
            logger.debug((Object)("Drop Action = " + dtde.getDropAction()));
            logger.debug((Object)("Source Actions = " + dtde.getSourceActions()));
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        logger.debug((Object)("Drop target drop event on " + this.getName() + ": " + dtde));
        dtde.rejectDrop();
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public DataFlavor bestImportFlavor(JComponent c, DataFlavor[] flavors) {
        return null;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess()) {
            logger.debug((Object)"Succesful drop");
        } else {
            logger.debug((Object)"Unsuccesful drop");
        }
    }

    public abstract Transferable createTransferableForSelection();

    public abstract void pasteData(Transferable var1);

    @Override
    @Transient
    @Accessor
    public String getNodeName() {
        return this.getName();
    }
}

