/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Utils {
    public static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(Integer.toHexString(data[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i] & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected exception: UTF-8 charset not supported: " + e);
        }
    }

    public static StringBuffer appendEscapedString(StringBuffer sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(value.length() * 11 / 10);
        }
        if (standardConformingStrings) {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\'') {
                    sbuf.append('\'');
                }
                sbuf.append(ch);
            }
        } else {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\\' || ch == '\'') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
        }
        return sbuf;
    }
}

