/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io.sza;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.sf.freecol.common.io.sza.AnimationEvent;
import net.sf.freecol.common.io.sza.ImageAnimationEvent;
import net.sf.freecol.common.util.CollectionUtils;

public final class SimpleZippedAnimation
implements Iterable<AnimationEvent> {
    private static final Predicate<AnimationEvent> isIAEI = ae -> ae instanceof ImageAnimationEvent;
    private static final ToIntFunction<AnimationEvent> ifIAEIWidth = ae -> ((ImageAnimationEventImpl)ae).getWidth();
    private static final ToIntFunction<AnimationEvent> ifIAEIHeight = ae -> ((ImageAnimationEventImpl)ae).getHeight();
    private static final String ANIMATION_DESCRIPTOR_FILE = "animation.txt";
    private final List<AnimationEvent> events;
    private final int width;
    private final int height;

    public SimpleZippedAnimation(URL url) throws IOException {
        this(url.openStream());
    }

    public SimpleZippedAnimation(InputStream stream) throws IOException {
        this(new ZipInputStream(stream));
    }

    private SimpleZippedAnimation(ZipInputStream zipStream) throws IOException {
        this(SimpleZippedAnimation.loadEvents(zipStream));
    }

    private SimpleZippedAnimation(List<AnimationEvent> evl) {
        this(evl, CollectionUtils.max(evl, isIAEI, ifIAEIWidth), CollectionUtils.max(evl, isIAEI, ifIAEIHeight));
    }

    private SimpleZippedAnimation(List<AnimationEvent> events, int width, int height) {
        this.events = events;
        this.width = width;
        this.height = height;
    }

    private static List<AnimationEvent> loadEvents(ZipInputStream zipStream) throws IOException {
        HashMap<String, BufferedImage> loadingImages = new HashMap<String, BufferedImage>();
        ArrayList<String> loadingDescriptor = new ArrayList<String>();
        try (ZipInputStream zipInputStream = zipStream;){
            ZipEntry ze;
            while ((ze = zipStream.getNextEntry()) != null) {
                if (ANIMATION_DESCRIPTOR_FILE.equals(ze.getName())) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)zipStream, StandardCharsets.UTF_8));
                    while ((line = in.readLine()) != null) {
                        loadingDescriptor.add(line);
                    }
                } else {
                    loadingImages.put(ze.getName(), ImageIO.read(zipStream));
                }
                zipStream.closeEntry();
            }
        }
        if (loadingDescriptor.isEmpty()) {
            throw new IOException("animation.txt is missing from the SZA: " + zipStream);
        }
        ArrayList<AnimationEvent> events = new ArrayList<AnimationEvent>(loadingDescriptor.size());
        for (String line : loadingDescriptor) {
            int idx = line.indexOf(40);
            int idx2 = line.indexOf("ms)");
            if (idx < 0 || idx2 <= idx) {
                throw new IOException("animation.txt should use the format: FILNAME (TIMEms) in: " + line);
            }
            String imageName = line.substring(0, idx).trim();
            int ms = Integer.parseInt(line.substring(idx + 1, idx2));
            BufferedImage image = (BufferedImage)loadingImages.get(imageName);
            if (image == null) {
                throw new IOException("Could not find referenced image: " + imageName);
            }
            events.add(new ImageAnimationEventImpl(image, ms));
        }
        return events;
    }

    public SimpleZippedAnimation createScaledVersion(float scale) {
        Function<AnimationEvent, AnimationEvent> scaleEvent = ae -> ae instanceof ImageAnimationEventImpl ? ((ImageAnimationEventImpl)ae).createScaledVersion(scale) : ae;
        return new SimpleZippedAnimation(CollectionUtils.transform(this.events, CollectionUtils.alwaysTrue(), scaleEvent), (int)((float)this.width * scale), (int)((float)this.height * scale));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public Iterator<AnimationEvent> iterator() {
        return Collections.unmodifiableList(this.events).iterator();
    }

    private static final class ImageAnimationEventImpl
    implements ImageAnimationEvent {
        private static final Component _c = new Component(){};
        private final BufferedImage image;
        private final int durationInMs;

        private ImageAnimationEventImpl(BufferedImage image, int durationInMs) {
            this.image = image;
            this.durationInMs = durationInMs;
        }

        private AnimationEvent createScaledVersion(float scale) {
            int width = (int)((float)this.getWidth() * scale);
            int height = (int)((float)this.getHeight() * scale);
            BufferedImage scaled = new BufferedImage(width, height, 2);
            Graphics2D g = scaled.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(this.image, 0, 0, width, height, null);
            g.dispose();
            return new ImageAnimationEventImpl(scaled, this.durationInMs);
        }

        public int getWidth() {
            return this.image.getWidth(null);
        }

        public int getHeight() {
            return this.image.getHeight(null);
        }

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public int getDurationInMs() {
            return this.durationInMs;
        }
    }
}

