/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.FeatureId;

public class FeatureDependencySpec {
    final String origin;
    final FeatureId featureId;
    final boolean include;

    public static FeatureDependencySpec create(FeatureId featureId) throws ProvisioningDescriptionException {
        return FeatureDependencySpec.create(featureId, null, false);
    }

    public static FeatureDependencySpec create(FeatureId featureId, String origin) throws ProvisioningDescriptionException {
        return FeatureDependencySpec.create(featureId, origin, false);
    }

    public static FeatureDependencySpec create(FeatureId featureId, boolean include) throws ProvisioningDescriptionException {
        return FeatureDependencySpec.create(featureId, null, include);
    }

    public static FeatureDependencySpec create(FeatureId featureId, String origin, boolean include) throws ProvisioningDescriptionException {
        return new FeatureDependencySpec(featureId, origin, include);
    }

    private FeatureDependencySpec(FeatureId featureId, String origin, boolean include) throws ProvisioningDescriptionException {
        this.featureId = featureId;
        this.origin = origin;
        this.include = include;
    }

    public String getOrigin() {
        return this.origin;
    }

    public FeatureId getFeatureId() {
        return this.featureId;
    }

    public boolean isInclude() {
        return this.include;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.featureId == null ? 0 : this.featureId.hashCode());
        result = 31 * result + (this.include ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureDependencySpec other = (FeatureDependencySpec)obj;
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.featureId == null ? other.featureId != null : !this.featureId.equals(other.featureId)) {
            return false;
        }
        return this.include == other.include;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (this.origin != null) {
            buf.append(" origin=").append(this.origin);
        }
        buf.append(" feature=").append(this.featureId);
        if (this.include) {
            buf.append(" auto-includes");
        }
        return buf.append(']').toString();
    }
}

