/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.AlphabetRegistrationException;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.Extension;
import org.scilab.forge.jlatexmath.FontAlreadyLoadedException;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.Metrics;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolMappingNotFoundException;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TextStyleMappingNotFoundException;
import org.scilab.forge.jlatexmath.XMLResourceParseException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DefaultTeXFont
implements TeXFont {
    private static String[] a;
    private static Map b;
    private static Map c;
    private static FontInfo[] a;
    private static Map d;
    private static Map e;
    private static boolean f;
    public static List a;
    public static Map a;
    protected float a;
    public boolean a = false;
    public boolean b;
    public boolean c = false;
    public boolean d = false;
    public boolean e = false;
    private final float b;

    public DefaultTeXFont(float f) {
        this.b = false;
        this.b = f;
    }

    public DefaultTeXFont(float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(f, 1.0f, bl, bl2, bl3, bl4, bl5);
    }

    public DefaultTeXFont(float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.b = false;
        this.b = f;
        this.a = f2;
        this.a = bl;
        this.b = bl2;
        this.c = bl3;
        this.d = bl4;
        this.e = bl5;
    }

    public static void addTeXFontDescription(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceParseException(string, fileNotFoundException);
        }
        DefaultTeXFont.addTeXFontDescription(fileInputStream, string);
    }

    public static void addTeXFontDescription(InputStream inputStream, String string) {
        DefaultTeXFontParser defaultTeXFontParser = new DefaultTeXFontParser(inputStream, string);
        a = defaultTeXFontParser.parseFontDescriptions(a);
        b.putAll(defaultTeXFontParser.parseTextStyleMappings());
        c.putAll(defaultTeXFontParser.parseSymbolMappings());
    }

    public static void addTeXFontDescription(Object object, InputStream inputStream, String string) {
        DefaultTeXFontParser defaultTeXFontParser = new DefaultTeXFontParser(object, inputStream, string);
        a = defaultTeXFontParser.parseFontDescriptions(a);
        defaultTeXFontParser.parseExtraPath();
        b.putAll(defaultTeXFontParser.parseTextStyleMappings());
        c.putAll(defaultTeXFontParser.parseSymbolMappings());
    }

    public static void addAlphabet(Character.UnicodeBlock unicodeBlock, InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream inputStream3, String string3) {
        if (!a.contains(unicodeBlock)) {
            DefaultTeXFont.addTeXFontDescription(inputStream, string);
            SymbolAtom.addSymbolAtom(inputStream2, string2);
            TeXFormula.addSymbolMappings(inputStream3, string3);
            a.add(unicodeBlock);
        }
    }

    public static void addAlphabet(Object object, Character.UnicodeBlock[] unicodeBlockArray, String string) {
        int n;
        boolean bl = false;
        for (n = 0; !bl && n < unicodeBlockArray.length; ++n) {
            bl = a.contains(unicodeBlockArray[n]) || bl;
        }
        if (!bl) {
            TeXParser.a = true;
            DefaultTeXFont.addTeXFontDescription(object, object.getClass().getResourceAsStream(string), string);
            for (n = 0; n < unicodeBlockArray.length; ++n) {
                a.add(unicodeBlockArray[n]);
            }
            TeXParser.a = false;
        }
    }

    public static void addAlphabet(Character.UnicodeBlock unicodeBlock, String string) {
        String string2 = "fonts/" + string + "/language_" + string + ".xml";
        String string3 = "fonts/" + string + "/symbols_" + string + ".xml";
        String string4 = "fonts/" + string + "/mappings_" + string + ".xml";
        try {
            DefaultTeXFont.addAlphabet(unicodeBlock, TeXFormula.class.getResourceAsStream(string2), string2, TeXFormula.class.getResourceAsStream(string3), string3, TeXFormula.class.getResourceAsStream(string4), string4);
        }
        catch (FontAlreadyLoadedException fontAlreadyLoadedException) {
            // empty catch block
        }
    }

    public static void addAlphabet(AlphabetRegistration alphabetRegistration) {
        try {
            if (alphabetRegistration != null) {
                DefaultTeXFont.addAlphabet(alphabetRegistration.getPackage(), alphabetRegistration.getUnicodeBlock(), alphabetRegistration.getTeXFontFileName());
            }
        }
        catch (FontAlreadyLoadedException fontAlreadyLoadedException) {
        }
        catch (AlphabetRegistrationException alphabetRegistrationException) {
            System.err.println(alphabetRegistrationException.toString());
        }
    }

    public static void registerAlphabet(AlphabetRegistration alphabetRegistration) {
        Character.UnicodeBlock[] unicodeBlockArray = alphabetRegistration.getUnicodeBlock();
        for (int i = 0; i < unicodeBlockArray.length; ++i) {
            a.put(unicodeBlockArray[i], alphabetRegistration);
        }
    }

    public TeXFont copy() {
        return new DefaultTeXFont(this.b, this.a, this.a, this.b, this.c, this.d, this.e);
    }

    public TeXFont deriveFont(float f) {
        return new DefaultTeXFont(f, this.a, this.a, this.b, this.c, this.d, this.e);
    }

    public TeXFont scaleFont(float f) {
        return new DefaultTeXFont(this.b, f, this.a, this.b, this.c, this.d, this.e);
    }

    public float getScaleFactor() {
        return this.a;
    }

    public float getAxisHeight(int n) {
        return DefaultTeXFont.getParameter("axisheight") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getBigOpSpacing1(int n) {
        return DefaultTeXFont.getParameter("bigopspacing1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getBigOpSpacing2(int n) {
        return DefaultTeXFont.getParameter("bigopspacing2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getBigOpSpacing3(int n) {
        return DefaultTeXFont.getParameter("bigopspacing3") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getBigOpSpacing4(int n) {
        return DefaultTeXFont.getParameter("bigopspacing4") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getBigOpSpacing5(int n) {
        return DefaultTeXFont.getParameter("bigopspacing5") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    private Char getChar(char c2, CharFont[] charFontArray, int n) {
        int n2;
        int n3;
        if (c2 >= '0' && c2 <= '9') {
            n3 = 0;
            n2 = c2 - 48;
        } else if (c2 >= 'a' && c2 <= 'z') {
            n3 = 2;
            n2 = c2 - 97;
        } else if (c2 >= 'A' && c2 <= 'Z') {
            n3 = 1;
            n2 = c2 - 65;
        } else {
            n3 = 3;
            n2 = c2;
        }
        if (charFontArray[n3] == null) {
            return this.getDefaultChar(c2, n);
        }
        return this.getChar(new CharFont((char)(charFontArray[n3].a + n2), charFontArray[n3].a), n);
    }

    public Char getChar(char c2, String string, int n) {
        Object v = b.get(string);
        if (v == null) {
            throw new TextStyleMappingNotFoundException(string);
        }
        return this.getChar(c2, (CharFont[])v, n);
    }

    public Char getChar(CharFont charFont, int n) {
        float f = DefaultTeXFont.getSizeFactor(n);
        int n2 = this.a ? charFont.b : charFont.a;
        FontInfo fontInfo = a[n2];
        if (this.a && charFont.a == charFont.b) {
            n2 = fontInfo.getBoldId();
            fontInfo = a[n2];
            charFont = new CharFont(charFont.a, n2, n);
        }
        if (this.b) {
            n2 = fontInfo.getRomanId();
            fontInfo = a[n2];
            charFont = new CharFont(charFont.a, n2, n);
        }
        if (this.c) {
            n2 = fontInfo.getSsId();
            fontInfo = a[n2];
            charFont = new CharFont(charFont.a, n2, n);
        }
        if (this.d) {
            n2 = fontInfo.getTtId();
            fontInfo = a[n2];
            charFont = new CharFont(charFont.a, n2, n);
        }
        if (this.e) {
            n2 = fontInfo.getItId();
            fontInfo = a[n2];
            charFont = new CharFont(charFont.a, n2, n);
        }
        Font font = fontInfo.getFont();
        return new Char(charFont.a, font, n2, this.getMetrics(charFont, this.a * f));
    }

    public Char getChar(String string, int n) {
        Object v = c.get(string);
        if (v == null) {
            throw new SymbolMappingNotFoundException(string);
        }
        return this.getChar((CharFont)v, n);
    }

    public Char getDefaultChar(char c2, int n) {
        if (c2 >= '0' && c2 <= '9') {
            return this.getChar(c2, a[0], n);
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return this.getChar(c2, a[2], n);
        }
        return this.getChar(c2, a[1], n);
    }

    public float getDefaultRuleThickness(int n) {
        return DefaultTeXFont.getParameter("defaultrulethickness") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getDenom1(int n) {
        return DefaultTeXFont.getParameter("denom1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getDenom2(int n) {
        return DefaultTeXFont.getParameter("denom2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public Extension getExtension(Char char_, int n) {
        Font font = char_.getFont();
        int n2 = char_.getFontCode();
        float f = DefaultTeXFont.getSizeFactor(n);
        FontInfo fontInfo = a[n2];
        int[] nArray = fontInfo.getExtension(char_.getChar());
        Char[] charArray = new Char[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            charArray[i] = nArray[i] == -1 ? null : new Char((char)nArray[i], font, n2, this.getMetrics(new CharFont((char)nArray[i], n2), f));
        }
        return new Extension(charArray[0], charArray[1], charArray[2], charArray[3]);
    }

    public float getKern(CharFont charFont, CharFont charFont2, int n) {
        if (charFont.a == charFont2.a) {
            FontInfo fontInfo = a[charFont.a];
            return fontInfo.getKern(charFont.a, charFont2.a, DefaultTeXFont.getSizeFactor(n) * TeXFormula.a);
        }
        return 0.0f;
    }

    public CharFont getLigature(CharFont charFont, CharFont charFont2) {
        if (charFont.a == charFont2.a) {
            FontInfo fontInfo = a[charFont.a];
            return fontInfo.getLigature(charFont.a, charFont2.a);
        }
        return null;
    }

    private Metrics getMetrics(CharFont charFont, float f) {
        FontInfo fontInfo = a[charFont.a];
        float[] fArray = fontInfo.getMetrics(charFont.a);
        return new Metrics(fArray[0], fArray[1], fArray[2], fArray[3], f * TeXFormula.a, f);
    }

    public int getMuFontId() {
        return ((Number)e.get("mufontid")).intValue();
    }

    public Char getNextLarger(Char char_, int n) {
        FontInfo fontInfo = a[char_.getFontCode()];
        CharFont charFont = fontInfo.getNextLarger(char_.getChar());
        FontInfo fontInfo2 = a[charFont.a];
        return new Char(charFont.a, fontInfo2.getFont(), charFont.a, this.getMetrics(charFont, DefaultTeXFont.getSizeFactor(n)));
    }

    public float getNum1(int n) {
        return DefaultTeXFont.getParameter("num1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getNum2(int n) {
        return DefaultTeXFont.getParameter("num2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getNum3(int n) {
        return DefaultTeXFont.getParameter("num3") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getQuad(int n, int n2) {
        FontInfo fontInfo = a[n2];
        return fontInfo.getQuad(DefaultTeXFont.getSizeFactor(n) * TeXFormula.a);
    }

    public float getSize() {
        return this.b;
    }

    public float getSkew(CharFont charFont, int n) {
        FontInfo fontInfo = a[charFont.a];
        char c2 = fontInfo.getSkewChar();
        if (c2 == '\uffffffff') {
            return 0.0f;
        }
        return this.getKern(charFont, new CharFont(c2, charFont.a), n);
    }

    public float getSpace(int n) {
        int n2 = ((Number)e.get("spacefontid")).intValue();
        FontInfo fontInfo = a[n2];
        return fontInfo.getSpace(DefaultTeXFont.getSizeFactor(n) * TeXFormula.a);
    }

    public float getSub1(int n) {
        return DefaultTeXFont.getParameter("sub1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getSub2(int n) {
        return DefaultTeXFont.getParameter("sub2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getSubDrop(int n) {
        return DefaultTeXFont.getParameter("subdrop") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getSup1(int n) {
        return DefaultTeXFont.getParameter("sup1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getSup2(int n) {
        return DefaultTeXFont.getParameter("sup2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getSup3(int n) {
        return DefaultTeXFont.getParameter("sup3") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getSupDrop(int n) {
        return DefaultTeXFont.getParameter("supdrop") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public float getXHeight(int n, int n2) {
        FontInfo fontInfo = a[n2];
        return fontInfo.getXHeight(DefaultTeXFont.getSizeFactor(n) * TeXFormula.a);
    }

    public float getEM(int n) {
        return DefaultTeXFont.getSizeFactor(n) * TeXFormula.a;
    }

    public boolean hasNextLarger(Char char_) {
        FontInfo fontInfo = a[char_.getFontCode()];
        return fontInfo.getNextLarger(char_.getChar()) != null;
    }

    public void setBold(boolean bl) {
        this.a = bl;
    }

    public boolean getBold() {
        return this.a;
    }

    public void setRoman(boolean bl) {
        this.b = bl;
    }

    public boolean getRoman() {
        return this.b;
    }

    public void setTt(boolean bl) {
        this.d = bl;
    }

    public boolean getTt() {
        return this.d;
    }

    public void setIt(boolean bl) {
        this.e = bl;
    }

    public boolean getIt() {
        return this.e;
    }

    public void setSs(boolean bl) {
        this.c = bl;
    }

    public boolean getSs() {
        return this.c;
    }

    public boolean hasSpace(int n) {
        FontInfo fontInfo = a[n];
        return fontInfo.hasSpace();
    }

    public boolean isExtensionChar(Char char_) {
        FontInfo fontInfo = a[char_.getFontCode()];
        return fontInfo.getExtension(char_.getChar()) != null;
    }

    public static void setMathSizes(float f, float f2, float f3, float f4) {
        if (DefaultTeXFont.f) {
            e.put("scriptfactor", Float.valueOf(Math.abs(f3 / f)));
            e.put("scriptscriptfactor", Float.valueOf(Math.abs(f4 / f)));
            e.put("textfactor", Float.valueOf(Math.abs(f2 / f)));
            TeXIcon.a = Math.abs(f);
        }
    }

    public static void setMagnification(float f) {
        if (DefaultTeXFont.f) {
            TeXIcon.b = f / 1000.0f;
        }
    }

    public static void enableMagnification(boolean bl) {
        f = bl;
    }

    private static float getParameter(String string) {
        Object v = d.get(string);
        if (v == null) {
            return 0.0f;
        }
        return ((Float)v).floatValue();
    }

    public static float getSizeFactor(int n) {
        if (n < 2) {
            return 1.0f;
        }
        if (n < 4) {
            return ((Number)e.get("textfactor")).floatValue();
        }
        if (n < 6) {
            return ((Number)e.get("scriptfactor")).floatValue();
        }
        return ((Number)e.get("scriptscriptfactor")).floatValue();
    }

    static {
        a = new FontInfo[0];
        f = true;
        a = new ArrayList();
        a = new HashMap();
        DefaultTeXFontParser defaultTeXFontParser = new DefaultTeXFontParser();
        a.add(Character.UnicodeBlock.of('a'));
        a = defaultTeXFontParser.parseFontDescriptions(a);
        d = defaultTeXFontParser.parseParameters();
        b = defaultTeXFontParser.parseTextStyleMappings();
        a = defaultTeXFontParser.parseDefaultTextStyleMappings();
        c = defaultTeXFontParser.parseSymbolMappings();
        e = defaultTeXFontParser.parseGeneralSettings();
        e.put("textfactor", 1);
        int n = ((Number)e.get("mufontid")).intValue();
        if (n < 0 || n >= a.length || a[n] == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", "GeneralSettings", "mufontid", "contains an unknown font id!");
        }
    }
}

