// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourcePrivatecaCaPool() *schema.Resource {
	return &schema.Resource{
		Create: resourcePrivatecaCaPoolCreate,
		Read:   resourcePrivatecaCaPoolRead,
		Update: resourcePrivatecaCaPoolUpdate,
		Delete: resourcePrivatecaCaPoolDelete,

		Importer: &schema.ResourceImporter{
			State: resourcePrivatecaCaPoolImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"location": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `Location of the CaPool. A full list of valid locations can be found by
running 'gcloud privateca locations list'.`,
			},
			"name": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The name for this CaPool.`,
			},
			"tier": {
				Type:         schema.TypeString,
				Required:     true,
				ForceNew:     true,
				ValidateFunc: validateEnum([]string{"ENTERPRISE", "DEVOPS"}),
				Description:  `The Tier of this CaPool. Possible values: ["ENTERPRISE", "DEVOPS"]`,
			},
			"issuance_policy": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The IssuancePolicy to control how Certificates will be issued from this CaPool.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"allowed_issuance_modes": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `IssuanceModes specifies the allowed ways in which Certificates may be requested from this CaPool.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"allow_config_based_issuance": {
										Type:        schema.TypeBool,
										Required:    true,
										Description: `When true, allows callers to create Certificates by specifying a CertificateConfig.`,
									},
									"allow_csr_based_issuance": {
										Type:        schema.TypeBool,
										Required:    true,
										Description: `When true, allows callers to create Certificates by specifying a CSR.`,
									},
								},
							},
						},
						"allowed_key_types": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `If any AllowedKeyType is specified, then the certificate request's public key must match one of the key types listed here.
Otherwise, any key may be used.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"elliptic_curve": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Represents an allowed Elliptic Curve key type.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"signature_algorithm": {
													Type:         schema.TypeString,
													Required:     true,
													ValidateFunc: validateEnum([]string{"ECDSA_P256", "ECDSA_P384", "EDDSA_25519"}),
													Description:  `The algorithm used. Possible values: ["ECDSA_P256", "ECDSA_P384", "EDDSA_25519"]`,
												},
											},
										},
									},
									"rsa": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Describes an RSA key that may be used in a Certificate issued from a CaPool.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"max_modulus_size": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `The maximum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
service will not enforce an explicit upper bound on RSA modulus sizes.`,
												},
												"min_modulus_size": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `The minimum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
service-level min RSA modulus size will continue to apply.`,
												},
											},
										},
									},
								},
							},
						},
						"baseline_values": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `A set of X.509 values that will be applied to all certificates issued through this CaPool. If a certificate request
includes conflicting values for the same properties, they will be overwritten by the values defined here. If a certificate
request uses a CertificateTemplate that defines conflicting predefinedValues for the same properties, the certificate
issuance request will fail.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"ca_options": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `Describes values that are relevant in a CA certificate.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"is_ca": {
													Type:        schema.TypeBool,
													Optional:    true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to true.`,
												},
												"max_issuer_path_length": {
													Type:     schema.TypeInt,
													Optional: true,
													Description: `Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.`,
												},
												"non_ca": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to false. 
If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.`,
												},
												"zero_max_issuer_path_length": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `When true, the "path length constraint" in Basic Constraints extension will be set to 0.
if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
the max path length will be omitted from the CA certificate.`,
												},
											},
										},
									},
									"key_usage": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `Indicates the intended use for keys that correspond to a certificate.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"base_key_usage": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"cert_sign": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used to sign certificates.`,
															},
															"content_commitment": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".`,
															},
															"crl_sign": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used sign certificate revocation lists.`,
															},
															"data_encipherment": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used to encipher data.`,
															},
															"decipher_only": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used to decipher only.`,
															},
															"digital_signature": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used for digital signatures.`,
															},
															"encipher_only": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used to encipher only.`,
															},
															"key_agreement": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used in a key agreement protocol.`,
															},
															"key_encipherment": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `The key may be used to encipher other keys.`,
															},
														},
													},
												},
												"extended_key_usage": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"client_auth": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.`,
															},
															"code_signing": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".`,
															},
															"email_protection": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".`,
															},
															"ocsp_signing": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".`,
															},
															"server_auth": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.`,
															},
															"time_stamping": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".`,
															},
														},
													},
												},
												"unknown_extended_key_usages": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Required:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
											},
										},
									},
									"additional_extensions": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"critical": {
													Type:     schema.TypeBool,
													Required: true,
													Description: `Indicates whether or not this extension is critical (i.e., if the client does not know how to
handle this extension, the client should consider this to be an error).`,
												},
												"object_id": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Describes values that are relevant in a CA certificate.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Required:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
												"value": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The value of this X.509 extension. A base64-encoded string.`,
												},
											},
										},
									},
									"aia_ocsp_servers": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
"Authority Information Access" extension in the certificate.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"policy_ids": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"object_id_path": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
											},
										},
									},
								},
							},
						},
						"identity_constraints": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Describes constraints on identities that may appear in Certificates issued through this CaPool.
If this is omitted, then this CaPool will not add restrictions on a certificate's identity.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"allow_subject_alt_names_passthrough": {
										Type:     schema.TypeBool,
										Required: true,
										Description: `If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
Otherwise, the requested SubjectAltNames will be discarded.`,
									},
									"allow_subject_passthrough": {
										Type:     schema.TypeBool,
										Required: true,
										Description: `If this is set, the Subject field may be copied from a certificate request into the signed certificate.
Otherwise, the requested Subject will be discarded.`,
									},
									"cel_expression": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a
certificate is signed. To see the full allowed syntax and some examples,
see https://cloud.google.com/certificate-authority-service/docs/cel-guide`,
										MaxItems: 1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"expression": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Textual representation of an expression in Common Expression Language syntax.`,
												},
												"description": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.`,
												},
												"location": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.`,
												},
												"title": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.`,
												},
											},
										},
									},
								},
							},
						},
						"maximum_lifetime": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority
expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.`,
						},
					},
				},
			},
			"labels": {
				Type:     schema.TypeMap,
				Optional: true,
				Description: `Labels with user-defined metadata.

An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
"1.3kg", "count": "3" }.`,
				Elem: &schema.Schema{Type: schema.TypeString},
			},
			"publishing_options": {
				Type:             schema.TypeList,
				Optional:         true,
				DiffSuppressFunc: emptyOrUnsetBlockDiffSuppress,
				Description:      `The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.`,
				MaxItems:         1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"publish_ca_cert": {
							Type:     schema.TypeBool,
							Required: true,
							Description: `When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access"
X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding
X.509 extension will not be written in issued certificates.`,
						},
						"publish_crl": {
							Type:     schema.TypeBool,
							Required: true,
							Description: `When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension
in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not
be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are
also rebuilt shortly after a certificate is revoked.`,
						},
					},
				},
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourcePrivatecaCaPoolCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	tierProp, err := expandPrivatecaCaPoolTier(d.Get("tier"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("tier"); !isEmptyValue(reflect.ValueOf(tierProp)) && (ok || !reflect.DeepEqual(v, tierProp)) {
		obj["tier"] = tierProp
	}
	issuancePolicyProp, err := expandPrivatecaCaPoolIssuancePolicy(d.Get("issuance_policy"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("issuance_policy"); !isEmptyValue(reflect.ValueOf(issuancePolicyProp)) && (ok || !reflect.DeepEqual(v, issuancePolicyProp)) {
		obj["issuancePolicy"] = issuancePolicyProp
	}
	publishingOptionsProp, err := expandPrivatecaCaPoolPublishingOptions(d.Get("publishing_options"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("publishing_options"); !isEmptyValue(reflect.ValueOf(publishingOptionsProp)) && (ok || !reflect.DeepEqual(v, publishingOptionsProp)) {
		obj["publishingOptions"] = publishingOptionsProp
	}
	labelsProp, err := expandPrivatecaCaPoolLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(labelsProp)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools?caPoolId={{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new CaPool: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CaPool: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating CaPool: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Use the resource in the operation response to populate
	// identity fields and d.Id() before read
	var opRes map[string]interface{}
	err = privatecaOperationWaitTimeWithResponse(
		config, res, &opRes, project, "Creating CaPool", userAgent,
		d.Timeout(schema.TimeoutCreate))
	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create CaPool: %s", err)
	}

	// This may have caused the ID to update - update it if so.
	id, err = replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating CaPool %q: %#v", d.Id(), res)

	return resourcePrivatecaCaPoolRead(d, meta)
}

func resourcePrivatecaCaPoolRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CaPool: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("PrivatecaCaPool %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading CaPool: %s", err)
	}

	if err := d.Set("tier", flattenPrivatecaCaPoolTier(res["tier"], d, config)); err != nil {
		return fmt.Errorf("Error reading CaPool: %s", err)
	}
	if err := d.Set("issuance_policy", flattenPrivatecaCaPoolIssuancePolicy(res["issuancePolicy"], d, config)); err != nil {
		return fmt.Errorf("Error reading CaPool: %s", err)
	}
	if err := d.Set("publishing_options", flattenPrivatecaCaPoolPublishingOptions(res["publishingOptions"], d, config)); err != nil {
		return fmt.Errorf("Error reading CaPool: %s", err)
	}
	if err := d.Set("labels", flattenPrivatecaCaPoolLabels(res["labels"], d, config)); err != nil {
		return fmt.Errorf("Error reading CaPool: %s", err)
	}

	return nil
}

func resourcePrivatecaCaPoolUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CaPool: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	issuancePolicyProp, err := expandPrivatecaCaPoolIssuancePolicy(d.Get("issuance_policy"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("issuance_policy"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, issuancePolicyProp)) {
		obj["issuancePolicy"] = issuancePolicyProp
	}
	publishingOptionsProp, err := expandPrivatecaCaPoolPublishingOptions(d.Get("publishing_options"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("publishing_options"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, publishingOptionsProp)) {
		obj["publishingOptions"] = publishingOptionsProp
	}
	labelsProp, err := expandPrivatecaCaPoolLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating CaPool %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("issuance_policy") {
		updateMask = append(updateMask, "issuancePolicy")
	}

	if d.HasChange("publishing_options") {
		updateMask = append(updateMask, "publishingOptions")
	}

	if d.HasChange("labels") {
		updateMask = append(updateMask, "labels")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating CaPool %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating CaPool %q: %#v", d.Id(), res)
	}

	err = privatecaOperationWaitTime(
		config, res, project, "Updating CaPool", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourcePrivatecaCaPoolRead(d, meta)
}

func resourcePrivatecaCaPoolDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CaPool: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting CaPool %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "CaPool")
	}

	err = privatecaOperationWaitTime(
		config, res, project, "Deleting CaPool", userAgent,
		d.Timeout(schema.TimeoutDelete))

	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Finished deleting CaPool %q: %#v", d.Id(), res)
	return nil
}

func resourcePrivatecaCaPoolImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/caPools/(?P<name>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<name>[^/]+)",
		"(?P<location>[^/]+)/(?P<name>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenPrivatecaCaPoolTier(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allowed_key_types"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypes(original["allowedKeyTypes"], d, config)
	transformed["maximum_lifetime"] =
		flattenPrivatecaCaPoolIssuancePolicyMaximumLifetime(original["maximumLifetime"], d, config)
	transformed["allowed_issuance_modes"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedIssuanceModes(original["allowedIssuanceModes"], d, config)
	transformed["identity_constraints"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraints(original["identityConstraints"], d, config)
	transformed["baseline_values"] =
		flattenPrivatecaCaPoolIssuancePolicyBaselineValues(original["baselineValues"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"rsa":            flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa(original["rsa"], d, config),
			"elliptic_curve": flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve(original["ellipticCurve"], d, config),
		})
	}
	return transformed
}
func flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["min_modulus_size"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMinModulusSize(original["minModulusSize"], d, config)
	transformed["max_modulus_size"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMaxModulusSize(original["maxModulusSize"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMinModulusSize(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMaxModulusSize(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["signature_algorithm"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveSignatureAlgorithm(original["signatureAlgorithm"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveSignatureAlgorithm(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyMaximumLifetime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyAllowedIssuanceModes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allow_csr_based_issuance"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowCsrBasedIssuance(original["allowCsrBasedIssuance"], d, config)
	transformed["allow_config_based_issuance"] =
		flattenPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowConfigBasedIssuance(original["allowConfigBasedIssuance"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowCsrBasedIssuance(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowConfigBasedIssuance(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraints(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allow_subject_passthrough"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectPassthrough(original["allowSubjectPassthrough"], d, config)
	transformed["allow_subject_alt_names_passthrough"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectAltNamesPassthrough(original["allowSubjectAltNamesPassthrough"], d, config)
	transformed["cel_expression"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression(original["celExpression"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectPassthrough(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectAltNamesPassthrough(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["expression"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionExpression(original["expression"], d, config)
	transformed["title"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionTitle(original["title"], d, config)
	transformed["description"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionDescription(original["description"], d, config)
	transformed["location"] =
		flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionLocation(original["location"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionExpression(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionTitle(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionLocation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolIssuancePolicyBaselineValues(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		v = make(map[string]interface{})
	}
	original := v.(map[string]interface{})
	transformed := make(map[string]interface{})
	transformed["additional_extensions"] =
		flattenPrivatecaCertificateConfigX509ConfigAdditionalExtensions(original["additionalExtensions"], d, config)
	transformed["policy_ids"] =
		flattenPrivatecaCertificateConfigX509ConfigPolicyIds(original["policyIds"], d, config)
	transformed["aia_ocsp_servers"] = flattenPrivatecaCertificateConfigX509ConfigAiaOcspServers(original["aiaOcspServers"], d, config)
	transformed["ca_options"] =
		flattenPrivatecaCertificateConfigX509ConfigCaOptions(original["caOptions"], d, config)
	transformed["key_usage"] =
		flattenPrivatecaCertificateConfigX509ConfigKeyUsage(original["keyUsage"], d, config)
	return []interface{}{transformed}
}

func flattenPrivatecaCaPoolPublishingOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["publish_ca_cert"] =
		flattenPrivatecaCaPoolPublishingOptionsPublishCaCert(original["publishCaCert"], d, config)
	transformed["publish_crl"] =
		flattenPrivatecaCaPoolPublishingOptionsPublishCrl(original["publishCrl"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCaPoolPublishingOptionsPublishCaCert(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolPublishingOptionsPublishCrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCaPoolLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandPrivatecaCaPoolTier(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowedKeyTypes, err := expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypes(original["allowed_key_types"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedKeyTypes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedKeyTypes"] = transformedAllowedKeyTypes
	}

	transformedMaximumLifetime, err := expandPrivatecaCaPoolIssuancePolicyMaximumLifetime(original["maximum_lifetime"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaximumLifetime); val.IsValid() && !isEmptyValue(val) {
		transformed["maximumLifetime"] = transformedMaximumLifetime
	}

	transformedAllowedIssuanceModes, err := expandPrivatecaCaPoolIssuancePolicyAllowedIssuanceModes(original["allowed_issuance_modes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedIssuanceModes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedIssuanceModes"] = transformedAllowedIssuanceModes
	}

	transformedIdentityConstraints, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraints(original["identity_constraints"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIdentityConstraints); val.IsValid() && !isEmptyValue(val) {
		transformed["identityConstraints"] = transformedIdentityConstraints
	}

	transformedBaselineValues, err := expandPrivatecaCaPoolIssuancePolicyBaselineValues(original["baseline_values"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBaselineValues); val.IsValid() && !isEmptyValue(val) {
		transformed["baselineValues"] = transformedBaselineValues
	}

	return transformed, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedRsa, err := expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa(original["rsa"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRsa); val.IsValid() && !isEmptyValue(val) {
			transformed["rsa"] = transformedRsa
		}

		transformedEllipticCurve, err := expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve(original["elliptic_curve"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEllipticCurve); val.IsValid() && !isEmptyValue(val) {
			transformed["ellipticCurve"] = transformedEllipticCurve
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMinModulusSize, err := expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMinModulusSize(original["min_modulus_size"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinModulusSize); val.IsValid() && !isEmptyValue(val) {
		transformed["minModulusSize"] = transformedMinModulusSize
	}

	transformedMaxModulusSize, err := expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMaxModulusSize(original["max_modulus_size"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxModulusSize); val.IsValid() && !isEmptyValue(val) {
		transformed["maxModulusSize"] = transformedMaxModulusSize
	}

	return transformed, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMinModulusSize(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaMaxModulusSize(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSignatureAlgorithm, err := expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveSignatureAlgorithm(original["signature_algorithm"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSignatureAlgorithm); val.IsValid() && !isEmptyValue(val) {
		transformed["signatureAlgorithm"] = transformedSignatureAlgorithm
	}

	return transformed, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveSignatureAlgorithm(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyMaximumLifetime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedIssuanceModes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowCsrBasedIssuance, err := expandPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowCsrBasedIssuance(original["allow_csr_based_issuance"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowCsrBasedIssuance); val.IsValid() && !isEmptyValue(val) {
		transformed["allowCsrBasedIssuance"] = transformedAllowCsrBasedIssuance
	}

	transformedAllowConfigBasedIssuance, err := expandPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowConfigBasedIssuance(original["allow_config_based_issuance"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowConfigBasedIssuance); val.IsValid() && !isEmptyValue(val) {
		transformed["allowConfigBasedIssuance"] = transformedAllowConfigBasedIssuance
	}

	return transformed, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowCsrBasedIssuance(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyAllowedIssuanceModesAllowConfigBasedIssuance(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraints(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowSubjectPassthrough, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectPassthrough(original["allow_subject_passthrough"], d, config)
	if err != nil {
		return nil, err
	} else {
		transformed["allowSubjectPassthrough"] = transformedAllowSubjectPassthrough
	}

	transformedAllowSubjectAltNamesPassthrough, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectAltNamesPassthrough(original["allow_subject_alt_names_passthrough"], d, config)
	if err != nil {
		return nil, err
	} else {
		transformed["allowSubjectAltNamesPassthrough"] = transformedAllowSubjectAltNamesPassthrough
	}

	transformedCelExpression, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression(original["cel_expression"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCelExpression); val.IsValid() && !isEmptyValue(val) {
		transformed["celExpression"] = transformedCelExpression
	}

	return transformed, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectPassthrough(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsAllowSubjectAltNamesPassthrough(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedExpression, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionExpression(original["expression"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExpression); val.IsValid() && !isEmptyValue(val) {
		transformed["expression"] = transformedExpression
	}

	transformedTitle, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionTitle(original["title"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTitle); val.IsValid() && !isEmptyValue(val) {
		transformed["title"] = transformedTitle
	}

	transformedDescription, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionDescription(original["description"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDescription); val.IsValid() && !isEmptyValue(val) {
		transformed["description"] = transformedDescription
	}

	transformedLocation, err := expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionLocation(original["location"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocation); val.IsValid() && !isEmptyValue(val) {
		transformed["location"] = transformedLocation
	}

	return transformed, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionExpression(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionTitle(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionLocation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolIssuancePolicyBaselineValues(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	if v == nil {
		return v, nil
	}
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	if len(original) == 0 {
		return nil, nil
	}
	transformed := make(map[string]interface{})

	caOptions, err := expandPrivatecaCertificateConfigX509ConfigCaOptions(original["ca_options"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["caOptions"] = caOptions

	keyUsage, err := expandPrivatecaCertificateConfigX509ConfigKeyUsage(original["key_usage"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["keyUsage"] = keyUsage

	policyIds, err := expandPrivatecaCertificateConfigX509ConfigPolicyIds(original["policy_ids"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["policyIds"] = policyIds

	aiaOcspServers, err := expandPrivatecaCertificateConfigX509ConfigAiaOcspServers(original["aia_ocsp_servers"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["aiaOcspServers"] = aiaOcspServers

	addExts, err := expandPrivatecaCertificateConfigX509ConfigAdditionalExtensions(original["additional_extensions"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["additionalExtensions"] = addExts

	return transformed, nil
}

func expandPrivatecaCaPoolPublishingOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPublishCaCert, err := expandPrivatecaCaPoolPublishingOptionsPublishCaCert(original["publish_ca_cert"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPublishCaCert); val.IsValid() && !isEmptyValue(val) {
		transformed["publishCaCert"] = transformedPublishCaCert
	}

	transformedPublishCrl, err := expandPrivatecaCaPoolPublishingOptionsPublishCrl(original["publish_crl"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPublishCrl); val.IsValid() && !isEmptyValue(val) {
		transformed["publishCrl"] = transformedPublishCrl
	}

	return transformed, nil
}

func expandPrivatecaCaPoolPublishingOptionsPublishCaCert(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolPublishingOptionsPublishCrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCaPoolLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}
