/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypeInfo;

public abstract class TypedNotationConverter<N, T>
implements NotationConverter<Object, T> {
    private final Class<N> typeToken;

    public TypedNotationConverter(Class<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken;
    }

    public TypedNotationConverter(TypeInfo<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken.getTargetType();
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate(String.format("Instances of %s.", this.typeToken.getSimpleName()));
    }

    public void convert(Object notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        if (this.typeToken.isInstance(notation)) {
            result.converted(this.parseType(this.typeToken.cast(notation)));
        }
    }

    protected abstract T parseType(N var1);
}

