/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import net.i2p.i2ptunnel.access.FilterDefinitionElement;
import net.i2p.i2ptunnel.access.Recorder;
import net.i2p.i2ptunnel.access.Threshold;

class FilterDefinition {
    private final Threshold defaultThreshold;
    private final FilterDefinitionElement[] elements;
    private final Recorder[] recorders;
    private final int purgeSeconds;

    FilterDefinition(Threshold defaultThreshold, FilterDefinitionElement[] elements, Recorder[] recorders) {
        this.defaultThreshold = defaultThreshold;
        this.elements = elements;
        this.recorders = recorders;
        int maxSeconds = defaultThreshold.getSeconds();
        for (FilterDefinitionElement element : elements) {
            maxSeconds = Math.max(maxSeconds, element.getThreshold().getSeconds());
        }
        for (Recorder recorder : recorders) {
            maxSeconds = Math.max(maxSeconds, recorder.getThreshold().getSeconds());
        }
        this.purgeSeconds = maxSeconds;
    }

    Threshold getDefaultThreshold() {
        return this.defaultThreshold;
    }

    FilterDefinitionElement[] getElements() {
        return this.elements;
    }

    Recorder[] getRecorders() {
        return this.recorders;
    }

    int getPurgeSeconds() {
        return this.purgeSeconds;
    }
}

