/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.LookupResult;
import net.i2p.client.impl.ClientWriterRunner;
import net.i2p.client.impl.I2CPMessageHandler;
import net.i2p.client.impl.I2CPMessageProducer;
import net.i2p.client.impl.I2PClientMessageHandlerMap;
import net.i2p.client.impl.LkupResult;
import net.i2p.client.impl.SessionIdleTimer;
import net.i2p.client.impl.SubSession;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.Base32;
import net.i2p.data.BlindData;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2cp.BlindingInfoMessage;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.HostLookupMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.internal.I2CPMessageQueue;
import net.i2p.internal.InternalClientManager;
import net.i2p.internal.QueuedI2CPMessageReader;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public abstract class I2PSessionImpl
implements I2PSession,
I2CPMessageReader.I2CPMessageEventListener {
    protected final Log _log;
    private final Destination _myDestination;
    private PrivateKey _privateKey;
    private SigningPrivateKey _signingPrivateKey;
    private final Properties _options;
    private SessionId _sessionId;
    protected volatile LeaseSet _leaseSet;
    private long _offlineExpiration;
    private Signature _offlineSignature;
    protected SigningPublicKey _transientSigningPublicKey;
    private final List<SubSession> _subsessions;
    private final ConcurrentHashMap<SessionId, SubSession> _subsessionMap;
    private final Object _subsessionLock = new Object();
    private static final String MIN_SUBSESSION_VERSION = "0.9.21";
    private volatile boolean _routerSupportsSubsessions;
    protected final String _hostname;
    protected final int _portNum;
    protected Socket _socket;
    protected I2CPMessageReader _reader;
    protected ClientWriterRunner _writer;
    protected I2CPMessageQueue _queue;
    protected I2PSessionListener _sessionListener;
    protected final I2CPMessageProducer _producer;
    protected Map<Long, MessagePayloadMessage> _availableMessages;
    protected final LinkedBlockingQueue<LookupWaiter> _pendingLookups = new LinkedBlockingQueue();
    private final AtomicInteger _lookupID = new AtomicInteger();
    protected final Object _bwReceivedLock = new Object();
    protected volatile int[] _bwLimits;
    private volatile String _routerVersion;
    protected final I2PClientMessageHandlerMap _handlerMap;
    protected final I2PAppContext _context;
    protected final Object _leaseSetWait = new Object();
    private String _errorMessage;
    private Throwable _errorCause;
    private static final Set<State> STATES_CLOSED = EnumSet.of(State.INIT, State.CLOSED);
    private static final Set<State> STATES_OPENING = EnumSet.of(State.INIT, State.OPENING);
    private static final Set<State> STATES_CLOSED_OR_OPENING = EnumSet.of(State.INIT, State.CLOSED, State.OPENING);
    private static final Set<State> STATES_CLOSED_OR_CLOSING = EnumSet.of(State.INIT, State.CLOSED, State.CLOSING);
    protected State _state = State.INIT;
    protected final Object _stateLock = new Object();
    protected AvailabilityNotifier _availabilityNotifier;
    private long _lastActivity;
    private boolean _isReduced;
    private final boolean _fastReceive;
    private volatile boolean _routerSupportsFastReceive;
    private volatile boolean _routerSupportsHostLookup;
    private volatile boolean _routerSupportsLS2;
    private volatile boolean _routerSupportsBlindingInfo;
    protected static final int CACHE_MAX_SIZE = SystemVersion.isAndroid() ? 32 : 128;
    private static final Map<Object, Destination> _lookupCache = new LHMCache<Object, Destination>(CACHE_MAX_SIZE);
    private static final String MIN_HOST_LOOKUP_VERSION = "0.9.11";
    protected static final String PROP_DOMAIN_SOCKET = "i2cp.domainSocket";
    private static final long VERIFY_USAGE_TIME = 60000L;
    private static final long MAX_SEND_WAIT = 10000L;
    private static final String MIN_FAST_VERSION = "0.9.4";
    private static final String MIN_LS2_VERSION = "0.9.38";
    private static final String MIN_BLINDINFO_VERSION = "0.9.43";
    public static final int LISTEN_PORT = 7654;
    private static final int BUF_SIZE = 32768;
    private static final SessionId DUMMY_SESSION = new SessionId(65535);
    private static final int MAX_RECONNECT_DELAY = 320000;
    private static final int BASE_RECONNECT_DELAY = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dateUpdated(String routerVersion) {
        this._routerVersion = routerVersion;
        boolean isrc = this._context.isRouterContext();
        this._routerSupportsFastReceive = isrc || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_FAST_VERSION) >= 0;
        this._routerSupportsHostLookup = isrc || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_HOST_LOOKUP_VERSION) >= 0;
        this._routerSupportsSubsessions = isrc || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_SUBSESSION_VERSION) >= 0;
        this._routerSupportsLS2 = isrc || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_LS2_VERSION) >= 0;
        this._routerSupportsBlindingInfo = isrc || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_BLINDINFO_VERSION) >= 0;
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.OPENING) {
                this.changeState(State.GOTDATE);
            }
        }
    }

    protected I2PSessionImpl(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap) {
        this(context, options, handlerMap, null, false);
    }

    protected I2PSessionImpl(I2PSessionImpl primary, InputStream destKeyStream, Properties options) throws I2PSessionException {
        this(primary.getContext(), options, primary.getHandlerMap(), primary.getProducer(), true);
        this._availabilityNotifier = new AvailabilityNotifier();
        try {
            this.readDestination(destKeyStream);
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Error reading the destination key stream", dfe);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error reading the destination key stream", ioe);
        }
    }

    private I2PSessionImpl(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap, I2CPMessageProducer producer, boolean hasDest) {
        boolean isrc;
        this._context = context;
        this._handlerMap = handlerMap;
        this._log = context.logManager().getLog(this.getClass());
        this._subsessions = new CopyOnWriteArrayList<SubSession>();
        this._subsessionMap = new ConcurrentHashMap(4);
        if (options == null) {
            options = (Properties)System.getProperties().clone();
        }
        this._options = this.loadConfig(options);
        this._hostname = this.getHost();
        this._portNum = this.getPort();
        this._fastReceive = Boolean.parseBoolean(this._options.getProperty("i2cp.fastReceive"));
        if (hasDest) {
            this._producer = producer;
            this._availableMessages = new ConcurrentHashMap<Long, MessagePayloadMessage>();
            this._myDestination = new Destination();
            this._privateKey = new PrivateKey();
            this._signingPrivateKey = new SigningPrivateKey();
        } else {
            this._producer = null;
            this._availableMessages = null;
            this._myDestination = null;
            this._privateKey = null;
            this._signingPrivateKey = null;
        }
        this._routerSupportsFastReceive = isrc = this._context.isRouterContext();
        this._routerSupportsHostLookup = isrc;
        this._routerSupportsSubsessions = isrc;
        this._routerSupportsLS2 = isrc;
    }

    public I2PSessionImpl(I2PAppContext context, InputStream destKeyStream, Properties options) throws I2PSessionException {
        this(context, options, new I2PClientMessageHandlerMap(context), new I2CPMessageProducer(context), true);
        this._availabilityNotifier = new AvailabilityNotifier();
        try {
            this.readDestination(destKeyStream);
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Error reading the destination key stream", dfe);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error reading the destination key stream", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public I2PSession addSubsession(InputStream privateKeyStream, Properties opts) throws I2PSessionException {
        SubSession sub;
        if (!this._routerSupportsSubsessions) {
            throw new I2PSessionException("Router does not support subsessions");
        }
        Object object = this._subsessionLock;
        synchronized (object) {
            if (this._subsessions.size() > this._subsessionMap.size()) {
                throw new I2PSessionException("Subsession request already pending");
            }
            sub = new SubSession((I2PSession)this, privateKeyStream, opts);
            for (SubSession ss : this._subsessions) {
                if (!ss.getDecryptionKey().equals(sub.getDecryptionKey()) || !ss.getPrivateKey().equals(sub.getPrivateKey())) continue;
                throw new I2PSessionException("Dup subsession");
            }
            this._subsessions.add(sub);
        }
        object = this._stateLock;
        synchronized (object) {
            if (this._state == State.OPEN) {
                this._producer.connect(sub);
            }
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubsession(I2PSession session) {
        if (!(session instanceof SubSession)) {
            return;
        }
        Object object = this._subsessionLock;
        synchronized (object) {
            this._subsessions.remove(session);
            SessionId id = ((SubSession)session).getSessionId();
            if (id != null) {
                this._subsessionMap.remove(id);
            }
            try {
                session.destroySession();
            }
            catch (I2PSessionException i2PSessionException) {
                // empty catch block
            }
        }
        Destination d = session.getMyDestination();
        if (d != null) {
            this._context.keyRing().remove(d.calculateHash());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<I2PSession> getSubsessions() {
        Object object = this._subsessionLock;
        synchronized (object) {
            return new ArrayList<I2PSession>(this._subsessions);
        }
    }

    private final Properties loadConfig(Properties opts) {
        Properties options = new Properties();
        options.putAll((Map<?, ?>)this.filter(opts));
        if (!(this._context.isRouterContext() || !this._context.getBooleanProperty("i2cp.auth") || opts.containsKey("i2cp.username") && opts.containsKey("i2cp.password"))) {
            String configUser = this._context.getProperty("i2cp.username");
            String configPW = this._context.getProperty("i2cp.password");
            if (configUser != null && configPW != null) {
                options.setProperty("i2cp.username", configUser);
                options.setProperty("i2cp.password", configPW);
            }
        }
        if (options.getProperty("i2cp.fastReceive") == null) {
            options.setProperty("i2cp.fastReceive", "true");
        }
        if (options.getProperty("i2cp.messageReliability") == null) {
            options.setProperty("i2cp.messageReliability", "none");
        }
        return options;
    }

    private String getHost() {
        if (this._context.isRouterContext()) {
            return "[internal connection]";
        }
        if (SystemVersion.isAndroid() && Boolean.parseBoolean(this._options.getProperty(PROP_DOMAIN_SOCKET))) {
            return "[Domain socket connection]";
        }
        return this._options.getProperty("i2cp.tcp.host", "127.0.0.1");
    }

    private int getPort() {
        if (this._context.isRouterContext() || SystemVersion.isAndroid() && Boolean.parseBoolean(this._options.getProperty(PROP_DOMAIN_SOCKET))) {
            return 0;
        }
        String portNum = this._options.getProperty("i2cp.tcp.port", "7654");
        try {
            return Integer.parseInt(portNum);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Invalid port number specified, defaulting to " + 7654, nfe);
            }
            return 7654;
        }
    }

    private Properties filter(Properties options) {
        Properties rv = new Properties();
        for (String key : options.stringPropertyNames()) {
            if (key.startsWith("java.") || key.startsWith("user.") || key.startsWith("os.") || key.startsWith("sun.") || key.startsWith("awt.") || key.startsWith("file.") || key.equals("line.separator") || key.equals("path.separator") || key.equals("prng.buffers") || key.equals("router.trustedUpdateKeys") || key.startsWith("router.update") || key.startsWith("routerconsole.") || key.startsWith("time.") || key.startsWith("stat.") || key.startsWith("gnu.") || key.startsWith("net.i2p.router.web.") || key.equals("loggerFilenameOverride") || key.equals("router.version") || key.equals("i2p.dir.base") || key.equals("i2p.reseedURL") || key.startsWith("networkaddress.cache.") || key.startsWith("http.") || key.startsWith("jetty.") || key.startsWith("org.mortbay.") || key.startsWith("wrapper.")) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping property: " + key);
                continue;
            }
            String val = options.getProperty(key);
            rv.setProperty(key, val);
        }
        return rv;
    }

    @Override
    public void updateOptions(Properties options) {
        this._options.putAll((Map<?, ?>)this.filter(options));
        this._producer.updateBandwidth(this);
        try {
            this._producer.updateTunnels(this, 0);
        }
        catch (I2PSessionException i2PSessionException) {
            // empty catch block
        }
    }

    public boolean getFastReceive() {
        return this._fastReceive && this._routerSupportsFastReceive;
    }

    public boolean supportsLS2() {
        return this._routerSupportsLS2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLeaseSet(LeaseSet ls) {
        this._leaseSet = ls;
        if (ls != null) {
            Object object = this._leaseSetWait;
            synchronized (object) {
                this._leaseSetWait.notifyAll();
            }
        }
    }

    LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(State state) {
        if (this._log.shouldInfo()) {
            this._log.info(this.getPrefix() + "Change state to " + (Object)((Object)state));
        }
        Object object = this._stateLock;
        synchronized (object) {
            this._state = state;
            this._stateLock.notifyAll();
        }
    }

    private void readDestination(InputStream destKeyStream) throws DataFormatException, IOException {
        this._myDestination.readBytes(destKeyStream);
        EncType etype = this._myDestination.getPublicKey().getType();
        if (etype != EncType.ELGAMAL_2048) {
            this._privateKey = new PrivateKey(etype);
        }
        this._privateKey.readBytes(destKeyStream);
        SigType dtype = this._myDestination.getSigningPublicKey().getType();
        this._signingPrivateKey = new SigningPrivateKey(dtype);
        this._signingPrivateKey.readBytes(destKeyStream);
        if (this._signingPrivateKey.isOffline()) {
            this._offlineExpiration = DataHelper.readLong(destKeyStream, 4) * 1000L;
            int itype = (int)DataHelper.readLong(destKeyStream, 2);
            SigType type = SigType.getByCode(itype);
            if (type == null) {
                throw new DataFormatException("Unsupported transient sig type: " + itype);
            }
            this._transientSigningPublicKey = new SigningPublicKey(type);
            this._transientSigningPublicKey.readBytes(destKeyStream);
            this._offlineSignature = new Signature(dtype);
            this._offlineSignature.readBytes(destKeyStream);
            this._signingPrivateKey = new SigningPrivateKey(type);
            this._signingPrivateKey.readBytes(destKeyStream);
        }
    }

    @Override
    public boolean isOffline() {
        return this._offlineSignature != null;
    }

    @Override
    public long getOfflineExpiration() {
        return this._offlineExpiration;
    }

    @Override
    public Signature getOfflineSignature() {
        return this._offlineSignature;
    }

    @Override
    public SigningPublicKey getTransientSigningPublicKey() {
        return this._transientSigningPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws I2PSessionException {
        Object object = this._stateLock;
        synchronized (object) {
            boolean wasOpening = false;
            boolean loop = true;
            while (loop) {
                switch (this._state) {
                    case INIT: {
                        loop = false;
                        break;
                    }
                    case CLOSED: {
                        if (wasOpening) {
                            throw new I2PSessionException("connect by other thread failed");
                        }
                        loop = false;
                        break;
                    }
                    case OPENING: 
                    case GOTDATE: {
                        wasOpening = true;
                        try {
                            this._stateLock.wait(10000L);
                            break;
                        }
                        catch (InterruptedException ie) {
                            throw new I2PSessionException("Interrupted", ie);
                        }
                    }
                    case CLOSING: {
                        throw new I2PSessionException("close in progress");
                    }
                    case OPEN: {
                        return;
                    }
                }
            }
            this.changeState(State.OPENING);
        }
        this._availabilityNotifier.stopNotifying();
        if (this._options != null && "Guaranteed".equals(this._options.getProperty("i2cp.messageReliability", "BestEffort")) && this._log.shouldLog(40)) {
            this._log.error("I2CP guaranteed delivery mode has been removed, using best effort.");
        }
        boolean success = false;
        long startConnect = this._context.clock().now();
        try {
            Object in;
            Object ie = this._stateLock;
            synchronized (ie) {
                this._errorMessage = null;
                this._errorCause = null;
                if (this._context.isRouterContext()) {
                    InternalClientManager mgr = this._context.internalClientManager();
                    if (mgr == null) {
                        throw new I2PSessionException("Router is not ready for connections");
                    }
                    this._queue = mgr.connect();
                    this._reader = new QueuedI2CPMessageReader(this._queue, (I2CPMessageReader.I2CPMessageEventListener)this);
                } else {
                    block76: {
                        if (SystemVersion.isAndroid() && this._options.getProperty(PROP_DOMAIN_SOCKET) != null) {
                            try {
                                Class<?> clazz = Class.forName("net.i2p.client.DomainSocketFactory");
                                Constructor<?> ctor = clazz.getDeclaredConstructor(I2PAppContext.class);
                                Object fact = ctor.newInstance(this._context);
                                Method createSocket = clazz.getDeclaredMethod("createSocket", String.class);
                                try {
                                    this._socket = (Socket)createSocket.invoke(fact, this._options.getProperty(PROP_DOMAIN_SOCKET));
                                    break block76;
                                }
                                catch (InvocationTargetException e) {
                                    throw new I2PSessionException("Cannot create domain socket", e);
                                }
                            }
                            catch (ClassNotFoundException e) {
                                throw new I2PSessionException("Cannot load DomainSocketFactory", e);
                            }
                            catch (NoSuchMethodException e) {
                                throw new I2PSessionException("Cannot load DomainSocketFactory", e);
                            }
                            catch (InstantiationException e) {
                                throw new I2PSessionException("Cannot load DomainSocketFactory", e);
                            }
                            catch (IllegalAccessException e) {
                                throw new I2PSessionException("Cannot load DomainSocketFactory", e);
                            }
                            catch (InvocationTargetException e) {
                                throw new I2PSessionException("Cannot load DomainSocketFactory", e);
                            }
                        }
                        if (Boolean.parseBoolean(this._options.getProperty("i2cp.SSL"))) {
                            try {
                                I2PSSLSocketFactory fact = new I2PSSLSocketFactory(this._context, false, "certificates/i2cp");
                                this._socket = fact.createSocket(this._hostname, this._portNum);
                                this._socket.setKeepAlive(true);
                            }
                            catch (GeneralSecurityException gse) {
                                IOException ioe = new IOException("SSL Fail");
                                ioe.initCause(gse);
                                throw ioe;
                            }
                        } else {
                            this._socket = new Socket(this._hostname, this._portNum);
                            this._socket.setKeepAlive(true);
                        }
                    }
                    OutputStream out = this._socket.getOutputStream();
                    out.write(42);
                    out.flush();
                    this._writer = new ClientWriterRunner(out, this);
                    this._writer.startWriting();
                    in = new BufferedInputStream(this._socket.getInputStream(), 32768);
                    this._reader = new I2CPMessageReader((InputStream)in, this);
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "before startReading");
            }
            this._reader.startReading();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Before getDate");
            }
            Object auth = null;
            if (!this._context.isRouterContext() && this._options.containsKey("i2cp.username") && this._options.containsKey("i2cp.password")) {
                auth = new OrderedProperties();
                ((Properties)auth).setProperty("i2cp.username", this._options.getProperty("i2cp.username"));
                ((Properties)auth).setProperty("i2cp.password", this._options.getProperty("i2cp.password"));
            }
            this.sendMessage_unchecked(new GetDateMessage("0.9.59", (Properties)auth));
            this.waitForDate();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Before producer.connect()");
            }
            this._producer.connect(this);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "After producer.connect()");
            }
            int waitcount = 0;
            while (this._leaseSet == null) {
                if (waitcount++ > 300) {
                    throw new IOException("No tunnels built after waiting 5 minutes. Your network connection may be down, or there is severe network congestion.");
                }
                in = this._leaseSetWait;
                synchronized (in) {
                    this._leaseSetWait.wait(1000L);
                }
                in = this._stateLock;
                synchronized (in) {
                    if (this.isClosed()) {
                        String msg = "Disconnected from router while waiting for tunnels";
                        if (this._errorMessage != null) {
                            msg = msg + ": " + this._errorMessage;
                        }
                        IOException ioe = new IOException(msg);
                        if (this._errorCause != null) {
                            ioe.initCause(this._errorCause);
                        }
                        throw ioe;
                    }
                }
            }
            if (this._log.shouldLog(20)) {
                long connected = this._context.clock().now();
                this._log.info(this.getPrefix() + "Lease set created with inbound tunnels after " + (connected - startConnect) + "ms - ready to participate in the network!");
            }
            I2PAppThread notifier = new I2PAppThread(this._availabilityNotifier, "ClientNotifier " + this.getName(), true);
            ((Thread)notifier).start();
            this.startIdleMonitor();
            this.startVerifyUsage();
            success = true;
            Object object2 = this._subsessionLock;
            synchronized (object2) {
                for (SubSession ss : this._subsessions) {
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getPrefix() + "Connecting subsession " + ss);
                    }
                    this._producer.connect(ss);
                }
            }
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted", ie);
        }
        catch (UnknownHostException uhe) {
            throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, uhe);
        }
        catch (IOException ioe) {
            String msg = this._context.isRouterContext() ? "Failed to build tunnels" : (SystemVersion.isAndroid() && this._options.getProperty(PROP_DOMAIN_SOCKET) != null ? "Failed to bind to the router on " + this._options.getProperty(PROP_DOMAIN_SOCKET) + " and build tunnels" : "Cannot connect to the router on " + this._hostname + ':' + this._portNum + " and build tunnels");
            if (ioe.getMessage() != null) {
                msg = msg + " - " + ioe.getMessage();
            }
            throw new I2PSessionException(this.getPrefix() + msg, ioe);
        }
        finally {
            if (success) {
                this.changeState(State.OPEN);
            } else {
                this._availabilityNotifier.stopNotifying();
                Object object3 = this._stateLock;
                synchronized (object3) {
                    this.changeState(State.CLOSING);
                    try {
                        this._producer.disconnect(this);
                    }
                    catch (I2PSessionException i2PSessionException) {}
                    this.closeSocket();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForDate() throws InterruptedException, IOException {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "After getDate / begin waiting for a response");
        }
        int waitcount = 0;
        while (true) {
            if (waitcount++ > 30) {
                throw new IOException("No handshake received from the router");
            }
            Object object = this._stateLock;
            synchronized (object) {
                if (this._state == State.GOTDATE) {
                    break;
                }
                if (!STATES_OPENING.contains((Object)this._state)) {
                    throw new IOException("Socket closed, state=" + (Object)((Object)this._state));
                }
                this._stateLock.wait(1000L);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "After received a SetDate response");
        }
    }

    @Override
    public byte[] receiveMessage(int msgId) throws I2PSessionException {
        MessagePayloadMessage msg = this._availableMessages.remove(msgId);
        if (msg == null) {
            this._log.error("Receive message " + msgId + " had no matches");
            return null;
        }
        this.updateActivity();
        return msg.getPayload().getUnencryptedData();
    }

    @Override
    public void reportAbuse(int msgId, int severity) throws I2PSessionException {
        this.verifyOpen();
        this._producer.reportAbuse(this, msgId, severity);
    }

    public abstract void receiveStatus(int var1, long var2, int var4);

    public void addNewMessage(MessagePayloadMessage msg) {
        Long mid = msg.getMessageId();
        this._availableMessages.put(mid, msg);
        long id = msg.getMessageId();
        byte[] data = msg.getPayload().getUnencryptedData();
        if (data == null || data.length <= 0) {
            if (this._log.shouldLog(50)) {
                this._log.log(50, this.getPrefix() + "addNewMessage of a message with no unencrypted data", new Exception("Empty message"));
            }
        } else {
            int size = data.length;
            this._availabilityNotifier.available(id, size);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Notified availability for session " + this._sessionId + ", message " + id);
            }
        }
    }

    protected void startVerifyUsage() {
        new VerifyUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        int type = message.getType();
        SessionId id = message.sessionId();
        SessionId currId = this._sessionId;
        if (id == null || id.equals(currId) || currId == null && id != null && type == 20 || (id == null || id.getSessionId() == 65535) && (type == 39 || type == 35)) {
            I2CPMessageHandler handler = this._handlerMap.getHandler(type);
            if (handler != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "Message received of type " + type + " to be handled by " + handler.getClass().getSimpleName());
                }
                handler.handleMessage(message, this);
            } else if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Unknown message or unhandleable message received: type = " + type);
            }
        } else {
            SubSession sub = this._subsessionMap.get(id);
            if (sub != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "Message received of type " + type + " to be handled by " + sub);
                }
                sub.messageReceived(reader, message);
            } else if (id != null && type == 20) {
                Object object = this._subsessionLock;
                synchronized (object) {
                    for (SubSession sess : this._subsessions) {
                        if (sess.getSessionId() == null) {
                            sess.messageReceived(reader, message);
                            id = sess.getSessionId();
                            if (id != null) {
                                if (id.equals(this._sessionId)) {
                                    sess.setSessionId(null);
                                    if (this._log.shouldLog(30)) {
                                        this._log.warn("Dup or our session id " + id);
                                    }
                                } else {
                                    SubSession old = this._subsessionMap.putIfAbsent(id, sess);
                                    if (old != null) {
                                        sess.setSessionId(null);
                                        if (this._log.shouldLog(30)) {
                                            this._log.warn("Dup session id " + id);
                                        }
                                    }
                                }
                            }
                            return;
                        }
                        if (!this._log.shouldLog(30)) continue;
                        this._log.warn(this.getPrefix() + "No session " + id + " to handle message: type = " + type);
                    }
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "No session " + id + " to handle message: type = " + type);
            }
        }
    }

    @Override
    public void readError(I2CPMessageReader reader, Exception error) {
        this.propogateError("There was an error reading data", error);
    }

    @Override
    public Destination getMyDestination() {
        return this._myDestination;
    }

    @Override
    public PrivateKey getDecryptionKey() {
        return this._privateKey;
    }

    @Override
    public SigningPrivateKey getPrivateKey() {
        return this._signingPrivateKey;
    }

    I2CPMessageProducer getProducer() {
        return this._producer;
    }

    I2PClientMessageHandlerMap getHandlerMap() {
        return this._handlerMap;
    }

    I2PAppContext getContext() {
        return this._context;
    }

    Properties getOptions() {
        return this._options;
    }

    SessionId getSessionId() {
        return this._sessionId;
    }

    void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    @Override
    public void setSessionListener(I2PSessionListener lsnr) {
        this._sessionListener = lsnr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this._stateLock;
        synchronized (object) {
            return STATES_CLOSED.contains((Object)this._state);
        }
    }

    protected void verifyOpen() throws I2PSessionException {
        Object object = this._stateLock;
        synchronized (object) {
            block11: while (true) {
                switch (this._state) {
                    case INIT: {
                        throw new I2PSessionException("Not open, must call connect() first");
                    }
                    case OPENING: 
                    case GOTDATE: {
                        try {
                            this._stateLock.wait(5000L);
                            continue block11;
                        }
                        catch (InterruptedException ie) {
                            throw new I2PSessionException("Interrupted", ie);
                        }
                    }
                    case OPEN: {
                        return;
                    }
                    case CLOSED: 
                    case CLOSING: {
                        throw new I2PSessionException("Already closed");
                    }
                }
            }
        }
    }

    void sendMessage(I2CPMessage message) throws I2PSessionException {
        this.verifyOpen();
        this.sendMessage_unchecked(message);
    }

    void sendMessage_unchecked(I2CPMessage message) throws I2PSessionException {
        block5: {
            if (this._queue != null) {
                try {
                    if (!this._queue.offer(message, 10000L)) {
                        throw new I2PSessionException("Timed out waiting while write queue was full");
                    }
                    break block5;
                }
                catch (InterruptedException ie) {
                    throw new I2PSessionException("Interrupted", ie);
                }
            }
            ClientWriterRunner writer = this._writer;
            if (writer == null) {
                throw new I2PSessionException("Already closed or not open");
            }
            writer.addMessage(message);
        }
    }

    void propogateError(String msg, Throwable error) {
        String msgpfx;
        int level;
        if (error instanceof EOFException) {
            level = 30;
            msgpfx = "Router closed connection: ";
        } else {
            level = 40;
            msgpfx = "Error occurred communicating with router: ";
        }
        if (this._log.shouldLog(level)) {
            this._log.log(level, this.getPrefix() + msgpfx + msg, error);
        }
        if (this._sessionListener != null) {
            this._sessionListener.errorOccurred(this, msg, error);
        }
        this._errorMessage = msg;
        this._errorCause = error;
    }

    @Override
    public void destroySession() {
        this.destroySession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(boolean sendDisconnect) {
        block17: {
            Object object = this._stateLock;
            synchronized (object) {
                if (STATES_CLOSED_OR_CLOSING.contains((Object)this._state)) {
                    return;
                }
                this.changeState(State.CLOSING);
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Destroy the session", new Exception("DestroySession()"));
            }
            if (sendDisconnect) {
                if (this._producer != null) {
                    try {
                        this._producer.disconnect(this);
                    }
                    catch (I2PSessionException ipe) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Error destroying the session", ipe);
                        }
                        break block17;
                    }
                }
                if (!this._context.isRouterContext()) {
                    DestroySessionMessage dmsg = new DestroySessionMessage();
                    dmsg.setSessionId(DUMMY_SESSION);
                    try {
                        this.sendMessage_unchecked(dmsg);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (I2PSessionException i2PSessionException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this._availabilityNotifier != null) {
            this._availabilityNotifier.stopNotifying();
        }
        this.closeSocket();
        this._subsessionMap.clear();
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Destination d;
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Closing the socket", new Exception("closeSocket"));
        }
        if ((d = this._myDestination) != null) {
            this._context.keyRing().remove(d.calculateHash());
        }
        Object object = this._stateLock;
        synchronized (object) {
            this.changeState(State.CLOSING);
            this.locked_closeSocket();
            this.changeState(State.CLOSED);
        }
        object = this._subsessionLock;
        synchronized (object) {
            for (SubSession sess : this._subsessions) {
                d = sess.getMyDestination();
                if (d != null) {
                    this._context.keyRing().remove(d.calculateHash());
                }
                sess.changeState(State.CLOSED);
                sess.setSessionId(null);
                sess.setLeaseSet(null);
            }
        }
    }

    private void locked_closeSocket() {
        if (this._reader != null) {
            this._reader.stopReading();
            this._reader = null;
        }
        if (this._queue != null) {
            this._queue.close();
        }
        if (this._writer != null) {
            this._writer.stopWriting();
            this._writer = null;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException ioe) {
                this.propogateError("Caught an IO error closing the socket.  ignored", ioe);
            }
            finally {
                this._socket = null;
            }
        }
        this.setSessionId(null);
        this.setLeaseSet(null);
    }

    @Override
    public void disconnected(I2CPMessageReader reader) {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        State oldState;
        Object object = this._stateLock;
        synchronized (object) {
            if (STATES_CLOSED_OR_CLOSING.contains((Object)this._state)) {
                return;
            }
            oldState = this._state;
            this.changeState(State.CLOSING);
        }
        if (this._log.shouldWarn()) {
            this._log.warn(this.getPrefix() + "Disconnected", new Exception("Disconnected"));
        }
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
        if (oldState != State.OPENING && this.shouldReconnect()) {
            if (this.reconnect()) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "I2CP reconnection successful");
                }
                return;
            }
            if (this._log.shouldLog(40)) {
                this._log.error(this.getPrefix() + "I2CP reconnection failed");
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error(this.getPrefix() + "Disconned from the router, and not trying to reconnect");
        }
        this.closeSocket();
        this.changeState(State.CLOSED);
        object = this._leaseSetWait;
        synchronized (object) {
            this._leaseSetWait.notifyAll();
        }
    }

    protected boolean shouldReconnect() {
        return true;
    }

    protected boolean reconnect() {
        this.closeSocket();
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Reconnecting...");
        }
        int i = 0;
        while (true) {
            long delay = 10000 << i;
            ++i;
            if (delay > 320000L || delay <= 0L) {
                delay = 320000L;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return false;
            }
            try {
                this.connect();
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "Reconnected on attempt " + i);
                }
                return true;
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(40)) continue;
                this._log.error(this.getPrefix() + "Error reconnecting on attempt " + i, ise);
                continue;
            }
            break;
        }
    }

    protected String getPrefix() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        this.getName(buf);
        buf.append('(').append(this._state.toString()).append(')');
        buf.append("]: ");
        return buf.toString();
    }

    protected String getName() {
        StringBuilder buf = new StringBuilder();
        this.getName(buf);
        return buf.toString();
    }

    private void getName(StringBuilder buf) {
        String s = this._options.getProperty("inbound.nickname");
        if (s != null) {
            buf.append(s);
        } else {
            buf.append(this.getClass().getSimpleName());
        }
        SessionId id = this._sessionId;
        if (id != null) {
            buf.append(" #").append(id.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destReceived(Destination d) {
        Hash h = d.calculateHash();
        Map<Object, Destination> map = _lookupCache;
        synchronized (map) {
            _lookupCache.put(h, d);
        }
        for (LookupWaiter w : this._pendingLookups) {
            if (!h.equals(w.hash)) continue;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.destination = d;
                w.code = 0;
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destLookupFailed(Hash h) {
        for (LookupWaiter w : this._pendingLookups) {
            if (!h.equals(w.hash)) continue;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.code = 1;
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destReceived(long nonce, Destination d) {
        Hash h = d.calculateHash();
        for (LookupWaiter w : this._pendingLookups) {
            if (nonce != w.nonce && !h.equals(w.hash)) continue;
            Object object = _lookupCache;
            synchronized (object) {
                if (w.name != null) {
                    _lookupCache.put(w.name, d);
                }
                _lookupCache.put(h, d);
            }
            object = w;
            synchronized (object) {
                w.destination = d;
                w.code = 0;
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destLookupFailed(long nonce, int code) {
        for (LookupWaiter w : this._pendingLookups) {
            if (nonce != w.nonce) continue;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.code = code;
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bwReceived(int[] i) {
        this._bwLimits = i;
        Object object = this._bwReceivedLock;
        synchronized (object) {
            this._bwReceivedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Object, Destination> map = _lookupCache;
        synchronized (map) {
            _lookupCache.clear();
        }
    }

    @Override
    public Destination lookupDest(Hash h) throws I2PSessionException {
        return this.lookupDest(h, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination lookupDest(Hash h, long maxWait) throws I2PSessionException {
        LookupWaiter waiter;
        long nonce;
        Object object = _lookupCache;
        synchronized (object) {
            Destination rv = _lookupCache.get(h);
            if (rv != null) {
                return rv;
            }
        }
        object = this._stateLock;
        synchronized (object) {
            if (STATES_CLOSED_OR_OPENING.contains((Object)this._state)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Session closed, cannot lookup " + h);
                }
                return null;
            }
        }
        if (this._routerSupportsHostLookup) {
            nonce = this._lookupID.incrementAndGet() & Integer.MAX_VALUE;
            waiter = new LookupWaiter(h, nonce);
        } else {
            nonce = 0L;
            waiter = new LookupWaiter(h);
        }
        this._pendingLookups.offer(waiter);
        Destination rv = null;
        try {
            Object id;
            if (this._routerSupportsHostLookup) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending HostLookup for " + h);
                }
                if ((id = this._sessionId) == null) {
                    id = DUMMY_SESSION;
                }
                this.sendMessage_unchecked(new HostLookupMessage((SessionId)id, h, nonce, maxWait));
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending DestLookup for " + h);
                }
                this.sendMessage_unchecked(new DestLookupMessage(h));
            }
            try {
                id = waiter;
                synchronized (id) {
                    waiter.wait(maxWait);
                    rv = waiter.destination;
                }
            }
            catch (InterruptedException ie) {
                throw new I2PSessionException("Interrupted", ie);
            }
        }
        finally {
            this._pendingLookups.remove(waiter);
        }
        return rv;
    }

    @Override
    public Destination lookupDest(String name) throws I2PSessionException {
        return this.lookupDest(name, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination lookupDest(String name, long maxWait) throws I2PSessionException {
        LookupWaiter waiter = this.x_lookupDest(name, maxWait);
        if (waiter == null) {
            return null;
        }
        LookupWaiter lookupWaiter = waiter;
        synchronized (lookupWaiter) {
            return waiter.destination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupResult lookupDest2(String name, long maxWait) throws I2PSessionException {
        LookupWaiter waiter = this.x_lookupDest(name, maxWait);
        if (waiter == null) {
            return new LkupResult(1, null);
        }
        LookupWaiter lookupWaiter = waiter;
        synchronized (lookupWaiter) {
            int code = waiter.code;
            Destination d = waiter.destination;
            if (d == null && code == 0) {
                code = 1;
            }
            return new LkupResult(code, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupWaiter x_lookupDest(String name, long maxWait) throws I2PSessionException {
        if (name.length() == 0) {
            return null;
        }
        if (name.length() >= 516) {
            try {
                return new LookupWaiter(new Destination(name));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        if (name.length() >= 256 && !this._context.isRouterContext()) {
            return null;
        }
        Map<Object, Destination> dfe = _lookupCache;
        synchronized (dfe) {
            Destination rv = _lookupCache.get(name);
            if (rv != null) {
                return new LookupWaiter(rv);
            }
        }
        if (this.isClosed()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Session closed, cannot lookup " + name);
            }
            return null;
        }
        if (!this._routerSupportsHostLookup) {
            if (name.length() == 60 && name.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                return new LookupWaiter(this.lookupDest(Hash.create(Base32.decode(name.toLowerCase(Locale.US).substring(0, 52))), maxWait));
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Router does not support HostLookup for " + name);
            }
            return null;
        }
        int nonce = this._lookupID.incrementAndGet() & Integer.MAX_VALUE;
        LookupWaiter waiter = new LookupWaiter(name, (long)nonce);
        this._pendingLookups.offer(waiter);
        try {
            SessionId id;
            if (this._log.shouldLog(20)) {
                this._log.info("Sending HostLookup for " + name);
            }
            if ((id = this._sessionId) == null) {
                id = DUMMY_SESSION;
            }
            this.sendMessage_unchecked(new HostLookupMessage(id, name, (long)nonce, maxWait));
            LookupWaiter lookupWaiter = waiter;
            synchronized (lookupWaiter) {
                try {
                    waiter.wait(maxWait);
                    LookupWaiter lookupWaiter2 = waiter;
                    return lookupWaiter2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (InterruptedException ie) {
                        throw new I2PSessionException("Interrupted", ie);
                    }
                }
            }
        }
        finally {
            this._pendingLookups.remove(waiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] bandwidthLimits() throws I2PSessionException {
        Object object = this._stateLock;
        synchronized (object) {
            if (STATES_CLOSED_OR_OPENING.contains((Object)this._state)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Session closed, cannot get bw limits");
                }
                return null;
            }
        }
        this.sendMessage_unchecked(new GetBandwidthLimitsMessage());
        try {
            object = this._bwReceivedLock;
            synchronized (object) {
                this._bwReceivedLock.wait(5000L);
            }
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted", ie);
        }
        return this._bwLimits;
    }

    @Override
    public void sendBlindingInfo(BlindData bd) throws I2PSessionException {
        SessionId id;
        if (!this._routerSupportsBlindingInfo) {
            throw new I2PSessionException("Router does not support BlindingInfo");
        }
        if (this._log.shouldInfo()) {
            this._log.info("Sending BlindingInfo");
        }
        if ((id = this._sessionId) == null) {
            id = DUMMY_SESSION;
        }
        this.sendMessage_unchecked(new BlindingInfoMessage(bd, id));
    }

    @Override
    public String getRouterVersion() {
        if (this._context.isRouterContext()) {
            return "0.9.59";
        }
        return this._routerVersion;
    }

    protected void updateActivity() {
        this._lastActivity = this._context.clock().now();
        if (this._isReduced) {
            this._isReduced = false;
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Restoring original tunnel quantity");
            }
            try {
                this._producer.updateTunnels(this, 0);
            }
            catch (I2PSessionException ise) {
                this._log.error(this.getPrefix() + "bork restore from reduced");
            }
        }
    }

    public long lastActivity() {
        return this._lastActivity;
    }

    public void setReduced() {
        this._isReduced = true;
    }

    private void startIdleMonitor() {
        this._isReduced = false;
        boolean reduce = Boolean.parseBoolean(this._options.getProperty("i2cp.reduceOnIdle"));
        boolean close = Boolean.parseBoolean(this._options.getProperty("i2cp.closeOnIdle"));
        if (reduce || close) {
            this.updateActivity();
            this._context.simpleTimer2().addEvent(new SessionIdleTimer(this._context, this, reduce, close), 300000L);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("Session: ");
        if (this._myDestination != null) {
            buf.append(this._myDestination.calculateHash().toBase64(), 0, 4);
        } else {
            buf.append("[null dest]");
        }
        buf.append(this.getPrefix());
        return buf.toString();
    }

    private static class LookupWaiter {
        public final Hash hash;
        public final String name;
        public final long nonce;
        public Destination destination;
        public int code;

        public LookupWaiter(Hash h) {
            this(h, -1L);
        }

        public LookupWaiter(Hash h, long nonce) {
            this.hash = h;
            this.name = null;
            this.nonce = nonce;
        }

        public LookupWaiter(String name, long nonce) {
            this.hash = null;
            this.name = name;
            this.nonce = nonce;
        }

        public LookupWaiter(Destination d) {
            this.hash = null;
            this.name = null;
            this.nonce = 0L;
            this.destination = d;
        }
    }

    protected class AvailabilityNotifier
    implements Runnable {
        private final List<Long> _pendingIds = new ArrayList<Long>(2);
        private final List<Integer> _pendingSizes = new ArrayList<Integer>(2);
        private volatile boolean _alive;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopNotifying() {
            this._alive = false;
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void available(long msgId, int size) {
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this._pendingIds.add(msgId);
                this._pendingSizes.add(size);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._alive = true;
            while (this._alive) {
                Long msgId = null;
                Integer size = null;
                AvailabilityNotifier availabilityNotifier = this;
                synchronized (availabilityNotifier) {
                    if (this._pendingIds.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!this._pendingIds.isEmpty()) {
                        msgId = this._pendingIds.remove(0);
                        size = this._pendingSizes.remove(0);
                    }
                }
                if (msgId == null || size == null) continue;
                if (I2PSessionImpl.this._sessionListener != null) {
                    try {
                        long before = System.currentTimeMillis();
                        I2PSessionImpl.this._sessionListener.messageAvailable(I2PSessionImpl.this, msgId.intValue(), size.intValue());
                        long duration = System.currentTimeMillis() - before;
                        if (duration <= 100L || !I2PSessionImpl.this._log.shouldLog(20)) continue;
                        I2PSessionImpl.this._log.info("Message availability notification for " + msgId.intValue() + " took " + duration + " to " + I2PSessionImpl.this._sessionListener);
                    }
                    catch (RuntimeException e) {
                        I2PSessionImpl.this._log.log(50, "Error notifying app of message availability", e);
                    }
                    continue;
                }
                I2PSessionImpl.this._log.log(50, "Unable to notify an app that " + msgId + " of size " + size + " is available!");
            }
        }
    }

    private class VerifyUsage
    extends SimpleTimer2.TimedEvent {
        private final List<Long> toCheck;

        public VerifyUsage() {
            super(I2PSessionImpl.this._context.simpleTimer2(), 60000L);
            this.toCheck = new ArrayList<Long>();
        }

        @Override
        public void timeReached() {
            if (I2PSessionImpl.this.isClosed()) {
                return;
            }
            if (!this.toCheck.isEmpty()) {
                for (Long msgId : this.toCheck) {
                    MessagePayloadMessage removed = I2PSessionImpl.this._availableMessages.remove(msgId);
                    if (removed == null) continue;
                    I2PSessionImpl.this._log.error(I2PSessionImpl.this.getPrefix() + " Client not responding? Message not processed! id=" + msgId + ": " + removed);
                }
                this.toCheck.clear();
            }
            this.toCheck.addAll(I2PSessionImpl.this._availableMessages.keySet());
            this.schedule(60000L);
        }
    }

    protected static enum State {
        INIT,
        OPENING,
        GOTDATE,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

