/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.devkit.workspaceModel.DevKitWorkspaceModelBundle;
import com.intellij.devkit.workspaceModel.RegenerateWorkspaceModelFix;
import com.intellij.devkit.workspaceModel.WorkspaceImplObsoleteInspectionKt;
import com.intellij.devkit.workspaceModel.WorkspaceKtClassExtentionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.storage.CodeGeneratorVersions;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/devkit/workspaceModel/WorkspaceImplObsoleteInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "calculateTargetApiVersion", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/openapi/project/Project;)Ljava/lang/Integer;", "intellij.devkit.workspaceModel"})
public final class WorkspaceImplObsoleteInspection
extends LocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ WorkspaceImplObsoleteInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitClass(@NotNull KtClass klass) {
                Integer apiVersion;
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                if (!WorkspaceKtClassExtentionsKt.isWorkspaceEntity(klass)) {
                    return;
                }
                GlobalSearchScope globalSearchScope = klass.getResolveScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"klass.resolveScope");
                Project project = klass.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"klass.project");
                Integer targetApiVersion = WorkspaceImplObsoleteInspection.access$calculateTargetApiVersion(this.this$0, globalSearchScope, project);
                if (targetApiVersion == null) {
                    WorkspaceImplObsoleteInspectionKt.access$getLOG$p().info("Can't evaluate target API version for " + klass.getName());
                    return;
                }
                if (Intrinsics.areEqual((Object)klass.getName(), (Object)"Builder")) {
                    return;
                }
                String string = klass.getName() + "Impl";
                Project project2 = klass.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"klass.project");
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)klass.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"allScope(klass.project)");
                Collection foundImplClasses = KotlinClassShortNameIndex.Helper.get(string, project2, globalSearchScope2);
                if (foundImplClasses.isEmpty()) {
                    return;
                }
                KtClassOrObject implClass = (KtClassOrObject)CollectionsKt.first((Iterable)foundImplClasses);
                KtClass ktClass = implClass instanceof KtClass ? (KtClass)implClass : null;
                Integer n = apiVersion = ktClass != null ? WorkspaceKtClassExtentionsKt.getApiVersion(ktClass) : null;
                if (Intrinsics.areEqual((Object)apiVersion, (Object)targetApiVersion)) {
                    return;
                }
                PsiElement psiElement = klass.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                String string2 = DevKitWorkspaceModelBundle.INSTANCE.message("inspection.workspace.msg.obsolete.implementation", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                PsiElement psiElement2 = klass.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement2);
                localQuickFixArray[0] = new RegenerateWorkspaceModelFix(psiElement2);
                this.$holder.registerProblem(psiElement, string2, localQuickFixArray);
            }
        };
    }

    private final Integer calculateTargetApiVersion(GlobalSearchScope scope, Project project) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(CodeGeneratorVersions.class.getName(), scope);
        if (psiClass == null) {
            return null;
        }
        PsiClass generatorVersionsClass = psiClass;
        PsiField psiField = generatorVersionsClass.findFieldByName("API_VERSION_INTERNAL", false);
        if (psiField == null) {
            return null;
        }
        PsiField versionField = psiField;
        PsiExpression psiExpression = versionField.getInitializer();
        PsiLiteralExpression psiLiteralExpression = psiExpression instanceof PsiLiteralExpression ? (PsiLiteralExpression)psiExpression : null;
        Object object = psiLiteralExpression != null ? psiLiteralExpression.getValue() : null;
        return object instanceof Integer ? (Integer)object : null;
    }

    public static final /* synthetic */ Integer access$calculateTargetApiVersion(WorkspaceImplObsoleteInspection $this, GlobalSearchScope scope, Project project) {
        return $this.calculateTargetApiVersion(scope, project);
    }
}

