/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.commit;

import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.commit.DevKitGitBundle;
import org.jetbrains.idea.devkit.commit.IssueIDPrePushHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\f0\t\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/commit/IntelliJPrePushHandler;", "Lorg/jetbrains/idea/devkit/commit/IssueIDPrePushHandler;", "()V", "commitMessageRegex", "Lkotlin/text/Regex;", "getCommitMessageRegex", "()Lkotlin/text/Regex;", "paths", "", "", "getPaths", "()Ljava/util/List;", "getPresentableName", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "isAvailable", "", "intellij.devkit.git"})
public final class IntelliJPrePushHandler
extends IssueIDPrePushHandler {
    @NotNull
    private final List<String> paths;
    @NotNull
    private final Regex commitMessageRegex;

    public IntelliJPrePushHandler() {
        Object[] objectArray = new String[]{"community", "platform"};
        this.paths = CollectionsKt.listOf((Object[])objectArray);
        this.commitMessageRegex = new Regex(".*\\w{2,}-\\d+.*", RegexOption.DOT_MATCHES_ALL);
    }

    @Override
    @NotNull
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    @NotNull
    public Regex getCommitMessageRegex() {
        return this.commitMessageRegex;
    }

    @Override
    public boolean isAvailable() {
        return Registry.is((String)"intellij.commit.message.validation.enabled", (boolean)true);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = DevKitGitBundle.message("push.commit.handler.idea.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"push.commit.handler.idea.name\")");
        return string;
    }
}

