/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.siyeh.ig.bugs.IncorrectMessageFormatInspection;
import com.siyeh.ig.bugs.message.MessageFormatUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.i18n.DevKitPropertiesMessageValidationInspection;
import org.jetbrains.idea.devkit.i18n.DevKitPropertiesMessageValidationInspectionKt;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/i18n/DevKitPropertiesMessageValidationInspection;", "Lcom/intellij/lang/properties/PropertiesInspectionBase;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getRelatedText", "", "pattern", "error", "Lcom/siyeh/ig/bugs/message/MessageFormatUtil$MessageFormatError;", "intellij.devkit.i18n"})
public final class DevKitPropertiesMessageValidationInspection
extends PropertiesInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!DevKitInspectionUtil.isAllowed(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ DevKitPropertiesMessageValidationInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element) {
                boolean bl;
                block12: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof Property)) {
                        return;
                    }
                    String string = ((Property)element).getUnescapedValue();
                    if (string == null) {
                        return;
                    }
                    String unescapedValue = string;
                    String string2 = ((Property)element).getValue();
                    if (string2 == null) {
                        return;
                    }
                    String value = string2;
                    if (!(StringsKt.contains$default((CharSequence)unescapedValue, (CharSequence)"{0}", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)unescapedValue, (CharSequence)"{0,", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)unescapedValue, (CharSequence)"{1}", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)unescapedValue, (CharSequence)"{1,", (boolean)false, (int)2, null))) {
                        return;
                    }
                    MessageFormatUtil.MessageFormatResult messageFormatResult = MessageFormatUtil.checkFormat((String)unescapedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)messageFormatResult, (String)"checkFormat(unescapedValue)");
                    MessageFormatUtil.MessageFormatResult messageFormatResult2 = messageFormatResult;
                    if (messageFormatResult2.valid()) {
                        return;
                    }
                    ASTNode aSTNode = element.getNode().findChildByType(PropertiesTokenTypes.VALUE_CHARACTERS);
                    if (aSTNode == null) {
                        return;
                    }
                    int startIndex = aSTNode.getStartOffsetInParent();
                    for (MessageFormatUtil.MessageFormatError error : messageFormatResult2.errors()) {
                        String relatedText;
                        if (DevKitPropertiesMessageValidationInspectionKt.access$getSKIPPED_ERROR_TYPES$p().contains(error.errorType())) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)error, (String)"error");
                        if (DevKitPropertiesMessageValidationInspection.access$getRelatedText(this.this$0, unescapedValue, error) == null) continue;
                        if (Intrinsics.areEqual((Object)unescapedValue, (Object)value)) {
                            this.$holder.registerProblem(element, new TextRange(error.fromIndex() + startIndex, error.toIndex() + startIndex), IncorrectMessageFormatInspection.getMessageFormatTemplate((MessageFormatUtil.MessageFormatErrorType)error.errorType(), (String)relatedText), new LocalQuickFix[0]);
                            continue;
                        }
                        int startedCount = 0;
                        int nextRelatedTestIndex = StringsKt.indexOf$default((CharSequence)unescapedValue, (String)relatedText, (int)0, (boolean)false, (int)4, null);
                        while (nextRelatedTestIndex != -1 && nextRelatedTestIndex != error.fromIndex()) {
                            ++startedCount;
                            nextRelatedTestIndex = StringsKt.indexOf$default((CharSequence)unescapedValue, (String)relatedText, (int)(nextRelatedTestIndex + 1), (boolean)false, (int)4, null);
                        }
                        if (nextRelatedTestIndex == -1) continue;
                        int nextStartIndex = StringsKt.indexOf$default((CharSequence)value, (String)relatedText, (int)0, (boolean)false, (int)4, null);
                        int n = startedCount;
                        for (int i = 0; i < n; ++i) {
                            nextStartIndex = StringsKt.indexOf$default((CharSequence)value, (String)relatedText, (int)(nextStartIndex + 1), (boolean)false, (int)4, null);
                        }
                        if (nextStartIndex == -1) continue;
                        this.$holder.registerProblem(element, new TextRange(nextStartIndex + startIndex, nextStartIndex + startIndex + error.toIndex() - error.fromIndex()), IncorrectMessageFormatInspection.getMessageFormatTemplate((MessageFormatUtil.MessageFormatErrorType)error.errorType(), (String)relatedText), new LocalQuickFix[0]);
                    }
                    List list = messageFormatResult2.errors();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"messageFormatResult.errors");
                    Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)buildVisitor.visitElement.1.INSTANCE);
                    boolean $i$f$any = false;
                    for (E element$iv : $this$any$iv) {
                        MessageFormatUtil.ErrorSeverity it = (MessageFormatUtil.ErrorSeverity)element$iv;
                        boolean bl2 = false;
                        if (!(it == MessageFormatUtil.ErrorSeverity.RUNTIME_EXCEPTION)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
                if (bl) {
                    return;
                }
            }
        };
    }

    private final String getRelatedText(String pattern, MessageFormatUtil.MessageFormatError error) {
        String string;
        if (error.fromIndex() < 0 || error.toIndex() > pattern.length() || error.toIndex() < error.fromIndex()) {
            string = null;
        } else {
            String string2 = pattern.substring(error.fromIndex(), error.toIndex());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    public static final /* synthetic */ String access$getRelatedText(DevKitPropertiesMessageValidationInspection $this, String pattern, MessageFormatUtil.MessageFormatError error) {
        return $this.getRelatedText(pattern, error);
    }
}

