/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;

abstract class DescriptionNotFoundInspectionBase
extends DevKitUastInspectionBase {
    private final DescriptionType myDescriptionType;

    protected DescriptionNotFoundInspectionBase(DescriptionType descriptionType) {
        super(UClass.class);
        this.myDescriptionType = descriptionType;
    }

    public final ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uClass == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(1);
        }
        if (uClass instanceof UAnonymousClass) {
            return null;
        }
        PsiClass psiClass = uClass.getJavaPsi();
        PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(psiClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(this.myDescriptionType.getClassName(), psiClass.getResolveScope());
        if (base == null || !psiClass.isInheritor(base, true)) {
            return null;
        }
        if (this.skipIfNotRegistered(psiClass)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, psiClass.getContainingFile(), isOnTheFly);
        boolean registered = this.myDescriptionType.isFixedDescriptionFilename() ? this.checkFixedDescription(holder, module, psiClass, uClass) : this.checkDynamicDescription(holder, module, psiClass);
        if (registered) {
            return holder.getResultsArray();
        }
        ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)uClass, (String)this.getHasNotDescriptionError(module, psiClass), (LocalQuickFix[])new LocalQuickFix[]{new CreateHtmlDescriptionFix(this.getDescriptionDir(module, psiClass), module, this.myDescriptionType)});
        return holder.getResultsArray();
    }

    protected abstract boolean skipIfNotRegistered(PsiClass var1);

    protected boolean skipOptionalBeforeAfter(PsiClass epClass) {
        return false;
    }

    protected boolean checkDynamicDescription(ProblemsHolder holder, Module module, PsiClass psiClass) {
        throw new IllegalStateException("must be implemented for " + ((Object)((Object)this)).getClass());
    }

    protected boolean checkFixedDescription(ProblemsHolder holder, Module module, PsiClass psiClass, UClass uClass) {
        String descriptionDir = this.getDescriptionDir(module, psiClass);
        if (StringUtil.isEmptyOrSpaces((String)descriptionDir)) {
            return false;
        }
        for (PsiDirectory description2 : this.getDescriptionsDirs(module)) {
            PsiFile descr;
            PsiDirectory dir = description2.findSubdirectory(descriptionDir);
            if (dir == null || (descr = dir.findFile("description.html")) == null) continue;
            if (!DescriptionNotFoundInspectionBase.hasBeforeAndAfterTemplate(dir.getVirtualFile()) && !this.skipOptionalBeforeAfter(psiClass)) {
                ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)uClass, (String)this.getHasNotBeforeAfterError(), (LocalQuickFix[])new LocalQuickFix[0]);
            }
            return true;
        }
        return false;
    }

    private static boolean hasBeforeAndAfterTemplate(@NotNull VirtualFile dir) {
        if (dir == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(2);
        }
        boolean hasBefore = false;
        boolean hasAfter = false;
        for (VirtualFile file : dir.getChildren()) {
            String name = file.getName();
            if (!name.endsWith(".template")) continue;
            if (name.startsWith("before.")) {
                hasBefore = true;
                continue;
            }
            if (!name.startsWith("after.")) continue;
            hasAfter = true;
        }
        return hasBefore && hasAfter;
    }

    @Nullable
    protected String getDescriptionDir(Module module, PsiClass psiClass) {
        return DescriptionCheckerUtil.getDescriptionDirName(psiClass);
    }

    protected PsiDirectory @NotNull [] getDescriptionsDirs(Module module) {
        PsiDirectory[] psiDirectoryArray = DescriptionCheckerUtil.getDescriptionsDirs(module, this.myDescriptionType);
        if (psiDirectoryArray == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(3);
        }
        return psiDirectoryArray;
    }

    @InspectionMessage
    @NotNull
    protected abstract String getHasNotDescriptionError(Module var1, PsiClass var2);

    @InspectionMessage
    @NotNull
    protected abstract String getHasNotBeforeAfterError();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionsDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasBeforeAndAfterTemplate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

