/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.ServiceInfo;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;
import org.jetbrains.idea.devkit.util.PluginPlatformInfo;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0001\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"IS_UNIT_TEST_OR_HEADLESS_MODE", "Lcom/siyeh/ig/callMatcher/CallMatcher;", "kotlin.jvm.PlatformType", "disallowedAttributes", "", "", "containsUnitTestOrHeadlessModeCheck", "", "aClass", "Lorg/jetbrains/uast/UClass;", "getMessage", "level", "Lcom/intellij/openapi/components/Service$Level;", "getServiceImplementation", "Lorg/jetbrains/idea/devkit/inspections/ServiceInfo;", "extension", "Lorg/jetbrains/idea/devkit/dom/Extension;", "hasDisallowedAttributes", "isVersion193OrHigher", "Lcom/intellij/psi/PsiClass;", "element", "Lcom/intellij/util/xml/DomElement;", "intellij.devkit.core"})
@JvmName(name="LightServiceMigrationUtil")
public final class LightServiceMigrationUtil {
    @NotNull
    private static final Set<String> disallowedAttributes;
    private static final CallMatcher IS_UNIT_TEST_OR_HEADLESS_MODE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final ServiceInfo getServiceImplementation(@NotNull Extension extension) {
        Service.Level level;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) return null;
        String string = extensionPoint.getEffectiveQualifiedName();
        String string2 = string;
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case -698444602: {
                if (string2.equals("com.intellij.projectService")) {
                    n = 1;
                }
                break;
            }
            case -1947960913: {
                if (string2.equals("com.intellij.applicationService")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                level = Service.Level.PROJECT;
                break;
            }
            case 2: {
                level = Service.Level.APP;
                break;
            }
            default: {
                return null;
            }
        }
        Service.Level level2 = level;
        ExtensionPoint extensionPoint2 = extension.getExtensionPoint();
        if (extensionPoint2 == null) return null;
        if (!DomUtil.hasXml((DomElement)((DomElement)extensionPoint2.getBeanClass()))) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)ServiceDescriptor.class.getName(), (Object)extensionPoint2.getBeanClass().getStringValue())) {
            return null;
        }
        if (LightServiceMigrationUtil.hasDisallowedAttributes(extension)) {
            return null;
        }
        GenericAttributeValue<?> genericAttributeValue = DevKitDomUtil.getAttribute(extension, "serviceImplementation");
        if (genericAttributeValue == null) {
            return null;
        }
        GenericAttributeValue<?> serviceImplementation = genericAttributeValue;
        if (!DomUtil.hasXml((DomElement)((DomElement)serviceImplementation))) {
            return null;
        }
        Object object = serviceImplementation.getValue();
        if (!(object instanceof PsiClass)) return null;
        PsiClass psiClass = (PsiClass)object;
        if (psiClass == null) {
            return null;
        }
        PsiClass aClass = psiClass;
        return new ServiceInfo(aClass, level2);
    }

    private static final boolean hasDisallowedAttributes(Extension extension) {
        for (String attributeName : disallowedAttributes) {
            GenericAttributeValue<?> attribute = DevKitDomUtil.getAttribute(extension, attributeName);
            if (attribute == null || !DomUtil.hasXml((DomElement)((DomElement)attribute))) continue;
            return true;
        }
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public static final String getMessage(@NotNull Service.Level level) {
        String string;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                String string2 = DevKitBundle.message("inspection.light.service.migration.app.level.message", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"inspection.ligh\u2026ation.app.level.message\")");
                break;
            }
            case 2: {
                String string3 = DevKitBundle.message("inspection.light.service.migration.project.level.message", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"inspection.ligh\u2026n.project.level.message\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final boolean isVersion193OrHigher(@NotNull DomElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Module module = element.getModule();
        if (PsiUtil.isIdeaProject((Project)(module != null ? module.getProject() : null))) {
            return true;
        }
        BuildNumber buildNumber = PluginPlatformInfo.forDomElement(element).getSinceBuildNumber();
        return buildNumber != null && buildNumber.getBaselineVersion() >= 193;
    }

    public static final boolean isVersion193OrHigher(@NotNull PsiClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        if (PsiUtil.isIdeaProject(aClass.getProject())) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)aClass));
        if (module == null) {
            return false;
        }
        Module module2 = module;
        BuildNumber buildNumber = PluginPlatformInfo.forModule(module2).getSinceBuildNumber();
        return buildNumber != null && buildNumber.getBaselineVersion() >= 193;
    }

    public static final boolean containsUnitTestOrHeadlessModeCheck(@NotNull UClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Ref.BooleanRef result = new Ref.BooleanRef();
        aClass.accept((UastVisitor)new AbstractUastVisitor(result){
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$result = $result;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (LightServiceMigrationUtil.access$getIS_UNIT_TEST_OR_HEADLESS_MODE$p().uCallMatches(node)) {
                    this.$result.element = true;
                    return false;
                }
                return super.visitCallExpression(node);
            }
        });
        return result.element;
    }

    public static final /* synthetic */ CallMatcher access$getIS_UNIT_TEST_OR_HEADLESS_MODE$p() {
        return IS_UNIT_TEST_OR_HEADLESS_MODE;
    }

    static {
        Object[] objectArray = new String[]{"serviceInterface", "os", "client", "overrides", "id", "preload"};
        disallowedAttributes = SetsKt.setOf((Object[])objectArray);
        objectArray = new CallMatcher[2];
        String[] stringArray = new String[]{"isUnitTestMode", "isHeadlessEnvironment"};
        objectArray[0] = CallMatcher.instanceCall((String)Application.class.getCanonicalName(), (String[])stringArray);
        stringArray = new String[]{"isUnitTestMode", "isHeadlessEnvironment"};
        objectArray[1] = CallMatcher.staticCall((String)"org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt", (String[])stringArray);
        IS_UNIT_TEST_OR_HEADLESS_MODE = CallMatcher.anyOf((CallMatcher[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Service.Level.values().length];
            try {
                nArray[Service.Level.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Service.Level.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

