/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.ExtensionPoints;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MoveToPackageFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptStringList;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xml.util.IncludedXmlTag;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.AddToGroup;
import org.jetbrains.idea.devkit.dom.Anchor;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.DependencyDescriptor;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.Helpset;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.Option;
import org.jetbrains.idea.devkit.dom.ProductDescriptor;
import org.jetbrains.idea.devkit.dom.Synonym;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.AddWithTagFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PluginPlatformInfo;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class PluginXmlDomInspection
extends DevKitPluginXmlInspectionBase {
    @NonNls
    private static final String PLUGIN_ICON_SVG_FILENAME = "pluginIcon.svg";
    private static final int MINIMAL_DESCRIPTION_LENGTH = 40;
    @NonNls
    public static final String DEPENDENCIES_DOC_URL = "https://plugins.jetbrains.com/docs/intellij/plugin-dependencies.html?from=DevkitPluginXmlInspection";
    public List<String> myRegistrationCheckIgnoreClassList = new ExternalizableStringSet(new String[0]);
    @XCollection
    public List<PluginModuleSet> PLUGINS_MODULES = new ArrayList<PluginModuleSet>();
    private final SynchronizedClearableLazy<Map<String, PluginModuleSet>> myPluginModuleSetByModuleName = new SynchronizedClearableLazy(() -> {
        HashMap<String, PluginModuleSet> result = new HashMap<String, PluginModuleSet>();
        for (PluginModuleSet modulesSet : this.PLUGINS_MODULES) {
            for (String module : modulesSet.modules) {
                result.put(module, modulesSet);
            }
        }
        return result;
    });
    private static final int FIRST_BRANCH_SUPPORTING_STAR = 131;
    private static final int LISTENERS_PLATFORM_VERSION = 193;
    private static final int LISTENERS_OS_ATTRIBUTE_PLATFORM_VERSION = 201;

    @NotNull
    public OptPane getOptionsPane() {
        OptStringList ignoreClassList = OptPane.stringList((String)"myRegistrationCheckIgnoreClassList", (String)DevKitBundle.message("inspections.plugin.xml.ignore.classes.title", new Object[0]), (StringValidator)new JavaClassValidator().withTitle(DevKitBundle.message("inspections.plugin.xml.add.ignored.class.title", new Object[0])));
        if (ApplicationManager.getApplication().isInternal()) {
            OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{ignoreClassList, OptPane.stringList((String)"PLUGINS_MODULES", (String)DevKitBundle.message("inspections.plugin.xml.plugin.modules.label", new Object[0])).description(DevKitBundle.message("inspections.plugin.xml.plugin.modules.description", new Object[0]))});
            if (optPane == null) {
                PluginXmlDomInspection.$$$reportNull$$$0(0);
            }
            return optPane;
        }
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{ignoreClassList});
        if (optPane == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("PLUGINS_MODULES", () -> StreamEx.of(this.PLUGINS_MODULES).map(set -> String.join((CharSequence)",", set.modules)).toMutableList(), newList -> {
            this.PLUGINS_MODULES.clear();
            StreamEx.of((Collection)newList).map(line -> {
                PluginModuleSet set = new PluginModuleSet();
                set.modules = (Set)StreamEx.split((CharSequence)line, (String)",").toCollection(LinkedHashSet::new);
                return set;
            }).into(this.PLUGINS_MODULES);
            this.myPluginModuleSetByModuleName.drop();
        });
        if (optionController == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        this.myPluginModuleSetByModuleName.drop();
    }

    @NotNull
    public String getShortName() {
        return "PluginXmlValidity";
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        GenericDomValue domValue;
        if (element == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(5);
        }
        if (helper == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(6);
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        super.checkDomElement(element, holder, helper);
        ComponentModuleRegistrationChecker componentModuleRegistrationChecker = new ComponentModuleRegistrationChecker(this.myPluginModuleSetByModuleName, this.myRegistrationCheckIgnoreClassList, holder);
        if (element instanceof IdeaPlugin) {
            Module module = element.getModule();
            if (module != null) {
                PluginXmlDomInspection.annotateIdeaPlugin((IdeaPlugin)element, holder, module);
                PluginXmlDomInspection.checkJetBrainsPlugin((IdeaPlugin)element, holder, module);
                PluginXmlDomInspection.checkPluginIcon((IdeaPlugin)element, holder, module);
            }
        } else if (element instanceof Extension) {
            PluginXmlDomInspection.annotateExtension((Extension)element, holder, componentModuleRegistrationChecker);
        } else if (element instanceof ExtensionPoint) {
            PluginXmlDomInspection.annotateExtensionPoint((ExtensionPoint)element, holder, componentModuleRegistrationChecker);
        } else if (element instanceof Vendor) {
            PluginXmlDomInspection.annotateVendor((Vendor)element, holder);
        } else if (element instanceof ProductDescriptor) {
            PluginXmlDomInspection.annotateProductDescriptor((ProductDescriptor)element, holder);
        } else if (element instanceof IdeaVersion) {
            PluginXmlDomInspection.annotateIdeaVersion((IdeaVersion)element, holder);
        } else if (element instanceof Dependency) {
            PluginXmlDomInspection.annotateDependency((Dependency)element, holder);
        } else if (element instanceof DependencyDescriptor) {
            PluginXmlDomInspection.annotateDependencyDescriptor((DependencyDescriptor)element, holder);
        } else if (element instanceof ContentDescriptor) {
            PluginXmlDomInspection.annotateContentDescriptor((ContentDescriptor)element, holder);
        } else if (element instanceof Extensions) {
            PluginXmlDomInspection.annotateExtensions((Extensions)element, holder);
        } else if (element instanceof Extensions.UnresolvedExtension) {
            PluginXmlDomInspection.annotateUnresolvedExtension((Extensions.UnresolvedExtension)element, holder);
        } else if (element instanceof AddToGroup) {
            PluginXmlDomInspection.annotateAddToGroup((AddToGroup)element, holder);
        } else if (element instanceof Action) {
            PluginXmlDomInspection.annotateAction((Action)element, holder, componentModuleRegistrationChecker);
        } else if (element instanceof Synonym) {
            PluginXmlDomInspection.annotateSynonym((Synonym)element, holder);
        } else if (element instanceof Group) {
            PluginXmlDomInspection.annotateGroup((Group)element, holder);
        } else if (element instanceof Component) {
            PluginXmlDomInspection.annotateComponent((Component)element, holder, componentModuleRegistrationChecker);
            if (element instanceof Component.Project) {
                PluginXmlDomInspection.annotateProjectComponent((Component.Project)element, holder);
            }
        } else if (element instanceof Helpset) {
            PluginXmlDomInspection.highlightRedundant(element, DevKitBundle.message("inspections.plugin.xml.deprecated.helpset", new Object[0]), holder);
        } else if (element instanceof Listeners) {
            PluginXmlDomInspection.annotateListeners((Listeners)element, holder);
        } else if (element instanceof Listeners.Listener) {
            PluginXmlDomInspection.annotateListener((Listeners.Listener)element, holder);
        }
        if (element instanceof GenericDomValue && (domValue = (GenericDomValue)element).getConverter() instanceof PluginPsiClassConverter) {
            GenericDomValue psiClassDomValue = (GenericDomValue)element;
            PluginXmlDomInspection.annotatePsiClassValue((GenericDomValue<PsiClass>)psiClassDomValue, holder);
        }
    }

    private static void annotateDependencyDescriptor(DependencyDescriptor descriptor, DomElementAnnotationHolder holder) {
        if (!PluginXmlDomInspection.isIdeaProjectOrJetBrains(descriptor)) {
            PluginXmlDomInspection.highlightJetbrainsOnly(descriptor, holder);
            return;
        }
        if (descriptor.getModuleEntry().isEmpty() && descriptor.getPlugin().isEmpty()) {
            holder.createProblem((DomElement)descriptor, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.dependency.descriptor.at.least.one.dependency", new Object[0]));
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)descriptor.getParentOfType(IdeaPlugin.class, false);
        assert (ideaPlugin != null);
        for (Dependency dependency : ideaPlugin.getDepends()) {
            if (dependency.getOptional().getValue() == Boolean.TRUE) continue;
            holder.createProblem((DomElement)dependency, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.dependency.descriptor.cannot.use.depends", new Object[0])).highlightWholeElement();
        }
    }

    private static void annotateContentDescriptor(ContentDescriptor descriptor, DomElementAnnotationHolder holder) {
        if (!PluginXmlDomInspection.isIdeaProjectOrJetBrains(descriptor)) {
            PluginXmlDomInspection.highlightJetbrainsOnly(descriptor, holder);
            return;
        }
        if (descriptor.getModuleEntry().isEmpty()) {
            holder.createProblem((DomElement)descriptor, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.module.descriptor.at.least.one.dependency", new Object[0]));
        }
    }

    private static boolean isIdeaProjectOrJetBrains(DomElement element) {
        Module module = element.getModule();
        if (module == null) {
            return true;
        }
        if (PsiUtil.isIdeaProject(module.getProject())) {
            return true;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)element.getParentOfType(IdeaPlugin.class, false);
        assert (ideaPlugin != null);
        return PluginManagerCore.isDevelopedByJetBrains((String)ideaPlugin.getVendor().getValue());
    }

    private static void annotatePsiClassValue(GenericDomValue<PsiClass> psiClassDomValue, DomElementAnnotationHolder holder) {
        Module module;
        PsiClass psiClass = (PsiClass)psiClassDomValue.getValue();
        if (psiClass == null) {
            return;
        }
        if (psiClass.getContainingClass() != null && !StringUtil.containsChar((String)StringUtil.notNullize((String)psiClassDomValue.getRawText()), (char)'$')) {
            holder.createProblem(psiClassDomValue, DevKitBundle.message("inspections.plugin.xml.inner.class.must.be.separated.with.dollar", new Object[0]), new LocalQuickFix[0]);
        }
        if ((module = psiClassDomValue.getModule()) == null) {
            return;
        }
        if (!PluginXmlDomInspection.isIdeaProjectOrJetBrains(psiClassDomValue)) {
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)psiClassDomValue.getParentOfType(IdeaPlugin.class, true);
        assert (ideaPlugin != null);
        String pluginPackage = ideaPlugin.getPackage().getStringValue();
        if (pluginPackage == null) {
            return;
        }
        String psiClassFqn = psiClass.getQualifiedName();
        assert (psiClassFqn != null);
        if (!StringUtil.startsWith((CharSequence)psiClassFqn, (CharSequence)(pluginPackage + ".")) && module == ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) {
            holder.createProblem(psiClassDomValue, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.dependency.class.located.in.wrong.package", psiClassFqn, pluginPackage), new LocalQuickFix[]{new MoveToPackageFix(psiClass.getContainingFile(), pluginPackage)});
        }
    }

    private static boolean isUnderProductionSources(DomElement domElement, @NotNull Module module) {
        VirtualFile virtualFile;
        if (module == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(7);
        }
        return (virtualFile = DomUtil.getFile((DomElement)domElement).getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.PRODUCTION);
    }

    private static void annotateListener(Listeners.Listener listener, DomElementAnnotationHolder holder) {
        PsiClass listenerClass = (PsiClass)listener.getListenerClassName().getValue();
        PsiClass topicClass = (PsiClass)listener.getTopicClassName().getValue();
        if (listenerClass == null || topicClass == null) {
            return;
        }
        if (!listenerClass.isInheritor(topicClass, true)) {
            holder.createProblem(listener.getListenerClassName(), DevKitBundle.message("inspections.plugin.xml.listener.does.not.inherit", listener.getListenerClassName().getStringValue(), listener.getTopicClassName().getStringValue()), new LocalQuickFix[0]);
        }
    }

    private static void annotateListeners(Listeners listeners, DomElementAnnotationHolder holder) {
        boolean canHaveOsAttribute;
        Module module = listeners.getModule();
        if (module == null || PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        PluginPlatformInfo platformInfo = PluginPlatformInfo.forDomElement(listeners);
        PluginPlatformInfo.PlatformResolveStatus resolveStatus = platformInfo.getResolveStatus();
        if (resolveStatus == PluginPlatformInfo.PlatformResolveStatus.DEVKIT_NO_MAIN) {
            holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.could.not.locate.main.descriptor", new Object[0]), null, new LocalQuickFix[0]).highlightWholeElement();
            return;
        }
        if (resolveStatus == PluginPlatformInfo.PlatformResolveStatus.DEVKIT_NO_SINCE_BUILD) {
            LocalQuickFix[] localQuickFixArray;
            boolean noSinceBuildXml;
            boolean bl = noSinceBuildXml = !DomUtil.hasXml(platformInfo.getMainIdeaPlugin().getIdeaVersion().getSinceBuild());
            if (noSinceBuildXml) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AddDomElementQuickFix((DomElement)platformInfo.getMainIdeaPlugin().getIdeaVersion());
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.must.be.specified", new Object[0]), null, fixes).highlightWholeElement();
            return;
        }
        BuildNumber buildNumber = platformInfo.getSinceBuildNumber();
        if (buildNumber == null) {
            holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.could.not.determine.platform.version", new Object[0]), null, new LocalQuickFix[0]).highlightWholeElement();
            return;
        }
        int baselineVersion = buildNumber.getBaselineVersion();
        boolean bl = canHaveOsAttribute = baselineVersion >= 201;
        if (!canHaveOsAttribute) {
            for (Listeners.Listener listener : listeners.getListeners()) {
                if (!DomUtil.hasXml(listener.getOs())) continue;
                holder.createProblem(listener.getOs(), ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.listeners.os.attribute", 201, baselineVersion), null, new LocalQuickFix[0]).highlightWholeElement();
            }
        }
        if (baselineVersion >= 193) {
            return;
        }
        holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.listeners.not.available", 193, baselineVersion), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void annotateDependency(Dependency dependency, DomElementAnnotationHolder holder) {
        GenericAttributeValue<Boolean> optional = dependency.getOptional();
        if (optional.getValue() == Boolean.FALSE) {
            PluginXmlDomInspection.highlightRedundant(optional, DevKitBundle.message("inspections.plugin.xml.dependency.superfluous.optional", new Object[0]), ProblemHighlightType.WARNING, holder);
        } else if (optional.getValue() == Boolean.TRUE && !DomUtil.hasXml(dependency.getConfigFile())) {
            holder.createProblem((DomElement)dependency, DevKitBundle.message("inspections.plugin.xml.dependency.specify.config.file", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(dependency.getConfigFile())}).highlightWholeElement();
        }
    }

    private static void annotateIdeaPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder, @NotNull Module module) {
        boolean isNotIdeaProject;
        if (module == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(8);
        }
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaPlugin.getIdeaPluginVersion(), holder);
        if (DomUtil.hasXml(ideaPlugin.getUseIdeaClassloader())) {
            PluginXmlDomInspection.highlightDeprecated(ideaPlugin.getUseIdeaClassloader(), DevKitBundle.message("inspections.plugin.xml.deprecated", new Object[0]), holder, true, true);
        }
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getUrl(), 255, holder);
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getId(), 255, holder);
        PluginXmlDomInspection.checkTemplateText(ideaPlugin.getName(), "Plugin display name here", holder);
        PluginXmlDomInspection.checkTemplateTextContainsWord(ideaPlugin.getName(), holder, "plugin", "IntelliJ", "JetBrains");
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getName(), 255, holder);
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getDescription(), 65535, holder);
        PluginXmlDomInspection.checkHasRealText(ideaPlugin.getDescription(), holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getDescription(), "Enter short description for your plugin here.", holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getDescription(), "most HTML tags may be used", holder);
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getChangeNotes(), 65535, holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getChangeNotes(), "Add change notes here", holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getChangeNotes(), "most HTML tags may be used", holder);
        if (!ideaPlugin.hasRealPluginId()) {
            return;
        }
        MultiMap dependencies = MultiMap.create();
        ideaPlugin.getDepends().forEach(dependency -> {
            if (DomUtil.hasXml(dependency.getConfigFile())) {
                dependencies.putValue((Object)dependency.getConfigFile().getStringValue(), dependency);
            }
        });
        for (Map.Entry entry : dependencies.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (Dependency dependency2 : (Collection)entry.getValue()) {
                if (dependency2.getXmlTag() instanceof IncludedXmlTag) continue;
                PluginXmlDomInspection.highlightRedundant((DomElement)dependency2, DevKitBundle.message("inspections.plugin.xml.duplicated.dependency", entry.getKey()), ProblemHighlightType.ERROR, holder);
            }
        }
        boolean bl = isNotIdeaProject = !PsiUtil.isIdeaProject(module.getProject());
        if (isNotIdeaProject && !DomUtil.hasXml(ideaPlugin.getVersion()) && PluginModuleType.isOfType(module)) {
            holder.createProblem((DomElement)ideaPlugin, DevKitBundle.message("inspections.plugin.xml.version.must.be.specified", new Object[0]), new LocalQuickFix[]{new AddMissingMainTag(DevKitBundle.message("inspections.plugin.xml.add.version.tag", new Object[0]), ideaPlugin.getVersion(), "")});
        }
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getVersion(), 64, holder);
        if (isNotIdeaProject && !DomUtil.hasXml((DomElement)ideaPlugin.getVendor())) {
            holder.createProblem((DomElement)ideaPlugin, DevKitBundle.message("inspections.plugin.xml.vendor.must.be.specified", new Object[0]), new LocalQuickFix[]{new AddMissingMainTag(DevKitBundle.message("inspections.plugin.xml.add.vendor.tag", new Object[0]), ideaPlugin.getVendor(), "")});
        }
        if (DomUtil.hasXml(ideaPlugin.getPackage()) && !PluginXmlDomInspection.isIdeaProjectOrJetBrains(ideaPlugin)) {
            PluginXmlDomInspection.highlightJetbrainsOnly(ideaPlugin.getPackage(), holder);
        }
    }

    private static void checkJetBrainsPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder, @NotNull Module module) {
        String url;
        if (module == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(9);
        }
        if (!PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        if (DomUtil.hasXml(ideaPlugin.getUrl()) && "https://www.jetbrains.com/idea".equals(url = ideaPlugin.getUrl().getStringValue())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getUrl(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.generic.plugin.url", new Object[0]), holder);
        }
        if (!ideaPlugin.hasRealPluginId()) {
            return;
        }
        @NonNls String id = ideaPlugin.getId().getStringValue();
        if (id != null && (StringUtil.startsWith((CharSequence)id, (CharSequence)"com.android.") || id.equals("org.jetbrains.android"))) {
            return;
        }
        if (!PluginXmlDomInspection.isUnderProductionSources(ideaPlugin, module)) {
            return;
        }
        Vendor vendor = ideaPlugin.getVendor();
        if (!DomUtil.hasXml((DomElement)vendor)) {
            holder.createProblem((DomElement)DomUtil.getFileElement((DomElement)ideaPlugin), DevKitBundle.message("inspections.plugin.xml.plugin.should.have.jetbrains.vendor", new Object[0]), new LocalQuickFix[]{new AddMissingMainTag(DevKitBundle.message("inspections.plugin.xml.vendor.specify.jetbrains", new Object[0]), vendor, "JetBrains")});
        } else if (!PluginManagerCore.isVendorJetBrains((String)vendor.getValue())) {
            holder.createProblem((DomElement)vendor, DevKitBundle.message("inspections.plugin.xml.plugin.should.have.jetbrains.vendor", new Object[0]), new LocalQuickFix[0]);
        } else {
            String url2 = vendor.getUrl().getStringValue();
            if (url2 != null && StringUtil.endsWith((CharSequence)url2, (CharSequence)"jetbrains.com")) {
                PluginXmlDomInspection.highlightRedundant(vendor.getUrl(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.vendor.no.url", url2), holder);
            }
        }
        if (DomUtil.hasXml(vendor.getEmail())) {
            PluginXmlDomInspection.highlightRedundant(vendor.getEmail(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.vendor.no.email", new Object[0]), holder);
        }
        if (DomUtil.hasXml(ideaPlugin.getChangeNotes())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getChangeNotes(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.change.notes", new Object[0]), holder);
        }
        if (DomUtil.hasXml(ideaPlugin.getVersion())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getVersion(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.version", new Object[0]), holder);
        }
        if (DomUtil.hasXml((DomElement)ideaPlugin.getIdeaVersion())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getIdeaVersion(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.idea.version", new Object[0]), holder);
        }
    }

    private static void checkPluginIcon(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder, Module module) {
        if (!ideaPlugin.hasRealPluginId()) {
            return;
        }
        if (!PluginXmlDomInspection.isUnderProductionSources(ideaPlugin, module)) {
            return;
        }
        if (Boolean.TRUE == ideaPlugin.getImplementationDetail().getValue()) {
            return;
        }
        Collection pluginIconFiles = FilenameIndex.getVirtualFilesByName((String)PLUGIN_ICON_SVG_FILENAME, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module));
        if (pluginIconFiles.isEmpty()) {
            holder.createProblem((DomElement)ideaPlugin, ProblemHighlightType.WEAK_WARNING, DevKitBundle.message("inspections.plugin.xml.no.plugin.icon.svg.file", PLUGIN_ICON_SVG_FILENAME), null, new LocalQuickFix[0]);
        }
    }

    private static void annotateExtensionPoint(ExtensionPoint extensionPoint, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        Module module;
        if (extensionPoint.getWithElements().isEmpty() && !extensionPoint.collectMissingWithTags().isEmpty()) {
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.ep.doesnt.have.with", new Object[0]), new LocalQuickFix[]{new AddWithTagFix()});
        }
        PluginXmlDomInspection.checkEpBeanClassAndInterface(extensionPoint, holder);
        PluginXmlDomInspection.checkEpNameAndQualifiedName(extensionPoint, holder);
        if (DomUtil.hasXml(extensionPoint.getQualifiedName())) {
            String epQualifiedName;
            IdeaPlugin ideaPlugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)extensionPoint, IdeaPlugin.class, (boolean)true);
            assert (ideaPlugin != null);
            final String pluginId = ideaPlugin.getPluginId();
            if (pluginId != null && (epQualifiedName = extensionPoint.getQualifiedName().getStringValue()) != null && epQualifiedName.startsWith(pluginId + ".")) {
                holder.createProblem(extensionPoint.getQualifiedName(), ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.ep.qualifiedName.superfluous", new Object[0]), null, new LocalQuickFix[]{new LocalQuickFix(){

                    @IntentionFamilyName
                    @NotNull
                    public String getFamilyName() {
                        String string = DevKitBundle.message("inspections.plugin.xml.ep.qualifiedName.superfluous.fix", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        ExtensionPoint fixExtensionPoint;
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (descriptor == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if ((fixExtensionPoint = (ExtensionPoint)DomUtil.findDomElement((PsiElement)descriptor.getPsiElement(), ExtensionPoint.class)) == null) {
                            return;
                        }
                        fixExtensionPoint.getQualifiedName().undefine();
                        fixExtensionPoint.getName().setStringValue(StringUtil.substringAfter((String)epQualifiedName, (String)(pluginId + ".")));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1, 2 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getFamilyName";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "applyFix";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1, 2 -> new IllegalArgumentException(string);
                        };
                    }
                }}).highlightWholeElement();
            }
        }
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module = extensionPoint.getModule())) {
            componentModuleRegistrationChecker.checkProperModule(extensionPoint);
        }
    }

    private static void checkEpBeanClassAndInterface(ExtensionPoint extensionPoint, DomElementAnnotationHolder holder) {
        boolean hasBeanClass = DomUtil.hasXml(extensionPoint.getBeanClass());
        boolean hasInterface = DomUtil.hasXml(extensionPoint.getInterface());
        if (hasBeanClass && hasInterface) {
            PluginXmlDomInspection.highlightRedundant(extensionPoint.getBeanClass(), DevKitBundle.message("inspections.plugin.xml.ep.both.beanClass.and.interface", new Object[0]), ProblemHighlightType.GENERIC_ERROR, holder);
            PluginXmlDomInspection.highlightRedundant(extensionPoint.getInterface(), DevKitBundle.message("inspections.plugin.xml.ep.both.beanClass.and.interface", new Object[0]), ProblemHighlightType.GENERIC_ERROR, holder);
        } else if (!hasBeanClass && !hasInterface) {
            holder.createProblem((DomElement)extensionPoint, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.ep.missing.beanClass.and.interface", new Object[0]), null, new LocalQuickFix[]{new AddDomElementQuickFix(extensionPoint.getBeanClass()), new AddDomElementQuickFix(extensionPoint.getInterface())});
        }
    }

    private static void checkEpNameAndQualifiedName(ExtensionPoint extensionPoint, DomElementAnnotationHolder holder) {
        GenericAttributeValue<String> name = extensionPoint.getName();
        GenericAttributeValue<String> qualifiedName = extensionPoint.getQualifiedName();
        boolean hasName = DomUtil.hasXml(name);
        boolean hasQualifiedName = DomUtil.hasXml(qualifiedName);
        if (hasName && hasQualifiedName) {
            holder.createProblem((DomElement)extensionPoint, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.ep.both.name.and.qualifiedName", new Object[0]), null, new LocalQuickFix[0]);
        } else if (!hasName && !hasQualifiedName) {
            holder.createProblem((DomElement)extensionPoint, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.ep.missing.name.and.qualifiedName", new Object[0]), null, new LocalQuickFix[0]);
        }
        if (hasQualifiedName) {
            if (!PluginXmlDomInspection.isValidEpName(qualifiedName)) {
                String message = DevKitBundle.message("inspections.plugin.xml.invalid.ep.name.description", DevKitBundle.message("inspections.plugin.xml.invalid.ep.qualifiedName", new Object[0]), qualifiedName.getValue());
                holder.createProblem(qualifiedName, ProblemHighlightType.WEAK_WARNING, message, null, new LocalQuickFix[0]);
            }
            return;
        }
        if (hasName && !PluginXmlDomInspection.isValidEpName(name)) {
            String message = DevKitBundle.message("inspections.plugin.xml.invalid.ep.name.description", DevKitBundle.message("inspections.plugin.xml.invalid.ep.name", new Object[0]), name.getValue());
            holder.createProblem(name, ProblemHighlightType.WEAK_WARNING, message, null, new LocalQuickFix[0]);
        }
    }

    private static boolean isValidEpName(GenericAttributeValue<String> nameAttrValue) {
        if (!nameAttrValue.exists()) {
            return true;
        }
        @NonNls String name = (String)nameAttrValue.getValue();
        if (name != null && (StringUtil.startsWith((CharSequence)name, (CharSequence)"Pythonid.") || StringUtil.startsWith((CharSequence)name, (CharSequence)"DevKit.")) && PsiUtil.isIdeaProject(nameAttrValue.getManager().getProject())) {
            return true;
        }
        if (StringUtil.isEmpty((String)name) || !Character.isLowerCase(name.charAt(0)) || StringUtil.toUpperCase((String)name).equals(name) || !StringUtil.isLatinAlphanumeric((CharSequence)name.replace(".", "")) || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        List fragments = StringUtil.split((String)name, (String)".");
        if (ContainerUtil.exists((Iterable)fragments, f -> Character.isUpperCase(f.charAt(0)))) {
            return false;
        }
        String epName = (String)fragments.get(fragments.size() - 1);
        List butlast = fragments.subList(0, fragments.size() - 1);
        List words = StringUtil.getWordsIn((String)epName);
        return !ContainerUtil.exists((Iterable)words, w -> ContainerUtil.exists((Iterable)butlast, f -> StringUtil.equalsIgnoreCase((CharSequence)w, (CharSequence)f)));
    }

    private static void annotateExtensions(Extensions extensions, DomElementAnnotationHolder holder) {
        GenericAttributeValue<IdeaPlugin> xmlnsAttribute = extensions.getXmlns();
        if (DomUtil.hasXml(xmlnsAttribute)) {
            PluginXmlDomInspection.highlightDeprecated(xmlnsAttribute, DevKitBundle.message("inspections.plugin.xml.use.defaultExtensionNs", new Object[0]), holder, false, true);
            return;
        }
        if (!DomUtil.hasXml(extensions.getDefaultExtensionNs())) {
            holder.createProblem((DomElement)extensions, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitBundle.message("inspections.plugin.xml.specify.defaultExtensionNs.explicitly", "com.intellij"), null, new LocalQuickFix[]{new AddDomElementQuickFix<GenericAttributeValue<IdeaPlugin>>(extensions.getDefaultExtensionNs()){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (descriptor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    super.applyFix(project, descriptor);
                    ((GenericAttributeValue)this.myElement).setStringValue("com.intellij");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "descriptor";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$2";
                    objectArray[2] = "applyFix";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }});
        }
    }

    private static void annotateUnresolvedExtension(Extensions.UnresolvedExtension unresolvedExtension, DomElementAnnotationHolder holder) {
        Module module = unresolvedExtension.getModule();
        if (module == null) {
            return;
        }
        Extensions extensions = (Extensions)unresolvedExtension.getParentOfType(Extensions.class, true);
        assert (extensions != null);
        String qualifiedExtensionId = extensions.getEpPrefix() + unresolvedExtension.getXmlElementName();
        ExtensionPoint extensionPoint = ExtensionPointIndex.findExtensionPoint(module, qualifiedExtensionId);
        if (extensionPoint == null) {
            String message = new HtmlBuilder().append(DevKitBundle.message("error.cannot.resolve.extension.point", qualifiedExtensionId)).nbsp().append((HtmlChunk)HtmlChunk.link((String)DEPENDENCIES_DOC_URL, (String)DevKitBundle.message("error.cannot.resolve.plugin.reference.link.title", new Object[0]))).wrapWith(HtmlChunk.html()).toString();
            holder.createProblem((DomElement)unresolvedExtension, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, message, null, new LocalQuickFix[0]);
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)extensionPoint.getParentOfType(IdeaPlugin.class, true);
        assert (ideaPlugin != null);
        final String dependencyId = ideaPlugin.getPluginId();
        LocalQuickFix addDependsFix = new LocalQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = DevKitBundle.message("error.cannot.resolve.extension.point.missing.dependency.fix.family.name", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                DomElement domElement;
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((domElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement())) == null) {
                    return;
                }
                IdeaPlugin ideaPlugin = (IdeaPlugin)domElement.getParentOfType(IdeaPlugin.class, true);
                assert (ideaPlugin != null);
                Dependency dependency = ideaPlugin.addDependency();
                dependency.setStringValue(dependencyId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        holder.createProblem((DomElement)unresolvedExtension, DevKitBundle.message("error.cannot.resolve.extension.point.missing.dependency", qualifiedExtensionId), new LocalQuickFix[]{addDependsFix});
    }

    private static void annotateIdeaVersion(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaVersion.getMin(), holder);
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaVersion.getMax(), holder);
        PluginXmlDomInspection.highlightUntilBuild(ideaVersion, holder);
        GenericAttributeValue<BuildNumber> sinceBuild = ideaVersion.getSinceBuild();
        GenericAttributeValue<BuildNumber> untilBuild = ideaVersion.getUntilBuild();
        if (!DomUtil.hasXml(sinceBuild) && !DomUtil.hasXml(untilBuild)) {
            return;
        }
        BuildNumber sinceBuildNumber = (BuildNumber)sinceBuild.getValue();
        BuildNumber untilBuildNumber = (BuildNumber)untilBuild.getValue();
        if (sinceBuildNumber == null || untilBuildNumber == null) {
            return;
        }
        int compare = Comparing.compare((Comparable)sinceBuildNumber, (Comparable)untilBuildNumber);
        if (compare > 0) {
            holder.createProblem(untilBuild, DevKitBundle.message("inspections.plugin.xml.until.build.must.be.greater.than.since.build", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void highlightUntilBuild(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        String untilBuild = ideaVersion.getUntilBuild().getStringValue();
        if (untilBuild != null && PluginXmlDomInspection.isStarSupported(ideaVersion.getSinceBuild().getStringValue())) {
            Matcher matcher = PluginManager.EXPLICIT_BIG_NUMBER_PATTERN.matcher(untilBuild);
            if (matcher.matches()) {
                holder.createProblem(ideaVersion.getUntilBuild(), DevKitBundle.message("inspections.plugin.xml.until.build.use.asterisk.instead.of.big.number", matcher.group(2)), new LocalQuickFix[]{new CorrectUntilBuildAttributeFix(PluginManager.convertExplicitBigNumberInUntilBuildToStar((String)untilBuild))});
            }
            if (untilBuild.matches("\\d+")) {
                int branch = Integer.parseInt(untilBuild);
                String corrected = branch - 1 + ".*";
                holder.createProblem(ideaVersion.getUntilBuild(), DevKitBundle.message("inspections.plugin.xml.until.build.misleading.plain.number", untilBuild, corrected), new LocalQuickFix[]{new CorrectUntilBuildAttributeFix(corrected)});
            }
        }
    }

    private static boolean isStarSupported(String buildNumber) {
        if (buildNumber == null) {
            return false;
        }
        Matcher matcher = Holder.BASE_LINE_EXTRACTOR.matcher(buildNumber);
        if (matcher.matches()) {
            int branch = Integer.parseInt(matcher.group(1));
            return branch >= 131;
        }
        return false;
    }

    private static void annotateExtension(Extension extension, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        Module module = extension.getModule();
        String effectiveQualifiedName = extensionPoint.getEffectiveQualifiedName();
        PluginXmlDomInspection.annotateExtensionPointStatus(holder, extension, extensionPoint, effectiveQualifiedName, module);
        PluginXmlDomInspection.annotateErrorHandler(holder, extension, effectiveQualifiedName, module);
        for (DomAttributeChildDescription attributeDescription : extension.getGenericInfo().getAttributeChildrenDescriptions()) {
            GenericAttributeValue attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension);
            if (attributeValue == null || !DomUtil.hasXml((DomElement)attributeValue)) continue;
            if ("icon".equals(attributeDescription.getXmlElementName())) {
                PluginXmlDomInspection.annotateResolveProblems(holder, attributeValue);
            } else if ("order".equals(attributeDescription.getXmlElementName())) {
                PluginXmlDomInspection.annotateOrderAttributeProblems(holder, attributeValue);
            }
            PluginXmlDomInspection.annotateReferencedFieldStatus(holder, extension, attributeDescription, attributeValue, module);
        }
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module)) {
            componentModuleRegistrationChecker.checkProperXmlFileForExtension(extension);
        }
    }

    private static void annotateExtensionPointStatus(DomElementAnnotationHolder holder, Extension extension, ExtensionPoint extensionPoint, String effectiveQualifiedName, @Nullable Module module) {
        ExtensionPoint.Status status = extensionPoint.getExtensionPointStatus();
        ExtensionPoint.Status.Kind kind = status.getKind();
        if (kind == ExtensionPoint.Status.Kind.SCHEDULED_FOR_REMOVAL_API) {
            String inVersion = status.getAdditionalData();
            String message = inVersion == null ? DevKitBundle.message("inspections.plugin.xml.deprecated.ep.marked.for.removal", effectiveQualifiedName) : DevKitBundle.message("inspections.plugin.xml.deprecated.ep.marked.for.removal.in.version", effectiveQualifiedName, inVersion);
            PluginXmlDomInspection.highlightDeprecatedMarkedForRemoval(extension, message, holder, false);
        } else if (kind == ExtensionPoint.Status.Kind.DEPRECATED) {
            PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep", effectiveQualifiedName), holder, false, false);
        } else if (kind == ExtensionPoint.Status.Kind.ADDITIONAL_DEPRECATED && module != null) {
            String knownReplacementEp = status.getAdditionalData();
            if (knownReplacementEp == null) {
                PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep", effectiveQualifiedName), holder, false, false);
            } else if (ExtensionPointIndex.findExtensionPoint(module, knownReplacementEp) != null) {
                PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep.use.replacement", effectiveQualifiedName, knownReplacementEp), holder, false, false);
            }
        } else if (kind == ExtensionPoint.Status.Kind.OBSOLETE) {
            PluginXmlDomInspection.highlightObsolete(extension, holder);
        } else if (kind == ExtensionPoint.Status.Kind.EXPERIMENTAL_API) {
            PluginXmlDomInspection.highlightExperimental(extension, holder);
        } else if (kind == ExtensionPoint.Status.Kind.INTERNAL_API && module != null && !PsiUtil.isIdeaProject(module.getProject())) {
            PluginXmlDomInspection.highlightInternal(extension, holder);
        }
    }

    private static void annotateErrorHandler(DomElementAnnotationHolder holder, Extension extension, String effectiveQualifiedName, @Nullable Module module) {
        if (ExtensionPoints.ERROR_HANDLER_EP.getName().equals(effectiveQualifiedName)) {
            IdeaPlugin plugin;
            String implementation = extension.getXmlTag().getAttributeValue("implementation");
            if (ITNReporter.class.getName().equals(implementation) && (plugin = (IdeaPlugin)extension.getParentOfType(IdeaPlugin.class, true)) != null) {
                Vendor vendor = plugin.getVendor();
                if (DomUtil.hasXml((DomElement)vendor) && PluginManagerCore.isDevelopedByJetBrains((String)vendor.getValue())) {
                    PluginXmlDomInspection.highlightRedundant(extension, DevKitBundle.message("inspections.plugin.xml.no.need.to.specify.itnReporter", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, holder);
                } else {
                    boolean inPlatformCode;
                    boolean bl = inPlatformCode = module != null && module.getName().startsWith("intellij.platform.");
                    if (!inPlatformCode) {
                        PluginXmlDomInspection.highlightRedundant(extension, DevKitBundle.message("inspections.plugin.xml.third.party.plugins.must.not.use.itnReporter", new Object[0]), holder);
                    }
                }
            }
        }
    }

    private static void annotateReferencedFieldStatus(DomElementAnnotationHolder holder, Extension extension, DomAttributeChildDescription<?> attributeDescription, GenericAttributeValue<?> attributeValue, @Nullable Module module) {
        PsiElement declaration = attributeDescription.getDeclaration(extension.getManager().getProject());
        if (declaration instanceof PsiField) {
            PsiField psiField = (PsiField)declaration;
            if (psiField.isDeprecated()) {
                if (psiField.hasAnnotation(ApiStatus.ScheduledForRemoval.class.getCanonicalName())) {
                    PluginXmlDomInspection.highlightDeprecatedMarkedForRemoval(attributeValue, DevKitBundle.message("inspections.plugin.xml.marked.for.removal.attribute", attributeDescription.getName()), holder, true);
                } else {
                    PluginXmlDomInspection.highlightDeprecated(attributeValue, DevKitBundle.message("inspections.plugin.xml.deprecated.attribute", attributeDescription.getName()), holder, false, true);
                }
            } else if (psiField.hasAnnotation(ApiStatus.Experimental.class.getCanonicalName())) {
                PluginXmlDomInspection.highlightExperimental(attributeValue, holder);
            } else if (psiField.hasAnnotation(ApiStatus.Internal.class.getCanonicalName()) && module != null && !PsiUtil.isIdeaProject(module.getProject())) {
                PluginXmlDomInspection.highlightInternal(attributeValue, holder);
            } else if (psiField.hasAnnotation(ApiStatus.Obsolete.class.getCanonicalName())) {
                PluginXmlDomInspection.highlightObsolete(attributeValue, holder);
            }
        }
    }

    private static void annotateComponent(Component component, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        GenericDomValue<PsiClass> interfaceClassElement;
        PsiClass interfaceClass;
        Module module = component.getModule();
        GenericDomValue<PsiClass> implementationClassElement = component.getImplementationClass();
        PsiClass implementationClass = (PsiClass)implementationClassElement.getValue();
        if (implementationClass != null) {
            if (componentModuleRegistrationChecker.isIdeaPlatformModule(module)) {
                componentModuleRegistrationChecker.checkProperXmlFileForClass(component, implementationClass);
            }
            if (implementationClass.hasModifierProperty("abstract")) {
                holder.createProblem(implementationClassElement, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), new LocalQuickFix[0]);
            }
        }
        if ((interfaceClass = (PsiClass)(interfaceClassElement = component.getInterfaceClass()).getValue()) != null) {
            IdeaPlugin plugin;
            if (interfaceClass.equals(implementationClass) && component.getHeadlessImplementationClass().getValue() == null) {
                PluginXmlDomInspection.highlightRedundant(interfaceClassElement, DevKitBundle.message("inspections.plugin.xml.component.interface.class.redundant", new Object[0]), ProblemHighlightType.WARNING, holder);
            }
            if ((plugin = (IdeaPlugin)component.getParentOfType(IdeaPlugin.class, false)) != null) {
                DuplicateComponentInterfaceChecker checker = new DuplicateComponentInterfaceChecker(component, interfaceClass);
                plugin.accept(checker);
                if (checker.declarationBeforeComponentFound) {
                    holder.createProblem(interfaceClassElement, DevKitBundle.message("inspections.registration.problems.component.duplicate.interface", interfaceClass.getQualifiedName()), new LocalQuickFix[0]);
                }
            }
        }
        if (implementationClass != null && interfaceClass != null && implementationClass != interfaceClass && !implementationClass.isInheritor(interfaceClass, true)) {
            holder.createProblem(implementationClassElement, DevKitBundle.message("inspections.registration.problems.component.incompatible.interface", interfaceClass.getQualifiedName()), new LocalQuickFix[0]);
        }
    }

    private static void annotateVendor(Vendor vendor, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(vendor.getLogo(), holder);
        PluginXmlDomInspection.checkTemplateText(vendor, "YourCompany", holder);
        PluginXmlDomInspection.checkMaxLength(vendor, 255, holder);
        PluginXmlDomInspection.checkTemplateText(vendor.getUrl(), "http://www.yourcompany.com", holder);
        PluginXmlDomInspection.checkMaxLength(vendor.getUrl(), 255, holder);
        PluginXmlDomInspection.checkTemplateText(vendor.getEmail(), "support@yourcompany.com", holder);
        PluginXmlDomInspection.checkMaxLength(vendor.getEmail(), 255, holder);
    }

    private static void annotateProductDescriptor(ProductDescriptor productDescriptor, DomElementAnnotationHolder holder) {
        String version;
        PluginXmlDomInspection.checkMaxLength(productDescriptor.getCode(), 15, holder);
        String releaseDate = (String)productDescriptor.getReleaseDate().getValue();
        if (releaseDate != null && !PluginXmlDomInspection.isPlaceHolder(releaseDate)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
                dateFormat.setLenient(false);
                dateFormat.parse(releaseDate);
            }
            catch (ParseException e) {
                holder.createProblem(productDescriptor.getReleaseDate(), DevKitBundle.message("inspections.plugin.xml.product.descriptor.invalid.date", new Object[0]), new LocalQuickFix[0]);
            }
        }
        if ((version = (String)productDescriptor.getReleaseVersion().getValue()) != null && !PluginXmlDomInspection.isPlaceHolder(version)) {
            try {
                Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                holder.createProblem(productDescriptor.getReleaseVersion(), DevKitBundle.message("inspections.plugin.xml.product.descriptor.invalid.version", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isPlaceHolder(@Nullable String value) {
        return value != null && value.length() > 4 && value.startsWith("__") && value.endsWith("__");
    }

    private static void annotateAddToGroup(AddToGroup addToGroup, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(addToGroup.getRelativeToAction())) {
            return;
        }
        if (!DomUtil.hasXml(addToGroup.getAnchor())) {
            holder.createProblem((DomElement)addToGroup, DevKitBundle.message("inspections.plugin.xml.anchor.must.have.relative-to-action", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(addToGroup.getAnchor())});
            return;
        }
        Anchor value = (Anchor)((Object)addToGroup.getAnchor().getValue());
        if (value == Anchor.after || value == Anchor.before) {
            return;
        }
        holder.createProblem(addToGroup.getAnchor(), DevKitBundle.message("inspections.plugin.xml.must.use.after.before.with.relative-to-action", new Object[]{Anchor.after, Anchor.before}), new LocalQuickFix[0]);
    }

    private static void annotateGroup(Group group, DomElementAnnotationHolder holder) {
        GenericAttributeValue useShortcutOfAttribute;
        GenericAttributeValue<PsiClass> clazz;
        GenericAttributeValue iconAttribute = group.getIcon();
        if (DomUtil.hasXml((DomElement)iconAttribute)) {
            PluginXmlDomInspection.annotateResolveProblems(holder, iconAttribute);
        }
        if (DomUtil.hasXml(clazz = group.getClazz()) && !DomUtil.hasXml((DomElement)group.getId())) {
            holder.createProblem((DomElement)group, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.action.group.id.required", new Object[0]), null, new LocalQuickFix[]{new AddDomElementQuickFix((DomElement)group.getId())});
        }
        if (!DomUtil.hasXml((DomElement)(useShortcutOfAttribute = group.getUseShortcutOf()))) {
            return;
        }
        if (!DomUtil.hasXml(clazz)) {
            holder.createProblem((DomElement)group, DevKitBundle.message("inspections.plugin.xml.action.class.required.with.use.shortcut.of", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(group.getClazz())});
            return;
        }
        PsiClass actionGroupClass = (PsiClass)clazz.getValue();
        if (actionGroupClass == null) {
            return;
        }
        LightMethodBuilder canBePerformedMethod = new LightMethodBuilder(actionGroupClass.getManager(), "canBePerformed").setContainingClass(JavaPsiFacade.getInstance((Project)actionGroupClass.getProject()).findClass(ActionGroup.class.getName(), actionGroupClass.getResolveScope())).setModifiers(new String[]{"public"}).setMethodReturnType((PsiType)PsiTypes.booleanType()).addParameter("context", DataContext.class.getName());
        PsiMethod overriddenCanBePerformedMethod = actionGroupClass.findMethodBySignature((PsiMethod)canBePerformedMethod, false);
        if (overriddenCanBePerformedMethod == null) {
            String methodPresentation = PsiFormatUtil.formatMethod((PsiMethod)canBePerformedMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            holder.createProblem(clazz, DevKitBundle.message("inspections.plugin.xml.action.must.override.method.with.use.shortcut.of", methodPresentation), new LocalQuickFix[0]);
        }
    }

    private static void annotateAction(Action action, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        Module module;
        GenericAttributeValue<String> iconAttribute = action.getIcon();
        if (DomUtil.hasXml(iconAttribute)) {
            PluginXmlDomInspection.annotateResolveProblems(holder, iconAttribute);
        }
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module = action.getModule())) {
            componentModuleRegistrationChecker.checkProperXmlFileForClass(action, (PsiClass)action.getClazz().getValue());
        }
    }

    private static void annotateSynonym(Synonym synonym, DomElementAnnotationHolder holder) {
        boolean hasKey = DomUtil.hasXml(synonym.getKey());
        boolean hasText = DomUtil.hasXml(synonym.getText());
        if (!hasKey && !hasText) {
            holder.createProblem((DomElement)synonym, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.synonym.missing.key.and.text", new Object[0]), null, new LocalQuickFix[]{new AddDomElementQuickFix(synonym.getKey()), new AddDomElementQuickFix(synonym.getText())});
        } else if (hasKey && hasText) {
            holder.createProblem((DomElement)synonym, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.synonym.both.key.and.text", new Object[0]), null, new LocalQuickFix[0]);
        }
    }

    private static void annotateProjectComponent(Component.Project projectComponent, DomElementAnnotationHolder holder) {
        GenericDomValue<Boolean> skipForDefault = projectComponent.getSkipForDefaultProject();
        if (skipForDefault.exists()) {
            PluginXmlDomInspection.highlightDeprecated(skipForDefault, DevKitBundle.message("inspections.plugin.xml.skipForDefaultProject.deprecated", new Object[0]), holder, true, true);
        }
    }

    private static void annotateOrderAttributeProblems(DomElementAnnotationHolder holder, GenericAttributeValue<?> attributeValue) {
        String orderValue = attributeValue.getStringValue();
        if (StringUtil.isEmpty((String)orderValue)) {
            return;
        }
        try {
            LoadingOrder.readOrder((String)orderValue);
        }
        catch (AssertionError ignore) {
            holder.createProblem(attributeValue, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.invalid.order.attribute", new Object[0]));
            return;
        }
        PluginXmlDomInspection.annotateResolveProblems(holder, attributeValue);
    }

    private static void annotateResolveProblems(DomElementAnnotationHolder holder, GenericAttributeValue<?> attributeValue) {
        XmlAttributeValue value = attributeValue.getXmlAttributeValue();
        if (value != null) {
            for (PsiReference reference : value.getReferences()) {
                if (reference.resolve() != null) continue;
                holder.createResolveProblem(attributeValue, reference);
            }
        }
    }

    private static void highlightRedundant(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightRedundant(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder);
    }

    private static void highlightAttributeNotUsedAnymore(GenericAttributeValue<?> attributeValue, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(attributeValue)) {
            return;
        }
        PluginXmlDomInspection.highlightDeprecated(attributeValue, DevKitBundle.message("inspections.plugin.xml.attribute.not.used.anymore", attributeValue.getXmlElementName()), holder, true, true);
    }

    private static void highlightDeprecated(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder, boolean useRemoveQuickfix, boolean highlightWholeElement) {
        PluginXmlDomInspection.doHighlightDeprecatedElement(element, message, holder, useRemoveQuickfix, highlightWholeElement, false);
    }

    private static void highlightDeprecatedMarkedForRemoval(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder, boolean highlightWholeElement) {
        PluginXmlDomInspection.doHighlightDeprecatedElement(element, message, holder, false, highlightWholeElement, true);
    }

    private static void doHighlightDeprecatedElement(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder, boolean useRemoveQuickfix, boolean highlightWholeElement, boolean forRemoval) {
        ProblemHighlightType problemHighlightType = forRemoval ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
        DomElementProblemDescriptor problem = !useRemoveQuickfix ? holder.createProblem(element, problemHighlightType, message, null, new LocalQuickFix[0]) : holder.createProblem(element, problemHighlightType, message, null, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)});
        if (highlightWholeElement) {
            problem.highlightWholeElement();
        }
    }

    private static void highlightJetbrainsOnly(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.jetbrains.only.api", ApiStatus.Experimental.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void highlightExperimental(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.usage.of.experimental.api", ApiStatus.Experimental.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void highlightInternal(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.usage.of.internal.api", ApiStatus.Internal.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void highlightObsolete(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.LIKE_DEPRECATED, DevKitBundle.message("inspections.plugin.xml.usage.of.obsolete.api", ApiStatus.Obsolete.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void checkTemplateText(GenericDomValue<String> domValue, @NonNls String templateText, DomElementAnnotationHolder holder) {
        if (templateText.equals(domValue.getValue())) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.do.not.use.template.text", templateText), new LocalQuickFix[0]);
        }
    }

    private static void checkTemplateTextContains(GenericDomValue<String> domValue, @NonNls String containsText, DomElementAnnotationHolder holder) {
        String text = domValue.getStringValue();
        if (text != null && StringUtil.containsIgnoreCase((String)text, (String)containsText)) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.must.not.contain.template.text", containsText), new LocalQuickFix[0]);
        }
    }

    private static void checkTemplateTextContainsWord(GenericDomValue<String> domValue, DomElementAnnotationHolder holder, String ... templateWords) {
        String text = domValue.getStringValue();
        if (text == null) {
            return;
        }
        for (String word : StringUtil.getWordsIn((String)text)) {
            for (String templateWord : templateWords) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)word, (CharSequence)templateWord)) continue;
                holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.must.not.contain.template.text", templateWord), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkMaxLength(GenericDomValue<String> domValue, int maxLength, DomElementAnnotationHolder holder) {
        String value = domValue.getStringValue();
        if (value != null && value.length() > maxLength) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.value.exceeds.max.length", maxLength), new LocalQuickFix[0]);
        }
    }

    private static void checkHasRealText(GenericDomValue<String> domValue, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(domValue)) {
            return;
        }
        String value = StringUtil.removeHtmlTags((String)StringUtil.notNullize((String)domValue.getStringValue()));
        value = StringUtil.replace((String)value, (String)"<![CDATA[", (String)"");
        if (StringUtil.isEmptyOrSpaces((String)(value = StringUtil.replace((String)value, (String)"]]>", (String)""))) || value.length() < 40) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.value.must.have.minimum.length", 40), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDomElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnderProductionSources";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateIdeaPlugin";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkJetBrainsPlugin";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static final class AddMissingMainTag
    implements LocalQuickFix {
        @IntentionFamilyName
        @NotNull
        private final String myFamilyName;
        @NotNull
        private final String myTagName;
        @Nullable
        private final String myTagValue;

        private AddMissingMainTag(@IntentionFamilyName @NotNull String familyName, @NotNull GenericDomValue<String> domValue, @Nullable String tagValue) {
            if (familyName == null) {
                AddMissingMainTag.$$$reportNull$$$0(0);
            }
            if (domValue == null) {
                AddMissingMainTag.$$$reportNull$$$0(1);
            }
            this.myFamilyName = familyName;
            this.myTagName = domValue.getXmlElementName();
            this.myTagValue = tagValue;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myFamilyName;
            if (string == null) {
                AddMissingMainTag.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiFile file;
            IdeaPlugin root;
            if (project == null) {
                AddMissingMainTag.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddMissingMainTag.$$$reportNull$$$0(4);
            }
            if ((root = DescriptorUtil.getIdeaPlugin((XmlFile)(file = descriptor.getPsiElement().getContainingFile()))) == null) {
                return;
            }
            XmlTag rootTag = root.getXmlTag();
            if (rootTag == null) {
                return;
            }
            XmlTag after = AddMissingMainTag.getLastSubTag(rootTag, new DomElement[]{root.getId(), root.getDescription(), root.getVersion(), root.getName()});
            XmlTag missingTag = rootTag.createChildTag(this.myTagName, rootTag.getNamespace(), this.myTagValue, false);
            XmlTag addedTag = after == null ? rootTag.addSubTag(missingTag, true) : (XmlTag)rootTag.addAfter((PsiElement)missingTag, (PsiElement)after);
            if (StringUtil.isEmpty((String)this.myTagValue) && !IntentionPreviewUtils.isPreviewElement((PsiElement)descriptor.getPsiElement())) {
                int valueStartOffset = addedTag.getValue().getTextRange().getStartOffset();
                NavigatableAdapter.navigate((Project)project, (VirtualFile)file.getVirtualFile(), (int)valueStartOffset, (boolean)true);
            }
        }

        private static XmlTag getLastSubTag(@NotNull XmlTag rootTag, DomElement ... children) {
            if (rootTag == null) {
                AddMissingMainTag.$$$reportNull$$$0(5);
            }
            HashSet<XmlTag> childrenTags = new HashSet<XmlTag>();
            for (DomElement child : children) {
                if (child == null) continue;
                childrenTags.add(child.getXmlTag());
            }
            XmlTag[] subTags = rootTag.getSubTags();
            for (int i = subTags.length - 1; i >= 0; --i) {
                if (!childrenTags.contains(subTags[i])) continue;
                return subTags[i];
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$AddMissingMainTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$AddMissingMainTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLastSubTag";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class CorrectUntilBuildAttributeFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(PluginXmlDomInspection.class);
        private final String myCorrectValue;

        CorrectUntilBuildAttributeFix(String correctValue) {
            this.myCorrectValue = correctValue;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = DevKitBundle.message("inspections.plugin.xml.change.until.build.name", this.myCorrectValue);
            if (string == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.plugin.xml.change.until.build.family.name", new Object[0]);
            if (string == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(3);
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class, (boolean)false);
            GenericAttributeValue domElement = DomManager.getDomManager((Project)project).getDomElement(attribute);
            LOG.assertTrue(domElement != null);
            domElement.setStringValue(this.myCorrectValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$CorrectUntilBuildAttributeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$CorrectUntilBuildAttributeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class Holder {
        private static final Pattern BASE_LINE_EXTRACTOR = Pattern.compile("(?:\\p{javaLetter}+-)?(\\d+)(?:\\..*)?");

        private Holder() {
        }
    }

    private static class DuplicateComponentInterfaceChecker
    implements DomElementVisitor {
        private final Component component;
        private final PsiClass componentInterfaceClass;
        private final int componentTextOffset;
        private String componentType;
        private boolean declarationBeforeComponentFound;

        private DuplicateComponentInterfaceChecker(@NotNull Component component, @NotNull PsiClass componentInterfaceClass) {
            if (component == null) {
                DuplicateComponentInterfaceChecker.$$$reportNull$$$0(0);
            }
            if (componentInterfaceClass == null) {
                DuplicateComponentInterfaceChecker.$$$reportNull$$$0(1);
            }
            this.declarationBeforeComponentFound = false;
            this.component = component;
            this.componentInterfaceClass = componentInterfaceClass;
            XmlElement componentElement = component.getXmlElement();
            this.componentTextOffset = componentElement != null ? componentElement.getTextOffset() : -1;
        }

        public void visitDomElement(DomElement element) {
            Component checkedComponent;
            element.acceptChildren((DomElementVisitor)this);
            if (!this.declarationBeforeComponentFound && element instanceof Component && this.isFirstDuplicateDeclaration(checkedComponent = (Component)element)) {
                this.declarationBeforeComponentFound = true;
            }
        }

        private boolean isFirstDuplicateDeclaration(Component checkedComponent) {
            if (checkedComponent == this.component) {
                return false;
            }
            XmlElement element = checkedComponent.getXmlElement();
            if (element != null && element.getTextOffset() >= this.componentTextOffset) {
                return false;
            }
            if (DuplicateComponentInterfaceChecker.componentLevelsEqual(this.component, checkedComponent) && this.componentInterfaceClass.equals(checkedComponent.getInterfaceClass().getValue())) {
                if (this.component instanceof Component.Module) {
                    if (this.componentType == null) {
                        this.componentType = DuplicateComponentInterfaceChecker.getComponentType(this.component);
                    }
                    String checkedComponentType = DuplicateComponentInterfaceChecker.getComponentType(checkedComponent);
                    return Objects.equals(this.componentType, checkedComponentType);
                }
                return true;
            }
            return false;
        }

        private static boolean componentLevelsEqual(Component component, Component checkedComponent) {
            return component instanceof Component.Application && checkedComponent instanceof Component.Application || component instanceof Component.Project && checkedComponent instanceof Component.Project || component instanceof Component.Module && checkedComponent instanceof Component.Module;
        }

        private static String getComponentType(Component component) {
            return component.getOptions().stream().filter(option -> "type".equals(option.getName().getValue())).map(Option::getValue).map(GenericValue::getValue).filter(Objects::nonNull).findFirst().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentInterfaceClass";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$DuplicateComponentInterfaceChecker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Tag(value="modules-set")
    public static class PluginModuleSet {
        @XCollection(elementName="module", valueAttributeName="name")
        @Property(surroundWithTag=false)
        public Set<String> modules = new LinkedHashSet<String>();
    }
}

