/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.LevelType;
import org.jetbrains.idea.devkit.inspections.RetrievingServiceInspectionKt;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010#\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001aH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006&"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RetrievingServiceInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "isStaticOrJvmStatic", "", "Lorg/jetbrains/uast/UMethod;", "(Lorg/jetbrains/uast/UMethod;)Z", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "findGetInstanceApplicationLevel", "uClass", "Lorg/jetbrains/uast/UClass;", "findGetInstanceMethod", "retrievingExpression", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "serviceClass", "findGetInstanceProjectLevel", "getReturnExpression", "Lorg/jetbrains/uast/UReturnExpression;", "method", "getServiceCandidate", "Lorg/jetbrains/uast/UCallExpression;", "isGetInstanceApplicationLevel", "isGetInstanceProjectLevel", "isServiceRetrievedCorrectly", "serviceLevel", "Lorg/jetbrains/idea/devkit/inspections/LevelType;", "registerProblem", "", "replacementMethod", "registerProblemMismatchedRetrieving", "node", "ReplaceWithGetInstanceCallFix", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nRetrievingServiceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrievingServiceInspection.kt\norg/jetbrains/idea/devkit/inspections/RetrievingServiceInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class RetrievingServiceInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"holder.file.language");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ RetrievingServiceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!RetrievingServiceInspectionKt.access$getCOMPONENT_MANAGER_GET_SERVICE$p().uCallMatches(node)) {
                    return true;
                }
                Service.Level level = RetrievingServiceInspection.access$howServiceRetrieved(this.this$0, node);
                if (level == null) {
                    return true;
                }
                Service.Level howServiceRetrieved = level;
                PsiType psiType = node.getReturnType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType == null) {
                    return true;
                }
                PsiClassType serviceType = psiClassType;
                PsiClass psiClass = serviceType.resolve();
                if (psiClass == null || (psiClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)psiClass), UClass.class)) == null) {
                    return true;
                }
                PsiClass serviceClass = psiClass;
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
                LevelType serviceLevel = ServiceUtil.getLevelType(project, (UClass)serviceClass);
                if (serviceLevel == LevelType.MODULE) {
                    return true;
                }
                if (serviceLevel == null) {
                    String className = serviceClass.getQualifiedName();
                    if (className != null) {
                        Object[] objectArray = new Object[]{className};
                        String message = DevKitBundle.message("inspection.retrieving.service.not.registered", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UCallExpression)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                    }
                } else if (!RetrievingServiceInspection.access$isServiceRetrievedCorrectly(this.this$0, serviceLevel, howServiceRetrieved)) {
                    RetrievingServiceInspection.access$registerProblemMismatchedRetrieving(this.this$0, howServiceRetrieved, this.$holder, node);
                } else {
                    UElement uElement = node.getUastParent();
                    UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
                    if (uQualifiedReferenceExpression == null) {
                        return true;
                    }
                    UQualifiedReferenceExpression retrievingExpression = uQualifiedReferenceExpression;
                    UMethod getInstanceMethod = RetrievingServiceInspection.access$findGetInstanceMethod(this.this$0, retrievingExpression, howServiceRetrieved, (UClass)serviceClass);
                    if (getInstanceMethod != null) {
                        RetrievingServiceInspection.access$registerProblem(this.this$0, getInstanceMethod, howServiceRetrieved, this.$holder, retrievingExpression);
                    }
                }
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    private final void registerProblemMismatchedRetrieving(Service.Level howServiceRetrieved, ProblemsHolder holder, UCallExpression node) {
        String message = switch (WhenMappings.$EnumSwitchMapping$0[howServiceRetrieved.ordinal()]) {
            case 1 -> DevKitBundle.message("inspection.retrieving.service.mismatch.for.project.level", new Object[0]);
            case 2 -> DevKitBundle.message("inspection.retrieving.service.mismatch.for.app.level", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UCallExpression)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isServiceRetrievedCorrectly(LevelType serviceLevel, Service.Level howServiceRetrieved) {
        if (serviceLevel == LevelType.NOT_SPECIFIED) return true;
        if (!(switch (WhenMappings.$EnumSwitchMapping$0[howServiceRetrieved.ordinal()]) {
            case 1 -> serviceLevel.isApp();
            case 2 -> serviceLevel.isProject();
            default -> throw new NoWhenBranchMatchedException();
        })) return false;
        return true;
    }

    private final Service.Level howServiceRetrieved(UCallExpression getServiceCandidate) {
        PsiType psiType = getServiceCandidate.getReceiverType();
        if (psiType == null) {
            return null;
        }
        PsiType receiverType = psiType;
        PsiClassType psiClassType = receiverType instanceof PsiClassType ? (PsiClassType)receiverType : null;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        PsiClassType aClass = psiClassType;
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)Application.class.getCanonicalName()) ? Service.Level.APP : (InheritanceUtil.isInheritor((PsiClass)aClass, (String)Project.class.getCanonicalName()) ? Service.Level.PROJECT : null);
    }

    private final UMethod findGetInstanceMethod(UQualifiedReferenceExpression retrievingExpression, Service.Level howServiceRetrieved, UClass serviceClass) {
        UReturnExpression returnExpr;
        UElement uElement = retrievingExpression.getUastParent();
        UReturnExpression uReturnExpression = returnExpr = uElement instanceof UReturnExpression ? (UReturnExpression)uElement : null;
        if (returnExpr != null) {
            UMethod containingMethod;
            UElement uElement2 = returnExpr.getJumpTarget();
            UMethod uMethod = containingMethod = uElement2 instanceof UMethod ? (UMethod)uElement2 : null;
            if (containingMethod != null) {
                if (howServiceRetrieved == Service.Level.APP && this.isGetInstanceApplicationLevel(containingMethod)) {
                    return null;
                }
                if (howServiceRetrieved == Service.Level.PROJECT && this.isGetInstanceProjectLevel(containingMethod)) {
                    return null;
                }
            }
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[howServiceRetrieved.ordinal()]) {
            case 1 -> this.findGetInstanceApplicationLevel(serviceClass);
            case 2 -> this.findGetInstanceProjectLevel(serviceClass);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void registerProblem(UMethod replacementMethod, Service.Level howServiceRetrieved, ProblemsHolder holder, UQualifiedReferenceExpression retrievingExpression) {
        Object object = UastUtils.getContainingUClass((UElement)((UElement)replacementMethod));
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object qualifiedName = object;
        String string = StringUtil.getShortName((String)qualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(qualifiedName)");
        String serviceName = string;
        Object[] objectArray = new Object[]{serviceName, replacementMethod.getName()};
        String message = DevKitBundle.message("inspection.retrieving.service.can.be.replaced.with", objectArray);
        ReplaceWithGetInstanceCallFix fix = new ReplaceWithGetInstanceCallFix(serviceName, replacementMethod.getName(), howServiceRetrieved);
        UReferenceExpression uReferenceExpression = (UReferenceExpression)retrievingExpression;
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
        ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UReferenceExpression)uReferenceExpression, (String)message, (LocalQuickFix[])localQuickFixArray, (ProblemHighlightType)ProblemHighlightType.WEAK_WARNING);
    }

    private final UMethod findGetInstanceProjectLevel(UClass uClass) {
        UMethod uMethod;
        block1: {
            UMethod[] uMethodArray = uClass.getMethods();
            int n = uMethodArray.length;
            for (int i = 0; i < n; ++i) {
                UMethod uMethod2;
                UMethod it = uMethod2 = uMethodArray[i];
                boolean bl = false;
                if (!this.isGetInstanceProjectLevel(it)) continue;
                uMethod = uMethod2;
                break block1;
            }
            uMethod = null;
        }
        return uMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGetInstanceProjectLevel(UMethod method) {
        UExpression uExpression;
        if (!this.isStaticOrJvmStatic(method)) return false;
        if (method.getVisibility() != UastVisibility.PUBLIC) return false;
        if (method.getUastParameters().size() != 1) {
            return false;
        }
        UParameter param = (UParameter)method.getUastParameters().get(0);
        if (!Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)Project.class.getCanonicalName())) {
            return false;
        }
        UReturnExpression uReturnExpression = this.getReturnExpression(method);
        UExpression uExpression2 = uReturnExpression != null ? uReturnExpression.getReturnExpression() : null;
        if (!(uExpression2 instanceof UQualifiedReferenceExpression)) return false;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uExpression2;
        if (uQualifiedReferenceExpression == null) {
            return false;
        }
        UQualifiedReferenceExpression qualifiedRef = uQualifiedReferenceExpression;
        if (!RetrievingServiceInspectionKt.access$getCOMPONENT_MANAGER_GET_SERVICE$p().uCallMatches((uExpression = qualifiedRef.getSelector()) instanceof UCallExpression ? (UCallExpression)uExpression : null)) return false;
        uExpression2 = qualifiedRef.getReceiver();
        USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression2 instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression2 : null;
        if (!Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? UResolvableKt.resolveToUElement((UResolvable)((UResolvable)uSimpleNameReferenceExpression)) : null), (Object)param)) return false;
        return true;
    }

    private final UMethod findGetInstanceApplicationLevel(UClass uClass) {
        UMethod uMethod;
        block1: {
            UMethod[] uMethodArray = uClass.getMethods();
            int n = uMethodArray.length;
            for (int i = 0; i < n; ++i) {
                UMethod uMethod2;
                UMethod it = uMethod2 = uMethodArray[i];
                boolean bl = false;
                if (!this.isGetInstanceApplicationLevel(it)) continue;
                uMethod = uMethod2;
                break block1;
            }
            uMethod = null;
        }
        return uMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGetInstanceApplicationLevel(UMethod method) {
        UExpression uExpression;
        if (!this.isStaticOrJvmStatic(method)) return false;
        if (method.getVisibility() != UastVisibility.PUBLIC) return false;
        if (!method.getUastParameters().isEmpty()) {
            return false;
        }
        UReturnExpression uReturnExpression = this.getReturnExpression(method);
        String[] stringArray = uReturnExpression != null ? uReturnExpression.getReturnExpression() : null;
        if (!(stringArray instanceof UQualifiedReferenceExpression)) return false;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)stringArray;
        if (uQualifiedReferenceExpression == null) {
            return false;
        }
        UQualifiedReferenceExpression qualifiedRef = uQualifiedReferenceExpression;
        if (!RetrievingServiceInspectionKt.access$getCOMPONENT_MANAGER_GET_SERVICE$p().uCallMatches((uExpression = qualifiedRef.getSelector()) instanceof UCallExpression ? (UCallExpression)uExpression : null)) return false;
        PsiType psiType = qualifiedRef.getReceiver().getExpressionType();
        if (psiType == null) return false;
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)Application.class.getCanonicalName(), (String)"Application::class.java.canonicalName");
        if (!AnalysisUastUtilKt.isInheritorOf((PsiType)psiType, (String[])stringArray)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStaticOrJvmStatic(UMethod $this$isStaticOrJvmStatic) {
        if ($this$isStaticOrJvmStatic.isStatic()) return true;
        String string = JvmStatic.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JvmStatic::class.java.canonicalName");
        if ($this$isStaticOrJvmStatic.findAnnotation(string) == null) return false;
        return true;
    }

    private final UReturnExpression getReturnExpression(UMethod method) {
        UExpression uExpression = method.getUastBody();
        Object object = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
        UExpression uExpression2 = object != null && (object = object.getExpressions()) != null ? (UExpression)CollectionsKt.singleOrNull((List)object) : null;
        return uExpression2 instanceof UReturnExpression ? (UReturnExpression)uExpression2 : null;
    }

    public static final /* synthetic */ Service.Level access$howServiceRetrieved(RetrievingServiceInspection $this, UCallExpression getServiceCandidate) {
        return $this.howServiceRetrieved(getServiceCandidate);
    }

    public static final /* synthetic */ boolean access$isServiceRetrievedCorrectly(RetrievingServiceInspection $this, LevelType serviceLevel, Service.Level howServiceRetrieved) {
        return $this.isServiceRetrievedCorrectly(serviceLevel, howServiceRetrieved);
    }

    public static final /* synthetic */ void access$registerProblemMismatchedRetrieving(RetrievingServiceInspection $this, Service.Level howServiceRetrieved, ProblemsHolder holder, UCallExpression node) {
        $this.registerProblemMismatchedRetrieving(howServiceRetrieved, holder, node);
    }

    public static final /* synthetic */ UMethod access$findGetInstanceMethod(RetrievingServiceInspection $this, UQualifiedReferenceExpression retrievingExpression, Service.Level howServiceRetrieved, UClass serviceClass) {
        return $this.findGetInstanceMethod(retrievingExpression, howServiceRetrieved, serviceClass);
    }

    public static final /* synthetic */ void access$registerProblem(RetrievingServiceInspection $this, UMethod replacementMethod, Service.Level howServiceRetrieved, ProblemsHolder holder, UQualifiedReferenceExpression retrievingExpression) {
        $this.registerProblem(replacementMethod, howServiceRetrieved, holder, retrievingExpression);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RetrievingServiceInspection$ReplaceWithGetInstanceCallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "serviceName", "", "methodName", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/Service$Level;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.devkit.core"})
    @SourceDebugExtension(value={"SMAP\nRetrievingServiceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrievingServiceInspection.kt\norg/jetbrains/idea/devkit/inspections/RetrievingServiceInspection$ReplaceWithGetInstanceCallFix\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,181:1\n18#2:182\n201#3,6:183\n208#3:190\n10#4:189\n*S KotlinDebug\n*F\n+ 1 RetrievingServiceInspection.kt\norg/jetbrains/idea/devkit/inspections/RetrievingServiceInspection$ReplaceWithGetInstanceCallFix\n*L\n163#1:182\n177#1:183,6\n177#1:190\n177#1:189\n*E\n"})
    private static final class ReplaceWithGetInstanceCallFix
    implements LocalQuickFix {
        @NotNull
        private final String serviceName;
        @NotNull
        private final String methodName;
        @NotNull
        private final Service.Level howServiceRetrieved;

        public ReplaceWithGetInstanceCallFix(@NotNull String serviceName, @NotNull String methodName, @NotNull Service.Level howServiceRetrieved) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)howServiceRetrieved, (String)"howServiceRetrieved");
            this.serviceName = serviceName;
            this.methodName = methodName;
            this.howServiceRetrieved = howServiceRetrieved;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.serviceName, this.methodName};
            String string = DevKitBundle.message("inspection.retrieving.service.replace.with", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.retr\u2026 serviceName, methodName)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UElement uElement;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    uElement = UastContextKt.toUElement((PsiElement)descriptor.getPsiElement());
                    if (uElement == null) break block13;
                    UElement $this$getParentOfType_u24default$iv = uElement;
                    boolean strict$iv = true;
                    UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
                    boolean $i$f$getParentOfType = false;
                    uElement = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv);
                    if (uElement != null) break block14;
                }
                return;
            }
            UElement oldCall = uElement;
            Language language = descriptor.getPsiElement().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"descriptor.psiElement.language");
            UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage(language);
            if (uastCodeGenerationPlugin == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = uastCodeGenerationPlugin;
            UastElementFactory factory = generationPlugin.getElementFactory(project);
            Object object = oldCall.getExpressionType();
            if (object == null || (object = object.getCanonicalText()) == null) {
                return;
            }
            Object serviceName = object;
            List parameters = switch (WhenMappings.$EnumSwitchMapping$0[this.howServiceRetrieved.ordinal()]) {
                case 1 -> CollectionsKt.emptyList();
                case 2 -> CollectionsKt.listOf((Object)oldCall.getReceiver());
                default -> throw new NoWhenBranchMatchedException();
            };
            PsiElement context = oldCall.getSourcePsi();
            UQualifiedReferenceExpression uQualifiedReferenceExpression = factory.createQualifiedReference((String)serviceName, context);
            UReferenceExpression receiver = uQualifiedReferenceExpression != null ? (UReferenceExpression)uQualifiedReferenceExpression : (UReferenceExpression)factory.createSimpleReference((String)serviceName, context);
            UCallExpression uCallExpression = factory.createCallExpression((UExpression)receiver, this.methodName, parameters, oldCall.getExpressionType(), UastCallKind.METHOD_CALL, null);
            if (uCallExpression == null) {
                return;
            }
            UCallExpression newCall = uCallExpression;
            UElement $this$replace$iv = oldCall;
            boolean $i$f$replace = false;
            if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)((UElement)newCall))) {
                UElement cfr_ignored_0 = (UElement)newCall;
            } else {
                UastCodeGenerationPlugin uastCodeGenerationPlugin2 = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin2 = uastCodeGenerationPlugin2 != null ? uastCodeGenerationPlugin2.replace($this$replace$iv, (UElement)newCall, UCallExpression.class) : null;
                boolean bl = false;
                if (it$iv == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                    logger.warn("failed replacing the " + $this$replace$iv + " with " + (UElement)newCall);
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Service.Level.values().length];
                try {
                    nArray[Service.Level.APP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Service.Level.PROJECT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Service.Level.values().length];
            try {
                nArray[Service.Level.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Service.Level.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

