/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;

class RegisterInspectionFix
implements IntentionAction {
    private final PsiClass myPsiClass;
    private final ExtensionPointName<? extends InspectionEP> myEp;

    RegisterInspectionFix(PsiClass psiClass, ExtensionPointName<? extends InspectionEP> ep) {
        this.myPsiClass = psiClass;
        this.myEp = ep;
    }

    @NotNull
    public String getText() {
        String string = DevKitBundle.message("register.inspection.fix.name", this.myPsiClass.getName());
        if (string == null) {
            RegisterInspectionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("register.inspection.fix.family.name", new Object[0]);
        if (string == null) {
            RegisterInspectionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RegisterInspectionFix.$$$reportNull$$$0(2);
        }
        return !DumbService.isDumb((Project)project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            RegisterInspectionFix.$$$reportNull$$$0(3);
        }
        PluginDescriptorChooser.show(project, editor, file, (Consumer<? super DomFileElement<IdeaPlugin>>)((Consumer)element -> this.doFix((DomFileElement<IdeaPlugin>)element, project, file)));
    }

    private void doFix(DomFileElement<IdeaPlugin> selectedValue, Project project, PsiFile file) {
        Extension extension = (Extension)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).compute(() -> {
            Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)selectedValue, this.myEp.getName());
            Extension e = extensions.addExtension(this.myEp.getName());
            XmlTag tag = e.getXmlTag();
            tag.setAttribute("implementationClass", this.myPsiClass.getQualifiedName());
            tag.setAttribute("language", "");
            return e;
        });
        PsiNavigateUtil.navigate((PsiElement)extension.getXmlTag());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            RegisterInspectionFix.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RegisterInspectionFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            RegisterInspectionFix.$$$reportNull$$$0(6);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            RegisterInspectionFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

