/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtilRt;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.run.DevKitApplicationPatcherKt;
import org.jetbrains.idea.devkit.run.JUnitDevKitPatcher;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J5\u0010\u0007\u001a\u00020\b\"\f\b\u0000\u0010\t*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u0002H\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/run/DevKitApplicationPatcher;", "Lcom/intellij/execution/RunConfigurationExtension;", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "updateJavaParameters", "", "T", "javaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nDevKitApplicationPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevKitApplicationPatcher.kt\norg/jetbrains/idea/devkit/run/DevKitApplicationPatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n2624#2,3:142\n2624#2,3:145\n*S KotlinDebug\n*F\n+ 1 DevKitApplicationPatcher.kt\norg/jetbrains/idea/devkit/run/DevKitApplicationPatcher\n*L\n57#1:142,3\n60#1:145,3\n*E\n"})
public final class DevKitApplicationPatcher
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters javaParameters, @Nullable RunnerSettings runnerSettings) {
        String productClassifier;
        boolean bl;
        String[] $this$none$iv;
        ParametersList vmParameters;
        block22: {
            String it;
            boolean bl2;
            boolean $i$f$none;
            List vmParametersAsList;
            block21: {
                String qualifiedName;
                Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)javaParameters, (String)"javaParameters");
                ApplicationConfiguration applicationConfiguration = configuration instanceof ApplicationConfiguration ? (ApplicationConfiguration)configuration : null;
                if (applicationConfiguration == null) {
                    return;
                }
                ApplicationConfiguration applicationConfiguration2 = applicationConfiguration;
                Project project = applicationConfiguration2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"applicationConfiguration.project");
                Project project2 = project;
                if (!PsiUtil.isIdeaProject(project2)) {
                    return;
                }
                vmParameters = javaParameters.getVMParametersList();
                boolean isDev = Intrinsics.areEqual((Object)((ApplicationConfiguration)configuration).getMainClassName(), (Object)"org.jetbrains.intellij.build.devServer.DevMainKt");
                List list = vmParameters.getList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"vmParameters.list");
                vmParametersAsList = list;
                if (vmParametersAsList.contains("--add-modules") || !isDev && !Intrinsics.areEqual((Object)((ApplicationConfiguration)configuration).getMainClassName(), (Object)"com.intellij.idea.Main")) {
                    return;
                }
                Module module = ((JavaRunConfigurationModule)((ApplicationConfiguration)configuration).getConfigurationModule()).getModule();
                Sdk sdk = JavaParameters.getJdkToRunModule((Module)module, (boolean)true);
                if (sdk == null) {
                    return;
                }
                Sdk jdk = sdk;
                if (!vmParameters.hasProperty("java.system.class.loader") && JUnitDevKitPatcher.loaderValid(project2, module, qualifiedName = "com.intellij.util.lang.PathClassLoader")) {
                    vmParameters.addProperty("java.system.class.loader", qualifiedName);
                }
                if (!vmParametersAsList.contains("--add-opens")) {
                    JUnitDevKitPatcher.appendAddOpensWhenNeeded(project2, jdk, vmParameters);
                }
                if (!isDev) {
                    return;
                }
                vmParameters.addProperty("kotlinx.coroutines.debug.enable.creation.stack.trace", "false");
                $this$none$iv = (String[])vmParametersAsList;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object entry : $this$none$iv) {
                        it = (String)entry;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.startsWith$default((String)it, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
                        bl2 = false;
                        break block21;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                vmParameters.add("-Xmx2g");
            }
            $this$none$iv = vmParametersAsList;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object t : $this$none$iv) {
                    it = (String)t;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!StringsKt.startsWith$default((String)it, (String)"-XX:ReservedCodeCacheSize", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block22;
                }
                bl = true;
            }
        }
        if (bl) {
            vmParameters.add("-XX:ReservedCodeCacheSize=512m");
        }
        $this$none$iv = new String[]{"-XX:+UseG1GC", "-XX:SoftRefLRUPolicyMSPerMB=50", "-XX:MaxJavaStackTraceDepth=10000", "-ea", "-XX:CICompilerCount=2", "-XX:PrintIdealGraphLevel=3"};
        vmParameters.addAll($this$none$iv);
        String $i$f$none = productClassifier = vmParameters.getPropertyValue("idea.platform.prefix");
        String string = $i$f$none == null ? "idea" : (productClassifier = Intrinsics.areEqual((Object)$i$f$none, (Object)"Idea") ? "idea-community" : productClassifier);
        if (!vmParameters.hasProperty("idea.config.path")) {
            String string2 = ((ApplicationConfiguration)configuration).getWorkingDirectory();
            String string3 = productClassifier.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string4 = FileUtilRt.toSystemIndependentName((String)(string2 + "/out/dev-data/" + string3));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toSystemIndependentName(\u2026Classifier.lowercase()}\")");
            String dir = string4;
            vmParameters.addProperty("idea.config.path", dir + "/config");
            vmParameters.addProperty("idea.system.path", dir + "/system");
        }
        Path runDir = Path.of(((ApplicationConfiguration)configuration).getWorkingDirectory() + "/out/dev-run/" + productClassifier, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)runDir, (String)"runDir");
        for (Map.Entry entry : DevKitApplicationPatcherKt.access$getIdeSystemProperties(runDir).entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            vmParameters.addProperty(name, value);
        }
        if (Boolean.parseBoolean(vmParameters.getPropertyValue("idea.dev.skip.build"))) {
            try {
                vmParameters.addProperty("idea.home.path", PathsKt.getInvariantSeparatorsPathString((Path)runDir));
                javaParameters.getClassPath().addAll(Files.readAllLines(runDir.resolve("core-classpath.txt")));
                javaParameters.setMainClass("com.intellij.idea.Main");
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        vmParameters.addProperty("idea.vendor.name", "JetBrains");
        vmParameters.addProperty("idea.use.dev.build.server", "true");
        Intrinsics.checkNotNullExpressionValue((Object)vmParameters, (String)"vmParameters");
        DevKitApplicationPatcherKt.access$setPropertyIfAbsent(vmParameters, "idea.dev.build.unpacked");
        vmParameters.addProperty("sun.io.useCanonCaches", "false");
        vmParameters.addProperty("sun.awt.disablegrab", "true");
        vmParameters.addProperty("sun.java2d.metal", "true");
        vmParameters.addProperty("idea.debug.mode", "true");
        vmParameters.addProperty("idea.is.internal", "true");
        vmParameters.addProperty("fus.internal.test.mode", "true");
        vmParameters.addProperty("jbScreenMenuBar.enabled", "true");
        vmParameters.addProperty("jdk.attach.allowAttachSelf");
        if (!vmParameters.hasParameter("-Didea.initially.ask.config=never")) {
            vmParameters.addProperty("idea.initially.ask.config", "true");
        }
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return configuration instanceof ApplicationConfiguration;
    }
}

