/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.run.ProductInfo;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"loadProductInfo", "Lorg/jetbrains/idea/devkit/run/ProductInfo;", "ideaJdkHome", "", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nProductInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductInfo.kt\norg/jetbrains/idea/devkit/run/ProductInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n1549#2:48\n1620#2,3:49\n10#3:52\n*S KotlinDebug\n*F\n+ 1 ProductInfo.kt\norg/jetbrains/idea/devkit/run/ProductInfoKt\n*L\n31#1:48\n31#1:49,3\n41#1:52\n*E\n"})
public final class ProductInfoKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ProductInfo loadProductInfo(@NotNull String ideaJdkHome) {
        Path productInfoJsonPath;
        Intrinsics.checkNotNullParameter((Object)ideaJdkHome, (String)"ideaJdkHome");
        Path ideHomePath = Path.of(ideaJdkHome, new String[0]);
        Path path = productInfoJsonPath = SystemInfo.isMac ? ideHomePath.resolve("Resources/product-info.json") : ideHomePath.resolve("product-info.json");
        if (Files.notExists(productInfoJsonPath, new LinkOption[0])) {
            return null;
        }
        try {
            void $this$mapTo$iv$iv;
            Map map = JsonUtil.nextObject((JsonReaderEx)new JsonReaderEx((CharSequence)Files.readString(productInfoJsonPath)));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"nextObject(JsonReaderEx(\u2026ng(productInfoJsonPath)))");
            Map jsonRoot = map;
            Object v = jsonRoot.get("launch");
            List list = TypeIntrinsics.isMutableList(v) ? (List)v : null;
            if (list == null) {
                return null;
            }
            List launch = list;
            Object object = CollectionsKt.firstOrNull((List)launch);
            Map map2 = TypeIntrinsics.isMutableMap((Object)object) ? (Map)object : null;
            if (map2 == null) {
                return null;
            }
            Map launchMap = map2;
            Object v2 = launchMap.get("bootClassPathJarNames");
            List list2 = TypeIntrinsics.isMutableList(v2) ? (List)v2 : null;
            if (list2 == null) {
                return null;
            }
            List bootClassPathJarNames = list2;
            Object v3 = launchMap.get("additionalJvmArguments");
            List list3 = TypeIntrinsics.isMutableList(v3) ? (List)v3 : null;
            if (list3 == null) {
                return null;
            }
            List additionalJvmArguments = list3;
            Iterable $this$map$iv = additionalJvmArguments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void s;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)s, (String)"$APP_PACKAGE", (String)ideaJdkHome, (boolean)false, (int)4, null), (String)"$IDE_HOME", (String)ideaJdkHome, (boolean)false, (int)4, null), (String)"%IDE_HOME%", (String)ideaJdkHome, (boolean)false, (int)4, null), (String)"Contents/Contents", (String)"Contents", (boolean)false, (int)4, null));
            }
            additionalJvmArguments = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            return new ProductInfo(bootClassPathJarNames, additionalJvmArguments);
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProductInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error("error parsing '" + productInfoJsonPath + "'", e);
            return null;
        }
    }
}

