/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.util;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.LicenseInfo;
import com.intellij.licensecommon.util.LicenseUtil;
import com.intellij.licensecommon.util.SubscriptionLicenseDecoder;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LicenseDecoder {
    private static final BigInteger PUBLIC_KEY_MODULUS = new BigInteger("86f71688cdd2612ca117d1f54bdae029", 16);
    private static final BigInteger PUBLIC_KEY_EXPONENT = new BigInteger("10001", 16);
    private static final BigInteger PANDORA_PUBLIC_KEY_MODULUS = new BigInteger("846d7cf2385dddd654629dd2ba94ca87", 16);
    private static final BigInteger PANDORA_PUBLIC_KEY_EXPONENT = new BigInteger("10001", 16);
    private static final BigInteger BEFORE_PANDORA_PUBLIC_KEY_MODULUS = new BigInteger("1030230a52c274c376605b2c1", 16);
    private static final BigInteger BEFORE_PANDORA_PUBLIC_KEY_EXPONENT = new BigInteger("10001", 16);
    public static final long KEY_GEN_ROUND_OFF_ERROR = 10800000L;
    public static final Date THIRD_TO_FOURTH_FREE_UPGRADE_DATE = LicenseDecoder.makeDate(2003, 9, 15);
    public static final Date FOURTH_TO_FIFTH_FREE_UPGRADE_DATE = LicenseDecoder.makeDate(2005, 4, 1);
    public static final Date FIFTH_TO_SIXTH_FREE_UPGRADE_DATE = LicenseDecoder.makeDate(2006, 6, 12);
    private static BigInteger SUBSCRIPTION_PUBLIC_MOD = new BigInteger("b50c87b9b4e1edeb6d737b732290bc61f98d60b7d09521c9bd20beca7cf83af74f49e26f67f1ff79aa77e08b4f13b4469a8b6056dd06c314a97c7cbae4864a6d", 16);
    private static BigInteger SUBSCRIPTION_PUBLIC_EXP = new BigInteger("10001", 16);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseInfo decodeLicenseKey(String userName, String licenseKey) throws InvalidLicenseKeyException {
        BigInteger encryptedValue;
        BigInteger decryptedValue;
        byte[] bytes;
        if (licenseKey.length() < 25) {
            return LicenseDecoder.decodeBefore30Key(userName, licenseKey);
        }
        LicenseInfo info = new LicenseInfo();
        info.userName = userName;
        int minusCount = 0;
        for (int i = 0; i < licenseKey.length(); ++i) {
            char c = licenseKey.charAt(i);
            if (c != '-') continue;
            ++minusCount;
        }
        if (minusCount <= 1) {
            return LicenseDecoder.decodeSubscriptionLicense(userName, licenseKey);
        }
        if (minusCount != 5 && minusCount != 4) {
            throw new InvalidLicenseKeyException();
        }
        if (minusCount == 5) {
            int index = licenseKey.indexOf(45);
            try {
                info.customerId = Integer.parseInt(licenseKey.substring(0, index));
                licenseKey = licenseKey.substring(index + 1);
            }
            catch (NumberFormatException e) {
                throw new InvalidLicenseKeyException();
            }
        } else {
            info.customerId = -1;
        }
        if ((bytes = (decryptedValue = (encryptedValue = LicenseUtil.decodeGroups(licenseKey)).modPow(PUBLIC_KEY_EXPONENT, PUBLIC_KEY_MODULUS)).toByteArray()).length != 12) {
            byte[] newBytes;
            if (bytes.length == 13) {
                if (bytes[0] != 0) throw new InvalidLicenseKeyException();
                newBytes = new byte[12];
                System.arraycopy(bytes, 1, newBytes, 0, 12);
                bytes = newBytes;
            } else {
                if (bytes.length >= 12) throw new InvalidLicenseKeyException();
                newBytes = new byte[12];
                System.arraycopy(bytes, 0, newBytes, 12 - bytes.length, bytes.length);
                bytes = newBytes;
            }
        }
        if (userName != null) {
            short checkSum = LicenseUtil.calculateCheckSum(userName, info.customerId, bytes);
            if (bytes[10] != (byte)(checkSum & 0xFF)) {
                throw new InvalidLicenseKeyException();
            }
            if (bytes[11] != (byte)(checkSum >> 8 & 0xFF)) {
                throw new InvalidLicenseKeyException();
            }
        }
        info.licenseType = bytes[0] >> 4;
        info.productId = bytes[0] & 0xF;
        info.minorVersion = bytes[1] >> 4;
        long time = ((long)bytes[2] & 0xFFL) + (((long)bytes[3] & 0xFFL) << 8) + (((long)bytes[4] & 0xFFL) << 16) + (((long)bytes[5] & 0xFFL) << 24) << 16;
        info.generationDate = new Date(time);
        info.majorVersion = LicenseDecoder.calcMajorVersionLicenseQualifiesFor(bytes[1] & 0xF, info.generationDate);
        int days = (bytes[6] & 0xFF) + ((bytes[7] & 0xFF) << 8);
        if (days == 0) return info;
        info.expirationDate = new Date(time + (long)days * 24L * 60L * 60L * 1000L);
        return info;
    }

    private static LicenseInfo decodeSubscriptionLicense(String userName, String licenseKey) throws InvalidLicenseKeyException {
        SubscriptionLicenseInfo info = new SubscriptionLicenseInfo();
        byte[] bytes = SubscriptionLicenseDecoder.decodeKeyAndCustomerId(licenseKey, info, SUBSCRIPTION_PUBLIC_EXP, SUBSCRIPTION_PUBLIC_MOD);
        SubscriptionLicenseDecoder.decodeData(bytes, info, userName, 14);
        SubscriptionLicenseDecoder.fillLicenseInfo(bytes, info, userName, -1);
        return info;
    }

    private static LicenseInfo decodeBefore30Key(String userName, String key) throws InvalidLicenseKeyException {
        int len;
        BigInteger decryptedValue;
        byte[] bytes;
        BigInteger encryptedValue = BigInteger.ZERO;
        for (int i = key.length() - 1; i >= 0; --i) {
            int n;
            char c = key.charAt(i);
            if ('0' <= c && c <= '9') {
                n = c - 48;
            } else if ('A' <= c && c <= 'Z') {
                n = c - 65 + 10;
            } else if ('a' <= c && c <= 'z') {
                n = c - 97 + 36;
            } else if (c == '<' || c == '+') {
                n = 62;
            } else if (c == '>' || c == '-') {
                n = 63;
            } else {
                throw new InvalidLicenseKeyException();
            }
            encryptedValue = encryptedValue.shiftLeft(6);
            encryptedValue = encryptedValue.add(BigInteger.valueOf(n));
        }
        if (key.length() < 20) {
            try {
                return LicenseDecoder.processOldLicenseData(userName, encryptedValue);
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if ((bytes = (decryptedValue = encryptedValue.modPow(PANDORA_PUBLIC_KEY_EXPONENT, PANDORA_PUBLIC_KEY_MODULUS)).toByteArray()).length != (len = 14)) {
            byte[] newBytes;
            if (bytes.length == len + 1 && bytes[0] == 0) {
                newBytes = new byte[len];
                System.arraycopy(bytes, 1, newBytes, 0, len);
                bytes = newBytes;
            } else if (bytes.length < len) {
                newBytes = new byte[len];
                System.arraycopy(bytes, 0, newBytes, len - bytes.length, bytes.length);
                bytes = newBytes;
            } else {
                throw new InvalidLicenseKeyException();
            }
        }
        LicenseInfo info = new LicenseInfo();
        info.userName = userName;
        if (userName != null) {
            int userNameSum = 1976;
            for (int i = 0; i < userName.length(); ++i) {
                userNameSum = (short)(userNameSum + userName.charAt(i));
                userNameSum = (short)(userNameSum + 666);
                userNameSum = (short)(userNameSum ^ 0x7895);
            }
            bytes[0] = (byte)(bytes[0] - (byte)(userNameSum & 0xFF));
            bytes[1] = (byte)(bytes[1] - (byte)(userNameSum >> 8 & 0xFF));
            if (bytes[0] != 0 || bytes[1] != 0) {
                throw new InvalidLicenseKeyException();
            }
        }
        info.generationDate = new Date(((long)bytes[5] & 0xFFL) + (((long)bytes[6] & 0xFFL) << 8) + (((long)bytes[7] & 0xFFL) << 16) + (((long)bytes[8] & 0xFFL) << 24) << 16);
        int days = (bytes[9] & 0xFF) + ((bytes[10] & 0xFF) << 8);
        info.expirationDate = days != 0 ? new Date(info.generationDate.getTime() + (long)days * 24L * 60L * 60L * 1000L) : null;
        info.licenseType = bytes[4];
        info.productId = 1;
        info.majorVersion = 2;
        info.minorVersion = 5;
        return info;
    }

    private static LicenseInfo processOldLicenseData(String userName, BigInteger encriptedValue) throws InvalidLicenseKeyException {
        int len;
        LicenseInfo info = new LicenseInfo();
        info.userName = userName;
        BigInteger decriptedValue = encriptedValue.modPow(BEFORE_PANDORA_PUBLIC_KEY_EXPONENT, BEFORE_PANDORA_PUBLIC_KEY_MODULUS);
        byte[] bytes = decriptedValue.toByteArray();
        if (bytes.length != (len = 12)) {
            byte[] newBytes;
            if (bytes.length == len + 1 && bytes[0] == 0) {
                newBytes = new byte[len];
                System.arraycopy(bytes, 1, newBytes, 0, len);
                bytes = newBytes;
            } else if (bytes.length < len) {
                newBytes = new byte[len];
                System.arraycopy(bytes, 0, newBytes, len - bytes.length, bytes.length);
                bytes = newBytes;
            } else {
                throw new InvalidLicenseKeyException();
            }
        }
        if (userName != null) {
            int userNameSum = 1976;
            for (int i = 0; i < userName.length(); ++i) {
                userNameSum = (short)(userNameSum + userName.charAt(i));
                userNameSum = (short)(userNameSum + 666);
                userNameSum = (short)(userNameSum ^ 0x7895);
            }
            bytes[0] = (byte)(bytes[0] - (byte)(userNameSum & 0xFF));
            bytes[1] = (byte)(bytes[1] - (byte)(userNameSum >> 8 & 0xFF));
            if (bytes[0] != 0 || bytes[1] != 0) {
                throw new InvalidLicenseKeyException();
            }
        }
        info.generationDate = null;
        info.expirationDate = (bytes[5] & 0xFF) != 255 ? new Date(((long)bytes[2] & 0xFFL) + (((long)bytes[3] & 0xFFL) << 8) + (((long)bytes[4] & 0xFFL) << 16) + (((long)bytes[5] & 0xFFL) << 24) << 16) : null;
        info.licenseType = bytes[10];
        info.productId = 1;
        info.majorVersion = 2;
        info.minorVersion = 0;
        return info;
    }

    public static int calcMajorVersionLicenseQualifiesFor(int encoded, Date generationDate) {
        if (encoded == 5 && LicenseDecoder.isBeforeWithRoundOff(FIFTH_TO_SIXTH_FREE_UPGRADE_DATE, generationDate)) {
            return 6;
        }
        if (encoded == 4 && LicenseDecoder.isBeforeWithRoundOff(FOURTH_TO_FIFTH_FREE_UPGRADE_DATE, generationDate)) {
            return 5;
        }
        if (encoded == 3 && LicenseDecoder.isBeforeWithRoundOff(THIRD_TO_FOURTH_FREE_UPGRADE_DATE, generationDate)) {
            return 4;
        }
        return encoded;
    }

    public static boolean isBeforeWithRoundOff(Date before, Date after) {
        long afterTime;
        long beforeTime = before.getTime();
        return beforeTime < (afterTime = after.getTime()) + 10800000L;
    }

    public static Date makeDate(int year, int month, int day) {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Prague"));
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }
}

