/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSADecoder {
    private final BigInteger myDigitsMod;
    private final BigInteger publicExponent;
    private final BigInteger publicModulus;
    private final int digitsPerChunk;
    private final int chunkSize;

    public RSADecoder(BigInteger publicExponent, BigInteger publicModulus) {
        this(publicExponent, publicModulus, 16);
    }

    public RSADecoder(BigInteger publicExponent, BigInteger publicModulus, int alphabetSize) {
        this.publicModulus = publicModulus;
        this.publicExponent = publicExponent;
        int keyLength = publicModulus.bitLength();
        this.chunkSize = keyLength / 8 - 1;
        int digits = (int)Math.ceil((double)keyLength / Math.log(alphabetSize) * Math.log(2.0));
        if (digits % 5 != 0) {
            digits = (digits / 5 + 1) * 5;
        }
        this.digitsPerChunk = digits;
        this.myDigitsMod = new BigInteger(Integer.toString(alphabetSize));
    }

    public byte[] decode(String data) throws InvalidLicenseKeyException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BigInteger chunkBytes = BigInteger.ZERO;
            int digitsRead = 0;
            for (int i = 0; i < data.length(); ++i) {
                char c = data.charAt(i);
                if (c == ' ' || c == '\t' || c == '\n' || c == '-') continue;
                chunkBytes = chunkBytes.multiply(this.myDigitsMod).add(RSADecoder.decodeChar(c));
                if (++digitsRead != this.digitsPerChunk) continue;
                BigInteger decodedChunk = chunkBytes.modPow(this.publicExponent, this.publicModulus);
                byte[] decodedBytes = decodedChunk.toByteArray();
                stream.write(decodedBytes, Math.max(decodedBytes.length - this.chunkSize, 0), Math.min(decodedBytes.length, this.chunkSize));
                chunkBytes = BigInteger.ZERO;
                digitsRead = 0;
            }
            if (digitsRead != 0) {
                throw new InvalidLicenseKeyException();
            }
            stream.close();
            return stream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private static BigInteger decodeChar(char c) throws InvalidLicenseKeyException {
        int d;
        if ('0' <= c && c <= '9') {
            d = c - 48;
        } else if ('A' <= c && c <= 'Z') {
            d = c - 65 + 10;
        } else if ('a' <= c && c <= 'z') {
            d = c - 97 + 36;
        } else if ('!' <= c && c <= ')') {
            d = c - 33 + 62;
        } else {
            throw new InvalidLicenseKeyException();
        }
        return BigInteger.valueOf(d);
    }

    public String decodeString(String data) throws InvalidLicenseKeyException {
        try {
            return new String(this.decode(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public Map<String, String> decodeProperties(String data) throws InvalidLicenseKeyException {
        HashMap<String, String> result = new HashMap<String, String>();
        String serialized = this.decodeString(data);
        StringTokenizer tokenizer = new StringTokenizer(serialized, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            result.put(key, value);
        }
        return result;
    }
}

