/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNode;
import org.gradle.internal.impldep.org.apache.ivy.plugins.conflict.AbstractConflictManager;
import org.gradle.internal.impldep.org.apache.ivy.plugins.latest.ArtifactInfo;
import org.gradle.internal.impldep.org.apache.ivy.plugins.latest.LatestStrategy;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class LatestConflictManager
extends AbstractConflictManager {
    private LatestStrategy strategy;
    private String strategyName;

    public LatestConflictManager() {
    }

    public LatestConflictManager(LatestStrategy strategy) {
        this.strategy = strategy;
    }

    public LatestConflictManager(String name, LatestStrategy strategy) {
        this.setName(name);
        this.strategy = strategy;
    }

    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        IvyNode node;
        if (conflicts.size() < 2) {
            return conflicts;
        }
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            node = (IvyNode)iter.next();
            DependencyDescriptor dd = node.getDependencyDescriptor(parent);
            if (dd == null || !dd.isForce() || !parent.getResolvedId().equals(dd.getParentRevisionId())) continue;
            return Collections.singleton(node);
        }
        iter = conflicts.iterator();
        while (iter.hasNext()) {
            node = (IvyNode)iter.next();
            ModuleRevisionId modRev = node.getResolvedId();
            if (!this.getSettings().getVersionMatcher().isDynamic(modRev)) continue;
            return null;
        }
        try {
            IvyNodeArtifactInfo latest = (IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo(conflicts), null);
            if (latest != null) {
                return Collections.singleton(latest.getNode());
            }
            return conflicts;
        }
        catch (NoConflictResolvedYetException ex) {
            return null;
        }
    }

    protected ArtifactInfo[] toArtifactInfo(Collection conflicts) {
        ArrayList<IvyNodeArtifactInfo> artifacts = new ArrayList<IvyNodeArtifactInfo>(conflicts.size());
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            artifacts.add(new IvyNodeArtifactInfo(node));
        }
        return artifacts.toArray(new ArtifactInfo[artifacts.size()]);
    }

    public LatestStrategy getStrategy() {
        if (this.strategy == null) {
            if (this.strategyName != null) {
                this.strategy = this.getSettings().getLatestStrategy(this.strategyName);
                if (this.strategy == null) {
                    Message.error("unknown latest strategy: " + this.strategyName);
                    this.strategy = this.getSettings().getDefaultLatestStrategy();
                }
            } else {
                this.strategy = this.getSettings().getDefaultLatestStrategy();
            }
        }
        return this.strategy;
    }

    public void setLatest(String strategyName) {
        this.strategyName = strategyName;
    }

    public void setStrategy(LatestStrategy strategy) {
        this.strategy = strategy;
    }

    public String toString() {
        return this.strategy != null ? String.valueOf(this.strategy) : this.strategyName;
    }

    protected static final class IvyNodeArtifactInfo
    implements ArtifactInfo {
        private final IvyNode node;

        private IvyNodeArtifactInfo(IvyNode dep) {
            this.node = dep;
        }

        public long getLastModified() {
            long lastModified = this.node.getLastModified();
            if (lastModified == 0L) {
                throw new NoConflictResolvedYetException();
            }
            return lastModified;
        }

        public String getRevision() {
            return this.node.getResolvedId().getRevision();
        }

        public IvyNode getNode() {
            return this.node;
        }
    }

    public static class NoConflictResolvedYetException
    extends RuntimeException {
    }
}

