/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.h2.expression.condition;

import java.util.Arrays;
import org.gradle.internal.impldep.org.h2.command.query.Query;
import org.gradle.internal.impldep.org.h2.engine.SessionLocal;
import org.gradle.internal.impldep.org.h2.expression.Expression;
import org.gradle.internal.impldep.org.h2.expression.ValueExpression;
import org.gradle.internal.impldep.org.h2.expression.condition.PredicateWithSubquery;
import org.gradle.internal.impldep.org.h2.result.LocalResult;
import org.gradle.internal.impldep.org.h2.result.ResultTarget;
import org.gradle.internal.impldep.org.h2.value.Value;
import org.gradle.internal.impldep.org.h2.value.ValueBoolean;
import org.gradle.internal.impldep.org.h2.value.ValueNull;

public class UniquePredicate
extends PredicateWithSubquery {
    public UniquePredicate(Query query) {
        super(query);
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        super.optimize(sessionLocal);
        if (this.query.isStandardDistinct()) {
            return ValueExpression.TRUE;
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        this.query.setSession(sessionLocal);
        int n = this.query.getColumnCount();
        LocalResult localResult = new LocalResult(sessionLocal, this.query.getExpressions().toArray(new Expression[0]), n, n);
        localResult.setDistinct();
        Target target = new Target(n, localResult);
        this.query.query(Integer.MAX_VALUE, target);
        localResult.close();
        return ValueBoolean.get(!target.hasDuplicates);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        return super.getUnenclosedSQL(stringBuilder.append("UNIQUE"), n);
    }

    private static final class Target
    implements ResultTarget {
        private final int columnCount;
        private final LocalResult result;
        boolean hasDuplicates;

        Target(int n, LocalResult localResult) {
            this.columnCount = n;
            this.result = localResult;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public long getRowCount() {
            return 0L;
        }

        @Override
        public void addRow(Value ... valueArray) {
            if (this.hasDuplicates) {
                return;
            }
            for (int i = 0; i < this.columnCount; ++i) {
                if (valueArray[i] != ValueNull.INSTANCE) continue;
                return;
            }
            if (valueArray.length != this.columnCount) {
                valueArray = Arrays.copyOf(valueArray, this.columnCount);
            }
            long l = this.result.getRowCount() + 1L;
            this.result.addRow(valueArray);
            if (l != this.result.getRowCount()) {
                this.hasDuplicates = true;
                this.result.close();
            }
        }
    }
}

